--
-- PostgreSQL database dump
--

-- Dumped from database version 9.5.3
-- Dumped by pg_dump version 9.5.2

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'WIN1252';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: dblink_pkey_results; Type: TYPE; Schema: public; Owner: ADMIN
--

CREATE TYPE dblink_pkey_results AS (
	"position" integer,
	colname text
);


ALTER TYPE dblink_pkey_results OWNER TO "ADMIN";

--
-- Name: dblink(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink(text) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_record';


ALTER FUNCTION public.dblink(text) OWNER TO "ADMIN";

--
-- Name: dblink(text, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink(text, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_record';


ALTER FUNCTION public.dblink(text, boolean) OWNER TO "ADMIN";

--
-- Name: dblink(text, text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink(text, text) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_record';


ALTER FUNCTION public.dblink(text, text) OWNER TO "ADMIN";

--
-- Name: dblink(text, text, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink(text, text, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_record';


ALTER FUNCTION public.dblink(text, text, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_build_sql_delete(text, int2vector, integer, text[]); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_build_sql_delete(text, int2vector, integer, text[]) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_build_sql_delete';


ALTER FUNCTION public.dblink_build_sql_delete(text, int2vector, integer, text[]) OWNER TO "ADMIN";

--
-- Name: dblink_build_sql_insert(text, int2vector, integer, text[], text[]); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_build_sql_insert(text, int2vector, integer, text[], text[]) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_build_sql_insert';


ALTER FUNCTION public.dblink_build_sql_insert(text, int2vector, integer, text[], text[]) OWNER TO "ADMIN";

--
-- Name: dblink_build_sql_update(text, int2vector, integer, text[], text[]); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_build_sql_update(text, int2vector, integer, text[], text[]) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_build_sql_update';


ALTER FUNCTION public.dblink_build_sql_update(text, int2vector, integer, text[], text[]) OWNER TO "ADMIN";

--
-- Name: dblink_cancel_query(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_cancel_query(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_cancel_query';


ALTER FUNCTION public.dblink_cancel_query(text) OWNER TO "ADMIN";

--
-- Name: dblink_close(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_close(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_close';


ALTER FUNCTION public.dblink_close(text) OWNER TO "ADMIN";

--
-- Name: dblink_close(text, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_close(text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_close';


ALTER FUNCTION public.dblink_close(text, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_close(text, text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_close(text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_close';


ALTER FUNCTION public.dblink_close(text, text) OWNER TO "ADMIN";

--
-- Name: dblink_close(text, text, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_close(text, text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_close';


ALTER FUNCTION public.dblink_close(text, text, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_connect(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_connect(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_connect';


ALTER FUNCTION public.dblink_connect(text) OWNER TO "ADMIN";

--
-- Name: dblink_connect(text, text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_connect(text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_connect';


ALTER FUNCTION public.dblink_connect(text, text) OWNER TO "ADMIN";

--
-- Name: dblink_connect_u(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_connect_u(text) RETURNS text
    LANGUAGE c STRICT SECURITY DEFINER
    AS '$libdir/dblink', 'dblink_connect';


ALTER FUNCTION public.dblink_connect_u(text) OWNER TO "ADMIN";

--
-- Name: dblink_connect_u(text, text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_connect_u(text, text) RETURNS text
    LANGUAGE c STRICT SECURITY DEFINER
    AS '$libdir/dblink', 'dblink_connect';


ALTER FUNCTION public.dblink_connect_u(text, text) OWNER TO "ADMIN";

--
-- Name: dblink_current_query(); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_current_query() RETURNS text
    LANGUAGE c
    AS '$libdir/dblink', 'dblink_current_query';


ALTER FUNCTION public.dblink_current_query() OWNER TO "ADMIN";

--
-- Name: dblink_disconnect(); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_disconnect() RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_disconnect';


ALTER FUNCTION public.dblink_disconnect() OWNER TO "ADMIN";

--
-- Name: dblink_disconnect(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_disconnect(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_disconnect';


ALTER FUNCTION public.dblink_disconnect(text) OWNER TO "ADMIN";

--
-- Name: dblink_error_message(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_error_message(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_error_message';


ALTER FUNCTION public.dblink_error_message(text) OWNER TO "ADMIN";

--
-- Name: dblink_exec(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_exec(text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_exec';


ALTER FUNCTION public.dblink_exec(text) OWNER TO "ADMIN";

--
-- Name: dblink_exec(text, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_exec(text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_exec';


ALTER FUNCTION public.dblink_exec(text, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_exec(text, text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_exec(text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_exec';


ALTER FUNCTION public.dblink_exec(text, text) OWNER TO "ADMIN";

--
-- Name: dblink_exec(text, text, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_exec(text, text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_exec';


ALTER FUNCTION public.dblink_exec(text, text, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_fetch(text, integer); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_fetch(text, integer) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_fetch';


ALTER FUNCTION public.dblink_fetch(text, integer) OWNER TO "ADMIN";

--
-- Name: dblink_fetch(text, integer, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_fetch(text, integer, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_fetch';


ALTER FUNCTION public.dblink_fetch(text, integer, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_fetch(text, text, integer); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_fetch(text, text, integer) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_fetch';


ALTER FUNCTION public.dblink_fetch(text, text, integer) OWNER TO "ADMIN";

--
-- Name: dblink_fetch(text, text, integer, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_fetch(text, text, integer, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_fetch';


ALTER FUNCTION public.dblink_fetch(text, text, integer, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_get_connections(); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_get_connections() RETURNS text[]
    LANGUAGE c
    AS '$libdir/dblink', 'dblink_get_connections';


ALTER FUNCTION public.dblink_get_connections() OWNER TO "ADMIN";

--
-- Name: dblink_get_pkey(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_get_pkey(text) RETURNS SETOF dblink_pkey_results
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_get_pkey';


ALTER FUNCTION public.dblink_get_pkey(text) OWNER TO "ADMIN";

--
-- Name: dblink_get_result(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_get_result(text) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_get_result';


ALTER FUNCTION public.dblink_get_result(text) OWNER TO "ADMIN";

--
-- Name: dblink_get_result(text, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_get_result(text, boolean) RETURNS SETOF record
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_get_result';


ALTER FUNCTION public.dblink_get_result(text, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_is_busy(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_is_busy(text) RETURNS integer
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_is_busy';


ALTER FUNCTION public.dblink_is_busy(text) OWNER TO "ADMIN";

--
-- Name: dblink_open(text, text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_open(text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_open';


ALTER FUNCTION public.dblink_open(text, text) OWNER TO "ADMIN";

--
-- Name: dblink_open(text, text, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_open(text, text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_open';


ALTER FUNCTION public.dblink_open(text, text, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_open(text, text, text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_open(text, text, text) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_open';


ALTER FUNCTION public.dblink_open(text, text, text) OWNER TO "ADMIN";

--
-- Name: dblink_open(text, text, text, boolean); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_open(text, text, text, boolean) RETURNS text
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_open';


ALTER FUNCTION public.dblink_open(text, text, text, boolean) OWNER TO "ADMIN";

--
-- Name: dblink_send_query(text, text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION dblink_send_query(text, text) RETURNS integer
    LANGUAGE c STRICT
    AS '$libdir/dblink', 'dblink_send_query';


ALTER FUNCTION public.dblink_send_query(text, text) OWNER TO "ADMIN";

--
-- Name: prc_u_historico_atualizacao_cliente(); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION prc_u_historico_atualizacao_cliente() RETURNS trigger
    LANGUAGE plpgsql
    AS $$ 






                    BEGIN 






                        IF (NEW.razao_social <> OLD.razao_social) THEN  






                            INSERT INTO alteracao_cliente (codigo_cliente, valor_anterior, data_alteracao, codigo_campo) VALUES (OLD.codigo, OLD.razao_social, NEW.data_alteracao, 3);






                        END IF;






                        IF ((SELECT codigo_pais FROM cadastro_cidades WHERE codigo = NEW.codigo_cidade) <> (SELECT codigo_pais FROM cadastro_cidades WHERE codigo = OLD.codigo_cidade)) THEN  






                            INSERT INTO alteracao_cliente (codigo_cliente, valor_anterior, data_alteracao, codigo_campo) ((SELECT OLD.codigo, CC.codigo_pais, NEW.data_alteracao, 4 FROM cliente CL INNER JOIN cadastro_cidades CC ON codigo = OLD.codigo_cidade  WHERE codigo = NEW.codigo));






                        END IF;






                        IF((OLD.cgc <> NEW.cgc) AND (OLD.pessoa IN (2,3))) THEN






                            INSERT INTO alteracao_cliente (codigo_cliente, valor_anterior, data_alteracao, codigo_campo) VALUES (OLD.codigo, OLD.cgc, NEW.data_alteracao,5);






                        END IF;






                        IF((OLD.cgc <> NEW.cgc) AND (OLD.pessoa IN (1,4))) THEN






                            INSERT INTO alteracao_cliente (codigo_cliente, valor_anterior, data_alteracao, codigo_campo) VALUES (OLD.codigo, OLD.cgc, NEW.data_alteracao,6);






                        END IF;






                        IF(OLD.inscricao_estadual <> NEW.inscricao_estadual) THEN






                            INSERT INTO alteracao_cliente (codigo_cliente, valor_anterior, data_alteracao, codigo_campo) VALUES (OLD.codigo, OLD.inscricao_estadual, NEW.data_alteracao,7);






                        END IF;






                        IF (OLD.codigo_cidade <> NEW.codigo_cidade) THEN






                            INSERT INTO alteracao_cliente (codigo_cliente, valor_anterior, data_alteracao, codigo_campo) ((SELECT C.codigo, CC.codigo_municipio, NEW.data_alteracao,8 FROM cliente AS C INNER JOIN cadastro_cidades CC ON OLD.codigo_cidade = CC.codigo WHERE C.codigo = OLD.codigo));






                        END IF;






                        IF (OLD.suframa <> NEW.suframa) THEN






                            INSERT INTO alteracao_cliente (codigo_cliente, valor_anterior, data_alteracao, codigo_campo) VALUES (OLD.codigo, CAST(OLD.suframa AS VARCHAR), NEW.data_alteracao,9);






                        END IF;






                






                        IF (OLD.endereco <> NEW.endereco) THEN






                            INSERT INTO alteracao_cliente (codigo_cliente, valor_anterior, data_alteracao, codigo_campo) VALUES (OLD.codigo, OLD.endereco, NEW.data_alteracao,10);






                        END IF;






                        IF (OLD.bairro <> NEW.bairro) THEN






                                    INSERT INTO alteracao_cliente (codigo_cliente, valor_anterior, data_alteracao, codigo_campo) VALUES (OLD.codigo, OLD.bairro, NEW.data_alteracao,13);






                                    END IF;






                                    RETURN NULL;






                                END;






                             $$;


ALTER FUNCTION public.prc_u_historico_atualizacao_cliente() OWNER TO "ADMIN";

--
-- Name: prc_u_historico_atualizacao_produto(); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION prc_u_historico_atualizacao_produto() RETURNS trigger
    LANGUAGE plpgsql
    AS $$






                    BEGIN 






                    IF (SELECT count(*) FROM alteracao_produto AP INNER JOIN produto PR ON PR.codigo = AP.codigo_produto WHERE codigo_produto = NEW.codigo) > 0 THEN






                        IF (NEW.descricao <> OLD.descricao) THEN  






                            UPDATE alteracao_produto SET descricao = OLD.descricao, data_inicial = OLD.data_alteracao, data_final = 'now()'






                            WHERE codigo_produto = NEW.codigo;






                        END IF;






                    ELSE






                        INSERT INTO alteracao_produto SELECT OLD.codigo, OLD.descricao, NEW.data_cadastro, NEW.data_alteracao 






                            FROM produto 






                            WHERE codigo = NEW.codigo;






                    END IF;






                        RETURN NULL;






                    END;






                 $$;


ALTER FUNCTION public.prc_u_historico_atualizacao_produto() OWNER TO "ADMIN";

--
-- Name: replica_cadastro(text, text, text, text, text, text, text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION replica_cadastro(usuario text, senha text, host text, porta text, loja text, empdestino text, emporigem text) RETURNS character
    LANGUAGE plpgsql
    AS $$ DECLARE registro RECORD; retval INTEGER; conexao text; texto text; BEGIN    conexao := 'host='|| host ||' password=' || senha || ' port=' || porta || ' user=' || usuario || ' dbname=' || loja ||'';    Raise NOTICE 'conexao %', conexao;    FOR registro IN SELECT * FROM dblink(conexao,'SELECT serial,descricao FROM replicacao_cadastros WHERE status = ''A''') AS resultado(serial BIGINT, descricao text) ORDER BY serial ASC    Loop        texto:= replace(registro.descricao,'empresa = ' || chr(39) || EmpOrigem || chr(39),'empresa = ' || chr(39) || EmpDestino || chr(39));        texto:= replace(texto,'fk_empresa = ' || chr(39) || EmpOrigem || chr(39),'fk_empresa = ' || chr(39) || EmpDestino || chr(39));        texto:= replace(texto,'empresa = ' || EmpOrigem,'empresa = ' || EmpDestino);        texto:= replace(texto,'fk_empresa = ' || EmpOrigem,'fk_empresa = ' || EmpDestino);        texto:= replace(texto,'pk_empresa = ' || EmpOrigem,'pk_empresa = ' || EmpDestino);        texto:= replace(texto,'empresa_destino', chr(39) || EmpDestino || chr(39));        texto:= replace(texto,'empresa_origem', chr(39) || EmpOrigem || chr(39));        Raise NOTICE 'executando %', texto;        EXECUTE  texto;        Raise NOTICE 'deletando %', 'DELETE FROM replicacao_cadastros WHERE serial = '|| registro.serial ||'';        PERFORM dblink_exec(conexao,'DELETE FROM replicacao_cadastros WHERE serial = ' || registro.serial ||'',true);    END LOOP;    RETURN NULL; END; $$;


ALTER FUNCTION public.replica_cadastro(usuario text, senha text, host text, porta text, loja text, empdestino text, emporigem text) OWNER TO "ADMIN";

--
-- Name: reverse(text); Type: FUNCTION; Schema: public; Owner: ADMIN
--

CREATE FUNCTION reverse(input text) RETURNS text
    LANGUAGE plpgsql IMMUTABLE STRICT
    AS $$ DECLARE RESULT text = ''; i INT; BEGIN FOR i IN 1..LENGTH(INPUT) BY 2 LOOP RESULT = substr(INPUT,i+1,1) || substr(INPUT,i,1) || RESULT; END LOOP; RETURN RESULT; END$$;


ALTER FUNCTION public.reverse(input text) OWNER TO "ADMIN";

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: abertura_caixa; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE abertura_caixa (
    caixa bigint,
    codigo bigint,
    nome_caixa character varying(100),
    data_abertura date,
    hora_abertura character varying(50),
    data_fechamento date,
    hora_fechamento character varying(50),
    serie_nf character varying(5),
    empresa bigint,
    pk_aberturacaixa bigint NOT NULL,
    gaveta_inicial numeric(15,4),
    gaveta_final numeric(15,4),
    fechamento_conciliado boolean DEFAULT false
);


ALTER TABLE abertura_caixa OWNER TO "ADMIN";

--
-- Name: acerto_vendedores; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE acerto_vendedores (
    empresa bigint,
    numero_do_documento bigint,
    tipo_de_documento bigint,
    nome_do_documento character varying(100),
    data_de_emissao date,
    data_do_vencimento date,
    numero_da_nf character varying(20),
    serie_nf character varying(2),
    vendedor bigint,
    data_liberacao date,
    numero_pedido bigint DEFAULT 0,
    saldo numeric(15,4) DEFAULT 0,
    nome_do_cliente character varying(100),
    numero_da_duplicata character varying(30)
);


ALTER TABLE acerto_vendedores OWNER TO "ADMIN";

--
-- Name: agenda; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE agenda (
    empresa bigint,
    codigo_usuario bigint,
    nome_usuario character varying(100),
    data date,
    item bigint,
    codigo bigint,
    nome character varying(100),
    data_agendamento date,
    horario_agendamento character varying(6),
    descricao text,
    status character varying(2) DEFAULT 'A'::character varying,
    descricao1 character varying(114),
    descricao2 character varying(114),
    descricao3 character varying(114),
    descricao4 character varying(114),
    descricao5 character varying(114)
);


ALTER TABLE agenda OWNER TO "ADMIN";

--
-- Name: agenda_atendimento_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE agenda_atendimento_pocket (
    aga_data date NOT NULL,
    pct_id integer NOT NULL,
    aga_status_atualizacao character varying,
    aga_mensagem_atendimento character varying,
    aga_grupo bigint DEFAULT 0 NOT NULL,
    aga_data_atualizacao date
);


ALTER TABLE agenda_atendimento_pocket OWNER TO "ADMIN";

--
-- Name: aliquota; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE aliquota (
    codigo bigint NOT NULL,
    nome character varying(50) NOT NULL,
    aliquota_do_imposto numeric(15,4) NOT NULL,
    empresa bigint NOT NULL
);


ALTER TABLE aliquota OWNER TO "ADMIN";

--
-- Name: aliquota_transportadora; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE aliquota_transportadora (
    bc_inicial numeric(15,4),
    bc_final numeric(15,4),
    aliquota_inicial numeric(15,4),
    deducao_inicial numeric(15,4),
    bc_acima numeric(15,4),
    aliquota_final numeric(15,4),
    deducao_final numeric(15,4),
    bc_inss numeric(15,4),
    inss_aliquota numeric(15,4),
    desconto_inss numeric(15,4),
    sest_senat numeric(15,4)
);


ALTER TABLE aliquota_transportadora OWNER TO "ADMIN";

--
-- Name: alteracao_cliente; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE alteracao_cliente (
    codigo_campo bigint,
    valor_anterior character varying(100),
    data_alteracao date,
    codigo_cliente bigint
);


ALTER TABLE alteracao_cliente OWNER TO "ADMIN";

--
-- Name: alteracao_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE alteracao_produto (
    codigo_produto character varying(20),
    descricao character varying(100),
    data_inicial date,
    data_final date
);


ALTER TABLE alteracao_produto OWNER TO "ADMIN";

--
-- Name: banco; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE banco (
    codigo bigint NOT NULL,
    nome character varying(100),
    bairro character varying(100),
    cidade character varying(100),
    endereco character varying(100),
    numero character varying(10),
    complemento character varying(20),
    estado character varying(2),
    cep character varying(8),
    cgc character varying(20),
    telefone character varying(30),
    portador_padrao bigint,
    previsao_inativa bigint,
    conta_contabil character varying(15) DEFAULT 0,
    saldo numeric(15,4) DEFAULT 0,
    saldo_conciliado numeric(15,4) DEFAULT 0,
    saldo_cx numeric(15,4) DEFAULT 0,
    saldo_conciliado_cx numeric(15,4) DEFAULT 0,
    limite_credito numeric(15,4) DEFAULT 0,
    saldo_todos_lancamentos smallint DEFAULT 0,
    juros numeric(15,4) DEFAULT 0,
    empresa bigint,
    codigo_banco character varying(5),
    fk_configuracao_boleto bigint,
    fk_conta_corrente integer,
    inativo boolean DEFAULT false NOT NULL
);


ALTER TABLE banco OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: boleta_nf; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE boleta_nf (
    nome_empresa_x bigint,
    nome_empresa_y bigint,
    endereco_empresa_x bigint,
    endereco_empresa_y bigint,
    cidade_empresa_x bigint,
    cidade_empresa_y bigint,
    estado_empresa_x bigint,
    estado_empresa_y bigint,
    cgc_empresa_x bigint,
    cgc_empresa_y bigint,
    inscricao_empresa_x bigint,
    inscricao_empresa_y bigint,
    data_emissao_x bigint,
    data_emissao_y bigint,
    vendedor_x bigint,
    vendedor_y bigint,
    numero_nf_x bigint,
    numero_nf_y bigint,
    valor_nf_x bigint,
    valor_nf_y bigint,
    numero_duplicata_x bigint,
    numero_duplicata_y bigint,
    valor_duplicata_x bigint,
    valor_duplicata_y bigint,
    vencimento_x bigint,
    vencimento_y bigint,
    nome_cliente_x bigint,
    nome_cliente_y bigint,
    endereco_cliente_x bigint,
    endereco_cliente_y bigint,
    telefone_cliente_x bigint,
    telefone_cliente_y bigint,
    cidade_cliente_x bigint,
    cidade_cliente_y bigint,
    estado_cliente_x bigint,
    estado_cliente_y bigint,
    cep_cliente_x bigint,
    cep_cliente_y bigint,
    cgc_cliente_x bigint,
    cgc_cliente_y bigint,
    inscricao_cliente_x bigint,
    inscricao_cliente_y bigint,
    numero_linhas bigint,
    instrucao_1_x bigint,
    instrucao_1_y bigint,
    instrucao_2_x bigint,
    instrucao_2_y bigint,
    instrucao_3_x bigint,
    instrucao_3_y bigint,
    instrucao_4_x bigint,
    instrucao_4_y bigint,
    instrucao_1 character varying(200),
    instrucao_2 character varying(200),
    instrucao_3 character varying(200),
    instrucao_4 character varying(200),
    data_proc_x bigint,
    data_proc_y bigint,
    outros_lanc_x bigint,
    outros_lanc_y bigint,
    outros_valores_x bigint,
    outros_valores_y bigint,
    salto_paginas bigint,
    ativar_condensado bigint DEFAULT 1,
    ativar_linhas_juntas bigint DEFAULT 1,
    banco bigint DEFAULT 1,
    nome_banco character varying(100),
    juros_c bigint DEFAULT 0,
    juros_l bigint DEFAULT 0,
    especie_c bigint DEFAULT 0,
    "especie_L" bigint DEFAULT 0,
    aceite_c bigint DEFAULT 0,
    "aceite_L" bigint DEFAULT 0,
    especie character varying(10) DEFAULT ''::character varying,
    aceite character varying(10) DEFAULT ''::character varying,
    arquivo_licenca character varying(100) DEFAULT ''::character varying,
    carteira bigint DEFAULT 0,
    compensacao bigint DEFAULT 0,
    seq_nome_arquivo bigint DEFAULT 0,
    sequencia bigint DEFAULT 0,
    layout character varying(100) DEFAULT ''::character varying,
    proximo_nosso_numero bigint DEFAULT 0,
    diretorio_arquivo character varying(100) DEFAULT ''::character varying,
    tipo_impressao_boleto character varying(100) DEFAULT ''::character varying,
    codigo_html character varying(200) DEFAULT ''::character varying,
    margem_superior bigint DEFAULT 0,
    qtde_caracteres_sacado bigint DEFAULT 0,
    conta_corrente character varying(30) DEFAULT ''::character varying,
    agencia character varying(10) DEFAULT ''::character varying,
    codigo_empresa_banco character varying(30) DEFAULT ''::character varying,
    inicio_nosso_numero bigint DEFAULT 0,
    fim_nosso_numero bigint DEFAULT 0,
    configuracao1 character varying(100) DEFAULT ''::character varying,
    configuracao2 character varying(100) DEFAULT ''::character varying,
    local_pgto character varying(200) DEFAULT ''::character varying,
    local_pgto_c bigint DEFAULT 0,
    local_pgto_l bigint DEFAULT 0,
    linhas_instrucao bigint DEFAULT 0,
    fonte character varying(100) DEFAULT ''::character varying,
    valor_duplicata2_c smallint DEFAULT 0,
    valor_duplicata2_l smallint DEFAULT 0,
    apresenta_juros_multa smallint DEFAULT 0,
    cod_baixa_dev smallint DEFAULT 0,
    dias_baixa_dev bigint DEFAULT 0,
    servidor_email bigint,
    logotipocedente character varying,
    tipo_boleto_email character varying,
    layoutretorno character varying(100),
    dv_agencia character varying(3)
);


ALTER TABLE boleta_nf OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: cad_acessor_clientes; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_acessor_clientes (
    empresa bigint,
    codigo bigint NOT NULL,
    nome character varying(250),
    telefone character varying(12),
    celular character varying(11)
);


ALTER TABLE cad_acessor_clientes OWNER TO "ADMIN";

--
-- Name: cad_cliente_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_cliente_pocket (
    clip_id bigint NOT NULL,
    pct_id integer NOT NULL,
    clip_codigo_cliente_pocket character varying,
    clip_razao_social character varying,
    clip_cnpj_cpf character varying,
    clip_nome_fantasia character varying,
    clip_endereco character varying,
    clip_bairro character varying,
    clip_cep character varying,
    clip_telefone character varying,
    clip_fax character varying,
    clip_celular character varying,
    clip_endereco_cobranca character varying,
    clip_bairro_cobranca character varying,
    clip_cep_cobranca character varying,
    clip_fax_cobranca character varying,
    clip_telefone_cobranca character varying,
    clip_celular_cobranca character varying,
    clip_inscricao_estadual character varying,
    clip_identidade character varying,
    clip_orgao_emissor character varying,
    clip_tipo_pessoa character varying,
    clip_contatos character varying,
    clip_data_cadastro date,
    clip_data_alteracao date,
    codigo_cidade_cliente integer,
    codigo_cidade_cobranca integer,
    clip_observacoes character varying,
    clip_ponto_referencia character varying,
    codigo_grupo_clientes bigint DEFAULT 0,
    clip_status character varying
);


ALTER TABLE cad_cliente_pocket OWNER TO "ADMIN";

--
-- Name: cad_cliente_pocket_clip_id_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE cad_cliente_pocket_clip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cad_cliente_pocket_clip_id_seq OWNER TO "ADMIN";

--
-- Name: cad_cliente_pocket_clip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE cad_cliente_pocket_clip_id_seq OWNED BY cad_cliente_pocket.clip_id;


--
-- Name: cad_formula_pontos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_formula_pontos (
    empresa bigint,
    cfp_codigo bigint,
    cfp_descricao character varying(100),
    cfp_validade integer,
    cfp_formula text,
    cfp_formula_devolucao text,
    cfp_data_inicio date,
    cfp_habilitado smallint DEFAULT 0
);


ALTER TABLE cad_formula_pontos OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: cad_grade; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_grade (
    grade_id integer NOT NULL,
    grade_descricao character varying(20) NOT NULL,
    inativo smallint DEFAULT 0,
    categoria character varying(4) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE cad_grade OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: cad_licenca_uso; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_licenca_uso (
    cli_id bigint NOT NULL,
    lu_serial_macadress character varying NOT NULL,
    lu_data_expiracao date,
    lu_status_liberacao character varying,
    lu_chave_seguranca_pocket character varying,
    lu_licenca_uso character varying
);


ALTER TABLE cad_licenca_uso OWNER TO "ADMIN";

--
-- Name: cad_pedido_venda_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_pedido_venda_pocket (
    pvp_id bigint NOT NULL,
    pct_id integer NOT NULL,
    pvp_codigo_cliente character varying NOT NULL,
    pvp_cod_condicao_pagamento integer NOT NULL,
    pvp_cod_pedido_pocket bigint NOT NULL,
    pvp_sub_total numeric,
    pvp_desconto numeric,
    pvp_acrescimo numeric,
    pvp_valor_liquido numeric,
    pvp_observacoes character varying,
    pvp_data_cadastro date,
    pvp_data_alteracao date,
    pvp_status_faturamento character varying,
    pvp_codigo_pedido character varying,
    pvp_juros_parcelas_variaveis numeric,
    tp_id integer
);


ALTER TABLE cad_pedido_venda_pocket OWNER TO "ADMIN";

--
-- Name: cad_pedido_venda_pocket_pvp_id_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE cad_pedido_venda_pocket_pvp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cad_pedido_venda_pocket_pvp_id_seq OWNER TO "ADMIN";

--
-- Name: cad_pedido_venda_pocket_pvp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE cad_pedido_venda_pocket_pvp_id_seq OWNED BY cad_pedido_venda_pocket.pvp_id;


--
-- Name: cad_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_pocket (
    pct_id integer NOT NULL,
    cod_vendedor bigint,
    pct_versao character varying,
    pct_query_bd_sqlce character varying,
    pct_usar_produto_multiplo bit(1),
    pct_numero_serie character varying
);


ALTER TABLE cad_pocket OWNER TO "ADMIN";

--
-- Name: cad_resultado_atendimento_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_resultado_atendimento_pocket (
    cres_id bigint,
    cres_resultado character varying,
    cres_status_atendimento character varying(2)
);


ALTER TABLE cad_resultado_atendimento_pocket OWNER TO "ADMIN";

--
-- Name: cad_servidoremail; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_servidoremail (
    codigo bigint,
    descricao character varying(100),
    servidor character varying,
    porta character varying,
    usuario character varying,
    senha character varying,
    url_logotipo character varying,
    titulo_email character varying,
    mensagem text,
    email_responsavel character varying,
    msg_cobranca text,
    fk_configuracao_documento_fiscal_eletronico bigint,
    enviar_copia_oculta boolean DEFAULT false,
    ssl smallint
);


ALTER TABLE cad_servidoremail OWNER TO "ADMIN";

--
-- Name: TABLE cad_servidoremail; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE cad_servidoremail IS 'Mensagem para envio de cobrana de titulos em atraso';


--
-- Name: cad_tabela_preco_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_tabela_preco_pocket (
    tp_id integer NOT NULL,
    tp_nome character varying,
    tp_status character varying,
    tp_id_tabela_pocket integer,
    tp_data_cadastro date,
    tp_data_alteracao date
);


ALTER TABLE cad_tabela_preco_pocket OWNER TO "ADMIN";

--
-- Name: cad_tipoimposto_impressorasfiscais; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cad_tipoimposto_impressorasfiscais (
    pk_codigo bigint NOT NULL,
    fk_aliquota bigint,
    fk_impressorasfiscais bigint,
    fk_empresa bigint NOT NULL,
    codigo_tributacao character varying(4)
);


ALTER TABLE cad_tipoimposto_impressorasfiscais OWNER TO "ADMIN";

--
-- Name: TABLE cad_tipoimposto_impressorasfiscais; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE cad_tipoimposto_impressorasfiscais IS 'Grava os tipos de impostos cadastrados nas impressoras fiscais ex. Bematech FF - SUBSITUICAO  II - ISENTO IN - NAO TRIBUTADO 01 - ICMS 12% 02 - ICMS 13%';


--
-- Name: cad_tipoimposto_impressorasfiscais_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE cad_tipoimposto_impressorasfiscais_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cad_tipoimposto_impressorasfiscais_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: cad_tipoimposto_impressorasfiscais_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE cad_tipoimposto_impressorasfiscais_pk_codigo_seq OWNED BY cad_tipoimposto_impressorasfiscais.pk_codigo;


--
-- Name: cadastro_arquivos_contratos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_arquivos_contratos (
    empresa bigint,
    cod_cliente bigint,
    ordem integer NOT NULL,
    data character varying,
    nome_arquivo character varying,
    usuario character varying,
    cod_modelo bigint
);


ALTER TABLE cadastro_arquivos_contratos OWNER TO "ADMIN";

--
-- Name: cadastro_arquivos_contratos_ordem_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE cadastro_arquivos_contratos_ordem_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cadastro_arquivos_contratos_ordem_seq OWNER TO "ADMIN";

--
-- Name: cadastro_arquivos_contratos_ordem_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE cadastro_arquivos_contratos_ordem_seq OWNED BY cadastro_arquivos_contratos.ordem;


--
-- Name: cadastro_atendimento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_atendimento (
    codigo bigint,
    descricao character varying(200)
);


ALTER TABLE cadastro_atendimento OWNER TO "ADMIN";

--
-- Name: cadastro_atividades; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_atividades (
    codigo bigint,
    descricao character varying(200),
    empresa bigint
);


ALTER TABLE cadastro_atividades OWNER TO "ADMIN";

--
-- Name: cadastro_atividades_cliente; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_atividades_cliente (
    empresa bigint,
    codigo_cliente bigint,
    codigo_atividade bigint,
    codigo_subatividades bigint
);


ALTER TABLE cadastro_atividades_cliente OWNER TO "ADMIN";

--
-- Name: cadastro_bens; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_bens (
    codigo bigint,
    nome_bens character varying(100),
    unidade character varying(6),
    nserie_obrigatorio smallint
);


ALTER TABLE cadastro_bens OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: cadastro_caixas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_caixas (
    codigo bigint NOT NULL,
    descricao character varying NOT NULL,
    unidades numeric(15,4),
    inativo smallint
);


ALTER TABLE cadastro_caixas OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: cadastro_caixas_venda; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_caixas_venda (
    caixa bigint NOT NULL,
    empresa bigint NOT NULL,
    usa_tef bigint,
    fk_impressorafiscal bigint,
    fk_gerenciadortef bigint,
    fk_configuracaobalanca bigint
);


ALTER TABLE cadastro_caixas_venda OWNER TO "ADMIN";

--
-- Name: cadastro_caracteristica; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_caracteristica (
    codigo bigint NOT NULL,
    codigo_caixa bigint,
    codigo_produto character varying NOT NULL,
    codigo_fornecedor bigint,
    codigo_fabricante bigint
);


ALTER TABLE cadastro_caracteristica OWNER TO "ADMIN";

--
-- Name: cadastro_caracteristica_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE cadastro_caracteristica_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cadastro_caracteristica_codigo_seq OWNER TO "ADMIN";

--
-- Name: cadastro_caracteristica_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE cadastro_caracteristica_codigo_seq OWNED BY cadastro_caracteristica.codigo;


--
-- Name: cadastro_centro_custo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_centro_custo (
    codigo bigint NOT NULL,
    descricao character varying(200),
    padrao smallint DEFAULT 0,
    empresa bigint,
    data_cadastro timestamp without time zone,
    data_alteracao timestamp without time zone
);


ALTER TABLE cadastro_centro_custo OWNER TO "ADMIN";

--
-- Name: cadastro_cidades; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_cidades (
    codigo bigint NOT NULL,
    cidade character varying(200),
    estado character varying(3),
    descricao_uf character varying(200),
    cep character varying(8),
    ddd character varying(4),
    distancia numeric(15,4),
    empresa bigint,
    data_cadastro timestamp without time zone DEFAULT '1900-01-01'::date,
    data_alteracao timestamp without time zone DEFAULT '1900-01-01'::date,
    codigo_municipio bigint DEFAULT 0,
    codigo_pais bigint DEFAULT 0,
    inativo smallint DEFAULT 0,
    codigo_municipio_setec character varying(10),
    fk_pais bigint DEFAULT 0 NOT NULL
);


ALTER TABLE cadastro_cidades OWNER TO "ADMIN";

--
-- Name: cadastro_comissao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_comissao (
    empresa bigint,
    codigo bigint,
    codigo_grupo character varying(20),
    nome_grupo character varying(100),
    codigo_produto character varying(20),
    nome_produto character varying(100),
    codigo_funcionario bigint,
    nome_funcionario character varying(100),
    desc_minimo numeric(15,4),
    com_minima numeric(15,4),
    desc_maximo numeric(15,4),
    com_maxima numeric(15,4),
    codigo_pagamento bigint DEFAULT 0,
    nome_pagamento character varying(100),
    codigo_regiao bigint DEFAULT 0,
    codigo_cliente bigint
);


ALTER TABLE cadastro_comissao OWNER TO "ADMIN";

--
-- Name: cadastro_conveniado; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_conveniado (
    codigo bigint,
    nome_convenio character varying(100),
    codigo_cliente bigint,
    nome_cliente character varying(100),
    inativo smallint,
    empresa bigint
);


ALTER TABLE cadastro_conveniado OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: cadastro_cores; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_cores (
    codigo bigint NOT NULL,
    descricao character varying NOT NULL,
    inativo smallint
);


ALTER TABLE cadastro_cores OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: cadastro_custos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_custos (
    codigo bigint,
    descricao character varying(100),
    unidade character varying(6)
);


ALTER TABLE cadastro_custos OWNER TO "ADMIN";

--
-- Name: cadastro_defeito; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_defeito (
    codigo bigint,
    nome_defeito character varying(100),
    tipo character varying(2)
);


ALTER TABLE cadastro_defeito OWNER TO "ADMIN";

--
-- Name: cadastro_descricao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_descricao (
    codigo bigint,
    descricao character varying(200),
    numero_solicitacao bigint DEFAULT 0,
    verifica_modulos smallint DEFAULT 0
);


ALTER TABLE cadastro_descricao OWNER TO "ADMIN";

--
-- Name: cadastro_endereco_estoque; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_endereco_estoque (
    codigo bigint,
    descricao character varying(200),
    empresa bigint
);


ALTER TABLE cadastro_endereco_estoque OWNER TO "ADMIN";

--
-- Name: cadastro_etapas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_etapas (
    codigo bigint,
    descricao character varying(200),
    observacoes text
);


ALTER TABLE cadastro_etapas OWNER TO "ADMIN";

--
-- Name: cadastro_etapas_separacao_mercadoria; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_etapas_separacao_mercadoria (
    pk_codigo bigint NOT NULL,
    descricao character varying(20),
    inativo integer DEFAULT 0 NOT NULL,
    sequencia integer
);


ALTER TABLE cadastro_etapas_separacao_mercadoria OWNER TO "ADMIN";

--
-- Name: TABLE cadastro_etapas_separacao_mercadoria; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE cadastro_etapas_separacao_mercadoria IS 'Cadastro de etapas que sero utilizados na separao de mercadoria venda (tela despacho de mercadoria)';


--
-- Name: COLUMN cadastro_etapas_separacao_mercadoria.inativo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN cadastro_etapas_separacao_mercadoria.inativo IS 'Informa se a etapa est ativa ou inativa! 0 - Ativa 1 - Inativa';


--
-- Name: COLUMN cadastro_etapas_separacao_mercadoria.sequencia; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN cadastro_etapas_separacao_mercadoria.sequencia IS 'Informa o workflow.';


--
-- Name: cadastro_fabricante; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_fabricante (
    empresa bigint,
    codigo bigint,
    nome_fabricante character varying(200),
    codigo_cidade bigint,
    nome_cidade character varying(200),
    estado character varying(3),
    cep character varying(8),
    telefone character varying(12),
    fax character varying(12),
    nome_logomarca character varying(40),
    disponivel_ecommerce smallint DEFAULT 0
);


ALTER TABLE cadastro_fabricante OWNER TO "ADMIN";

--
-- Name: cadastro_licencas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_licencas (
    id_cliente bigint,
    numero_licencas bigint,
    data_inicio date,
    data_bloqueio date,
    liberacao bigint,
    mensagem text DEFAULT ''::text,
    codigo_usuario bigint DEFAULT 0,
    atendimento_externo bigint DEFAULT 0,
    cgc character varying DEFAULT ''::character varying,
    numero_acessos_externos bigint DEFAULT 0
);


ALTER TABLE cadastro_licencas OWNER TO "ADMIN";

--
-- Name: COLUMN cadastro_licencas.numero_acessos_externos; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN cadastro_licencas.numero_acessos_externos IS 'Informar o numero de acessos externos';


--
-- Name: cadastro_metas_cotas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_metas_cotas (
    empresa bigint,
    mes bigint,
    cod_funcionario bigint,
    cota numeric(15,4) DEFAULT 0,
    cota_intermediaria numeric(15,4) DEFAULT 0,
    meta numeric(15,4) DEFAULT 0
);


ALTER TABLE cadastro_metas_cotas OWNER TO "ADMIN";

--
-- Name: cadastro_modelos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_modelos (
    codigo bigint,
    descricao character varying,
    status smallint,
    endereco character varying,
    endereco_arquivo character varying
);


ALTER TABLE cadastro_modelos OWNER TO "ADMIN";

--
-- Name: cadastro_modulos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_modulos (
    id_cliente bigint,
    codigo_modulo character varying(100),
    nome_modulo character varying(100),
    quantidade_licencas bigint DEFAULT 0
);


ALTER TABLE cadastro_modulos OWNER TO "ADMIN";

--
-- Name: cadastro_numeracao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_numeracao (
    numero bigint,
    descricao character varying
);


ALTER TABLE cadastro_numeracao OWNER TO "ADMIN";

--
-- Name: cadastro_observacoes; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_observacoes (
    codigo bigint,
    cfop character varying(5),
    status smallint,
    descricao text,
    obs_reducao text,
    obs_isento text DEFAULT ''::text,
    empresa bigint
);


ALTER TABLE cadastro_observacoes OWNER TO "ADMIN";

--
-- Name: cadastro_pos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_pos (
    pk_codigo bigint NOT NULL,
    descricao character varying(100) NOT NULL,
    localizacao character varying(100) NOT NULL,
    numeroserie character varying(100),
    inativo character varying(1) DEFAULT 0 NOT NULL,
    fk_credenciadora bigint
);


ALTER TABLE cadastro_pos OWNER TO "ADMIN";

--
-- Name: TABLE cadastro_pos; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE cadastro_pos IS 'Armazenar os dados das maquinas de POS (carto de crdito)  ex.: pagh light';


--
-- Name: cadastro_quantidade_tamanho; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_quantidade_tamanho (
    fk_movimentograde bigint NOT NULL,
    fk_cadcaracteristica bigint NOT NULL,
    quantidade numeric(15,4),
    quantidade_alta numeric(15,4)
);


ALTER TABLE cadastro_quantidade_tamanho OWNER TO "ADMIN";

--
-- Name: TABLE cadastro_quantidade_tamanho; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE cadastro_quantidade_tamanho IS 'Responsvel por armazenar as quantidades e quantidades alta determinadas para cada tamanho ';


--
-- Name: cadastro_regioes; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_regioes (
    codigo bigint NOT NULL,
    descricao character varying(200),
    empresa bigint
);


ALTER TABLE cadastro_regioes OWNER TO "ADMIN";

--
-- Name: cadastro_registro_licencas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_registro_licencas (
    id_cliente bigint,
    codigo_acesso character varying(100),
    registro_licenca character varying(100),
    tipo_estacao smallint
);


ALTER TABLE cadastro_registro_licencas OWNER TO "ADMIN";

--
-- Name: cadastro_rotas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_rotas (
    codigo bigint,
    descricao character varying(200),
    quilometro character varying(20),
    empresa bigint
);


ALTER TABLE cadastro_rotas OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: cadastro_statuspedidobi; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_statuspedidobi (
    pk_codigo bigint NOT NULL,
    fk_condicaopgto bigint NOT NULL,
    status_pedido bigint NOT NULL
);


ALTER TABLE cadastro_statuspedidobi OWNER TO "ADMIN";

--
-- Name: cadastro_statuspedidobi_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE cadastro_statuspedidobi_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cadastro_statuspedidobi_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: cadastro_statuspedidobi_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE cadastro_statuspedidobi_pk_codigo_seq OWNED BY cadastro_statuspedidobi.pk_codigo;


SET default_with_oids = true;

--
-- Name: cadastro_subatividades; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_subatividades (
    empresa bigint,
    codigo_atividades bigint,
    codigo bigint,
    descricao character varying(200)
);


ALTER TABLE cadastro_subatividades OWNER TO "ADMIN";

--
-- Name: cadastro_tamanhocaracteristica; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_tamanhocaracteristica (
    id_cadtamanhocaracteristica bigint NOT NULL,
    codigo_caract bigint NOT NULL,
    codigo_tamanho bigint NOT NULL,
    codigo_cores bigint NOT NULL,
    inativo smallint
);


ALTER TABLE cadastro_tamanhocaracteristica OWNER TO "ADMIN";

--
-- Name: cadastro_tamanhocaracteristica_id_cadtamanhocaracteristica_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE cadastro_tamanhocaracteristica_id_cadtamanhocaracteristica_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cadastro_tamanhocaracteristica_id_cadtamanhocaracteristica_seq OWNER TO "ADMIN";

--
-- Name: cadastro_tamanhocaracteristica_id_cadtamanhocaracteristica_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE cadastro_tamanhocaracteristica_id_cadtamanhocaracteristica_seq OWNED BY cadastro_tamanhocaracteristica.id_cadtamanhocaracteristica;


--
-- Name: cadastro_unidades; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_unidades (
    codigo bigint NOT NULL,
    descricao character varying(100) NOT NULL,
    unidade character varying(6) NOT NULL,
    inativo smallint DEFAULT 0
);


ALTER TABLE cadastro_unidades OWNER TO "ADMIN";

--
-- Name: cadastro_vendedores_regiao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_vendedores_regiao (
    empresa bigint,
    cod_vendedor bigint,
    cod_cidade bigint
);


ALTER TABLE cadastro_vendedores_regiao OWNER TO "ADMIN";

--
-- Name: cadastro_versao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cadastro_versao (
    versao character varying,
    ordem bigint DEFAULT (0)::bigint,
    modulos character varying,
    telas character varying,
    texto text,
    telas_texto character varying,
    data date
);


ALTER TABLE cadastro_versao OWNER TO "ADMIN";

--
-- Name: caixas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE caixas (
    caixa bigint,
    numero_maquina character varying(100),
    empresa bigint
);


ALTER TABLE caixas OWNER TO "ADMIN";

--
-- Name: calculo_entrada_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE calculo_entrada_tmp (
    empresa bigint,
    codigo_usuario bigint,
    ordem_item bigint,
    data_emissao date,
    codigo_fornecedor bigint,
    numero_nf bigint,
    codigo_produto character varying(20),
    porc_reduzida numeric(15,4),
    iva numeric(15,4),
    icms numeric(15,4),
    porc_substituicao numeric(15,4),
    sub_total numeric(15,4),
    base_calc_icms numeric(15,4),
    valor_icms numeric(15,4),
    base_calc_substituicao numeric(15,4),
    valor_icms_subst numeric(15,4),
    valor_ipi numeric(15,4),
    valor_outras numeric(15,4),
    valor_seguro numeric(15,4),
    valor_frete numeric(15,4),
    valor_icms_frete numeric(15,4),
    valor_desconto numeric(15,4),
    custo_atual numeric(15,4) DEFAULT 0,
    marckup_atacado numeric(15,4) DEFAULT 0,
    marckup_varejo numeric(15,4) DEFAULT 0,
    preco_varejo numeric(15,4) DEFAULT 0,
    preco_atacado numeric(15,4) DEFAULT 0,
    outros character varying(3),
    pis numeric(15,4) DEFAULT 0,
    cofins numeric(15,4) DEFAULT 0
);


ALTER TABLE calculo_entrada_tmp OWNER TO "ADMIN";

--
-- Name: calculo_preco_venda; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE calculo_preco_venda (
    codigo_grupo character varying(20),
    codigo_produto character varying(20),
    marcacao_venda character varying(20),
    frete numeric(15,4),
    pis numeric(15,4),
    icms_simples numeric(15,4),
    cpmf numeric(15,4),
    imposto_renda numeric(15,4),
    despesas_fixas numeric(15,4),
    comissoes numeric(15,4),
    cofins numeric(15,4),
    juros numeric(15,4),
    depreciacao numeric(15,4),
    previsao_descontos numeric(15,4),
    contribuicao_social numeric(15,4),
    simples numeric(15,4),
    lucro_atacado numeric(15,4),
    lucro_varejo numeric(15,4)
);


ALTER TABLE calculo_preco_venda OWNER TO "ADMIN";

--
-- Name: categoria; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE categoria (
    codigo bigint NOT NULL,
    nome character varying(100),
    status character(1),
    codigopai bigint
);


ALTER TABLE categoria OWNER TO "ADMIN";

--
-- Name: cheques_fornecedor; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cheques_fornecedor (
    codigo_fornecedor bigint,
    nome_fornecedor character varying(100),
    data_lancamento date,
    numero_cheque character varying(50),
    data_emissao date,
    data_vencimento date,
    codigo_cliente bigint,
    nome_cliente character varying(100),
    nome_emitido character varying(100),
    valor numeric(15,4),
    pgto_devolvido character varying(3),
    status character varying(2) DEFAULT 'C'::character varying,
    codigo_bordero bigint DEFAULT 0
);


ALTER TABLE cheques_fornecedor OWNER TO "ADMIN";

--
-- Name: cliente; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cliente (
    codigo bigint NOT NULL,
    razao_social character varying(100),
    nome_fantasia character varying(100),
    endereco character varying(100),
    bairro character varying(100),
    cidade character varying(100),
    uf character varying(2),
    pais character varying(50),
    caixa_postal character varying(20),
    cep character varying(8),
    telefone character varying(12),
    fax character varying(12),
    telefone_dados character varying(12),
    cgc character varying(14),
    identidade character varying(14),
    orgao_emissor character varying(10),
    pessoa bigint,
    inscricao_estadual character varying(20),
    ponto_referencia text,
    ponto_referencia_1 text,
    data_cadastro timestamp without time zone,
    data_alteracao timestamp without time zone,
    restricao character varying(20),
    inativo bigint,
    endereco_cobranca character varying(100),
    bairro_cobranca character varying(100),
    cidade_cobranca character varying(100),
    uf_cobranca character varying(4),
    caixa_postal_cobranca character varying(20),
    cep_cobranca character varying(11),
    telefone_cobranca character varying(12),
    fax_cobranca character varying(12),
    fone1_cobranca character varying(12),
    ponto_referencia_cobranca text,
    ponto_referencia_cobranca1 text,
    email character varying(100),
    site character varying(40),
    nome_pai character varying(100),
    nome_mae character varying(100),
    endereco_pai character varying(100),
    bairro_pai character varying(100),
    cidade_pai character varying(100),
    conjuge character varying(100),
    local_trabalho character varying(100),
    data_admissao date,
    endereco_trabalho character varying(100),
    bairro_trabalho character varying(100),
    cidade_trabalho character varying(100),
    uf_trabalho character varying(4),
    cep_trabalho character varying(11),
    telefone_trabalho character varying(12),
    fax_trabalho character varying(12),
    cargo_funcao character varying(100),
    renda_trabalho numeric(15,4),
    nome_comercial_1 character varying(100),
    fone_comercial_1 character varying(12),
    data_comercial_1 date,
    maior_fatura_1 numeric(15,4),
    ultima_fatura_1 numeric(15,4),
    pagamento_comercial_1 character varying(100),
    contato_comercial_1 character varying(100),
    conceito_comercial_1 character varying(100),
    nome_comercial_2 character varying(100),
    fone_comercial_2 character varying(12),
    data_comercial_2 date,
    maior_fatura_2 numeric(15,4),
    ultima_fatura_2 numeric(15,4),
    pagamento_comercial_2 character varying(100),
    contato_comercial_2 character varying(100),
    conceito_comercial_2 character varying(100),
    nome_comercial_3 character varying(100),
    fone_comercial_3 character varying(12),
    data_comercial_3 date,
    maior_fatura_3 numeric(15,4),
    ultima_fatura_3 numeric(15,4),
    pagamento_comercial_3 character varying(100),
    contato_comercial_3 character varying(100),
    conceito_comercial_3 character varying(100),
    nome_banco_1 character varying(100),
    fone_banco_1 character varying(12),
    data_banco_1 date,
    conta_banco_1 character varying(40),
    contato_banco_1 character varying(100),
    conceito_banco_1 character varying(100),
    agencia_banco_1 character varying(50),
    nome_banco_2 character varying(100),
    fone_banco_2 character varying(12),
    data_banco_2 date,
    conta_banco_2 character varying(40),
    contato_banco_2 character varying(100),
    conceito_banco_2 character varying(100),
    agencia_banco_2 character varying(50),
    nome_banco_3 character varying(100),
    fone_banco_3 character varying(12),
    data_banco_3 date,
    conta_banco_3 character varying(40),
    contato_banco_3 character varying(100),
    conceito_banco_3 character varying(100),
    agencia_banco_3 character varying(50),
    codigo_pagamento bigint,
    forma_pagamento character varying(100),
    codigo_cartao character varying(40),
    senha_cartao character varying(20),
    limite_credito numeric(15,4),
    inicio_cartao date,
    vencimento_cartao date,
    vencimento_parcelas bigint,
    conta_contabil character varying(50),
    codigo_vendedor bigint,
    nome_vendedor character varying(100),
    nome_socio_1 character varying(100),
    identidade_socio_1 character varying(20),
    emissor_socio_1 character varying(20),
    nascimento_socio_1 date,
    cpf_socio_1 character varying(20),
    endereco_socio_1 character varying(100),
    bairro_socio_1 character varying(100),
    cidade_socio_1 character varying(100),
    estado_socio_1 character varying(4),
    cep_socio_1 character varying(20),
    telefone_socio_1 character varying(20),
    fundacao_socio_1 date,
    nome_socio_2 character varying(100),
    identidade_socio_2 character varying(20),
    emissor_socio_2 character varying(20),
    nascimento_socio_2 date,
    cpf_socio_2 character varying(20),
    endereco_socio_2 character varying(100),
    bairro_socio_2 character varying(100),
    cidade_socio_2 character varying(100),
    estado_socio_2 character varying(4),
    cep_socio_2 character varying(20),
    telefone_socio_2 character varying(20),
    fundacao_socio_2 date,
    nome_socio_3 character varying(100),
    identidade_socio_3 character varying(20),
    emissor_socio_3 character varying(20),
    nascimento_socio_3 date,
    cpf_socio_3 character varying(20),
    endereco_socio_3 character varying(100),
    bairro_socio_3 character varying(100),
    cidade_socio_3 character varying(100),
    estado_socio_3 character varying(4),
    cep_socio_3 character varying(20),
    telefone_socio_3 character varying(20),
    fundacao_socio_3 date,
    indice numeric(15,4),
    negativo_spc character varying(20),
    data_consulta_spc date,
    desconto_duplicatas numeric(15,4),
    vendas_negativado bigint,
    debito_aberto bigint,
    suframa bigint,
    observacoes text,
    contatos text,
    cid character varying,
    atacado_varejo bigint,
    data_nascimento date,
    obs_restricao text,
    juros numeric(15,4),
    codigo_cidade bigint,
    codigo_regiao bigint,
    nome_regiao character varying(100),
    codigo_grupo_cliente bigint,
    nome_grupo_cliente character varying(100),
    codigo_rota bigint,
    nome_rota character varying(100),
    codigo_cidade_cobranca bigint,
    codigo_cidade_trabalho bigint,
    crm character varying(20) DEFAULT 0,
    reducao_icms numeric(15,4) DEFAULT 0,
    codigo_suframa character varying(20) DEFAULT ''::character varying,
    valor_parcelas numeric(15,4) DEFAULT 0,
    reajuste numeric(15,4) DEFAULT 0,
    data_acumulativo bigint DEFAULT 0,
    data_ult_compra_comercial_1 date,
    data_ult_compra_comercial_2 date,
    data_ult_compra_comercial_3 date,
    limite_compra_comercial_1 numeric(15,4) DEFAULT 0,
    limite_compra_comercial_2 numeric(15,4) DEFAULT 0,
    limite_compra_comercial_3 numeric(15,4) DEFAULT 0,
    multa numeric(15,4) DEFAULT 0,
    dias_protesto smallint DEFAULT 0,
    novo character varying(2) DEFAULT ''::character varying,
    alterar character varying(2) DEFAULT ''::character varying,
    cod_banco bigint DEFAULT 0,
    foto character varying DEFAULT ''::character varying,
    novo_ecommerce character varying(1) DEFAULT ''::character varying,
    alterar_ecommerce character varying(1) DEFAULT ''::character varying,
    empresa bigint,
    codigo_acessor bigint,
    desconto_piscofins smallint DEFAULT 0,
    desconto_fidelidade numeric(15,4) DEFAULT 0,
    email_cobranca character varying,
    super_simples bit(1) DEFAULT B'0'::"bit",
    aliquota_subst_super_simples numeric(6,4) DEFAULT 0.00,
    cliente_tare bit(1) DEFAULT B'0'::"bit" NOT NULL,
    codigo_tare character(15) DEFAULT '0'::bpchar NOT NULL,
    industria_fabricante bit(1) DEFAULT B'0'::"bit" NOT NULL,
    fk_formafaturamento integer,
    inscricao_municipal character varying(20),
    tipo_ie smallint,
    codigo_protesto smallint DEFAULT 0 NOT NULL
);


ALTER TABLE cliente OWNER TO "ADMIN";

--
-- Name: COLUMN cliente.super_simples; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN cliente.super_simples IS 'Informa se o cliente  do super simples.';


--
-- Name: COLUMN cliente.aliquota_subst_super_simples; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN cliente.aliquota_subst_super_simples IS 'Informa a aliquota a ser usada caso o cliente seja do Super Simples.';


--
-- Name: COLUMN cliente.cliente_tare; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN cliente.cliente_tare IS 'Informa se o cliente  optante TARE.';


--
-- Name: COLUMN cliente.codigo_tare; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN cliente.codigo_tare IS 'Informa o cdigo do TARE do cliente.';


--
-- Name: COLUMN cliente.industria_fabricante; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN cliente.industria_fabricante IS 'Informa se o cliente  indstria/Fabricante';


SET default_with_oids = false;

--
-- Name: cliente_parametros; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cliente_parametros (
    pk_cliente_parametros bigint NOT NULL,
    fk_cliente bigint,
    mostrar_un_principal_nota boolean DEFAULT false
);


ALTER TABLE cliente_parametros OWNER TO "ADMIN";

--
-- Name: cliente_parametros_pk_cliente_parametros_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE cliente_parametros_pk_cliente_parametros_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE cliente_parametros_pk_cliente_parametros_seq OWNER TO "ADMIN";

--
-- Name: cliente_parametros_pk_cliente_parametros_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE cliente_parametros_pk_cliente_parametros_seq OWNED BY cliente_parametros.pk_cliente_parametros;


SET default_with_oids = true;

--
-- Name: cliente_tipo_documento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cliente_tipo_documento (
    cod_cliente bigint,
    cod_documento bigint,
    empresa bigint
);


ALTER TABLE cliente_tipo_documento OWNER TO "ADMIN";

--
-- Name: codigo_barras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE codigo_barras (
    codigo character varying(20) NOT NULL,
    codigo_barras character varying(100) NOT NULL,
    empresa bigint DEFAULT 1 NOT NULL,
    preco_venda numeric(15,4) DEFAULT 0,
    data_inicial date,
    data_final date,
    preco_promocao numeric(15,4) DEFAULT 0,
    descricao character varying(100) DEFAULT ''::character varying
);


ALTER TABLE codigo_barras OWNER TO "ADMIN";

--
-- Name: comissao_cartao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE comissao_cartao (
    empresa bigint,
    data_emissao date,
    numero_pedido bigint,
    codigo_vendedor bigint,
    tipo_documento bigint,
    codigo_portador bigint,
    valor numeric(15,4),
    outros character varying(2),
    origem smallint DEFAULT 1
);


ALTER TABLE comissao_cartao OWNER TO "ADMIN";

--
-- Name: COLUMN comissao_cartao.origem; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN comissao_cartao.origem IS 'Informar a origem do documento 1 - Venda 2 - Devolucao';


--
-- Name: comissao_funcionario; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE comissao_funcionario (
    empresa bigint,
    numero_nf bigint,
    numero_pedido bigint,
    serie_nf character varying(3),
    data_emissao date,
    tipo_de_documento bigint,
    codigo_cliente bigint,
    codigo_vendedor bigint,
    codigo_tmk bigint,
    status character varying(2),
    codigo_produto character varying(20),
    codigo_grupo character varying(20),
    preco_tabela numeric(15,4),
    preco_venda numeric(15,4),
    porc_comissao numeric(15,4),
    valor_comissao numeric(15,4),
    quantidade numeric(15,4) DEFAULT 0,
    acerto character varying(1) DEFAULT 'A'::character varying,
    data_pagamento date,
    sequencia_nf bigint DEFAULT '-1'::integer NOT NULL,
    perc_comissao_empresa numeric(15,4) DEFAULT 0
);


ALTER TABLE comissao_funcionario OWNER TO "ADMIN";

--
-- Name: COLUMN comissao_funcionario.perc_comissao_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN comissao_funcionario.perc_comissao_empresa IS 'Armazena o percentual da comisso da empresa informada na hora da venda (com.participantes venda)';


--
-- Name: comissao_meta_cota; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE comissao_meta_cota (
    empresa bigint,
    cod_documento bigint,
    cod_funcionario bigint,
    com_abaixo_cota numeric(15,4) DEFAULT 0,
    com_igual_cota numeric(15,4) DEFAULT 0,
    com_acima_cota numeric(15,4) DEFAULT 0,
    com_acima_igual_meta numeric(15,4) DEFAULT 0
);


ALTER TABLE comissao_meta_cota OWNER TO "ADMIN";

--
-- Name: composicao_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE composicao_produto (
    empresa bigint,
    codigo_produto character varying(20),
    nome_produto character varying(100),
    unidade character varying(6),
    codigo_composicao character varying(20),
    descricao_composicao character varying(100),
    unidade_composicao character varying(3),
    quantidade_composicao numeric(18,7),
    codigo_custo character varying(20),
    descricao_custo character varying(100),
    unidade_custo character varying(3),
    quantidade_custo numeric(18,7),
    custo_custo numeric(15,4) DEFAULT 0,
    codigo_etapa bigint DEFAULT 0,
    sequencia_etapa bigint DEFAULT 0,
    qtd_maxima_perda numeric(18,7) DEFAULT 0,
    qtd_min_producao numeric(18,7) DEFAULT 0,
    qtd_perda numeric(18,7) DEFAULT 0,
    custo_composicao numeric(15,4)
);


ALTER TABLE composicao_produto OWNER TO "ADMIN";

--
-- Name: condicao_pagamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE condicao_pagamento (
    codigo bigint NOT NULL,
    descricao character varying(100),
    tipo_cliente bigint,
    atacado_varejo character varying(2),
    vista_prazo bigint,
    forma_prazo bigint,
    forma_pagamento integer,
    rede bigint,
    parcela_1 bigint,
    parcela_2 bigint,
    parcela_3 bigint,
    parcela_4 bigint,
    parcela_5 bigint,
    parcela_6 bigint,
    parcela_7 bigint,
    parcela_8 bigint,
    parcela_9 bigint,
    parcela_10 bigint,
    parcela_11 bigint,
    parcela_12 bigint,
    indice numeric(15,4),
    inativo bigint DEFAULT 0,
    desconto numeric(15,4),
    nome_vista_prazo character varying(50) DEFAULT ''::character varying,
    pagamento_minimo numeric(15,4) DEFAULT 0,
    pagamento_maximo numeric(15,4) DEFAULT 0,
    desc_aut_produto smallint DEFAULT 0,
    outras_despesas numeric(15,4) DEFAULT 0,
    convenio smallint DEFAULT 0,
    vencimento_cliente smallint DEFAULT 0,
    senha_venda smallint DEFAULT 0,
    envia_pocket smallint DEFAULT 0,
    quantidade_minima numeric(15,4) DEFAULT 0,
    quantidade_maxima numeric(15,4) DEFAULT 0,
    empresa bigint DEFAULT 0,
    libera_preco_promocao boolean DEFAULT false
);


ALTER TABLE condicao_pagamento OWNER TO "ADMIN";

--
-- Name: conferencia_mercadoria_entrada; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE conferencia_mercadoria_entrada (
    empresa bigint,
    codigo_produto character varying(20),
    quantidade numeric(15,4),
    codigo_usuario bigint,
    sequencia_nf bigint DEFAULT 0,
    ordem bigint
);


ALTER TABLE conferencia_mercadoria_entrada OWNER TO "ADMIN";

--
-- Name: config_codigo_barras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE config_codigo_barras (
    descricao character varying(50),
    codigo_tipo bigint,
    codigo bigint NOT NULL,
    identificadores character varying(3)
);


ALTER TABLE config_codigo_barras OWNER TO "ADMIN";

--
-- Name: configuracao_cheque; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE configuracao_cheque (
    numero_ordem_x character varying(12),
    numero_ordem_y character varying(12),
    emissao_x character varying(12),
    emissao_y character varying(12),
    vencimento_x character varying(12),
    vencimento_y character varying(12),
    cheque_x character varying(12),
    cheque_y character varying(12),
    banco_x character varying(12),
    banco_y character varying(12),
    agencia_x character varying(12),
    agencia_y character varying(12),
    valor_x character varying(12),
    valor_y character varying(12),
    nome_banco_x character varying(12),
    nome_banco_y character varying(12),
    nominal_x character varying(12),
    nominal_y character varying(12),
    observacao_x text,
    observacao_y text,
    cidade_x character varying(12),
    cidade_y character varying(12),
    mes_x character varying(12),
    mes_y character varying(12),
    ano_x character varying(12),
    ano_y character varying(12),
    extenso_x character varying(12),
    extenso_y character varying(12)
);


ALTER TABLE configuracao_cheque OWNER TO "ADMIN";

--
-- Name: configuracao_codigo_barras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE configuracao_codigo_barras (
    codigo integer DEFAULT 0 NOT NULL,
    sequencia integer DEFAULT 0 NOT NULL,
    q_etiqueta character varying(100),
    q_tamanho character varying(100),
    sufixo character varying(100),
    p1 character varying(100),
    p2 character varying(100),
    p3 character varying(100),
    p4 character varying(100),
    p5 character varying(100),
    p6 character varying(100),
    p7 character varying(100),
    p8 character varying(100),
    p9 character varying(100),
    limite_campo integer,
    etiquetas_por_linha integer,
    distancia_entre_etiquetas integer,
    campo_banco character varying(50),
    tabela_banco character varying(50)
);


ALTER TABLE configuracao_codigo_barras OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: configuracao_ecommerce; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE configuracao_ecommerce (
    empresa bigint NOT NULL,
    razao_social character varying(100) NOT NULL,
    usuario_bd character varying(50),
    senha_bd character varying(50),
    nome_bd character varying(100),
    servidor_bd character varying(100),
    tipo_bd character varying(1),
    porta_bd character varying(5)
);


ALTER TABLE configuracao_ecommerce OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: configuracao_entrega; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE configuracao_entrega (
    empresa bigint,
    nome_campo character varying(40),
    coluna bigint DEFAULT 0,
    linha bigint DEFAULT 0,
    tamanho bigint
);


ALTER TABLE configuracao_entrega OWNER TO "ADMIN";

--
-- Name: configuracao_frete; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE configuracao_frete (
    numero_ctrc_1_x character varying(12),
    numero_ctrc_1_y character varying(12),
    cfop_x character varying(12),
    cfop_y character varying(12),
    natureza_x character varying(12),
    natureza_y character varying(12),
    local_x character varying(12),
    local_y character varying(12),
    emissao_x character varying(12),
    emissao_y character varying(12),
    nome_remetente_x character varying(12),
    nome_remetente_y character varying(12),
    endereco_remetente_x character varying(12),
    endereco_remetente_y character varying(12),
    municipio_remetente_x character varying(12),
    municipio_remetente_y character varying(12),
    frete_pago_x character varying(12),
    frete_pago_y character varying(12),
    frete_apagar_x character varying(12),
    frete_apagar_y character varying(12),
    cep_remetente_x character varying(12),
    cep_remetente_y character varying(12),
    uf_remetente_x character varying(12),
    uf_remetente_y character varying(12),
    cnpj_remetente_x character varying(12),
    cnpj_remetente_y character varying(12),
    ie_remetente_x character varying(12),
    ie_remetente_y character varying(12),
    km_remetente_x character varying(12),
    km_remetente_y character varying(12),
    nome_destinatario_x character varying(12),
    nome_destinatario_y character varying(12),
    endereco_destinatario_x character varying(12),
    endereco_destinatario_y character varying(12),
    municipio_destinatario_x character varying(12),
    municipio_destinatario_y character varying(12),
    cep_destinatario_x character varying(12),
    cep_destinatario_y character varying(12),
    uf_destinatario_x character varying(12),
    uf_destinatario_y character varying(12),
    cnpj_destinatario_x character varying(12),
    cnpj_destinatario_y character varying(12),
    ie_destinatario_x character varying(12),
    ie_destinatario_y character varying(12),
    nome_consignatario_x character varying(12),
    nome_consignatario_y character varying(12),
    endereco_consignatario_x character varying(12),
    endereco_consignatario_y character varying(12),
    municipio_consignatario_x character varying(12),
    municipio_consignatario_y character varying(12),
    cep_consignatario_x character varying(12),
    cep_consignatario_y character varying(12),
    uf_consignatario_x character varying(12),
    uf_consignatario_y character varying(12),
    frete_cobrado_ate_x character varying(12),
    frete_cobrado_ate_y character varying(12),
    nome_redespacho_x character varying(12),
    nome_redespacho_y character varying(12),
    endereco_redespacho_x character varying(12),
    endereco_redespacho_y character varying(12),
    municipio_redespacho_x character varying(12),
    municipio_redespacho_y character varying(12),
    cep_redespacho_x character varying(12),
    cep_redespacho_y character varying(12),
    uf_redespacho_x character varying(12),
    uf_redespacho_y character varying(12),
    cnpj_redespacho_x character varying(12),
    cnpj_redespacho_y character varying(12),
    numero_ctrc_2_x character varying(12),
    numero_ctrc_2_y character varying(12),
    carga_x character varying(12),
    carga_y character varying(12),
    quantidade_x character varying(12),
    quantidade_y character varying(12),
    especie_x character varying(12),
    especie_y character varying(12),
    peso_x character varying(12),
    peso_y character varying(12),
    medida_x character varying(12),
    medida_y character varying(12),
    nf_x character varying(12),
    nf_y character varying(12),
    valor_mercadoria_x character varying(12),
    valor_mercadoria_y character varying(12),
    marca_reboque_x character varying(12),
    marca_reboque_y character varying(12),
    placa_reboque_x character varying(12),
    placa_reboque_y character varying(12),
    local_reboque_x character varying(12),
    local_reboque_y character varying(12),
    uf_reboque_x character varying(12),
    uf_reboque_y character varying(12),
    frete_pv_x character varying(12),
    frete_pv_y character varying(12),
    frete_valor_x character varying(12),
    frete_valor_y character varying(12),
    sec_cat_x character varying(12),
    sec_cat_y character varying(12),
    despacho_x character varying(12),
    despacho_y character varying(12),
    pedagio_x character varying(12),
    pedagio_y character varying(12),
    outros_x character varying(12),
    outros_y character varying(12),
    total_x character varying(12),
    total_y character varying(12),
    base_icms_x character varying(12),
    base_icms_y character varying(12),
    aliquota_x character varying(12),
    aliquota_y character varying(12),
    icms_x character varying(12),
    icms_y character varying(12),
    coleta_x character varying(12),
    coleta_y character varying(12),
    entrega_x character varying(12),
    entrega_y character varying(12),
    proprietario_contratado_x character varying(12),
    proprietario_contratado_y character varying(12),
    endereco_contratado_x character varying(12),
    endereco_contratado_y character varying(12),
    cidade_contratado_x character varying(12),
    cidade_contratado_y character varying(12),
    uf_contratado_x character varying(12),
    uf_contratado_y character varying(12),
    cnpj_contratado_x character varying(12),
    cnpj_contratado_y character varying(12),
    inss_contratado_x character varying(12),
    inss_contratado_y character varying(12),
    motorista_contratado_x character varying(12),
    motorista_contratado_y character varying(12),
    dner_contratado_x character varying(12),
    dner_contratado_y character varying(12),
    carta_contratado_x character varying(12),
    carta_contratado_y character varying(12),
    local_carta_contratado_x character varying(12),
    local_carta_contratado_y character varying(12),
    uf_carta_contratado_x character varying(12),
    uf_carta_contratado_y character varying(12),
    placa_contratado_x character varying(12),
    placa_contratado_y character varying(12),
    local_placa_contratado_x character varying(12),
    local_placa_contratado_y character varying(12),
    marca_placa_contratado_x character varying(12),
    marca_placa_contratado_y character varying(12),
    cor_placa_contratado_x character varying(12),
    cor_placa_contratado_y character varying(12),
    obs_placa_contratado_x character varying(12),
    obs_placa_contratado_y character varying(12),
    fatura_destinatario_x character varying(12),
    fatura_destinatario_y character varying(12),
    condicoes_destinatario_x character varying(12),
    condicoes_destinatario_y character varying(12),
    carga_conta_destinatario_x character varying(12),
    carga_conta_destinatario_y character varying(12),
    descarga_conta_destinatario_x character varying(12),
    descarga_conta_destinatario_y character varying(12),
    usuario_x character varying(12),
    usuario_y character varying(12),
    vlr_frete_motorista_x character varying(12),
    vlr_frete_motorista_y character varying(12),
    vlr_adiantamento_motorista_x character varying(12),
    vlr_adiantamento_motorista_y character varying(12),
    vlr_outros_1_motorista_x character varying(12),
    vlr_outros_1_motorista_y character varying(12),
    vlr_outros_2_motorista_x character varying(12),
    vlr_outros_2_motorista_y character varying(12),
    vlr_outros_3_motorista_x character varying(12),
    vlr_outros_3_motorista_y character varying(12),
    vlr_outros_4_motorista_x character varying(12),
    vlr_outros_4_motorista_y character varying(12),
    vlr_outros_5_motorista_x character varying(12),
    vlr_outros_5_motorista_y character varying(12),
    vlr_outros_6_motorista_x character varying(12),
    vlr_outros_6_motorista_y character varying(12),
    vlr_saldo_motorista_x character varying(12),
    vlr_saldo_motorista_y character varying(12),
    numero_recibo_x character varying(12),
    numero_recibo_y character varying(12),
    vlr_recibo_x character varying(12),
    vlr_recibo_y character varying(12),
    extenso_recibo_x character varying(12),
    extenso_recibo_y character varying(12),
    local_recibo_x character varying(12),
    local_recibo_y character varying(12),
    dia_recibo_x character varying(12),
    dia_recibo_y character varying(12),
    mes_recibo_x character varying(12),
    mes_recibo_y character varying(12),
    ano_recibo_x character varying(12),
    ano_recibo_y character varying(12),
    nome_recibo_x character varying(12),
    nome_recibo_y character varying(12),
    nome_empresa_x character varying(12),
    nome_empresa_y character varying(12),
    trans_recibo_x character varying(12),
    trans_recibo_y character varying(12),
    mot_recibo_x character varying(12),
    mot_recibo_y character varying(12),
    fonte_conhecimento character varying(4)
);


ALTER TABLE configuracao_frete OWNER TO "ADMIN";

--
-- Name: configuracao_nf; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE configuracao_nf (
    situacao_trib_x character varying(12),
    situacao_trib_y character varying(12),
    tipo_venda_x character varying(12),
    tipo_venda_y character varying(12),
    codigo_fiscal_x character varying(12),
    codigo_fiscal_y character varying(12),
    nf_x character varying(12),
    nf_y character varying(12),
    nf_entrada_x character varying(12),
    nf_entrada_y character varying(12),
    nome_cliente_x character varying(12),
    nome_cliente_y character varying(12),
    cgc_x character varying(12),
    cgc_y character varying(12),
    numero_nota_x character varying(12),
    numero_nota_y character varying(12),
    endereco_x character varying(12),
    endereco_y character varying(12),
    bairro_x character varying(12),
    bairro_y character varying(12),
    cep_x character varying(12),
    cep_y character varying(12),
    cidade_x character varying(12),
    cidade_y character varying(12),
    telefone_x character varying(12),
    telefone_y character varying(12),
    estado_x character varying(12),
    estado_y character varying(12),
    inscricao_x character varying(12),
    inscricao_y character varying(12),
    data_emissao_x character varying(12),
    data_emissao_y character varying(12),
    duplicatas_x character varying(12),
    duplicatas_y character varying(12),
    vencimentos_x character varying(12),
    vencimentos_y character varying(12),
    numero_dup_x character varying(12),
    numero_dup_y character varying(12),
    valor_dup_x character varying(12),
    valor_dup_y character varying(12),
    multiplicador_dup character varying(12),
    quantidade_dup character varying(12),
    fonte_cabecalho character varying(20),
    fonte_duplicatas character varying(20),
    negrito bigint,
    codigo_produto_x character varying(12),
    codigo_produto_y character varying(12),
    descricao_produto_x character varying(12),
    descricao_produto_y character varying(12),
    unidade_x character varying(12),
    unidade_y character varying(12),
    quantidade_x character varying(12),
    quantidade_y character varying(12),
    preco_unitario_x character varying(12),
    preco_unitario_y character varying(12),
    subtotal_x character varying(12),
    subtotal_y character varying(12),
    aliquota_x character varying(12),
    aliquota_y character varying(12),
    percentual_x character varying(12),
    percentual_y character varying(12),
    desconto_produto_x character varying(12),
    desconto_produto_y character varying(12),
    desconto_percentual_x character varying(12),
    desconto_percentual_y character varying(12),
    liquido_produto_x character varying(12),
    liquido_produto_y character varying(12),
    total_bruto_x character varying(12),
    total_bruto_y character varying(12),
    encargos_x character varying(12),
    encargos_y character varying(12),
    desconto_extra_x character varying(12),
    desconto_extra_y character varying(12),
    desconto_especial_x character varying(12),
    desconto_especial_y character varying(12),
    fonte_produtos character varying(20),
    codigo_servico_x character varying(12),
    codigo_servico_y character varying(12),
    descricao_servico_x character varying(12),
    descricao_servico_y character varying(12),
    unidade_servico_x character varying(12),
    unidade_servico_y character varying(12),
    quantidade_servico_x character varying(12),
    quantidade_servico_y character varying(12),
    preco_servico_unitario_x character varying(12),
    preco_servico_unitario_y character varying(12),
    desconto_servico_x character varying(12),
    desconto_servico_y character varying(12),
    liquido_servico_x character varying(12),
    liquido_servico_y character varying(12),
    subtotal_servico_x character varying(12),
    subtotal_servico_y character varying(12),
    percentual_servico_x character varying(12),
    percentual_servico_y character varying(12),
    perc_aliquota_rodape_x character varying(12),
    perc_aliquota_rodape_y character varying(12),
    total_servico2_x character varying(12),
    total_servico2_y character varying(12),
    total_bruto_servico_x character varying(12),
    total_bruto_servico_y character varying(12),
    encargos_servico_x character varying(12),
    encargos_servico_y character varying(12),
    desconto_extra_servico_x character varying(12),
    desconto_extra_servico_y character varying(12),
    desconto_especial_servico_x character varying(12),
    desconto_especial_servico_y character varying(12),
    observacoes_x character varying(12),
    observacoes_y character varying(12),
    lei_x character varying(12),
    lei_y character varying(12),
    numero_cupom_x character varying(12),
    numero_cupom_y character varying(12),
    tipo_documento_x character varying(12),
    tipo_documento_y character varying(12),
    bc_iss_x character varying(12),
    bc_iss_y character varying(12),
    valor_iss_x character varying(12),
    valor_iss_y character varying(12),
    vendedor_x character varying(12),
    vendedor_y character varying(12),
    mecanico_x character varying(12),
    mecanico_y character varying(12),
    bc_icms_x character varying(12),
    bc_icms_y character varying(12),
    valor_icms_x character varying(12),
    valor_icms_y character varying(12),
    bc_substituicao_x character varying(12),
    bc_substituicao_y character varying(12),
    valor_substituicao_x character varying(12),
    valor_substituicao_y character varying(12),
    encargos2_x character varying(12),
    encargos2_y character varying(12),
    total_servico_x character varying(12),
    total_servico_y character varying(12),
    total_produtos_x character varying(12),
    total_produtos_y character varying(12),
    frete_x character varying(12),
    frete_y character varying(12),
    seguro_x character varying(12),
    seguro_y character varying(12),
    total_nota_x character varying(12),
    total_nota_y character varying(12),
    numero_nota2_x character varying(12),
    numero_nota2_y character varying(12),
    nome_transportadora_x character varying(12),
    nome_transportadora_y character varying(12),
    endereco_transportadora_x character varying(12),
    endereco_transportadora_y character varying(12),
    cidade_transportadora_x character varying(12),
    cidade_transportadora_y character varying(12),
    estado_transportadora_x character varying(12),
    estado_transportadora_y character varying(12),
    cnpj_transportadora_x character varying(12),
    cnpj_transportadora_y character varying(12),
    inscricao_transportadora_x character varying(12),
    inscricao_transportadora_y character varying(12),
    placa_transportadora_x character varying(12),
    placa_transportadora_y character varying(12),
    uf_transportadora_x character varying(12),
    uf_transportadora_y character varying(12),
    emitente_x character varying(12),
    emitente_y character varying(12),
    qtd_total_nf_x character varying(12),
    qtd_total_nf_y character varying(12),
    fonte_transportadora character varying(20),
    valor_ipi_x character varying(12),
    valor_ipi_y character varying(12),
    fonte_rodape character varying(20),
    especie_x character varying(12),
    especie_y character varying(12),
    peso_bruto_x character varying(12),
    peso_bruto_y character varying(12),
    peso_liquido_x character varying(12),
    peso_liquido_y character varying(12),
    codificacao_fiscal_x character varying(12),
    codificacao_fiscal_y character varying(12),
    observacao_geral text,
    observacao_x character varying(12),
    observacao_y character varying(12),
    cliente_rodape_x character varying(12) DEFAULT 0,
    cliente_rodape_y character varying(12) DEFAULT 0,
    cnpj_empresa_x character varying(12) DEFAULT 0,
    cnpj_empresa_y character varying(12) DEFAULT 0,
    inscricao_empresa_x character varying(12) DEFAULT 0,
    inscricao_empresa_y character varying(12) DEFAULT 0,
    endereco_empresa_x character varying(12) DEFAULT 0,
    endereco_empresa_y character varying(12) DEFAULT 0,
    ativar_condensado smallint DEFAULT 0,
    ativar_linhas_juntas smallint DEFAULT 0,
    salto_paginas smallint DEFAULT 0,
    numero_linhas smallint DEFAULT 0,
    caracteres_porlinha smallint DEFAULT 0,
    qtde_itens smallint DEFAULT 0,
    qtde_itens_servico smallint DEFAULT 0,
    tipo_nota bigint DEFAULT 1
);


ALTER TABLE configuracao_nf OWNER TO "ADMIN";

--
-- Name: conhecimento_frete; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE conhecimento_frete (
    numero_conhecimento bigint,
    serie_nf character varying(4),
    cfop bigint,
    data_emissao date,
    codigo_remetente bigint,
    nome_remetente character varying(100),
    cgc_cpf_rem character varying(15),
    inscricao_estadual_rem character varying(15),
    endereco_rem character varying(100),
    municipio_rem character varying(100),
    uf_rem character varying(3),
    cep_rem character varying(15),
    codigo_dest bigint,
    nome_dest character varying(100),
    cgc_cpf_dest character varying(15),
    inscricao_estadual_dest character varying(15),
    endereco_dest character varying(100),
    municipio_dest character varying(100),
    uf_dest character varying(4),
    cep_dest character varying(15),
    codigo_cons bigint,
    nome_cons character varying(100),
    endereco_cons character varying(100),
    municipio_cons character varying(100),
    uf_cons character varying(5),
    cep_cons character varying(15),
    frete_cons bigint,
    quilometragem character varying(50),
    codigo_red bigint,
    nome_red character varying(100),
    cgc_cpf_red character varying(14),
    endereco_red character varying(100),
    municipio_red character varying(100),
    cbo_uf_red character varying(4),
    cep_red character varying(15),
    frete_cobrado character varying(100),
    conhecimento_red character varying(50),
    natureza_carga character varying(100),
    quantidade numeric(15,4),
    especie character varying(50),
    peso numeric(15,4),
    metro numeric(15,4),
    nota_fiscal character varying(50),
    valor_mercadoria numeric(15,4),
    codigo_motorista bigint,
    nome_motorista character varying(100),
    marca_vei character varying(50),
    placa_vei character varying(50),
    local_vei character varying(50),
    uf_vei character varying(4),
    frete_peso numeric(15,4),
    frete_valor numeric(15,4),
    sec_cat numeric(15,4),
    despacho numeric(15,4),
    pedagio numeric(15,4),
    outros numeric(15,4),
    total_prestacao numeric(15,4),
    base_calculo numeric(15,4),
    aliquota numeric(15,4),
    valor_icms numeric(15,4),
    local_coleta character varying(100),
    local_entrega character varying(100),
    codigo_prop bigint,
    nome_prop character varying(100),
    cgc_cpf_prop character varying(15),
    endereco_prop character varying(100),
    municipio_prop character varying(100),
    cbo_uf_col character varying(4),
    cep_col character varying(14),
    inss_col character varying(50),
    registro_dner character varying(50),
    carta_col character varying(50),
    de_col character varying(100),
    uf_col character varying(4),
    placa_col character varying(50),
    de_coleta character varying(50),
    marca_col character varying(50),
    cor_col character varying(50),
    sub_total_seguro numeric(15,4),
    valor_abatimento numeric(15,4),
    irpf numeric(15,4),
    inss numeric(15,4),
    adiantamento numeric(15,4),
    sest_senat numeric(15,4),
    outros_valores numeric(15,4),
    total_geral numeric(15,4),
    bc_irpf numeric(15,4),
    bc_inss numeric(15,4),
    lancar_contas character varying(5),
    dia_pagamento bigint,
    vencimento date,
    frete_entrega character varying(5),
    tipo_transporte character varying(30),
    especificacao bigint,
    carta_frete character varying(5),
    impresso character varying(2),
    data_contas_pagar date,
    observacao text,
    adiantamento_transportadora numeric(15,4) DEFAULT 0.00000,
    adiantamento_motorista numeric(15,4),
    rct numeric(15,4),
    rcf numeric(15,4),
    iof numeric(15,4),
    telefone character varying(12),
    usuario_canhoto character varying(100) DEFAULT '0'::character varying,
    data_canhoto date,
    time_canhoto character varying(10) DEFAULT '00:00:00'::character varying
);


ALTER TABLE conhecimento_frete OWNER TO "ADMIN";

--
-- Name: conserta_estoque; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE conserta_estoque (
    codigo character varying(30),
    descricao character varying(100),
    marca character varying(100),
    quantidade_anterior numeric(18,7),
    quantidade_atual numeric(18,7),
    quantidade numeric(18,7),
    motivo character varying(100),
    motivo_relatorio text,
    data_emissao date,
    horario character varying(20),
    responsavel bigint,
    custo numeric(20,7),
    id_consertaestoque bigint NOT NULL,
    data timestamp without time zone
);


ALTER TABLE conserta_estoque OWNER TO "ADMIN";

--
-- Name: conserta_estoque_id_consertaestoque_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE conserta_estoque_id_consertaestoque_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE conserta_estoque_id_consertaestoque_seq OWNER TO "ADMIN";

--
-- Name: conserta_estoque_id_consertaestoque_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE conserta_estoque_id_consertaestoque_seq OWNED BY conserta_estoque.id_consertaestoque;


--
-- Name: conserta_inventario; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE conserta_inventario (
    codigo character varying(30),
    descricao character varying(100),
    custo_anterior numeric(15,4),
    custo_medio_anterior numeric(15,4),
    custo numeric(15,4),
    custo_medio numeric(15,4),
    motivo_relatorio text,
    data_emissao date,
    horario character varying(20),
    responsavel bigint,
    serie_nf character varying(4),
    data_inventario character varying(20),
    quantidade_anterior numeric(15,4) DEFAULT 0,
    quantidade numeric(15,4) DEFAULT 0
);


ALTER TABLE conserta_inventario OWNER TO "ADMIN";

--
-- Name: contador_sped_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE contador_sped_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


ALTER TABLE contador_sped_seq OWNER TO "ADMIN";

--
-- Name: SEQUENCE contador_sped_seq; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON SEQUENCE contador_sped_seq IS 'Criado sequncia para sanar a ordenao de registros na gerao do SPED Fiscal, onde  obrigatrio o preenchemento da ordem dos itens em vrios registros.';


--
-- Name: contas_apagar; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE contas_apagar (
    empresa bigint NOT NULL,
    sequencia bigint NOT NULL,
    numero_do_documento character varying(50),
    codigo bigint,
    nome character varying(100),
    tipo_documento bigint,
    nome_documento character varying(100),
    data_de_entrada date,
    data_de_emissao date,
    data_do_vencimento date,
    data_prorrogacao date,
    data_previsao date,
    valor numeric(15,4),
    desconto numeric(15,4),
    valor_juros numeric(15,4),
    valor_restante numeric(15,4),
    codigo_portador bigint,
    nome_portador character varying(100),
    numero_da_conta character varying(20),
    nome_conta character varying(100),
    numero_nf bigint,
    serie_nf character varying(5),
    perdidos character varying(2),
    observacoes text,
    codigo_usuario bigint,
    nome_usuario character varying(100),
    data date,
    "time" character varying(20),
    cod_custo bigint DEFAULT 0,
    tipo_pessoa smallint DEFAULT 2
);


ALTER TABLE contas_apagar OWNER TO "ADMIN";

--
-- Name: COLUMN contas_apagar.tipo_pessoa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN contas_apagar.tipo_pessoa IS '0 - No Definida 1 - Cliente 2 - Fornecedor 3 - Funcionario 4 - Transportadora';


--
-- Name: contas_apagar_exclusao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE contas_apagar_exclusao (
    empresa bigint,
    sequencia bigint,
    numero_do_documento character varying(50),
    codigo bigint,
    nome character varying(100),
    tipo_documento bigint,
    nome_documento character varying(100),
    data_de_entrada date,
    data_de_emissao date,
    data_do_vencimento date,
    data_prorrogacao date,
    data_previsao date,
    valor numeric(15,4),
    desconto numeric(15,4),
    valor_juros numeric(15,4),
    valor_restante numeric(15,4),
    codigo_portador bigint,
    nome_portador character varying(100),
    numero_da_conta character varying(20),
    nome_conta character varying(100),
    numero_nf bigint,
    serie_nf character varying(5),
    perdidos character varying(2),
    observacoes text,
    codigo_usuario bigint,
    nome_usuario character varying(100),
    data date,
    "time" character varying(20),
    cod_custo bigint DEFAULT 0,
    tipo_pessoa smallint DEFAULT 2
);


ALTER TABLE contas_apagar_exclusao OWNER TO "ADMIN";

--
-- Name: contas_apagar_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE contas_apagar_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE contas_apagar_sequencia_seq OWNER TO "ADMIN";

--
-- Name: contas_pagas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE contas_pagas (
    empresa bigint NOT NULL,
    sequencia bigint NOT NULL,
    numero_do_documento character varying(50),
    codigo bigint,
    nome character varying(100),
    tipo_documento bigint,
    nome_documento character varying(100),
    data_de_entrada date,
    data_de_emissao date,
    data_do_vencimento date,
    data_da_baixa date,
    valor_a_pagar numeric(15,4),
    valor_pago numeric(15,4),
    valor_restante numeric(15,4),
    valor_juros numeric(15,4),
    codigo_portador bigint,
    nome_portador character varying(100),
    numero_da_conta character varying(20),
    nome_conta character varying(100),
    numero_nf bigint,
    serie_nf character varying(5),
    perdidos character varying(2),
    observacoes text,
    desconto numeric(15,4),
    seq_contas_apagar bigint,
    cod_custo bigint DEFAULT 0,
    codigo_usuario bigint DEFAULT 0,
    data date,
    hora character varying(10) DEFAULT 0,
    tipo_pessoa smallint DEFAULT 2
);


ALTER TABLE contas_pagas OWNER TO "ADMIN";

--
-- Name: contas_pagas_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE contas_pagas_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE contas_pagas_sequencia_seq OWNER TO "ADMIN";

--
-- Name: controle_entrega; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE controle_entrega (
    empresa bigint,
    controle bigint,
    prefixo character varying(40),
    dc character varying(4),
    com character varying(4),
    tipo character varying(4),
    tara character varying(40),
    peso_bruto character varying(40),
    agencia_navegacao character varying(100),
    vagao smallint,
    identificacao_veiculo character varying(40),
    porto character varying(40),
    recebimento_mercadoria character varying(40),
    lacre character varying(40),
    navio character varying(100),
    exportador character varying(100),
    marcas character varying(100),
    marcas1 character varying(100),
    marcas2 character varying(100),
    quantidade numeric(15,4),
    especie character varying(100),
    especie1 character varying(100),
    especie2 character varying(100),
    carga_mercadoria character varying(100),
    carga_mercadoria1 character varying(100),
    carga_mercadoria2 character varying(100),
    peso character varying(40),
    peso1 character varying(40),
    peso2 character varying(40),
    observacao character varying(100),
    observacao1 character varying(100),
    observacao2 character varying(100),
    impresso character varying(2) DEFAULT 'N'::character varying
);


ALTER TABLE controle_entrega OWNER TO "ADMIN";

--
-- Name: cupom_fiscal_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE cupom_fiscal_tmp (
    item bigint DEFAULT (0)::bigint,
    caixa bigint,
    codigo_barra character varying(20) DEFAULT '0'::character varying,
    aliquota bigint DEFAULT (0)::bigint,
    empresa bigint NOT NULL,
    data_de_emissao date,
    numero_da_nota bigint DEFAULT (0)::bigint,
    serie_da_nota character(3),
    numero_do_cupom bigint,
    serie_do_cupom character(2),
    codigo_do_grupo character varying(25),
    codigo_do_produto character varying(20),
    servico_produto character(2),
    unidade character(6),
    nome_do_produto character varying(100),
    quantidade numeric(12,5),
    valor_unitario numeric(12,5),
    codigo_da_aliquota bigint,
    valor_total numeric(12,5),
    porcentagem_do_icms numeric(12,5),
    valor_do_icms numeric(12,5),
    desconto_produto numeric(12,5),
    codigo_do_vendedor bigint,
    codigo_do_cliente bigint DEFAULT (0)::bigint,
    outros character(3),
    base_calculo_icms numeric(12,5),
    codificacao_fiscal bigint,
    preco_custo numeric(12,5),
    codigo_fiscal_nacional character varying(30),
    preco_pis numeric(12,5) DEFAULT 0.00000,
    preco_cofins numeric(12,5) DEFAULT 0.00000,
    preco_custo_medio numeric(12,5) DEFAULT 0.00000,
    locacao character varying(20),
    cst character varying(3) DEFAULT 0,
    outras_despesas numeric(15,6) DEFAULT 0,
    perc_red_icms numeric(15,6) DEFAULT 0,
    pk_codigo bigint NOT NULL
);


ALTER TABLE cupom_fiscal_tmp OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: curva_abcd_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE curva_abcd_tmp (
    empresa bigint,
    data_inicial date,
    data_final date,
    codigo_do_produto character varying(20),
    data_ultima_ent date,
    data_ultima_saida date,
    quantidade_vend numeric(15,4),
    faturamento numeric(15,4),
    lucratividade numeric(15,4),
    classe_quantidade character varying(2),
    classe_faturamento character varying(2),
    classe_lucratividade character varying(2),
    posicao_quantidade bigint,
    posicao_faturamento bigint,
    posicao_lucratividade bigint,
    faturas bigint,
    giro numeric(15,4),
    status character varying(2) DEFAULT 'N'::character varying,
    marckup numeric(15,4) DEFAULT 0,
    qtd_ultima_entrada numeric(15,4)
);


ALTER TABLE curva_abcd_tmp OWNER TO "ADMIN";

--
-- Name: dados_boleta; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE dados_boleta (
    codigo_do_cliente bigint,
    titulo character varying(20),
    numero_documento bigint,
    nome_do_cliente character varying(100),
    outros1 character varying(200),
    vlroutros1 numeric(15,4),
    outros2 character varying(200),
    vlroutros2 numeric(15,4),
    outros3 character varying(200),
    vlroutros3 numeric(15,4),
    outros4 character varying(200),
    vlroutros4 numeric(15,4),
    outros5 character varying(200),
    vlroutros5 numeric(15,4),
    serie_nf character varying(4),
    soma1 smallint DEFAULT 0,
    soma2 smallint DEFAULT 0,
    soma3 smallint DEFAULT 0,
    soma4 smallint DEFAULT 0,
    soma5 smallint DEFAULT 0
);


ALTER TABLE dados_boleta OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: dados_impressora; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE dados_impressora (
    tipo_impressao bigint,
    tipo_nota_fiscal bigint,
    altera_valor_unitario bigint,
    emissao_orcamento bigint,
    emissao_pedido bigint,
    emissao_ordem bigint,
    duplicata_lado bigint,
    linha_final_matricial bigint,
    linha_espaco_matricial bigint,
    linha_metade_matricial bigint,
    linha_final_metade_matricial bigint,
    linha_final_tinta bigint,
    linha_espaco_tinta bigint,
    linha_metade_tinta bigint,
    linha_final_metade_tinta bigint,
    fonte_matricial bigint,
    linha_matricial bigint,
    final_matricial bigint,
    fonte_matricial1 bigint,
    linha_matricial1 bigint,
    final_matricial1 bigint,
    fonte_matricial2 bigint,
    linha_matricial2 bigint,
    final_matricial2 bigint,
    fonte_matricial3 bigint,
    linha_matricial3 bigint,
    final_matricial3 bigint,
    fonte_matricial4 bigint,
    linha_matricial4 bigint,
    final_matricial4 bigint,
    fonte_tinta double precision,
    linha_tinta bigint,
    final_tinta bigint,
    fonte_tinta1 double precision,
    linha_tinta1 bigint,
    final_tinta1 bigint,
    fonte_tinta2 double precision,
    linha_tinta2 bigint,
    final_tinta2 bigint,
    fonte_tinta3 double precision,
    linha_tinta3 bigint,
    final_tinta3 bigint,
    fonte_tinta4 double precision,
    linha_tinta4 bigint,
    final_tinta4 bigint,
    estoque_negativo bigint,
    indice numeric(15,4),
    avaliacao_cadastro bigint,
    limite_credito numeric(15,4),
    primeiro_prazo_v character varying,
    segundo_prazo_v character varying,
    terceiro_prazo_v character varying,
    primeiro_prazo_a character varying,
    segundo_prazo_a character varying,
    terceiro_prazo_a character varying,
    desconto_pelo_total bigint,
    desconto_por_produto bigint,
    desconto_total_varejo numeric(15,4),
    desconto_total_atacado numeric(15,4),
    desconto_fidelidade smallint,
    apresenta_desconto bigint,
    sub_codigos bigint,
    consulta_pecas bigint,
    fatura_venda bigint,
    novalinhaautomatica bigint,
    impressora_automatica bigint,
    quantidade_impressao_automatica bigint,
    pesquisa_avancada_estoque bigint,
    custo_sem_imposto_entrada bigint,
    entrada_amarrado_pedido bigint,
    impressao_separacao_mercadoria bigint,
    tinta_estoquista bigint,
    impressao_separacao_mercadoria_fecha bigint,
    duplicidade_produto bigint,
    decimal_estoque bigint,
    decimal_custo bigint,
    conta_contabil_fornecedor character varying(20),
    conta_contabil_transporte character varying(20),
    decimal_venda bigint,
    ordem_alfabetica_pedido bigint DEFAULT 0,
    empresa_sequencial bigint,
    entrada_outros bigint,
    prazo_carteira bigint,
    cheque_prazo_bx_caixa bigint,
    busca_orcamento smallint,
    lancamento_credito bigint,
    meses_pedido bigint,
    libera_servico bigint,
    chq_vista_carteira bigint,
    seg_cadastro_cliente bigint,
    cabecalho_impressao bigint,
    imp_sep_merc_junto_fech bigint,
    atualiza_carteira bigint,
    imp_aut_juridica bigint,
    restricao_exterior bigint,
    desdobramento_vendedor bigint,
    imp_orc_vendedor bigint,
    numeracao_pelo_orc bigint,
    ap_desc_pedido_porc bigint,
    juros_carteira numeric(15,4),
    atualiza_cart_dev bigint,
    nascimento_obrigatorio bigint,
    servico_separado_nf bigint,
    venda_compartilhada smallint,
    forma_desconto smallint DEFAULT 0 NOT NULL,
    sep_est_obrigatorio smallint DEFAULT 0,
    calcula_impostos_venda smallint DEFAULT 0,
    formato_plano character varying(33) DEFAULT '@.@@@.@@@@'::character varying,
    entrega_receber smallint DEFAULT 0,
    tipo_comissao smallint DEFAULT 1,
    desconto_pedido smallint DEFAULT 0,
    cheque_devolucao smallint DEFAULT 0,
    conta_cancelamento character varying(20) DEFAULT 0,
    observacoes_venda smallint DEFAULT 0,
    desconto_automatico smallint DEFAULT 0,
    pedido_nota smallint DEFAULT 0,
    juros_composto smallint DEFAULT 0,
    comissao_servico smallint DEFAULT 0,
    lote_automatico smallint DEFAULT 0,
    multa numeric(15,4) DEFAULT 0,
    valor_amarrado_pagamento smallint DEFAULT 0,
    preco_consumidor_revendedor smallint DEFAULT 0,
    saida_dos smallint DEFAULT 0,
    linha_dos bigint DEFAULT 0,
    consulta_chq_tef smallint DEFAULT 0,
    unidade_secundaria character varying(1) DEFAULT 0,
    endereco_foto character varying(100) DEFAULT ''::character varying,
    analise_marckup_venda smallint DEFAULT 0,
    lanca_credito smallint DEFAULT 1,
    conta_fechamento_caixa smallint DEFAULT 0,
    conta_vista_dre smallint DEFAULT 0,
    conta_prazo_dre smallint DEFAULT 0,
    conta_cmv_dre smallint DEFAULT 0,
    conta_devolucao_dre smallint DEFAULT 0,
    metodo_industrializacao smallint DEFAULT 0,
    envia_direto_impressora_or smallint DEFAULT 1,
    obs_cliente smallint DEFAULT 1,
    libera_desc_promocao smallint DEFAULT 0,
    desconto_carteira numeric(15,4) DEFAULT 0,
    nao_lanca_dir_contas_pagas smallint DEFAULT 0,
    diasprotesto smallint DEFAULT 0,
    reserva_maxima smallint DEFAULT 0,
    imprime_etiquetas_vendas smallint DEFAULT 0,
    limite_itens_nf smallint DEFAULT 0,
    tipo_separacao bigint,
    impressao_agregado smallint,
    utiliza_tabela_precos bigint DEFAULT 0,
    utiliza_estoque_deposito bigint DEFAULT 0,
    reducao_icms_cliente numeric(15,4) DEFAULT 0,
    preco_promocao_por_pagamento bigint DEFAULT 0,
    separacao_barras bigint DEFAULT 0,
    controle_pontos bigint DEFAULT 0,
    calcula_comissao_troca bigint DEFAULT 1,
    exclusao_limpar_tela bigint DEFAULT 0,
    conta_consignacao smallint DEFAULT 0,
    codigo_cfg_codigo_barras bigint,
    banco_default_fechamento_venda bigint DEFAULT 0,
    controle_lote bigint DEFAULT 0,
    faturamento_transito smallint DEFAULT 0,
    rastreabilidade_produtos smallint DEFAULT 0,
    impressao_codbarras smallint DEFAULT 0,
    exige_pedidos_devolucao smallint DEFAULT 1,
    cancelamento_mes_anterior smallint DEFAULT 0,
    direto_impressora_estoquista smallint DEFAULT 0,
    integracao_ecommerce smallint DEFAULT 0,
    visualiza_clientes_carteira_vendedor smallint DEFAULT 0,
    nao_calcula_ipi_venda_cupom smallint DEFAULT 0,
    parcela_substituicao smallint DEFAULT 0 NOT NULL,
    decimal_lista_preco integer DEFAULT 0 NOT NULL,
    caixa_aberto smallint DEFAULT 1 NOT NULL,
    conta_outras_saidas bigint DEFAULT 0 NOT NULL,
    prazo_entrega_fornecedor bigint DEFAULT 0 NOT NULL,
    tempo_reposicao_produto bigint DEFAULT 0 NOT NULL,
    fk_empresa bigint DEFAULT 0 NOT NULL,
    dias_envio_cobranca_aut bigint DEFAULT 0 NOT NULL,
    utiliza_autoriza_pedido_compra smallint DEFAULT 0 NOT NULL,
    nao_altera_portador_baixa character varying(1) DEFAULT '0'::character varying NOT NULL,
    replica_informacoes_cadastro smallint DEFAULT 0 NOT NULL,
    permitir_quebra_linha_descricao_produto_venda boolean DEFAULT false NOT NULL,
    cbo_entrada_mercadoria smallint DEFAULT 0 NOT NULL,
    somente_vendas_em_aberto smallint DEFAULT 0 NOT NULL,
    codigo_produto_numerico smallint DEFAULT 0,
    conta_funrural smallint,
    conta_estoque smallint DEFAULT 0,
    conta_contabil_cliente character varying(20) DEFAULT ''::character varying,
    conta_caixa_diario smallint DEFAULT 0,
    conta_compras smallint DEFAULT 0,
    conta_devolucao_compras smallint DEFAULT 0,
    conta_servico_avista smallint DEFAULT 0,
    conta_servico_aprazo smallint DEFAULT 0,
    conta_cliente smallint DEFAULT 0,
    conta_fornecedor smallint DEFAULT 0,
    conta_estoque_inicial smallint DEFAULT 0,
    conta_estoque_final smallint DEFAULT 0,
    conta_juros_recebidos smallint DEFAULT 0,
    conta_juros_pagos smallint DEFAULT 0,
    conta_desconto_concedido smallint DEFAULT 0,
    conta_desconto_obtido smallint DEFAULT 0,
    conta_titulo_receber smallint DEFAULT 0,
    conta_titulo_pagar smallint DEFAULT 0,
    controlar_contabil boolean DEFAULT false,
    controlar_conta_cliente boolean DEFAULT false,
    tipo_controle_rastreabilidade smallint DEFAULT 1,
    calcula_peso_automatico_venda boolean DEFAULT false,
    especie_padrao_venda character varying(60),
    imprimir_nome_fantasia_cliente boolean DEFAULT false,
    imprimir_pedido_via_estoquista boolean DEFAULT false,
    conta_transportadora smallint DEFAULT 0,
    definicao_impressao_termica smallint DEFAULT 0,
    desconto_progressivo smallint DEFAULT 0,
    lancar_cancelamento_caixa boolean DEFAULT true,
    cancelamento_exige_caixa_origem_aberto boolean DEFAULT false,
    imprimir_referencia boolean DEFAULT false,
    conta_outras_entradas bigint DEFAULT 0,
    controlar_conta_funcionario boolean DEFAULT false,
    conta_contabil_funcionario character varying(20) DEFAULT ''::character varying,
    conta_funcionario smallint DEFAULT 0,
    tipo_impressao_zebra bigint DEFAULT 0,
    analise_compras_qtd_mes bigint DEFAULT 0,
    aplicar_desconto_total_produto boolean DEFAULT false,
    bloquear_preco_venda integer DEFAULT 0 NOT NULL
);


ALTER TABLE dados_impressora OWNER TO "ADMIN";

--
-- Name: COLUMN dados_impressora.decimal_lista_preco; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN dados_impressora.decimal_lista_preco IS 'Informa qual tipo de vinculo que a lista de preo estar ligada.';


--
-- Name: COLUMN dados_impressora.conta_outras_saidas; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN dados_impressora.conta_outras_saidas IS 'Informar o plano de contas outras saidas que ser lanado no caixa';


--
-- Name: COLUMN dados_impressora.prazo_entrega_fornecedor; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN dados_impressora.prazo_entrega_fornecedor IS 'Armazena o valor padro do prazo de entrega do fornecedor que ser lanado automaticamente nos fornecedores que tiverem esse valor em seu cadastro como 0';


--
-- Name: COLUMN dados_impressora.tempo_reposicao_produto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN dados_impressora.tempo_reposicao_produto IS 'Armazena o valor padro do tempo de reposio que ser lanado automaticamente nos produtos que tiverem seu valor como 0';


--
-- Name: COLUMN dados_impressora.nao_altera_portador_baixa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN dados_impressora.nao_altera_portador_baixa IS 'informa se alterar o portador na hora que se efetuar sua baixa (um paleativo especifico para o camelodromo) ser retirado futuramente qnd estiver pronto novo financeiro';


--
-- Name: COLUMN dados_impressora.desconto_progressivo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN dados_impressora.desconto_progressivo IS '0 - Desabilitado 1 - Total da venda 2 - Por Produto 3 - Total da venda e por produto';


--
-- Name: COLUMN dados_impressora.bloquear_preco_venda; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN dados_impressora.bloquear_preco_venda IS 'Bloquear a digitação no campo valor unitário das telas Vendas/OR e Nota/Cupom';


SET default_with_oids = false;

--
-- Name: duplicata_nf; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE duplicata_nf (
    nome_empresa_x bigint,
    nome_empresa_y bigint,
    data_emissao_x bigint,
    data_emissao_y bigint,
    vendedor_x bigint,
    vendedor_y bigint,
    numero_nf_x bigint,
    numero_nf_y bigint,
    valor_nf_x bigint,
    valor_nf_y bigint,
    numero_duplicata_x bigint,
    numero_duplicata_y bigint,
    valor_duplicata_x bigint,
    valor_duplicata_y bigint,
    vencimento_x bigint,
    vencimento_y bigint,
    nome_cliente_x bigint,
    nome_cliente_y bigint,
    endereco_cliente_x bigint,
    endereco_cliente_y bigint,
    bairro_cliente_x bigint,
    bairro_cliente_y bigint,
    cidade_cliente_x bigint,
    cidade_cliente_y bigint,
    estado_cliente_x bigint,
    estado_cliente_y bigint,
    cep_cliente_x bigint,
    cep_cliente_y bigint,
    praca_pgto_x bigint,
    praca_pgto_y bigint,
    cep_praca_pgto_x bigint,
    cep_praca_pgto_y bigint,
    cgc_cliente_x bigint,
    cgc_cliente_y bigint,
    inscricao_cliente_x bigint,
    inscricao_cliente_y bigint,
    valor_extenso1_x bigint,
    valor_extenso1_y bigint,
    instrucao_1_x bigint,
    instrucao_1_y bigint,
    instrucao_2_x bigint,
    instrucao_2_y bigint,
    instrucao_3_x bigint,
    instrucao_3_y bigint,
    instrucao_1 character varying(100),
    instrucao_2 character varying(100),
    instrucao_3 character varying(100),
    instrucao_4 character varying(100),
    data_proc_x bigint,
    data_proc_y bigint,
    nota_fiscal_x bigint,
    nota_fiscal_y bigint,
    valor_nota_fiscal_x bigint,
    valor_nota_fiscal_y bigint,
    numero_linhas bigint,
    salto_paginas bigint,
    endereco_cobranca_x character varying(100),
    endereco_cobranca_y character varying(100),
    ativar_condensado bigint DEFAULT 1,
    ativar_linhas_juntas bigint DEFAULT 1,
    cnpj_empresa_x bigint DEFAULT 0,
    cnpj_empresa_y bigint DEFAULT 0
);


ALTER TABLE duplicata_nf OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: duplicata_receber; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE duplicata_receber (
    empresa bigint NOT NULL,
    numero_do_documento bigint NOT NULL,
    tipo_de_documento bigint,
    nome_do_documento character varying(100),
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    codigo_emitido bigint,
    nome_emitido character varying(100),
    codigo_portador bigint,
    nome_portador character varying(100),
    data_de_entrada date,
    data_de_emissao date,
    numero_da_duplicata character varying(30),
    agencia character varying(11),
    banco character varying(11),
    data_do_vencimento date,
    data_prorrogado date,
    data_previsao date,
    valor_do_vencimento numeric(15,4),
    saldo numeric(15,4),
    valor_juros numeric(15,4),
    numero_da_nf character varying(20),
    serie_nf character varying(2),
    vendedor bigint,
    perdidos character varying(2),
    observacoes text,
    codigo_fornecedor bigint,
    nome_fornecedor character varying(100),
    data_remessa date,
    descontados bigint,
    codigo_usuario bigint,
    nome_usuario character varying(100),
    data date,
    "time" character varying(20),
    liquidacao_titulos bigint,
    cgc_terceiro character varying(20),
    codigo_conveniado bigint,
    nome_conveniado character varying(100),
    comissao character varying(1) DEFAULT 0,
    data_pgto_comissao character varying(10) DEFAULT 0,
    impresso character varying(2) DEFAULT 'N'::character varying,
    numero_pedido bigint DEFAULT 0,
    nosso_numero character varying(50),
    sequencia_nf bigint DEFAULT '-1'::integer NOT NULL,
    conta_corrente character varying(30) DEFAULT ''::character varying
);


ALTER TABLE duplicata_receber OWNER TO "ADMIN";

--
-- Name: duplicata_receber_exclusao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE duplicata_receber_exclusao (
    empresa bigint,
    numero_do_documento bigint,
    tipo_de_documento bigint,
    nome_do_documento character varying(100),
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    codigo_emitido bigint,
    nome_emitido character varying(100),
    codigo_portador bigint,
    nome_portador character varying(100),
    data_de_entrada date,
    data_de_emissao date,
    numero_da_duplicata character varying(30),
    agencia character varying(11),
    banco character varying(11),
    data_do_vencimento date,
    data_prorrogado date,
    data_previsao date,
    valor_do_vencimento numeric(15,4),
    saldo numeric(15,4),
    valor_juros numeric(15,4),
    numero_da_nf character varying(20),
    serie_nf character varying(2),
    vendedor bigint,
    perdidos character varying(2),
    observacoes text,
    codigo_fornecedor bigint,
    nome_fornecedor character varying(100),
    data_remessa date,
    descontados bigint,
    codigo_usuario bigint,
    nome_usuario character varying(100),
    data date,
    "time" character varying(20),
    liquidacao_titulos bigint,
    cgc_terceiro character varying(20),
    codigo_conveniado bigint,
    nome_conveniado character varying(100),
    comissao character varying(1) DEFAULT 'A'::character varying,
    data_pgto_comissao character varying(10),
    impresso character varying(2) DEFAULT 'N'::character varying,
    numero_pedido bigint DEFAULT 0,
    nosso_numero character varying(50),
    sequencia_nf bigint DEFAULT '-1'::integer NOT NULL,
    conta_corrente character varying(30) DEFAULT ''::character varying
);


ALTER TABLE duplicata_receber_exclusao OWNER TO "ADMIN";

--
-- Name: duplicata_receber_numero_do_documento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE duplicata_receber_numero_do_documento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE duplicata_receber_numero_do_documento_seq OWNER TO "ADMIN";

--
-- Name: duplicatas_baixadas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE duplicatas_baixadas (
    empresa bigint NOT NULL,
    numero_do_documento bigint NOT NULL,
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    codigo_emitido bigint,
    nome_emitido character varying(100),
    codigo_portador bigint,
    nome_portador character varying(100),
    data_de_entrada date,
    data_de_emissao date,
    numero_da_duplicata character varying(30),
    banco character varying(20),
    agencia character varying(20),
    data_do_vencimento date,
    valor_do_vencimento numeric(15,4),
    saldo numeric(15,4),
    data_do_pagamento date,
    valor_pago numeric(15,4),
    valor_dos_juros numeric(15,4),
    numero_nf character varying(20),
    serie_nf character varying(2),
    tipo_de_documento bigint,
    nome_documento character varying(100),
    vendedor bigint,
    perdidos character varying(2),
    numero_movimento_caixa bigint,
    observacoes text,
    codigo_fornecedor bigint,
    nome_fornecedor character varying(100),
    data_remessa date,
    descontados bigint,
    codigo_usuario bigint,
    nome_usuario character varying(100),
    data date,
    "time" character varying(20),
    liquidacao_titulos bigint,
    cgc_terceiro character varying(20),
    desconto numeric(15,4),
    seq_duplicata_receber bigint,
    codigo_conveniado bigint,
    nome_conveniado character varying(100),
    numero_pedido bigint DEFAULT 0,
    nosso_numero character varying(50),
    comissao character varying(1) DEFAULT 'A'::character varying,
    data_pgto_comissao date,
    sequencia_nf bigint DEFAULT '-1'::integer NOT NULL,
    sequencia_dev bigint DEFAULT '-1'::integer NOT NULL,
    conta_corrente character varying(30) DEFAULT ''::character varying
);


ALTER TABLE duplicatas_baixadas OWNER TO "ADMIN";

--
-- Name: duplicatas_baixadas_numero_do_documento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE duplicatas_baixadas_numero_do_documento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE duplicatas_baixadas_numero_do_documento_seq OWNER TO "ADMIN";

--
-- Name: emissao_cheque; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE emissao_cheque (
    numero_ordem bigint,
    data_de_emissao date,
    data_do_vencimento date,
    numero_do_cheque character varying(10),
    banco character varying(10),
    agencia character varying(10),
    valor numeric(15,4),
    codigo_banco bigint,
    nome_banco character varying(100),
    nominal character varying(100),
    impresso character varying(2),
    observacoes text,
    codigo_responsavel bigint,
    nome_responsavel character varying(250)
);


ALTER TABLE emissao_cheque OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: empresa_adicional; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE empresa_adicional (
    codigo bigint NOT NULL,
    codigo_cnae bigint,
    codigo_iest character varying(20),
    id_empresa bigint,
    cod_incidencia_tributaria smallint DEFAULT 1,
    cod_apropriacao_credito smallint DEFAULT 1,
    atividade_empresa character varying(3) DEFAULT '09'::character varying
);


ALTER TABLE empresa_adicional OWNER TO "ADMIN";

--
-- Name: empresa_adicional_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE empresa_adicional_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE empresa_adicional_codigo_seq OWNER TO "ADMIN";

--
-- Name: empresa_adicional_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE empresa_adicional_codigo_seq OWNED BY empresa_adicional.codigo;


SET default_with_oids = true;

--
-- Name: empresas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE empresas (
    codigo bigint NOT NULL,
    loja bigint,
    nome character varying(100),
    fantasia character varying(100),
    bairro character varying(100),
    logradouro character varying(100),
    numero character varying(5),
    complemento character varying(100),
    estado character varying(2),
    cep character varying(8),
    cgc character varying(20),
    inscricao_estadual character varying(20),
    inscricao_municipal character varying(20),
    inscricao_junta character varying(20),
    pedido_industria character varying(40),
    nota_fiscal bigint,
    modelo bigint DEFAULT 1,
    contato character varying(30),
    telefone character varying(12),
    fax character varying(12),
    serie character varying(3) DEFAULT 1,
    orcamento bigint,
    dolar numeric(12,2),
    numero_ip character varying(50),
    consumidor_final bigint,
    figura character varying(100),
    versao character varying(15) DEFAULT 0,
    sequencia_central smallint DEFAULT 0,
    central smallint DEFAULT 0,
    super_simples character varying(1) DEFAULT '0'::character varying,
    porta bigint DEFAULT 5432,
    download smallint DEFAULT 0,
    observacao text DEFAULT ''::text,
    verifica_bd character varying DEFAULT 0,
    nota_servico bigint DEFAULT 0,
    ultimo_contrato bigint DEFAULT 0,
    perc_simples numeric(15,4) DEFAULT 0,
    verifica_estoque date DEFAULT '1900-01-01'::date,
    backup date DEFAULT '1900-01-01'::date,
    nota_fiscal_eletronica character(1) DEFAULT 0,
    cod_cidade bigint DEFAULT 1,
    tipo_nfe character varying(1) DEFAULT 1,
    serie_nfe bigint DEFAULT 0,
    numero_contingencia bigint DEFAULT 0,
    pedido_consignacao bigint DEFAULT 0,
    perc_iss_simples numeric(15,4) DEFAULT 0,
    optante_tare bit(1) DEFAULT B'0'::"bit",
    observacao_tare text,
    modelo_nf_servico character varying(2),
    serie_nf_servico character varying(3),
    observacao_cliente_tare text DEFAULT ''::text,
    site character varying,
    email character varying,
    regime_especial_tributacao smallint,
    nota_servico_eletronica smallint DEFAULT 0,
    numeracao_rps bigint,
    envia_cadastros smallint DEFAULT 0 NOT NULL,
    opt_sn smallint,
    inccult smallint,
    cmc character varying,
    cidade integer,
    codigo_tributacao_municipio character varying(20)
);


ALTER TABLE empresas OWNER TO "ADMIN";

--
-- Name: COLUMN empresas.optante_tare; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN empresas.optante_tare IS 'Informa se a empresa  optante do TARE.';


--
-- Name: COLUMN empresas.observacao_tare; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN empresas.observacao_tare IS 'Observao que sair na NF.';


--
-- Name: COLUMN empresas.observacao_cliente_tare; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN empresas.observacao_cliente_tare IS 'Informa o cdigo do TARE do cliente.';


--
-- Name: COLUMN empresas.nota_servico_eletronica; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN empresas.nota_servico_eletronica IS 'Informa se o cliente trabalha com nota fiscal de servio eletrnica.';


--
-- Name: estoque; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE estoque (
    empresa bigint NOT NULL,
    codigo_do_grupo character varying(20),
    codigo_do_produto character varying(20) NOT NULL,
    quantidade numeric(18,7),
    producao numeric(18,7) DEFAULT 0,
    qtde_transito numeric(18,7) DEFAULT 0,
    qtde_excesso_falta numeric(18,7) DEFAULT 0 NOT NULL,
    qtde_reservada numeric(18,7) DEFAULT 0 NOT NULL
);


ALTER TABLE estoque OWNER TO "ADMIN";

--
-- Name: COLUMN estoque.qtde_excesso_falta; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN estoque.qtde_excesso_falta IS 'Informar a quantidade que est em excesso ou falta no estoque';


--
-- Name: estoque_deposito; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE estoque_deposito (
    codigo bigint,
    codigo_produto character varying,
    quantidade numeric(15,4)
);


ALTER TABLE estoque_deposito OWNER TO "ADMIN";

--
-- Name: estoque_tamanho; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE estoque_tamanho (
    quantidade numeric(15,6),
    empresa bigint NOT NULL,
    id_cadtamanhocaracteristica bigint NOT NULL
);


ALTER TABLE estoque_tamanho OWNER TO "ADMIN";

--
-- Name: estrutura_dre; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE estrutura_dre (
    empresa bigint,
    cod_descricao smallint,
    descricao character varying(100),
    cod_grupo smallint,
    titulo_grupo character varying(100),
    titulo_resultado character varying(100),
    cod_conta smallint,
    conta character varying(15),
    nome character varying(100),
    titulo_resultado_pacote character varying(100) DEFAULT ''::character varying,
    titulo_resultado_parcial character varying(100) DEFAULT ''::character varying
);


ALTER TABLE estrutura_dre OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: etiqueta_zebra; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE etiqueta_zebra (
    codigo integer NOT NULL,
    descricao character varying(50) NOT NULL,
    codigo_etiqueta_zebra_tipo_modelo integer NOT NULL,
    q_largura_area_impressao integer NOT NULL,
    q_p1_altura integer NOT NULL,
    q_p2_gap_vertical integer,
    s_velocidade integer NOT NULL,
    d_densidade integer NOT NULL,
    qtde_etiquetas_por_fileira integer NOT NULL,
    largura integer NOT NULL,
    gap_horizontal integer NOT NULL,
    tabela_filtro character varying(80),
    campo_filtro character varying(80),
    padrao boolean DEFAULT false NOT NULL
);


ALTER TABLE etiqueta_zebra OWNER TO "ADMIN";

--
-- Name: etiqueta_zebra_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE etiqueta_zebra_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE etiqueta_zebra_codigo_seq OWNER TO "ADMIN";

--
-- Name: etiqueta_zebra_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE etiqueta_zebra_codigo_seq OWNED BY etiqueta_zebra.codigo;


--
-- Name: etiqueta_zebra_itens; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE etiqueta_zebra_itens (
    codigo integer NOT NULL,
    codigo_etiqueta_zebra bigint NOT NULL,
    codigo_etiqueta_zebra_parametro bigint NOT NULL,
    codigo_etiqueta_zebra_tipo_item bigint NOT NULL,
    codigo_etiqueta_zebra_formatacao bigint NOT NULL,
    rotulo text,
    tabela_banco character varying(80),
    campo_banco character varying(80),
    fixo boolean,
    indice_inicial_campo integer DEFAULT 0,
    tamanho_indice_campo integer DEFAULT 0
);


ALTER TABLE etiqueta_zebra_itens OWNER TO "ADMIN";

--
-- Name: etiqueta_zebra_itens_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE etiqueta_zebra_itens_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE etiqueta_zebra_itens_codigo_seq OWNER TO "ADMIN";

--
-- Name: etiqueta_zebra_itens_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE etiqueta_zebra_itens_codigo_seq OWNED BY etiqueta_zebra_itens.codigo;


--
-- Name: etiqueta_zebra_parametro; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE etiqueta_zebra_parametro (
    codigo integer NOT NULL,
    codigo_etiqueta_zebra_tipo_item bigint NOT NULL,
    descricao character varying(50) NOT NULL,
    p1 integer NOT NULL,
    p2 integer NOT NULL,
    p3 integer NOT NULL,
    p4 character varying(50) NOT NULL,
    p5 integer,
    p6 integer,
    p7 character varying(50) NOT NULL,
    limite_campo integer
);


ALTER TABLE etiqueta_zebra_parametro OWNER TO "ADMIN";

--
-- Name: etiqueta_zebra_parametro_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE etiqueta_zebra_parametro_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE etiqueta_zebra_parametro_codigo_seq OWNER TO "ADMIN";

--
-- Name: etiqueta_zebra_parametro_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE etiqueta_zebra_parametro_codigo_seq OWNED BY etiqueta_zebra_parametro.codigo;


SET default_with_oids = true;

--
-- Name: etiquetas_produtos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE etiquetas_produtos (
    notas_produtos character varying(2),
    or1 character varying(2),
    nome_campos character varying(100),
    nome_campos2 character varying(100),
    seq character varying(2),
    coluna1 character varying(12),
    coluna2 character varying(12),
    coluna3 character varying(12),
    coluna4 character varying(12),
    coluna5 character varying(12),
    numero_fileiras bigint,
    numero_caracteres bigint,
    impressora character varying(50) DEFAULT 0,
    caracteres_pagina bigint DEFAULT 110,
    tabela character varying(3) DEFAULT 'P'::character varying,
    empresa bigint DEFAULT 0,
    cod_etiqueta bigint DEFAULT 1,
    nome_etiqueta character varying(100) DEFAULT ''::character varying,
    numero_linhas bigint DEFAULT 0,
    letra_condensada smallint DEFAULT 1,
    linhas_juntas smallint DEFAULT 1
);


ALTER TABLE etiquetas_produtos OWNER TO "ADMIN";

--
-- Name: fabricante_produtos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE fabricante_produtos (
    empresa bigint,
    codigo_fabricante bigint NOT NULL,
    nome_fabricante character varying(100),
    codigo_produto character varying(20) NOT NULL,
    nome_produto character varying(100),
    principal smallint DEFAULT 0
);


ALTER TABLE fabricante_produtos OWNER TO "ADMIN";

--
-- Name: financeira; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE financeira (
    codigo bigint DEFAULT 0 NOT NULL,
    parcelas bigint DEFAULT 0 NOT NULL,
    indice numeric(15,4) DEFAULT 0,
    tac numeric(15,4) DEFAULT 0,
    taxas numeric(15,4) DEFAULT 0,
    empresa bigint,
    pk_codigo bigint NOT NULL,
    prazo bigint DEFAULT 0 NOT NULL
);


ALTER TABLE financeira OWNER TO "ADMIN";

--
-- Name: COLUMN financeira.prazo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN financeira.prazo IS 'Prazo que cada parcela ir conter ex.: 1 Parcela = prazo 30 dias a partir da data de emissao 2 Parcela = prazo 32 dias a partir da data de emissao';


--
-- Name: financeira_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE financeira_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE financeira_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: financeira_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE financeira_pk_codigo_seq OWNED BY financeira.pk_codigo;


--
-- Name: forma_faturamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE forma_faturamento (
    codigo integer NOT NULL,
    descricao character varying(50),
    influencia_estoque character varying(1),
    digitacao_grade character varying(1),
    forma_preco character varying(1),
    transito character varying(1) DEFAULT 0,
    entrada_saida character varying(1) DEFAULT 'S'::character varying,
    contrapartida character varying(1) DEFAULT 0,
    inativo character varying(1) DEFAULT 0,
    empresa bigint DEFAULT 0,
    tipo_cliente character varying(1) DEFAULT '3'::character varying NOT NULL,
    tipo_devolucao bit(1) DEFAULT B'0'::"bit" NOT NULL,
    mensagem_retencao text,
    mensagem_reducao text,
    mensagem_padrao text,
    mensagem_isento text,
    padraopdv character varying(1) DEFAULT 0 NOT NULL,
    transferencia_credito character varying(1) DEFAULT 0 NOT NULL,
    operacao_com_combustivel character varying(2),
    operacao_interestadual smallint DEFAULT 0 NOT NULL
);


ALTER TABLE forma_faturamento OWNER TO "ADMIN";

--
-- Name: fornecedor; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE fornecedor (
    codigo bigint NOT NULL,
    razao_social character varying(100),
    nome_fantasia character varying(100),
    endereco character varying(100),
    bairro character varying(100),
    cidade character varying(100),
    uf character varying(2),
    pais character varying(50),
    caixa_postal character varying(20),
    cep character varying(8),
    telefone character varying(12),
    fax character varying(12),
    telefone_dados character varying(12),
    cgc character varying(14),
    identidade character varying(14),
    orgao_emissor character varying(10),
    pessoa bigint,
    inscricao_estadual character varying(20),
    ponto_referencia text,
    data_cadastro timestamp without time zone,
    data_alteracao timestamp without time zone,
    email character varying(100),
    site character varying(40),
    red_icms numeric(15,4),
    conta_contabil character varying(40),
    icms_subst numeric(15,4),
    reducao_invertido bigint,
    observacoes text,
    contatos text,
    codigo_cidade integer,
    codigo_grupo bigint,
    nome_grupo character varying(100),
    eventual smallint DEFAULT 0,
    juros numeric(15,4) DEFAULT 0,
    inativo smallint DEFAULT 0,
    empresa bigint,
    helaboratorio smallint DEFAULT 0,
    nome_logomarca character varying(40),
    disponivel_ecommerce smallint DEFAULT 0,
    prazo_entrega bigint DEFAULT 0 NOT NULL,
    tipo_ie smallint,
    retem_funrural boolean,
    aliq_funrural double precision
);


ALTER TABLE fornecedor OWNER TO "ADMIN";

--
-- Name: COLUMN fornecedor.prazo_entrega; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN fornecedor.prazo_entrega IS 'Prazo de entrega padro ';


--
-- Name: fornecedor_produtos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE fornecedor_produtos (
    empresa bigint,
    codigo_fornecedor bigint NOT NULL,
    nome_fornecedor character varying(100),
    codigo_produto character varying(20) NOT NULL,
    nome_produto character varying(100),
    codfornecedor character varying(30) DEFAULT 0,
    principal character varying(1) DEFAULT 0 NOT NULL
);


ALTER TABLE fornecedor_produtos OWNER TO "ADMIN";

--
-- Name: COLUMN fornecedor_produtos.principal; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN fornecedor_produtos.principal IS 'Marca quem e o fornecedor principal do produto';


--
-- Name: funcionario; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE funcionario (
    codigo bigint NOT NULL,
    nome character varying(100),
    cargo character varying(100),
    comissao_varejo numeric(15,4),
    comissao_atacado numeric(15,4),
    endereco character varying(100),
    bairro character varying(100),
    cep character varying(8),
    uf character varying(2),
    cpf character varying(14),
    data_nascimento date,
    identidade character varying(15),
    orgao_emissor character varying(10),
    data_admissao date,
    telefone character varying(12),
    categoria bigint,
    relacao bigint,
    inativo bigint,
    desc_varejo numeric(22,5),
    desc_atacado numeric(22,5),
    meta_venda numeric(15,4) DEFAULT 0,
    codigo_cidade bigint DEFAULT 0,
    recados character varying(20) DEFAULT 0,
    celular character varying(20) DEFAULT 0,
    codigo_cidade_nasc bigint DEFAULT 0,
    carteira_trabalho character varying(20) DEFAULT 0,
    pis character varying(20) DEFAULT 0,
    pai character varying(100) DEFAULT ''::character varying,
    mae character varying(100) DEFAULT ''::character varying,
    esposo character varying(100) DEFAULT ''::character varying,
    filhos bigint DEFAULT 0,
    menores bigint DEFAULT 0,
    estudando bigint DEFAULT 0,
    cursos text,
    emprego text,
    salario numeric(15,4) DEFAULT 0,
    data_cadastro timestamp without time zone,
    demissao date,
    estado_civil smallint DEFAULT 0,
    compartilhado numeric(15,4) DEFAULT 0,
    observacoes text DEFAULT ''::text,
    empresa bigint,
    email character varying(100),
    data_alteracao timestamp without time zone,
    desconto_somente_logado boolean DEFAULT false NOT NULL,
    conta_contabil character varying(20) DEFAULT ''::character varying
);


ALTER TABLE funcionario OWNER TO "ADMIN";

--
-- Name: COLUMN funcionario.desconto_somente_logado; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN funcionario.desconto_somente_logado IS 'True: Deve permitir o desconto por vendedor apenas se o usurio vinculado ao funcionario estiver logado no sistema, caso contrrio, solicitar senha para liberao.';


--
-- Name: funcionario_cadastro_etapas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE funcionario_cadastro_etapas (
    empresa bigint,
    fk_cadetapasseparacao bigint,
    fk_funcionario bigint
);


ALTER TABLE funcionario_cadastro_etapas OWNER TO "ADMIN";

--
-- Name: TABLE funcionario_cadastro_etapas; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE funcionario_cadastro_etapas IS 'Responsvel por fazer a ligao entre funcionrio com cadastro de etapas separacao de mercadoria para ser utilizado no despacho de mercadoria';


--
-- Name: grupo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE grupo (
    codigo character varying(20) NOT NULL,
    nome character varying(100),
    empresa bigint,
    status smallint DEFAULT 1,
    data_cadastro timestamp without time zone DEFAULT '2000-01-01'::date NOT NULL,
    data_alteracao timestamp without time zone DEFAULT '2000-01-01'::date NOT NULL
);


ALTER TABLE grupo OWNER TO "ADMIN";

--
-- Name: COLUMN grupo.status; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN grupo.status IS 'Define se o registro e um GRUPO ou SUBGRUPo 1 - GRUPO 2 - SUBGRUPO';


--
-- Name: grupo_clientes; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE grupo_clientes (
    codigo bigint,
    descricao character varying(200),
    empresa bigint,
    data_cadastro timestamp without time zone,
    data_alteracao timestamp without time zone
);


ALTER TABLE grupo_clientes OWNER TO "ADMIN";

--
-- Name: historico_padrao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE historico_padrao (
    codigo bigint,
    digito character varying(1),
    nome character varying(50)
);


ALTER TABLE historico_padrao OWNER TO "ADMIN";

--
-- Name: impressora_fiscal; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE impressora_fiscal (
    serie character varying(20),
    empresa bigint DEFAULT 1 NOT NULL,
    modelo_impressora character varying(20) DEFAULT ''::character varying,
    pk_codigo bigint NOT NULL,
    mfadcional character varying(1),
    tipo character varying(7),
    marca character varying(20),
    versaosb character varying(10),
    datasb date,
    horasb character varying(20),
    marcacc smallint,
    modelocc smallint,
    versaocc smallint,
    totalizadorgeral numeric(15,6) DEFAULT 0,
    impressora bigint DEFAULT 1,
    truncaarredonda character varying(1) DEFAULT 'T'::character varying NOT NULL
);


ALTER TABLE impressora_fiscal OWNER TO "ADMIN";

--
-- Name: impressora_fiscal_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE impressora_fiscal_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE impressora_fiscal_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: impressora_fiscal_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE impressora_fiscal_pk_codigo_seq OWNED BY impressora_fiscal.pk_codigo;


--
-- Name: info_conta_consumo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE info_conta_consumo (
    empresa bigint,
    codigo bigint NOT NULL,
    tipo_conta smallint,
    codigo_consumo character varying(2),
    tipo_ligacao smallint,
    grupo_tensao character varying(2)
);


ALTER TABLE info_conta_consumo OWNER TO "ADMIN";

--
-- Name: COLUMN info_conta_consumo.tipo_conta; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN info_conta_consumo.tipo_conta IS '1 - Energia Eltrica/Gs 2 - gua 3 - Telefone';


--
-- Name: info_conta_consumo_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE info_conta_consumo_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE info_conta_consumo_codigo_seq OWNER TO "ADMIN";

--
-- Name: info_fotos_produtos_ecommerce; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE info_fotos_produtos_ecommerce (
    codigo_produto character varying(20),
    nome_imagem character varying(100),
    local_ecommerce smallint,
    codigo bigint NOT NULL
);


ALTER TABLE info_fotos_produtos_ecommerce OWNER TO "ADMIN";

--
-- Name: COLUMN info_fotos_produtos_ecommerce.local_ecommerce; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN info_fotos_produtos_ecommerce.local_ecommerce IS '1 - Imagem Principal 2 - Imagem da Lupa 3 - Imagens do Anncio';


--
-- Name: info_fotos_produtos_ecommerce_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE info_fotos_produtos_ecommerce_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE info_fotos_produtos_ecommerce_codigo_seq OWNER TO "ADMIN";

--
-- Name: info_fotos_produtos_ecommerce_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE info_fotos_produtos_ecommerce_codigo_seq OWNED BY info_fotos_produtos_ecommerce.codigo;


--
-- Name: info_produto_ecommerce; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE info_produto_ecommerce (
    peso_produto_ecommerce numeric(15,4),
    comprimento_produto_ecommerce numeric(15,4),
    largura_produto_ecommerce numeric(15,4),
    diametro_produto_ecommerce numeric(15,4),
    codigo_produto_ecommerce character varying(20),
    altura_produto_ecommerce numeric(15,4),
    codigo bigint NOT NULL,
    frete_gratis character varying(1) DEFAULT 'N'::character varying
);


ALTER TABLE info_produto_ecommerce OWNER TO "ADMIN";

--
-- Name: info_produto_ecommerce_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE info_produto_ecommerce_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE info_produto_ecommerce_codigo_seq OWNER TO "ADMIN";

--
-- Name: info_produto_ecommerce_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE info_produto_ecommerce_codigo_seq OWNED BY info_produto_ecommerce.codigo;


--
-- Name: informacao_codigo_barras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE informacao_codigo_barras (
    descricao character varying(50),
    posicao_inicial integer NOT NULL,
    posicao_final integer NOT NULL,
    tabela_referencia character varying(50),
    campo_referencia character varying(50),
    codigo integer NOT NULL,
    codigo_configuracao bigint NOT NULL,
    casas_decimais integer DEFAULT 0
);


ALTER TABLE informacao_codigo_barras OWNER TO "ADMIN";

--
-- Name: informacao_codigo_barras_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE informacao_codigo_barras_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE informacao_codigo_barras_codigo_seq OWNER TO "ADMIN";

--
-- Name: informacao_codigo_barras_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE informacao_codigo_barras_codigo_seq OWNED BY informacao_codigo_barras.codigo;


--
-- Name: kit; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE kit (
    codigo_referente character varying(20) NOT NULL,
    codigo_produto character varying(20) NOT NULL,
    nome_produto character varying(100),
    quantidade_produto numeric(15,4),
    preco_venda numeric(15,4) DEFAULT 0
);


ALTER TABLE kit OWNER TO "ADMIN";

--
-- Name: liberacao_digitacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE liberacao_digitacao (
    codigo_responsavel bigint,
    data_inicial date,
    data_final date
);


ALTER TABLE liberacao_digitacao OWNER TO "ADMIN";

--
-- Name: linhas_etiquetas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE linhas_etiquetas (
    empresa bigint,
    notas_produtos character varying(2),
    fileira bigint,
    linha bigint,
    cod_etiqueta bigint DEFAULT 1
);


ALTER TABLE linhas_etiquetas OWNER TO "ADMIN";

--
-- Name: lista_cliente_agenda_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE lista_cliente_agenda_pocket (
    aga_data date NOT NULL,
    pct_id integer NOT NULL,
    codigo_cliente character varying NOT NULL,
    lca_status_atendimento character varying,
    lca_observacao_atendimento character(400),
    lca_inicio_atendimento character varying(20),
    lca_fim_atendimento character varying(20),
    lca_sequencia bigint DEFAULT 0,
    cres_id bigint
);


ALTER TABLE lista_cliente_agenda_pocket OWNER TO "ADMIN";

--
-- Name: lista_item_pedido_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE lista_item_pedido_pocket (
    ivp_id bigint NOT NULL,
    pvp_id bigint NOT NULL,
    pct_id integer NOT NULL,
    ivp_cod_produto character varying,
    ivp_preco_unitario numeric,
    ivp_desconto numeric,
    ivp_quantidade numeric,
    ivp_valor_total numeric,
    ivp_status_faturamento character varying,
    pvp_codigo_pedido character varying
);


ALTER TABLE lista_item_pedido_pocket OWNER TO "ADMIN";

--
-- Name: lista_item_pedido_pocket_ivp_id_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE lista_item_pedido_pocket_ivp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE lista_item_pedido_pocket_ivp_id_seq OWNER TO "ADMIN";

--
-- Name: lista_item_pedido_pocket_ivp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE lista_item_pedido_pocket_ivp_id_seq OWNED BY lista_item_pedido_pocket.ivp_id;


--
-- Name: log_senhas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE log_senhas (
    data date,
    hora character varying(20),
    codigo_usuario bigint,
    nome_usuario character varying(100),
    historico text,
    tela character varying(200),
    observacoes text,
    outros character varying(4)
);


ALTER TABLE log_senhas OWNER TO "ADMIN";

--
-- Name: log_senhas_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE log_senhas_tmp (
    codigo bigint,
    data date,
    hora character varying(20),
    codigo_usuario bigint,
    nome_usuario character varying(100),
    historico text,
    tela character varying(200),
    observacoes text,
    outros character varying(4),
    status character varying(2) DEFAULT 'A'::character varying,
    vista_prazo smallint DEFAULT 0,
    total_desconto numeric(15,4) DEFAULT 0,
    liberacao text,
    codigo_vendedor bigint DEFAULT 0,
    tipo_liberacao_senha bigint
);


ALTER TABLE log_senhas_tmp OWNER TO "ADMIN";

--
-- Name: loginconsistencia; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE loginconsistencia (
    logi_empresa bigint,
    logi_numerro bigint,
    logi_origem character varying(50),
    logi_usrcad character varying(15),
    logi_datacad character varying(20),
    logi_descr character varying(70),
    logi_atividade character varying(100),
    logi_objeto character varying(10),
    logi_nomepc character varying(20),
    logi_sistemaop character varying(10)
);


ALTER TABLE loginconsistencia OWNER TO "ADMIN";

--
-- Name: lucro_operacional; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE lucro_operacional (
    empresa bigint,
    data date,
    valor_produto numeric(15,4),
    valor_servico numeric(15,4),
    valor_devolucao numeric(15,4),
    valor_custo numeric(15,4),
    serie_nf character varying(10)
);


ALTER TABLE lucro_operacional OWNER TO "ADMIN";

--
-- Name: mapa_resumo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE mapa_resumo (
    empresa bigint,
    data_de_emissao date,
    ecf_numero bigint,
    numero_ordem_reduzao bigint,
    coo_inicial bigint,
    coo_final bigint,
    totalizado_geral_inicial numeric(15,5),
    totalizado_geral_final numeric(15,5),
    numero_serie character varying(50),
    valor_contabil numeric(15,5),
    numero_sequencial_imp character varying(50),
    contador_reducoes bigint,
    observacoes_1 character varying(200),
    observacoes_2 character varying(200),
    fk_impressorafiscal bigint
);


ALTER TABLE mapa_resumo OWNER TO "ADMIN";

--
-- Name: mapa_resumo_aliquota; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE mapa_resumo_aliquota (
    empresa bigint,
    data_de_emissao date,
    aliquota character varying(30),
    valor_contabil numeric(15,5),
    numero_sequencial_imp character varying(50)
);


ALTER TABLE mapa_resumo_aliquota OWNER TO "ADMIN";

--
-- Name: menu; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE menu (
    empresa bigint,
    usuario bigint,
    nome character varying(100),
    status smallint DEFAULT 1,
    sistema smallint DEFAULT 1
);


ALTER TABLE menu OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: motivos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE motivos (
    codigo bigint DEFAULT 0,
    id_ocorrencia bigint DEFAULT 0,
    codigo_motivo bigint DEFAULT 9,
    motivo text
);


ALTER TABLE motivos OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: motorista; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE motorista (
    codigo bigint NOT NULL,
    razao_social character varying(100),
    endereco character varying(40),
    bairro character varying(30),
    cidade character varying(20),
    uf character varying(2),
    caixa_postal character varying(20),
    cep character varying(8),
    telefone character varying(12),
    fax character varying(12),
    telefone_dados character varying(12),
    cpf character varying(11),
    identidade character varying(14),
    orgao_emissor character varying(10),
    ponto_referencia text,
    data_cadastro timestamp without time zone,
    data_alteracao timestamp without time zone,
    email character varying(100),
    naturalidade character varying(100),
    tipo_sangue character varying(100),
    cartao_pamcary date,
    cnh character varying(100),
    estado_civil character varying(100),
    filiacao text,
    observacoes text,
    contatos text,
    vencimento_cnh date,
    nascimento date,
    categoria_cnh character varying(4)
);


ALTER TABLE motorista OWNER TO "ADMIN";

--
-- Name: movimentacao_geral_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimentacao_geral_tmp (
    numero_do_cupom character varying(11),
    numero_da_nota character varying(11),
    numero_do_pedido character varying(11),
    nome_do_cliente character varying(100),
    codigo_do_produto character varying(20),
    data_do_documento date,
    tipo_de_documento bigint,
    codificacao_fiscal character varying(5),
    quantidade_entrada numeric(15,4),
    quantidade_saida numeric(15,4),
    codigo_do_vendedor bigint,
    status character varying(11),
    outros character varying(3),
    operacao character varying(2),
    sequencia bigint,
    data timestamp without time zone
);


ALTER TABLE movimentacao_geral_tmp OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_conhecimento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_conhecimento (
    codigo_transportadora bigint,
    nome_transportadora character varying(100),
    numero_conhecimento bigint,
    cfop bigint,
    nome_cfop character varying(100),
    data_de_emissao date,
    data_de_entrada date,
    serie_nota character varying(4),
    valor_notas numeric(15,4),
    valor_frete numeric(15,4),
    base_calculo_do_icms numeric(15,4),
    valor_do_icms numeric(15,4),
    aliquota_icms numeric(15,4),
    especie bigint,
    lancado_carteira bigint,
    carteira bigint,
    nome_carteira character varying(100),
    vencimento date,
    observacoes text,
    outros character varying(3),
    condicao character varying(2) DEFAULT 'E'::character varying,
    sequencia integer NOT NULL,
    empresa bigint NOT NULL,
    indicador_frete smallint,
    serie_conhecimento character varying(2),
    modelo_conhecimento character varying(2),
    chave_acesso_cte character varying(44),
    uf_placa character varying(2),
    placa_veiculo character varying(10),
    fk_formafaturamento bigint,
    valor_pis numeric(15,4) DEFAULT 0 NOT NULL,
    valor_cofins numeric(15,4) DEFAULT 0 NOT NULL,
    cst_icms character varying(4),
    cod_municipio_ori bigint,
    cod_municipio_dest bigint
);


ALTER TABLE movimento_cabecalho_conhecimento OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_conhecimento_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_cabecalho_conhecimento_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_cabecalho_conhecimento_sequencia_seq OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_conhecimento_sequencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE movimento_cabecalho_conhecimento_sequencia_seq OWNED BY movimento_cabecalho_conhecimento.sequencia;


--
-- Name: movimento_cabecalho_consignacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_consignacao (
    empresa bigint NOT NULL,
    id_pedido bigint NOT NULL,
    status character(1),
    data_emissao date,
    valor_desconto numeric(15,4) DEFAULT 0,
    hora_emissao character varying(8),
    data_acerto date,
    codigo_assessor bigint
);


ALTER TABLE movimento_cabecalho_consignacao OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_locacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_locacao (
    empresa bigint,
    numero_os bigint,
    data date,
    codigo_cliente bigint,
    nome_cliente character varying(100),
    solicitante character varying(100),
    observacoes text,
    codigo_usuario bigint,
    nome_usuario character varying(100),
    endereco_entrega character varying(100),
    bairro_entrega character varying(100),
    codigo_cidade_entrega bigint,
    nome_cidade_entrega character varying(100),
    uf_entrega character varying(3),
    outras_despesas numeric(15,4),
    total_geral numeric(15,4),
    horario character varying(10),
    numero_pedido bigint DEFAULT 0,
    calculo_por_dia smallint DEFAULT 0 NOT NULL,
    codigo_forma bigint,
    codigo_vendedor bigint,
    status bigint,
    data_fechamento date
);


ALTER TABLE movimento_cabecalho_locacao OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_nota_fiscal_cancelada; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_nota_fiscal_cancelada (
    empresa bigint NOT NULL,
    data_de_emissao date,
    numero_nf bigint,
    serie_nf character varying(3),
    numero_do_cupom bigint,
    serie_do_cupom character varying(2),
    codificacao_fiscal bigint,
    tipo_cliente bigint,
    venda character varying(6),
    tipo_do_documento bigint,
    forma_pagamento bigint,
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    pessoa character varying(1),
    cgc character varying(18),
    inscricao_estadual character varying(20),
    endereco character varying(100),
    bairro character varying(100),
    cidade character varying(100),
    uf character varying(2),
    cep character varying(10),
    telefone character varying(13),
    codigo_do_vendedor bigint,
    nome_do_vendedor character varying(100),
    valor_total_produtos numeric(15,4),
    valor_total_servico numeric(15,4),
    base_calculo_do_icms numeric(15,4),
    valor_do_icms numeric(15,4),
    base_calculo_substituicao_icms numeric(15,4),
    valor_icms_substituicao numeric(15,4),
    bc_iss numeric(15,4),
    valor_do_iss numeric(15,4),
    valor_ipi numeric(15,4),
    tipo_frete bigint,
    frete numeric(15,4),
    outras_despesas numeric(15,4),
    valor_do_desconto_produtos numeric(15,4),
    valor_do_desconto_servico numeric(15,4),
    arredondamento numeric(15,4),
    total_da_nota numeric(15,4),
    total_custo numeric(15,4),
    total_custo_cont numeric(15,4),
    contribuinte character varying(1),
    numero_movimento_caixa_venda bigint,
    numero_movimento_caixa_servico bigint,
    codigo_transportadora bigint,
    placa character varying(10),
    uf_placa character varying(2),
    quantidade numeric(15,4),
    especie character varying(100),
    peso_bruto character varying(50),
    peso_liquido character varying(50),
    liberacao_venda bigint,
    outros character varying(3),
    numero_pedido bigint,
    desconto_gerente bigint,
    observacoes text,
    codigo_cidade bigint,
    codigo_regiao bigint,
    codigo_grupo_cliente bigint,
    codigo_rota bigint,
    codigo_conveniado bigint,
    tmk bigint,
    total_pis numeric(15,4),
    total_cofins numeric(15,4),
    custo_medio numeric(15,4),
    custo_medio_cont numeric(15,4),
    entrega character varying(2) DEFAULT 'N'::character varying,
    data_cancelamento date,
    desconto_pe numeric(15,4) DEFAULT 0,
    numero_orcamento bigint DEFAULT 0,
    transito bigint DEFAULT 0,
    prazo_medio bigint DEFAULT 0,
    saida_dev character varying(2) DEFAULT 'S'::character varying,
    caixa smallint DEFAULT 1,
    sequencia bigint NOT NULL,
    cod_tabela_preco bigint DEFAULT 0,
    cod_venda_pocket bigint DEFAULT 0,
    cod_cad_pocket bigint DEFAULT 0,
    cod_id_venda_pocket bigint DEFAULT 0,
    id_nfe bigint DEFAULT 0,
    status_nfe character varying(2) DEFAULT 'S'::character varying,
    desconto_fidelidade numeric(15,4),
    data_saida date,
    hora_saida character varying,
    modelo_nf character varying(3),
    dados_adicionais text,
    fk_codigo_embarque bigint,
    fk_forma_faturamento bigint,
    valor_total_impostos numeric(15,4) DEFAULT 0,
    numeracao_rps bigint,
    valor_total_seguro numeric(15,4),
    icms_compartilhado_origem numeric(15,4),
    icms_compartilhado_destino numeric(15,4),
    icms_valor_fcp numeric(15,4),
    data timestamp without time zone,
    nf_complementacao character varying(2),
    ponto_referencia text DEFAULT ''::text,
    endereco_entrega text DEFAULT ''::text NOT NULL
);


ALTER TABLE movimento_cabecalho_nota_fiscal_cancelada OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_cabecalho_nota_fiscal_cancelada.endereco_entrega; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_cabecalho_nota_fiscal_cancelada.endereco_entrega IS 'Endereo de entrega do pedido.';


--
-- Name: movimento_cabecalho_nota_fiscal_cancelada_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_cabecalho_nota_fiscal_cancelada_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_cabecalho_nota_fiscal_cancelada_sequencia_seq OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_nota_fiscal_devolvida; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_nota_fiscal_devolvida (
    empresa bigint NOT NULL,
    data_de_emissao date,
    numero_nf bigint,
    serie_nf character varying(3),
    tipo_cliente bigint,
    venda character varying(2),
    tipo_do_documento bigint,
    forma_pagamento bigint,
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    pessoa character varying(1),
    cgc character varying(18),
    inscricao_estadual character varying(20),
    endereco character varying(100),
    bairro character varying(100),
    cidade character varying(100),
    uf character varying(2),
    cep character varying(10),
    telefone character varying(13),
    codigo_do_vendedor bigint,
    nome_do_vendedor character varying(100),
    valor_total_produtos numeric(15,4),
    base_calculo_do_icms numeric(15,4),
    valor_do_icms numeric(15,4),
    base_calculo_substituicao_icms numeric(15,4),
    valor_icms_substituicao numeric(15,4),
    frete numeric(15,4),
    outras_despesas numeric(15,4),
    valor_do_desconto_produtos numeric(15,4),
    total_da_nota numeric(15,4),
    total_custo numeric(15,4),
    total_custo_cont numeric(15,4),
    total_ipi numeric(15,4),
    contribuinte character varying(1),
    numero_movimento_caixa_devolvida bigint,
    data_emissao_devolvida date,
    emissao_dev bigint,
    outros character varying(3),
    tipo_caixa smallint,
    codigo_cidade bigint,
    codigo_regiao bigint,
    codigo_grupo_cliente bigint,
    codigo_rota bigint,
    codigo_conveniado bigint,
    tmk bigint,
    total_pis numeric(15,4),
    total_cofins numeric(15,4),
    custo_medio numeric(15,4),
    custo_medio_cont numeric(15,4),
    sequencia bigint NOT NULL,
    cod_tabela_preco bigint DEFAULT 0,
    cod_venda_pocket bigint DEFAULT 0,
    cod_cad_pocket bigint DEFAULT 0,
    cod_id_venda_pocket bigint DEFAULT 0,
    id_nfe bigint DEFAULT 0,
    status_nfe character varying(2) DEFAULT 'S'::character varying,
    modelo_nf character varying(3),
    dados_adicionais text,
    fk_forma_faturamento bigint,
    troca_mercadoria smallint DEFAULT 0 NOT NULL,
    valor_total_impostos numeric(15,4) DEFAULT 0,
    valor_total_seguro numeric(15,4),
    data timestamp without time zone
);


ALTER TABLE movimento_cabecalho_nota_fiscal_devolvida OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_cabecalho_nota_fiscal_devolvida.troca_mercadoria; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_cabecalho_nota_fiscal_devolvida.troca_mercadoria IS 'Informa se a devoluo  referente a troca de mercadorias: 0 - Devoluo normal, 1 - Devoluo com troca de mercadorias.';


--
-- Name: movimento_cabecalho_nota_fiscal_devolvida_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_cabecalho_nota_fiscal_devolvida_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_cabecalho_nota_fiscal_devolvida_sequencia_seq OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_nota_fiscal_entrada; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_nota_fiscal_entrada (
    empresa bigint NOT NULL,
    data_de_entrada date,
    data_de_emissao date,
    numero bigint,
    serie character varying(3),
    modelo_nf character varying(3),
    tipo_do_documento bigint,
    codificacao_fiscal bigint,
    codigo_do_fornecedor bigint,
    nome_fornecedor character varying(100),
    uf character varying(2),
    cgc character varying(20),
    inscricao_estadual character varying(20),
    valor_total_produtos numeric(15,4),
    base_calculo_do_icms numeric(15,4),
    valor_do_icms numeric(15,4),
    base_calculo_substituicao_icms numeric(15,4),
    valor_icms_substituicao numeric(15,4),
    valor_ipi numeric(15,4),
    frete numeric(15,4),
    frete_conhecimento numeric(15,4),
    seguro numeric(15,4),
    outras_despesas numeric(15,4),
    valor_do_desconto numeric(15,4),
    total_da_nota numeric(15,4),
    total_custo numeric(15,4),
    numero_movimento_caixa bigint,
    impresso_nf bigint,
    imposto_retido bigint,
    atualiza_custo bigint,
    codigo_transportadora bigint,
    placa character varying(20),
    uf_placa character varying(4),
    tipo_frete bigint,
    observacoes text,
    usuario bigint,
    calculo_nota bigint,
    atualiza_carteira smallint,
    atualiza_caixa bigint,
    tipo_caixa character varying(1),
    data_caixa date,
    data_chegada date,
    sequencia bigint NOT NULL,
    id_nfe bigint DEFAULT 0,
    status_nfe character varying(2) DEFAULT 'S'::character varying,
    total_pis numeric(15,6) DEFAULT 0,
    total_cofins numeric(15,6) DEFAULT 0,
    total_importacao numeric(15,4) DEFAULT 0,
    quantidade numeric(15,4),
    especie character varying(100),
    peso_bruto character varying(50),
    peso_liquido character varying(50),
    dados_adicionais text,
    fk_codigo_importacao bigint,
    conta_consumo smallint DEFAULT 0,
    fk_codigo_conta_consumo bigint,
    chave_acesso_nfe character varying(50),
    nf_complementar smallint DEFAULT 0 NOT NULL,
    valor_total_impostos numeric(15,4) DEFAULT 0,
    codigo_situacao_sped character varying(2) DEFAULT '00'::character varying NOT NULL,
    valor_total_seguro numeric(15,4),
    data timestamp without time zone,
    prazo_medio double precision DEFAULT 0 NOT NULL
);


ALTER TABLE movimento_cabecalho_nota_fiscal_entrada OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_cabecalho_nota_fiscal_entrada.chave_acesso_nfe; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_cabecalho_nota_fiscal_entrada.chave_acesso_nfe IS 'Informa a chave de acesso da NFe.';


--
-- Name: COLUMN movimento_cabecalho_nota_fiscal_entrada.codigo_situacao_sped; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_cabecalho_nota_fiscal_entrada.codigo_situacao_sped IS 'Campo para guardar o codigo de situao do documento (COD_SIT) do sped: 00 - Documento regular, 01 - Escriturao extempornea de documento regular, 02 - Documento cancelado, 03 - Escriturao extempornea de documento cancelado, 04 - NF-e, NFC-e ou CT-e - denegado, 05 - NF-e, NFC-e ou CT-e - Numerao inutilizada, 06 - Documento Fiscal Complementar, 07 - Escriturao extempornea de documento complementar, 08 - Documento Fiscal emitido com base em Regime Especial ou Norma Especfica.';


--
-- Name: movimento_cabecalho_nota_fiscal_entrada_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_cabecalho_nota_fiscal_entrada_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_cabecalho_nota_fiscal_entrada_sequencia_seq OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_nota_fiscal_entrada_sequencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE movimento_cabecalho_nota_fiscal_entrada_sequencia_seq OWNED BY movimento_cabecalho_nota_fiscal_entrada.sequencia;


--
-- Name: movimento_cabecalho_nota_fiscal_entrada_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_nota_fiscal_entrada_tmp (
    empresa bigint,
    data_de_entrada date,
    data_de_emissao date,
    numero bigint,
    serie character varying(3),
    modelo_nf character varying(3),
    tipo_do_documento bigint,
    codificacao_fiscal bigint,
    codigo_do_fornecedor bigint,
    nome_fornecedor character varying(100),
    uf character varying(2),
    cgc character varying(20),
    inscricao_estadual character varying(20),
    valor_total_produtos numeric(15,4),
    base_calculo_do_icms numeric(15,4),
    valor_do_icms numeric(15,4),
    base_calculo_substituicao_icms numeric(15,4),
    valor_icms_substituicao numeric(15,4),
    valor_ipi numeric(15,4),
    frete numeric(15,4),
    frete_conhecimento numeric(15,4),
    seguro numeric(15,4),
    outras_despesas numeric(15,4),
    valor_do_desconto numeric(15,4),
    total_da_nota numeric(15,4),
    total_custo numeric(15,4),
    numero_movimento_caixa bigint,
    impresso_nf bigint,
    imposto_retido bigint,
    atualiza_custo bigint,
    codigo_transportadora bigint,
    placa character varying(20),
    uf_placa character varying(4),
    tipo_frete bigint,
    observacoes text,
    usuario bigint,
    calculo_nota bigint,
    atualiza_carteira smallint,
    atualiza_caixa bigint,
    tipo_caixa character varying(1),
    data_caixa date,
    data_chegada date,
    sequencia bigint NOT NULL,
    id_nfe bigint,
    status_nfe character varying(2) DEFAULT 'S'::character varying,
    total_pis numeric(15,6) DEFAULT 0,
    total_cofins numeric(15,6) DEFAULT 0,
    total_importacao numeric(15,4) DEFAULT 0,
    quantidade numeric(15,4),
    especie character varying(100),
    peso_bruto character varying(50),
    peso_liquido character varying(50),
    fk_codigo_importacao bigint,
    conta_consumo smallint DEFAULT 0,
    fk_codigo_conta_consumo bigint,
    chave_acesso_nfe character varying(50),
    nf_complementar smallint DEFAULT 0 NOT NULL,
    pedido_transferencia character varying(1) DEFAULT 0,
    valor_total_impostos numeric(15,4) DEFAULT 0,
    codigo_situacao_sped character varying(2) DEFAULT '00'::character varying NOT NULL,
    valor_total_seguro numeric(15,4),
    data timestamp without time zone,
    prazo_medio double precision DEFAULT 0 NOT NULL
);


ALTER TABLE movimento_cabecalho_nota_fiscal_entrada_tmp OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_cabecalho_nota_fiscal_entrada_tmp.chave_acesso_nfe; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_cabecalho_nota_fiscal_entrada_tmp.chave_acesso_nfe IS 'Informa a chave de acesso da NFe.';


--
-- Name: COLUMN movimento_cabecalho_nota_fiscal_entrada_tmp.pedido_transferencia; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_cabecalho_nota_fiscal_entrada_tmp.pedido_transferencia IS 'Informa se a nota e originado de pedido de transferencia';


--
-- Name: COLUMN movimento_cabecalho_nota_fiscal_entrada_tmp.codigo_situacao_sped; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_cabecalho_nota_fiscal_entrada_tmp.codigo_situacao_sped IS 'Campo para guardar o codigo de situao do documento (COD_SIT) do sped: 00 - Documento regular, 01 - Escriturao extempornea de documento regular, 02 - Documento cancelado, 03 - Escriturao extempornea de documento cancelado, 04 - NF-e, NFC-e ou CT-e - denegado, 05 - NF-e, NFC-e ou CT-e - Numerao inutilizada, 06 - Documento Fiscal Complementar, 07 - Escriturao extempornea de documento complementar, 08 - Documento Fiscal emitido com base em Regime Especial ou Norma Especfica.';


--
-- Name: movimento_cabecalho_nota_fiscal_saida; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_nota_fiscal_saida (
    empresa bigint NOT NULL,
    data_de_emissao date,
    numero_nf bigint,
    serie_nf character varying(3),
    numero_do_cupom bigint,
    serie_do_cupom character varying(2),
    codificacao_fiscal bigint,
    tipo_cliente bigint,
    venda character varying(6),
    tipo_do_documento bigint,
    forma_pagamento bigint,
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    pessoa character varying(1),
    cgc character varying(18),
    inscricao_estadual character varying(20),
    endereco character varying(100),
    bairro character varying(100),
    cidade character varying(100),
    uf character varying(2),
    cep character varying(10),
    telefone character varying(13),
    codigo_do_vendedor bigint,
    nome_do_vendedor character varying(100),
    valor_total_produtos numeric(15,4),
    valor_total_servico numeric(15,4),
    base_calculo_do_icms numeric(15,4),
    valor_do_icms numeric(15,4),
    base_calculo_substituicao_icms numeric(15,4),
    valor_icms_substituicao numeric(15,4),
    bc_iss numeric(15,4),
    valor_do_iss numeric(15,4),
    valor_ipi numeric(15,4),
    tipo_frete bigint,
    frete numeric(15,4),
    outras_despesas numeric(15,4),
    valor_do_desconto_produtos numeric(15,4),
    valor_do_desconto_servico numeric(15,4),
    arredondamento numeric(15,4),
    total_da_nota numeric(15,4),
    total_custo numeric(15,4),
    total_custo_cont numeric(15,4),
    contribuinte character varying(1),
    numero_movimento_caixa_venda bigint,
    numero_movimento_caixa_servico bigint,
    codigo_transportadora bigint,
    placa character varying(10),
    uf_placa character varying(2),
    quantidade numeric(15,4),
    especie character varying(100),
    peso_bruto character varying(50),
    peso_liquido character varying(50),
    liberacao_venda bigint,
    outros character varying(3),
    numero_pedido bigint,
    desconto_gerente bigint,
    observacoes text,
    codigo_cidade bigint,
    codigo_regiao bigint,
    codigo_grupo_cliente bigint,
    codigo_rota bigint,
    codigo_conveniado bigint,
    tmk bigint,
    total_pis numeric(15,4),
    total_cofins numeric(15,4),
    custo_medio numeric(15,4),
    custo_medio_cont numeric(15,4),
    entrega character varying(2) DEFAULT 'N'::character varying,
    data_recebimento date,
    desconto_pe numeric(15,4) DEFAULT 0,
    numero_orcamento bigint DEFAULT 0,
    transito bigint DEFAULT 0,
    prazo_medio bigint DEFAULT 0,
    saida_dev character varying(2) DEFAULT 'S'::character varying,
    caixa smallint DEFAULT 1,
    sequencia bigint NOT NULL,
    cod_tabela_preco bigint DEFAULT 0,
    cod_venda_pocket bigint DEFAULT 0,
    cod_cad_pocket bigint DEFAULT 0,
    cod_id_venda_pocket bigint DEFAULT 0,
    id_nfe bigint DEFAULT 0,
    status_nfe character varying(2) DEFAULT 'S'::character varying,
    desconto_fidelidade numeric(15,4),
    data_saida date,
    hora_saida character varying,
    modelo_nf character varying(3),
    dados_adicionais text,
    fk_codigo_embarque bigint,
    fk_forma_faturamento bigint,
    valor_total_impostos numeric(15,4) DEFAULT 0,
    numeracao_rps bigint,
    valor_total_seguro numeric(15,4),
    icms_compartilhado_origem numeric(15,4),
    icms_compartilhado_destino numeric(15,4),
    icms_valor_fcp numeric(15,4),
    data timestamp without time zone,
    nf_complementacao character varying(2),
    ponto_referencia text DEFAULT ''::text,
    endereco_entrega text DEFAULT ''::text NOT NULL
);


ALTER TABLE movimento_cabecalho_nota_fiscal_saida OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_cabecalho_nota_fiscal_saida.endereco_entrega; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_cabecalho_nota_fiscal_saida.endereco_entrega IS 'Endereo de entrega do pedido.';


--
-- Name: movimento_cabecalho_nota_fiscal_saida_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_cabecalho_nota_fiscal_saida_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_cabecalho_nota_fiscal_saida_sequencia_seq OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_nota_fiscal_saida_sequencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE movimento_cabecalho_nota_fiscal_saida_sequencia_seq OWNED BY movimento_cabecalho_nota_fiscal_saida.sequencia;


--
-- Name: movimento_cabecalho_orcamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_orcamento (
    empresa bigint NOT NULL,
    data_de_emissao date,
    data_de_entrega date,
    numero_pedido bigint,
    tipo_do_documento bigint,
    nome_documento character varying(100),
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    pessoa character varying(1),
    cgc character varying(18),
    inscricao_estadual character varying(20),
    endereco character varying(100),
    bairro character varying(100),
    cidade character varying(100),
    uf character varying(2),
    cep character varying(10),
    telefone character varying(13),
    codigo_do_vendedor bigint,
    nome_do_vendedor character varying(100),
    codigo_servico bigint,
    nome_servico character varying(100),
    tipo_frete bigint,
    frete numeric(15,4),
    outras_despesas numeric(15,4),
    total_da_nota numeric(15,4),
    numero_orcamento bigint,
    codigo_transportadora bigint,
    placa character varying(20),
    uf_placa character varying(2),
    liberacao_venda bigint,
    numero_nota_referente bigint,
    serie_nota_referente character varying(3),
    libera_negativo_spc bigint,
    libera_debito_carteira bigint,
    indice numeric(15,4),
    codigo_prazo_medio bigint,
    libera_forma_venda bigint,
    restricao bigint,
    desconto_gerente bigint,
    observacoes text,
    endereco_entrega text,
    libera_unitario bigint,
    entrega character varying(2),
    pacoteiro character varying(100),
    status character(2),
    influencia_estoque character varying(10),
    codigo_cidade bigint,
    codigo_regiao bigint,
    nome_regiao character varying(100),
    codigo_grupo_cliente bigint,
    nome_grupo_cliente character varying(100),
    codigo_rota bigint,
    nome_rota character varying(100),
    codigo_conveniado bigint,
    nome_conveniado character varying(100),
    libera_estoque_negativo smallint,
    tmk bigint,
    outras_taxas numeric(15,4) DEFAULT 0,
    cod_tabela_preco bigint DEFAULT 0,
    cod_venda_pocket bigint DEFAULT 0,
    cod_cad_pocket bigint DEFAULT 0,
    desconto_pocket numeric(15,4) DEFAULT 0,
    cod_id_venda_pocket bigint DEFAULT 0,
    nome_arquivo_word character varying DEFAULT ''::character varying,
    sequencia bigint NOT NULL,
    fk_usuario bigint,
    total_icmssubstituicao numeric(15,4) DEFAULT 0,
    pedido_transferencia character varying(1) DEFAULT 0 NOT NULL,
    fk_formafaturamento bigint DEFAULT 0 NOT NULL,
    hora time without time zone,
    data timestamp without time zone,
    fk_cliente_mobilidade bigint,
    quantidade numeric(15,4),
    especie character varying(100),
    peso_bruto character varying(50),
    peso_liquido character varying(50),
    ponto_referencia text DEFAULT ''::text
);


ALTER TABLE movimento_cabecalho_orcamento OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_cabecalho_orcamento.pedido_transferencia; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_cabecalho_orcamento.pedido_transferencia IS 'Informa se a nota e originado de pedido de transferencia';


--
-- Name: movimento_cabecalho_registro_servico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_registro_servico (
    empresa bigint,
    numero_os bigint,
    data date,
    horario character varying(10),
    codigo_usuario bigint,
    nome_usuario character varying(100),
    codigo_cliente bigint,
    nome_cliente character varying(100),
    tipo_os bigint,
    tipo_chamada bigint,
    solicitante character varying(100),
    resultado bigint,
    observacoes text,
    valor_os numeric(15,4),
    horario_entrada character varying(10),
    horario_saida character varying(10),
    data_fechamento date,
    codigo_tecnico bigint DEFAULT 0,
    nome_tecnico character varying(100),
    codigo_para bigint DEFAULT 0,
    status character varying(2),
    texto_recebido text,
    descricao bigint DEFAULT 5,
    horario_final character varying(10) DEFAULT 0
);


ALTER TABLE movimento_cabecalho_registro_servico OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_servicos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cabecalho_servicos (
    empresa bigint,
    numero_servico bigint,
    data_abertura date,
    hora_abertura character varying(6),
    data_entrada date,
    hora_entrada character varying(6),
    data_concerto date,
    hora_concerto character varying(6),
    data_saida date,
    hora_saida character varying(6),
    data_entrega date,
    hora_entrega character varying(6),
    entregue_para character varying(100),
    data_fechamento date,
    codigo_cliente bigint,
    contato character varying(100),
    prazo_entrega bigint,
    tipo_garantia bigint,
    prazo_garantia bigint,
    outras1 character varying(100),
    outras2 character varying(100),
    outras3 character varying(100),
    cod_tecnico bigint,
    cod_vendedor bigint,
    cod_pagamento bigint,
    tipo_frete smallint,
    valor_frete numeric(15,4),
    outras_despesas numeric(15,4),
    total_produtos numeric(15,4),
    total_servicos numeric(15,4),
    observacoes text,
    libera_negativo_spc smallint DEFAULT 0,
    libera_debito_carteira smallint DEFAULT 0,
    libera_estoque_negativo smallint DEFAULT 0,
    libera_restricao smallint DEFAULT 0,
    status character varying(2) DEFAULT 'A'::character varying,
    numero_pedido bigint DEFAULT 0,
    numero_tecnicos bigint DEFAULT 0,
    total_desconto numeric(15,4) DEFAULT 0,
    libera_compartilhada smallint DEFAULT 0,
    libera_forma_venda smallint DEFAULT 0,
    nome_cliente character varying(100) DEFAULT 'AO CONSUMIDOR'::character varying,
    numero_pedido_serv bigint DEFAULT 0,
    cidade character varying(100),
    uf character varying(2),
    tipo_os character varying(10),
    tipo_fechamento character varying(50),
    data timestamp without time zone,
    pk_movimento_cabecalho_servicos bigint NOT NULL
);


ALTER TABLE movimento_cabecalho_servicos OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_servicos_pk_movimento_cabecalho_servico_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_cabecalho_servicos_pk_movimento_cabecalho_servico_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_cabecalho_servicos_pk_movimento_cabecalho_servico_seq OWNER TO "ADMIN";

--
-- Name: movimento_cabecalho_servicos_pk_movimento_cabecalho_servico_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE movimento_cabecalho_servicos_pk_movimento_cabecalho_servico_seq OWNED BY movimento_cabecalho_servicos.pk_movimento_cabecalho_servicos;


--
-- Name: movimento_caixa; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_caixa (
    empresa integer,
    data date,
    numero_identificador bigint NOT NULL,
    caixa bigint,
    codigo_responsavel bigint,
    numero_do_movimento bigint,
    numero_da_conta character varying(10),
    numero_da_conta_reduzida bigint,
    digito_da_conta character varying(1),
    credito_ou_debito character varying(1),
    valor numeric(15,4),
    especie bigint,
    codigo_historico bigint,
    complemento_historico character varying(250),
    data_de_emissao date,
    data_do_vencimento date,
    data_movimentacao date,
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    codigo_emitido bigint,
    nome_emitido character varying(100),
    tipo_documento bigint,
    forma_contas bigint,
    numero_da_duplicata character varying(50),
    valor_do_vencimento numeric(15,4),
    saldo numeric(15,4),
    tipo_de_lancamento bigint,
    tipo_conta character varying(5),
    serie_nota character varying(5),
    caixa_fechado character varying(5),
    observacoes text,
    relacao_pagar_receber bigint,
    fk_aberturacaixa bigint,
    centro_custo bigint DEFAULT 0 NOT NULL
);


ALTER TABLE movimento_caixa OWNER TO "ADMIN";

--
-- Name: movimento_caixa_geral; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_caixa_geral (
    codigo_empresa bigint,
    nome_empresa character varying(100),
    numero_identificador bigint NOT NULL,
    data date,
    caixa bigint,
    codigo_banco bigint,
    nome_banco character varying(100),
    numero_do_movimento bigint,
    numero_da_conta character varying(10),
    numero_da_conta_reduzida bigint,
    digito_da_conta character varying(1),
    credito_ou_debito character varying(1),
    valor numeric(15,4),
    especie bigint,
    codigo_historico bigint,
    complemento_historico character varying(100),
    data_de_emissao date,
    data_do_vencimento date,
    data_movimentacao date,
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    codigo_emitido bigint,
    nome_emitido character varying(100),
    tipo_documento bigint,
    forma_contas bigint,
    numero_da_duplicata character varying(50),
    valor_do_vencimento numeric(15,4),
    saldo numeric(15,4),
    tipo_de_lancamento bigint,
    tipo_conta character varying(5),
    serie_nota character varying(5),
    observacoes text,
    seq_carteira bigint,
    conta_partida bigint DEFAULT 1,
    nome_conta_partida character varying(100) DEFAULT ''::character varying,
    conciliado character varying(2) DEFAULT 'N'::character varying,
    centro_custo bigint DEFAULT 0,
    tipo_definicao_pessoa smallint DEFAULT 0 NOT NULL
);


ALTER TABLE movimento_caixa_geral OWNER TO "ADMIN";

--
-- Name: movimento_caixa_geral_numero_identificador_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_caixa_geral_numero_identificador_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_caixa_geral_numero_identificador_seq OWNER TO "ADMIN";

--
-- Name: movimento_caixa_numero_identificador_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_caixa_numero_identificador_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_caixa_numero_identificador_seq OWNER TO "ADMIN";

--
-- Name: movimento_conhecimento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_conhecimento (
    codigo_transportadora bigint,
    nome_transportadora character varying(100),
    numero_conhecimento character varying(100),
    codigo_fornecedor bigint,
    nome_fornecedor character varying(100),
    nota_fiscal character varying(100),
    valor_nota numeric(15,4),
    porc_divisao numeric(15,4),
    valor_divisao numeric(15,4),
    base_calculo_divisao numeric(15,4),
    outros character varying(3),
    sequencia bigint DEFAULT 0,
    pk_empresa bigint NOT NULL,
    pk_codigo bigint NOT NULL
);


ALTER TABLE movimento_conhecimento OWNER TO "ADMIN";

--
-- Name: movimento_conhecimento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_conhecimento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_conhecimento_seq OWNER TO "ADMIN";

--
-- Name: movimento_consignacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_consignacao (
    empresa bigint,
    id_pedido bigint,
    cod_produto character varying(20),
    seq_venda bigint,
    seq_devolucao bigint,
    num_retorno bigint,
    nome_comprador character varying(30),
    data_retorno date,
    status character varying(2),
    status_pocket character varying(7) DEFAULT 'EMPRESA'::character varying
);


ALTER TABLE movimento_consignacao OWNER TO "ADMIN";

--
-- Name: movimento_consignacao_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_consignacao_produto (
    empresa bigint,
    numero_pedido bigint,
    codigo_do_produto character varying(20),
    quantidade numeric(15,4)
);


ALTER TABLE movimento_consignacao_produto OWNER TO "ADMIN";

--
-- Name: movimento_controle_pontos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_controle_pontos (
    empresa bigint,
    mcp_cod_formula bigint,
    mcp_cod_cliente bigint,
    mcp_sequencia bigint NOT NULL,
    mcp_pontos numeric(15,4) DEFAULT 0,
    mcp_status character varying(2),
    mcp_status_pontos character varying(1)
);


ALTER TABLE movimento_controle_pontos OWNER TO "ADMIN";

--
-- Name: movimento_cotacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_cotacao (
    item bigint,
    codigo_fornecedor bigint,
    nome_fornecedor character varying(100),
    codigo_produto character varying(20) DEFAULT ''::character varying,
    nome_produto character varying(100),
    unidade character varying(20),
    marca character varying(100),
    prazo2 character varying(50),
    prazo3 character varying(50),
    prazo4 character varying(50),
    prazo5 character varying(50),
    preco numeric(15,4),
    preco1 numeric(15,4),
    preco2 numeric(15,4),
    preco3 numeric(15,4),
    preco4 numeric(15,4),
    preco5 numeric(15,4),
    frete bigint,
    taxa numeric(15,4),
    outras_despesas numeric(15,4),
    entrega character varying(50),
    data_cotacao date,
    observacao text,
    icms numeric(15,4) DEFAULT 0,
    ipi numeric(15,4) DEFAULT 0,
    previa smallint DEFAULT 0,
    codigo_prod_fornecedor character varying(30) DEFAULT 'N'::character varying,
    desc_vista numeric(15,4) DEFAULT 0,
    desc_prazo numeric(15,4) DEFAULT 0,
    preco_vista numeric(15,4) DEFAULT 0,
    preco_prazo numeric(15,4) DEFAULT 0
);


ALTER TABLE movimento_cotacao OWNER TO "ADMIN";

--
-- Name: movimento_dados_cupom_fiscal; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_dados_cupom_fiscal (
    empresa bigint NOT NULL,
    fk_codigo_saida bigint NOT NULL,
    codigo_cliente bigint,
    cfop character varying(4),
    codigo_situacao_tributaria character varying(3),
    data_de_emissao date
);


ALTER TABLE movimento_dados_cupom_fiscal OWNER TO "ADMIN";

--
-- Name: movimento_deposito; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_deposito (
    id_deposito bigint DEFAULT 0 NOT NULL,
    empresa bigint,
    seq_tabelas bigint,
    cod_produto character varying,
    cod_deposito bigint,
    quantidade numeric(15,4),
    status character varying(4),
    data date,
    usuario character varying DEFAULT ''::character varying,
    tempo character varying DEFAULT ''::character varying
);


ALTER TABLE movimento_deposito OWNER TO "ADMIN";

--
-- Name: movimento_documento_importacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_documento_importacao (
    pk_codigo bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    numero_documento character varying(10),
    data_registro date,
    local_desembaraco character varying(60),
    uf_desembaraco character varying(2),
    data_desembaraco date,
    codigo_exportador bigint,
    numero_adicao smallint,
    numero_sequencial smallint,
    codigo_fabricao_estrangeiro character varying(60),
    valor_desconto numeric(15,4),
    numero_pedido character varying(15),
    numero_item_pedido smallint,
    tipo_via_transporte smallint,
    valor_afrmm numeric(15,4),
    tipo_intermedio smallint,
    cnpj_adquirinte character varying(14),
    uf_adquirinte character varying(2),
    numero_drawback bigint
);


ALTER TABLE movimento_documento_importacao OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_documento_importacao.tipo_via_transporte; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_documento_importacao.tipo_via_transporte IS 'Via de transporte internacional informada na Declarao de Importao (DI)';


--
-- Name: COLUMN movimento_documento_importacao.valor_afrmm; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_documento_importacao.valor_afrmm IS 'Valor da AFRMM - Adicional ao Frete para Renovao da Marinha Mercante';


--
-- Name: COLUMN movimento_documento_importacao.tipo_intermedio; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_documento_importacao.tipo_intermedio IS '1=Importao por conta prpria; 2=Importao por conta e ordem; 3=Importao por encomenda;';


--
-- Name: movimento_documento_importacao_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_documento_importacao_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_documento_importacao_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: movimento_entrada_saida_grade; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_entrada_saida_grade (
    id_moventsaidagrade bigint NOT NULL,
    id_cadtamanhocaracteristica bigint NOT NULL,
    quantidade bigint NOT NULL,
    status character varying(1) NOT NULL,
    seq_saida bigint,
    seq_devolucao bigint,
    seq_entrada bigint,
    empresa bigint NOT NULL,
    seq_orcamento bigint,
    id_consertaestoque bigint
);


ALTER TABLE movimento_entrada_saida_grade OWNER TO "ADMIN";

--
-- Name: movimento_entrada_saida_grade_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_entrada_saida_grade_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_entrada_saida_grade_seq OWNER TO "ADMIN";

--
-- Name: movimento_folha_pagamento_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_folha_pagamento_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_folha_pagamento_codigo_seq OWNER TO "ADMIN";

--
-- Name: movimento_folha_pagamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_folha_pagamento (
    empresa bigint,
    codigo integer DEFAULT nextval('movimento_folha_pagamento_codigo_seq'::regclass) NOT NULL,
    cod_funcionario bigint,
    data_ref date,
    conta_reduzida bigint,
    credito_debito character varying(2),
    data_lanc date,
    valor numeric(15,4),
    complemento text,
    usuario bigint DEFAULT 0,
    data date,
    hora character varying(10) DEFAULT 0
);


ALTER TABLE movimento_folha_pagamento OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: movimento_grade; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_grade (
    movg_cadg_id integer NOT NULL,
    movg_tamanho character varying(5) NOT NULL,
    codigo bigint NOT NULL
);


ALTER TABLE movimento_grade OWNER TO "ADMIN";

--
-- Name: movimento_grade_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_grade_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_grade_codigo_seq OWNER TO "ADMIN";

--
-- Name: movimento_grade_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE movimento_grade_codigo_seq OWNED BY movimento_grade.codigo;


--
-- Name: movimento_id_pedido; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_id_pedido
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_id_pedido OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: movimento_impostos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_impostos (
    pk_codigo bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    percentual_icms_simples numeric(15,4),
    valor_icms_simples numeric(15,4),
    fk_movnotafiscalsaida bigint,
    base_calculo_pis numeric(15,4) DEFAULT 0,
    percentual_pis numeric(15,4) DEFAULT 0,
    base_calculo_cofins numeric(15,4) DEFAULT 0,
    percentual_cofins numeric(15,4) DEFAULT 0,
    cst_pis character varying(3),
    cst_cofins character varying(3),
    cst_ipi character varying(3),
    base_calculo_ipi numeric(15,4) DEFAULT 0,
    fk_movnotafiscaldevolvida bigint,
    fk_movnotafiscalentrada bigint,
    fk_movnotafiscalcancelada bigint,
    fk_movcabconhecimento bigint,
    valor_aproximado_impostos numeric(15,4),
    percentual_mva_icmsst double precision DEFAULT 0 NOT NULL
);


ALTER TABLE movimento_impostos OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_impostos.valor_aproximado_impostos; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_impostos.valor_aproximado_impostos IS 'Armazenar o valor aproximado dos impostos da lei da transparncia, a soma dos seguintes campos: (ICMS + PIS + COFINS + Subst)';


--
-- Name: movimento_impostos_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_impostos_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_impostos_codigo_seq OWNER TO "ADMIN";

--
-- Name: movimento_industria; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_industria (
    empresa bigint,
    numero_pedido bigint,
    data_pedido date,
    codigo_cliente bigint,
    nome_cliente character varying(100),
    codigo_produto character varying(30),
    nome_produto character varying(100),
    unidade character varying(6),
    quantidade numeric(18,7),
    codigo_mp character varying(30),
    descricao_mp character varying(100),
    unidade_mp character varying(6),
    quantidade_mp numeric(18,7),
    custo_mp numeric(18,7) DEFAULT 0,
    codigo_custo character varying(30),
    descricao_custo character varying(100),
    unidade_custo character varying(3),
    quantidade_custo numeric(18,7),
    custo_custo numeric(18,7) DEFAULT 0,
    outros character varying(3),
    status character varying(1),
    observacao text,
    custo_final numeric(18,7) DEFAULT 0,
    custo_final_medio numeric(18,7) DEFAULT 0,
    custo_final_medio_cont numeric(18,7) DEFAULT 0,
    data_fechamento date,
    horario_fechamento character varying(20) DEFAULT 0,
    usuario_fechamento character varying(100) DEFAULT ''::character varying,
    quantidade_composicao numeric(18,7) DEFAULT 0,
    codigo_vendedor smallint DEFAULT 0,
    nome_vendedor character varying(100) DEFAULT ''::character varying,
    codigo_tecnico bigint DEFAULT 0,
    nome_tecnico character(100) DEFAULT ''::bpchar,
    quantidade_conversao numeric(18,7) DEFAULT 0,
    usuario bigint DEFAULT 0,
    etapa_atual bigint DEFAULT 0,
    qtd_perda numeric(18,7) DEFAULT 0,
    qtd_sobra numeric(18,7) DEFAULT 0,
    item_novo bigint DEFAULT 0,
    status_etapa character varying(2),
    sequencia_etapa bigint,
    tipo_movimento character varying(3),
    data_entrega date,
    data timestamp without time zone
);


ALTER TABLE movimento_industria OWNER TO "ADMIN";

--
-- Name: movimento_kit; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_kit (
    empresa bigint,
    data_de_emissao date,
    sequencia integer NOT NULL,
    codigo_do_produto character varying(20),
    unidade character varying(4),
    quantidade numeric(15,4),
    outros character varying(3)
);


ALTER TABLE movimento_kit OWNER TO "ADMIN";

--
-- Name: movimento_kit_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_kit_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_kit_sequencia_seq OWNER TO "ADMIN";

--
-- Name: movimento_kit_sequencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE movimento_kit_sequencia_seq OWNED BY movimento_kit.sequencia;


--
-- Name: movimento_locacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_locacao (
    empresa bigint,
    numero_os bigint,
    item bigint,
    codigo_do_produto character varying(20),
    nome_do_produto character varying(100),
    unidade character varying(3),
    preco_equipamento numeric(15,4),
    quantidade numeric(15,4),
    quantidade_dev numeric(15,4),
    preco_unitario numeric(15,4),
    preco_pago numeric(15,4),
    dias bigint,
    dias_posse bigint,
    data_inicial date,
    data_vcto date,
    data_dev date,
    sub_total numeric(15,4),
    sub_total_pago numeric(15,4),
    numero_pedido bigint DEFAULT 0,
    tipo character varying(4) DEFAULT ''::character varying
);


ALTER TABLE movimento_locacao OWNER TO "ADMIN";

--
-- Name: movimento_local_embarque; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_local_embarque (
    pk_codigo bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    uf_embarque character varying(2),
    local_embarque character varying(60),
    local_despacho character varying(60)
);


ALTER TABLE movimento_local_embarque OWNER TO "ADMIN";

--
-- Name: movimento_local_embarque_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_local_embarque_pk_codigo_seq
    START WITH 7
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_local_embarque_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: movimento_lote; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_lote (
    empresa bigint,
    codigo_fornecedor bigint,
    codigo_cliente bigint,
    numero_pedido bigint,
    data_emissao date,
    sequencia bigint,
    codigo_produto character varying(20),
    numero_lote character varying(30),
    data_vencimento date,
    qtde_entrada numeric(15,4),
    qtde_saida numeric(15,4),
    qtde_atual numeric(15,4),
    codigo_usuario bigint,
    data date,
    hora character varying(20),
    status character varying(2) DEFAULT 'E'::character varying,
    qtde_da_nota numeric(15,4),
    lote_seq bigint,
    seq_referencia bigint DEFAULT 0,
    seq_controle bigint DEFAULT 0,
    data_fabricacao date,
    preco_consumidor numeric(15,4) DEFAULT 0,
    seq_lote_movimento bigint DEFAULT 0 NOT NULL
);


ALTER TABLE movimento_lote OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_lote.seq_controle; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_lote.seq_controle IS 'responsavel por inserir um numero sequencial que ir servir como referencia at a concluso de todo o processo e o fechamento da transao, caso ocorra alguma coisa errada e com esse numero que ir estornar os dados';


--
-- Name: movimento_lote_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_lote_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_lote_seq OWNER TO "ADMIN";

--
-- Name: movimento_nfe; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_nfe (
    empresa bigint,
    id_nfe bigint NOT NULL,
    num_nfe character varying,
    num_lote bigint,
    num_recepcao bigint,
    num_protocolo bigint DEFAULT 0,
    arquivo_xml bytea,
    endereco_arquivo_xml character varying(500),
    xml_base64 text,
    pdf_base64 text
);


ALTER TABLE movimento_nfe OWNER TO "ADMIN";

--
-- Name: movimento_nfe_id_nfe_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_nfe_id_nfe_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_nfe_id_nfe_seq OWNER TO "ADMIN";

--
-- Name: movimento_nfe_id_num_lote; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_nfe_id_num_lote
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_nfe_id_num_lote OWNER TO "ADMIN";

--
-- Name: movimento_nota_fiscal_cancelada; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_nota_fiscal_cancelada (
    empresa bigint,
    data_de_emissao date,
    numero_da_nota bigint,
    serie_da_nota character varying(3),
    numero_do_cupom character varying(11),
    serie_do_cupom character varying(2),
    codigo_do_grupo character varying(20),
    codigo_do_produto character varying(20),
    servico_produto character varying(2),
    unidade character varying(6),
    nome_do_produto character varying(100),
    quantidade numeric(15,4),
    valor_unitario numeric(15,7),
    codigo_da_aliquota bigint,
    valor_total numeric(15,4),
    porcentagem_do_icms numeric(15,4),
    valor_do_icms numeric(15,4),
    desconto_produto numeric(20,8),
    codigo_do_vendedor bigint,
    codigo_do_mecanico bigint,
    codigo_do_cliente bigint,
    outros character varying(3),
    base_calculo_icms numeric(15,4),
    codificacao_fiscal character varying(6),
    preco_custo numeric(18,7),
    preco_ipi numeric(15,4),
    porcentagem_ipi numeric(15,4),
    numero_nota_referente bigint,
    influencia_estoque character varying(2),
    codigo_fiscal_nacional character varying(30),
    codigo_aliquota_cf bigint,
    porcentagem_icms_cf numeric(15,4),
    preco_pis numeric(15,4),
    preco_cofins numeric(15,4),
    preco_custo_medio numeric(18,7),
    locacao character varying(30),
    desconto_pe numeric(20,8) DEFAULT 0,
    codigo_situacao_tributaria character varying(3) DEFAULT '0'::character varying,
    base_calc_substituicao numeric(15,4) DEFAULT 0,
    valor_icms_substituicao numeric(15,4) DEFAULT 0,
    caixa smallint DEFAULT 1,
    fator_conversao numeric(15,4) DEFAULT 1,
    sequencia bigint DEFAULT 0,
    preco_promocao character varying(2) DEFAULT ''::character varying,
    outras_despesas numeric(15,4) DEFAULT 0,
    perc_icms_subst numeric(15,6) DEFAULT 0,
    perc_red_icms_subst numeric(15,6) DEFAULT 0,
    perc_red_icms numeric(15,6) DEFAULT 0,
    codigo_barras character varying(20) DEFAULT ''::character varying,
    pk_codigo bigint,
    valor_seguro numeric(15,4),
    icms_bc_destino numeric(15,4),
    icms_aliquota_destino numeric(15,4),
    icms_percentual_partilhado numeric(15,4),
    icms_valor_origem numeric(15,4),
    icms_valor_destino numeric(15,4),
    icms_aliquota_fcp numeric(15,4),
    icms_valor_fcp numeric(15,4),
    data timestamp without time zone
);


ALTER TABLE movimento_nota_fiscal_cancelada OWNER TO "ADMIN";

--
-- Name: movimento_nota_fiscal_devolvida; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_nota_fiscal_devolvida (
    empresa bigint NOT NULL,
    data_de_emissao date,
    numero bigint,
    serie character varying(3),
    codigo_do_grupo character varying(20),
    codigo_do_produto character varying(20),
    servico_produto character varying(2),
    unidade character varying(6),
    nome_do_produto character varying(100),
    quantidade numeric(18,7),
    valor_unitario numeric(15,7),
    codigo_da_aliquota bigint,
    valor_total numeric(15,4),
    porcentagem_do_icms numeric(15,4),
    valor_icms numeric(15,4),
    desconto_produto numeric(20,8),
    codigo_do_vendedor bigint,
    codigo_do_cliente bigint,
    base_calculo_icms numeric(15,4),
    preco_custo numeric(18,7),
    preco_ipi numeric(15,4),
    codificacao_fiscal character varying DEFAULT 6,
    codificacao_fiscal_devolvida bigint,
    outros character varying(3),
    influencia_estoque character varying(2),
    codigo_fiscal_nacional character varying(30),
    preco_pis numeric(15,4),
    preco_cofins numeric(15,4),
    preco_custo_medio numeric(18,7),
    locacao character varying(30),
    base_calc_substituicao numeric(15,4) DEFAULT 0,
    valor_icms_substituicao numeric(15,4) DEFAULT 0,
    sequencia bigint DEFAULT 0 NOT NULL,
    sequencia_devolvida bigint DEFAULT 0,
    outras_despesas numeric(15,4) DEFAULT 0,
    perc_icms_subst numeric(15,6) DEFAULT 0,
    perc_red_icms_subst numeric(15,6) DEFAULT 0,
    perc_red_icms numeric(15,6) DEFAULT 0,
    cst character varying(3) DEFAULT ''::character varying,
    num_retorno_consignacao bigint,
    codigo_barras character varying(20) DEFAULT ''::character varying,
    pk_codigo bigint NOT NULL,
    valor_seguro numeric(15,4),
    fator_conversao numeric(15,4) DEFAULT 1 NOT NULL,
    data timestamp without time zone
);


ALTER TABLE movimento_nota_fiscal_devolvida OWNER TO "ADMIN";

--
-- Name: movimento_nota_fiscal_devolvida_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_nota_fiscal_devolvida_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_nota_fiscal_devolvida_codigo_seq OWNER TO "ADMIN";

--
-- Name: movimento_nota_fiscal_entrada; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_nota_fiscal_entrada (
    empresa bigint NOT NULL,
    data_de_entrada date,
    codigo_do_fornecedor bigint,
    numero bigint,
    serie character varying(3),
    tipo_do_documento bigint,
    codigo_do_grupo character varying(20),
    codigo_do_produto character varying(20),
    codigo_fornecedor bigint,
    unidade character varying(6),
    nome_do_produto character varying(100),
    quantidade numeric(18,7),
    valor_bruto numeric(15,7),
    porc_desconto numeric(15,4),
    valor_unitario numeric(15,7),
    valor_total numeric(15,4),
    porcentagem_do_ipi numeric(15,4),
    valor_do_ipi numeric(15,4),
    perc_icms numeric(15,4),
    base_calculo_icms numeric(15,4),
    valor_icms numeric(15,4),
    preco_custo numeric(18,7),
    preco_custo_medio numeric(18,7),
    codigo_da_aliquota bigint,
    codificacao_fiscal character varying(5),
    reducao_icms character varying(2),
    outros character varying(3),
    influencia_estoque character varying(2),
    garantia_produto character varying(30) DEFAULT 0,
    base_calculo_subst numeric(15,4) DEFAULT 0,
    icms_substituicao numeric(15,4) DEFAULT 0,
    outras_despesas numeric(15,4) DEFAULT 0,
    checa_lote smallint DEFAULT 0,
    industria_revenda character varying(1) DEFAULT 'R'::character varying,
    desconto_pe numeric(20,8) DEFAULT 0,
    sequencia bigint DEFAULT 0,
    perc_icms_subst numeric(15,6) DEFAULT 0,
    perc_red_icms_subst numeric(15,6) DEFAULT 0,
    cst character varying(3) DEFAULT ''::character varying,
    perc_red_icms numeric(15,6) DEFAULT 0,
    preco_pis numeric(15,6) DEFAULT 0,
    preco_cofins numeric(15,6) DEFAULT 0,
    base_calculo_importacao numeric(15,4) DEFAULT 0,
    despesas_aduaneiras numeric(15,6) DEFAULT 0,
    imposto_importacao numeric(15,6) DEFAULT 0,
    valor_iof numeric(15,6) DEFAULT 0,
    codigo_barras character varying(20) DEFAULT ''::character varying,
    pk_codigo bigint NOT NULL,
    fator_conversao numeric(15,4) DEFAULT 1 NOT NULL,
    valor_seguro numeric(15,4),
    data timestamp without time zone,
    valor_iva numeric(15,6) DEFAULT 0
);


ALTER TABLE movimento_nota_fiscal_entrada OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_nota_fiscal_entrada.fator_conversao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_nota_fiscal_entrada.fator_conversao IS 'Grava o fator de converso de unidades secundrias.';


--
-- Name: movimento_nota_fiscal_entrada_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_nota_fiscal_entrada_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_nota_fiscal_entrada_codigo_seq OWNER TO "ADMIN";

--
-- Name: movimento_nota_fiscal_entrada_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_nota_fiscal_entrada_tmp (
    empresa bigint,
    data_de_entrada date,
    codigo_do_fornecedor bigint,
    numero bigint,
    serie character varying(3),
    tipo_do_documento bigint,
    codigo_do_grupo character varying(20),
    codigo_do_produto character varying(20),
    codigo_fornecedor bigint,
    unidade character varying(6),
    nome_do_produto character varying(100),
    quantidade numeric(15,4),
    valor_bruto numeric(15,7),
    porc_desconto numeric(15,4),
    valor_unitario numeric(15,7),
    valor_total numeric(15,4),
    porcentagem_do_ipi numeric(15,4),
    valor_do_ipi numeric(15,4),
    perc_icms numeric(15,4),
    base_calculo_icms numeric(15,4),
    valor_icms numeric(15,4),
    preco_custo numeric(18,7),
    preco_custo_medio numeric(18,7),
    preco_custo_medio_cont numeric(18,7),
    codigo_da_aliquota bigint,
    codificacao_fiscal character varying(5),
    reducao_icms character varying(2),
    outros character varying(3),
    influencia_estoque character varying(2),
    garantia_produto character varying(30) DEFAULT 0,
    base_calculo_subst numeric(15,4) DEFAULT 0,
    icms_substituicao numeric(15,4) DEFAULT 0,
    outras_despesas numeric(15,4) DEFAULT 0,
    checa_lote smallint DEFAULT 0,
    industria_revenda character varying(1) DEFAULT 'R'::character varying,
    desconto_pe numeric(20,8) DEFAULT 0,
    sequencia bigint DEFAULT 0,
    perc_icms_subst numeric(15,6) DEFAULT 0,
    perc_red_icms_subst numeric(15,6) DEFAULT 0,
    cst character varying(3) DEFAULT ''::character varying,
    perc_red_icms numeric(15,6) DEFAULT 0,
    preco_pis numeric(15,6) DEFAULT 0,
    preco_cofins numeric(15,6) DEFAULT 0,
    base_calculo_importacao numeric(15,4) DEFAULT 0,
    despesas_aduaneiras numeric(15,6) DEFAULT 0,
    imposto_importacao numeric(15,6) DEFAULT 0,
    valor_iof numeric(15,6) DEFAULT 0,
    codigo_barras character varying(20) DEFAULT ''::character varying,
    pk_codigo bigint,
    fator_conversao numeric(15,4) DEFAULT 1 NOT NULL,
    valor_seguro numeric(15,4),
    data timestamp without time zone,
    valor_iva numeric(15,6) DEFAULT 0
);


ALTER TABLE movimento_nota_fiscal_entrada_tmp OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_nota_fiscal_entrada_tmp.fator_conversao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_nota_fiscal_entrada_tmp.fator_conversao IS 'Grava o fator de converso de unidades secundrias.';


--
-- Name: movimento_nota_fiscal_saida; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_nota_fiscal_saida (
    empresa bigint NOT NULL,
    data_de_emissao date,
    numero_da_nota bigint,
    serie_da_nota character varying(3),
    numero_do_cupom character varying(11),
    serie_do_cupom character varying(2),
    codigo_do_grupo character varying(20),
    codigo_do_produto character varying(20),
    servico_produto character varying(2),
    unidade character varying(6),
    nome_do_produto character varying(100),
    quantidade numeric(18,7),
    valor_unitario numeric(15,7),
    codigo_da_aliquota bigint,
    valor_total numeric(15,4),
    porcentagem_do_icms numeric(15,4),
    valor_do_icms numeric(15,4),
    desconto_produto numeric(20,8),
    codigo_do_vendedor bigint,
    codigo_do_mecanico bigint,
    codigo_do_cliente bigint,
    outros character varying(3),
    base_calculo_icms numeric(15,4),
    codificacao_fiscal character varying(6),
    preco_custo numeric(18,7),
    preco_ipi numeric(15,4),
    porcentagem_ipi numeric(15,4),
    numero_nota_referente bigint,
    influencia_estoque character varying(2),
    codigo_fiscal_nacional character varying(30),
    codigo_aliquota_cf bigint,
    porcentagem_icms_cf numeric(15,4),
    preco_pis numeric(15,4),
    preco_cofins numeric(15,4),
    preco_custo_medio numeric(18,7),
    locacao character varying(30),
    desconto_pe numeric(20,8) DEFAULT 0,
    codigo_situacao_tributaria character varying(3) DEFAULT '0'::character varying,
    base_calc_substituicao numeric(15,4) DEFAULT 0,
    valor_icms_substituicao numeric(15,4) DEFAULT 0,
    caixa smallint DEFAULT 1,
    fator_conversao numeric(15,4) DEFAULT 1,
    sequencia bigint DEFAULT 0 NOT NULL,
    preco_promocao character varying(2) DEFAULT ''::character varying,
    outras_despesas numeric(15,4) DEFAULT 0,
    perc_icms_subst numeric(15,6) DEFAULT 0,
    perc_red_icms_subst numeric(15,6) DEFAULT 0,
    perc_red_icms numeric(15,6) DEFAULT 0,
    codigo_barras character varying(20) DEFAULT ''::character varying,
    pk_codigo bigint NOT NULL,
    valor_seguro numeric(15,4),
    icms_bc_destino numeric(15,4),
    icms_aliquota_destino numeric(15,4),
    icms_percentual_partilhado numeric(15,4),
    icms_valor_origem numeric(15,4),
    icms_valor_destino numeric(15,4),
    icms_aliquota_fcp numeric(15,4),
    icms_valor_fcp numeric(15,4)
);


ALTER TABLE movimento_nota_fiscal_saida OWNER TO "ADMIN";

--
-- Name: movimento_nota_fiscal_saida_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_nota_fiscal_saida_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_nota_fiscal_saida_codigo_seq OWNER TO "ADMIN";

--
-- Name: movimento_orcamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_orcamento (
    empresa bigint NOT NULL,
    data_de_emissao date,
    numero_pedido bigint,
    ordem_item bigint,
    codigo_do_grupo character varying(20),
    codigo_do_produto character varying(20),
    unidade character varying(6),
    nome_do_produto character varying(100),
    quantidade numeric(18,7),
    valor_unitario numeric(15,7),
    valor_total numeric(15,4),
    porcentagem_ipi numeric(15,4),
    valor_ipi numeric(15,4),
    desconto_produto numeric(20,8),
    produto_servico character varying(2),
    status character varying(2),
    numero_nota_referente character varying(20),
    locacao character varying(30),
    preco_promocao character varying(4),
    outros character varying(2) DEFAULT 'CX'::character varying,
    desconto_pe numeric(20,8) DEFAULT 0,
    custo numeric(18,7) DEFAULT 0,
    custo_medio numeric(18,7) DEFAULT 0,
    impostos numeric(15,4) DEFAULT 0,
    pis numeric(15,4) DEFAULT 0,
    cofins numeric(15,4) DEFAULT 0,
    kit character varying DEFAULT ''::character varying,
    quantidade_secundaria numeric(15,4) DEFAULT 0,
    fator_conversao numeric(15,4) DEFAULT 1,
    sequencia bigint,
    codigo_barras character varying(20) DEFAULT ''::character varying,
    utiliza_precocliente character varying(1),
    data timestamp without time zone,
    pk_codigo bigint NOT NULL
);


ALTER TABLE movimento_orcamento OWNER TO "ADMIN";

--
-- Name: movimento_orcamento_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_orcamento_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_orcamento_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: movimento_orcamento_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE movimento_orcamento_pk_codigo_seq OWNED BY movimento_orcamento.pk_codigo;


--
-- Name: movimento_ordem_servico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_ordem_servico (
    numero_servico bigint,
    item bigint,
    codigo_do_produto character varying(20),
    nome_do_produto character varying(100),
    unidade character varying(6),
    quantidade numeric(15,4),
    preco_unitario numeric(15,4),
    desconto numeric(15,4),
    preco_liquido numeric(15,4),
    sub_total numeric(15,4),
    opcao character varying(2),
    codigo_do_grupo character varying(20) DEFAULT '0'::character varying
);


ALTER TABLE movimento_ordem_servico OWNER TO "ADMIN";

--
-- Name: movimento_ordem_servicos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_ordem_servicos (
    empresa bigint,
    numero_servico bigint,
    ordem bigint,
    cod_item character varying(20),
    nome_item character varying(100),
    unidade character varying(6),
    quantidade numeric(18,7),
    preco_unitario numeric(15,4),
    desconto numeric(15,4),
    preco_liquido numeric(15,4),
    sub_total numeric(15,4),
    opcao character varying(2),
    outros character varying(2) DEFAULT 'NF'::character varying,
    impresso character varying(1) DEFAULT 'N'::character varying,
    marca character varying(100) DEFAULT ''::character varying,
    localizacao character varying(30) DEFAULT ''::character varying,
    qtde_estornada numeric(15,4) DEFAULT 0,
    status character varying(2) DEFAULT 'N'::character varying,
    placa character varying(30) DEFAULT ''::character varying,
    preco_promocao character varying(2) DEFAULT ''::character varying,
    codigo_barras character varying(20) DEFAULT ''::character varying,
    data timestamp without time zone,
    adicionado_execucao boolean DEFAULT false,
    alterado_execucao boolean DEFAULT false,
    qtd_alterada double precision DEFAULT 0,
    pk_movimento_ordem_servicos bigint NOT NULL,
    fk_movimento_cabecalho_servicos bigint
);


ALTER TABLE movimento_ordem_servicos OWNER TO "ADMIN";

--
-- Name: movimento_ordem_servicos_pk_movimento_ordem_servicos_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_ordem_servicos_pk_movimento_ordem_servicos_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_ordem_servicos_pk_movimento_ordem_servicos_seq OWNER TO "ADMIN";

--
-- Name: movimento_ordem_servicos_pk_movimento_ordem_servicos_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE movimento_ordem_servicos_pk_movimento_ordem_servicos_seq OWNED BY movimento_ordem_servicos.pk_movimento_ordem_servicos;


--
-- Name: movimento_registro_servico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_registro_servico (
    empresa bigint,
    numero_os bigint,
    agendamento date,
    codigo_tecnico bigint,
    tecnico character varying(100),
    descricao text,
    status character varying(2) DEFAULT 'N'::character varying,
    conclusao date
);


ALTER TABLE movimento_registro_servico OWNER TO "ADMIN";

--
-- Name: movimento_remessa; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_remessa (
    lancamento bigint,
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    data_do_vencimento date,
    data_de_emissao date,
    banco character varying(11),
    agencia character varying(11),
    numero_do_cheque character varying(30),
    cidade character varying(100),
    estado character varying(2),
    valor numeric(15,4),
    documento character varying(30),
    tipo_de_documento bigint,
    vista_prazo bigint,
    observacoes text
);


ALTER TABLE movimento_remessa OWNER TO "ADMIN";

--
-- Name: movimento_remessa_lancamento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_remessa_lancamento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_remessa_lancamento_seq OWNER TO "ADMIN";

--
-- Name: movimento_romaneio_entrega; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_romaneio_entrega (
    empresa bigint,
    data_romaneio date,
    numero_romaneio bigint,
    numero_pedido bigint,
    numero_nota bigint,
    numero_cupom bigint,
    serie character varying(3),
    data_emissao date,
    codigo_responsavel bigint,
    nome_responsavel character varying(100),
    observacao text,
    data_entrega date
);


ALTER TABLE movimento_romaneio_entrega OWNER TO "ADMIN";

--
-- Name: movimento_romaneio_entrega_numero_romaneio_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_romaneio_entrega_numero_romaneio_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_romaneio_entrega_numero_romaneio_seq OWNER TO "ADMIN";

--
-- Name: movimento_seq_lote_controle; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE movimento_seq_lote_controle
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE movimento_seq_lote_controle OWNER TO "ADMIN";

--
-- Name: movimento_tecnicos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_tecnicos (
    empresa bigint,
    originado bigint,
    ordem bigint,
    cod_produto character varying(20),
    cod_tecnico bigint,
    nome_tecnico character varying(100),
    fk_movcaborcamento bigint,
    perc_comissao_empresa numeric(15,2) DEFAULT 0
);


ALTER TABLE movimento_tecnicos OWNER TO "ADMIN";

--
-- Name: COLUMN movimento_tecnicos.perc_comissao_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN movimento_tecnicos.perc_comissao_empresa IS 'Armazena o percentual da comissao da empresa para comissao por participantes';


--
-- Name: movimento_transito; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_transito (
    empresa bigint,
    numero_pedido bigint,
    data_de_emissao date,
    numero_da_nota bigint,
    serie_da_nota character varying(2),
    numero_do_cupom character varying(11),
    codigo_do_grupo character varying(20),
    codigo_do_produto character varying(20),
    unidade character varying(4),
    nome_do_produto character varying(100),
    quantidade numeric(15,4),
    valor_unitario numeric(15,7),
    valor_total numeric(15,4),
    codigo_do_vendedor bigint,
    codigo_do_cliente bigint,
    outros character varying(3),
    data_liquidada date,
    sequencia_nf bigint DEFAULT 0
);


ALTER TABLE movimento_transito OWNER TO "ADMIN";

--
-- Name: movimento_transito_compra; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE movimento_transito_compra (
    empresa bigint,
    codigo_forma bigint,
    data_de_emissao date,
    numero_da_nota bigint,
    serie_da_nota character varying(2),
    codigo_do_produto character varying(20),
    unidade character varying(6),
    nome_do_produto character varying(100),
    quantidade numeric(15,4),
    valor_unitario numeric(15,7),
    valor_total numeric(15,4),
    codigo_do_fornecedor bigint,
    outros character varying(3),
    data_liquidada date,
    sequencia_nf bigint DEFAULT 0,
    nota_contra_partida bigint DEFAULT 0
);


ALTER TABLE movimento_transito_compra OWNER TO "ADMIN";

--
-- Name: natureza_operacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE natureza_operacao (
    codigo integer,
    item integer NOT NULL,
    filial bigint,
    descricao character varying(100),
    codigo_da_aliquota bigint,
    tipo_venda character varying(5),
    tipo_cliente character varying(5),
    tipo_da_operacao character varying(1),
    estado character varying(1),
    pais character varying(1),
    conta_prazo character varying(8),
    conta_vista character varying(8),
    servico_produto character varying(2),
    suframa bigint,
    fora_estabelecimento smallint DEFAULT 0,
    industria_revenda character varying(1) DEFAULT 'R'::character varying,
    empresa character varying(20),
    codigo_csosn bigint,
    fk_faturamentocontribuinte character varying(5) DEFAULT 0,
    fk_faturamentonaocontribuinte character varying(5) DEFAULT 0
);


ALTER TABLE natureza_operacao OWNER TO "ADMIN";

--
-- Name: niveis_codigo_grupo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE niveis_codigo_grupo (
    empresa bigint,
    nivel1 bigint,
    nivel2 bigint,
    nivel3 bigint
);


ALTER TABLE niveis_codigo_grupo OWNER TO "ADMIN";

--
-- Name: niveis_codigo_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE niveis_codigo_produto (
    empresa bigint,
    nivel1 bigint,
    nivel2 bigint,
    nivel3 bigint,
    nivel4 bigint
);


ALTER TABLE niveis_codigo_produto OWNER TO "ADMIN";

--
-- Name: nota_fiscal_parcelamento_entrada_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE nota_fiscal_parcelamento_entrada_tmp (
    empresa bigint,
    codigo bigint,
    usuario bigint,
    tipo_documento bigint,
    data_de_emissao date,
    numero_da_duplicata character varying(20),
    banco character varying(10),
    agencia character varying(10),
    data_do_vencimento date,
    valor_do_vencimento numeric(15,4),
    codigo_portador bigint,
    nome_portador character varying(100),
    observacoes text,
    codigo_caixa bigint,
    nome_caixa character varying(100),
    tipo_caixa character varying(10),
    data_caixa date,
    conta_reduzida bigint DEFAULT 0,
    centro_custo bigint DEFAULT 0
);


ALTER TABLE nota_fiscal_parcelamento_entrada_tmp OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: nota_fiscal_parcelamento_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE nota_fiscal_parcelamento_tmp (
    empresa bigint,
    numero_pedido bigint,
    usuario bigint,
    codigo bigint,
    tipo_documento bigint,
    data_de_emissao date,
    numero_da_duplicata character varying(20),
    banco character varying(10),
    agencia character varying(10),
    data_do_vencimento date,
    valor_do_vencimento numeric(15,4),
    juros numeric(15,4),
    praca character varying(100),
    estado character varying(3),
    administradora bigint,
    terceiros character varying(100),
    cgc character varying(20),
    conta_corrente character varying(30) DEFAULT ''::character varying,
    aproveita_titulo_anterior smallint DEFAULT 0,
    verifica_tef smallint DEFAULT 0,
    fk_pos bigint,
    credito_debito character varying(1),
    bandeira smallint,
    numero_autorizacao character varying(20)
);


ALTER TABLE nota_fiscal_parcelamento_tmp OWNER TO "ADMIN";

--
-- Name: numero_pedido_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE numero_pedido_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE numero_pedido_seq OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: pagina_livro_fiscal; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE pagina_livro_fiscal (
    tipo bigint,
    mes character varying(2),
    ano character varying(4),
    pagina bigint
);


ALTER TABLE pagina_livro_fiscal OWNER TO "ADMIN";

--
-- Name: parcela_variavel_pedido_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE parcela_variavel_pedido_pocket (
    pvpp_id integer NOT NULL,
    pvp_id bigint NOT NULL,
    pct_id integer NOT NULL,
    pvpp_valor numeric,
    pvpp_prazo integer,
    pvpp_data_vencimento date,
    pvp_codigo_pedido character varying
);


ALTER TABLE parcela_variavel_pedido_pocket OWNER TO "ADMIN";

--
-- Name: parcelado_caixa_cheque_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE parcelado_caixa_cheque_tmp (
    caixa bigint,
    usuario bigint,
    data_emissao date,
    data_vencimento date,
    numero_cheque character varying(50),
    banco character varying(20),
    agencia character varying(20),
    valor numeric(15,4),
    terceiros character varying(100),
    observacoes character varying(100),
    uf character varying(4),
    codigo_do_cliente bigint,
    nome_do_cliente character varying(100),
    referencia character varying(100),
    cgc_terceiro character varying(20),
    vistaprazo integer,
    conta_corrente character varying(30) DEFAULT ''::character varying
);


ALTER TABLE parcelado_caixa_cheque_tmp OWNER TO "ADMIN";

--
-- Name: parcelado_caixa_tmps; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE parcelado_caixa_tmps (
    caixa bigint,
    usuario bigint,
    tipo bigint,
    valor numeric(15,4),
    codportador bigint,
    nomeportador character varying(100),
    juros numeric(15,4),
    conta character varying(50),
    conta_reduzida bigint,
    digito_conta bigint,
    desconto numeric(15,4) DEFAULT 0,
    conta_desc character varying(50) DEFAULT 0,
    conta_reduzida_desc bigint DEFAULT 0,
    digito_conta_desc bigint DEFAULT 0,
    conta_lanc character varying(15) DEFAULT 0,
    descricao character varying DEFAULT ''::character varying,
    sequencia_pagar bigint DEFAULT 0,
    titulo character varying DEFAULT ''::character varying
);


ALTER TABLE parcelado_caixa_tmps OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: pedido_compra_automatico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE pedido_compra_automatico (
    empresa bigint,
    data_emissao date,
    codigo_usuario bigint,
    nome_usuario character varying(100),
    codigo_produto character varying(20),
    nome_produto character varying(100),
    codigo_cliente bigint,
    nome_cliente character varying(100),
    validade date,
    quantidade numeric(15,4),
    observacao character varying(255),
    status character(1),
    situacao character(1)
);


ALTER TABLE pedido_compra_automatico OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: plano_conta; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE plano_conta (
    conta character varying(15) NOT NULL,
    digito character varying(1),
    nome character varying(100),
    natureza character varying(1),
    conta_reduzida bigint,
    conta_contabilidade character varying(60),
    digito_contabilidade bigint,
    nome_contabilidade character varying(100),
    natureza_contabilidade character varying(5),
    conta_reduzida_contabilidade bigint,
    digito_conta_reduzida_contabilidade bigint,
    tipo_conta character varying(2),
    balancete smallint DEFAULT 0,
    conta_mestre smallint DEFAULT 0,
    inativo smallint DEFAULT 0,
    empresa bigint,
    natureza_conta_contabilidade character varying(2),
    tipo_contabilidade character varying(1),
    data_contabilidade timestamp without time zone,
    nivel_contabilidade integer,
    conta_referenciada_rfb character varying(60)
);


ALTER TABLE plano_conta OWNER TO "ADMIN";

--
-- Name: prazo_medio; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE prazo_medio (
    codigo bigint,
    prazo bigint,
    vencimento date,
    valor numeric(15,4),
    valor_parcela numeric(15,4),
    ordem smallint,
    status character varying DEFAULT 'V'::character varying
);


ALTER TABLE prazo_medio OWNER TO "ADMIN";

--
-- Name: prazo_medio_sequencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE prazo_medio_sequencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE prazo_medio_sequencia_seq OWNER TO "ADMIN";

--
-- Name: preco_cliente; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE preco_cliente (
    empresa bigint,
    codigo_cliente bigint,
    codigo character varying(20),
    codigo_grupo character varying(10),
    descricao character varying(100),
    marca character varying(100),
    preco_atacado numeric(15,4),
    preco_varejo numeric(15,4),
    codigo_regiao smallint DEFAULT 0,
    liberado smallint DEFAULT 0
);


ALTER TABLE preco_cliente OWNER TO "ADMIN";

--
-- Name: produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE produto (
    codigo character varying(20) NOT NULL,
    subcodigo bigint,
    banho character varying(30),
    tipo character varying(10),
    modelo character varying(30),
    descricao character varying(100),
    codigo_grupo character varying(20) NOT NULL,
    servico_produto character varying(20),
    codigo_fornecedor bigint,
    nome_fornecedor character varying(100),
    marca character varying(100),
    preco_varejo numeric(15,4),
    data_varejo date,
    desconto_varejo numeric(15,4),
    minimo_varejo numeric(15,4),
    preco_atacado numeric(15,4),
    data_atacado date,
    desconto_atacado numeric(15,4),
    minimo_atacado numeric(15,4),
    data_inicial date,
    data_final date,
    preco_promocao numeric(15,4),
    custo_anterior numeric(18,7),
    custo numeric(18,7),
    custo_dolar numeric(18,7),
    data_custo date,
    custo_medio_anterior numeric(18,7),
    custo_medio numeric(18,7),
    dolar_custo_medio numeric(18,7),
    data_custo_medio date,
    custo_mercado numeric(18,7),
    dolar_custo numeric(18,7),
    data_custo_mercado date,
    aliquota_estadual bigint,
    unidade character varying(6),
    prazo_venda bigint,
    peso_bruto numeric(15,4),
    peso_liquido numeric(15,4),
    embalagem numeric(15,4) DEFAULT 0,
    estoque_maximo numeric(15,4),
    estoque_minimo numeric(15,4),
    valor_ipi numeric(15,4),
    dolar numeric(15,4),
    marckup_atacado numeric(15,4),
    marckup_varejo numeric(15,4),
    codigo_barras character varying(100),
    indexado_dolar bigint,
    inativo bigint,
    emissao_kit bigint,
    status character varying(2),
    produto_fornecedor character varying(20),
    figura text,
    cor character varying(150),
    observacao text,
    locacao_1 character varying(30),
    locacao_2 character varying(30),
    locacao_3 character varying(30),
    marcacao_venda bigint,
    codificacao_fiscal character varying(30),
    codigo_associado bigint,
    ministerio_saude character varying(20) DEFAULT 0,
    controle_lote smallint DEFAULT 0,
    industria_revenda character varying(1) DEFAULT 'R'::character varying,
    fracionado smallint DEFAULT 0,
    novo character varying(2) DEFAULT ''::character varying,
    alterar character varying(2) DEFAULT ''::character varying,
    kit_discriminado smallint DEFAULT 0,
    data_cadastro timestamp without time zone DEFAULT '2008-07-17'::date,
    data_alteracao timestamp without time zone,
    libera_estoque smallint DEFAULT 0,
    novo_ecommerce character varying(1) DEFAULT ''::character varying,
    alterar_ecommerce character varying(1) DEFAULT ''::character varying,
    envia_pocket smallint DEFAULT 1,
    recebido_tepp character varying(2) DEFAULT ''::character varying,
    altera_custo character varying(1) DEFAULT 'N'::character varying,
    utiliza_grade smallint DEFAULT 0,
    codigo_unidade smallint NOT NULL,
    ultimo_precocompra numeric(15,4) DEFAULT 0 NOT NULL,
    bloqueio_embalagem smallint DEFAULT 0,
    disponivel_ecommerce smallint DEFAULT 0,
    ativo_ecommerce smallint DEFAULT 0,
    fk_cadastrotributacao integer,
    bloqueia_movimentacao character varying(1) DEFAULT 0,
    controle_numero_serie smallint DEFAULT 0,
    codigo_lista_servico smallint,
    codigo_genero_item character varying(2),
    fk_cnae_servico bigint,
    porcentagem_retencao_contribuicao_social_servico numeric(15,4) DEFAULT 0,
    servico_retem_contribuicao_social smallint,
    fk_marca bigint,
    referencia character varying(50),
    cest character varying(30),
    derivado_petroleo character varying(2),
    codigo_anp character varying(30),
    controlar_rastreabilidade boolean DEFAULT false,
    abaixo_preco_custo smallint DEFAULT 0,
    controlar_altura_largura boolean DEFAULT false
);


ALTER TABLE produto OWNER TO "ADMIN";

--
-- Name: COLUMN produto.bloqueia_movimentacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN produto.bloqueia_movimentacao IS 'bloqueia para no deixar movimentar o produto em caso de necessidade ex.: (contagem estoque)';


--
-- Name: COLUMN produto.controle_numero_serie; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN produto.controle_numero_serie IS '0 - Desativado 1 - Possibilita controlar produtos pelo numero de serie sem ter necessidade de informar data de fabricao e data de validade.';


--
-- Name: COLUMN produto.referencia; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN produto.referencia IS 'campo para informao da referncia do produto';


--
-- Name: produtocategoria; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE produtocategoria (
    codigocategoria bigint NOT NULL,
    codigoproduto character varying(20) NOT NULL
);


ALTER TABLE produtocategoria OWNER TO "ADMIN";

--
-- Name: replicacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE replicacao (
    empresa smallint,
    serial integer NOT NULL,
    descricao text,
    status character varying(2),
    "time" timestamp with time zone
);


ALTER TABLE replicacao OWNER TO "ADMIN";

--
-- Name: replicacao_cadastros; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE replicacao_cadastros (
    empresa smallint,
    serial integer NOT NULL,
    descricao text,
    status character varying(2),
    tempo timestamp with time zone
);


ALTER TABLE replicacao_cadastros OWNER TO "ADMIN";

--
-- Name: replicacao_cadastros_serial_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE replicacao_cadastros_serial_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE replicacao_cadastros_serial_seq OWNER TO "ADMIN";

--
-- Name: replicacao_cadastros_serial_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE replicacao_cadastros_serial_seq OWNED BY replicacao_cadastros.serial;


--
-- Name: replicacao_historico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE replicacao_historico (
    descricao text,
    data date,
    hora character varying(20),
    status character varying(1) DEFAULT 'A'::character varying
);


ALTER TABLE replicacao_historico OWNER TO "ADMIN";

--
-- Name: replicacao_libera_cadastro; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE replicacao_libera_cadastro (
    nome text
);


ALTER TABLE replicacao_libera_cadastro OWNER TO "ADMIN";

--
-- Name: replicacao_serial_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE replicacao_serial_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE replicacao_serial_seq OWNER TO "ADMIN";

--
-- Name: replicacao_serial_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE replicacao_serial_seq OWNED BY replicacao.serial;


--
-- Name: saldo_caixa; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE saldo_caixa (
    caixa bigint,
    data date,
    saldo numeric(15,4),
    serie_nf character varying(5),
    hora_fechamento character varying(20),
    empresa bigint
);


ALTER TABLE saldo_caixa OWNER TO "ADMIN";

--
-- Name: separacao_mercadoria; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE separacao_mercadoria (
    empresa bigint,
    codigo_produto character varying(20),
    quantidade numeric(15,4),
    quantidade_cortada numeric(15,4) DEFAULT 0,
    pk_codigo bigint,
    fk_sepmercadoriacabecalho bigint,
    quantidade_pedido numeric(15,4) DEFAULT 0,
    motivo_corte text,
    fk_item_venda bigint DEFAULT 0 NOT NULL,
    fator_conversao double precision DEFAULT 1 NOT NULL
);


ALTER TABLE separacao_mercadoria OWNER TO "ADMIN";

--
-- Name: separacao_mercadoria_cabecalho; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE separacao_mercadoria_cabecalho (
    pk_codigo bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    fk_cabecalhoorcamento bigint NOT NULL,
    data_entrada timestamp(0) without time zone,
    data_finalizacao timestamp without time zone,
    status character varying(2) NOT NULL
);


ALTER TABLE separacao_mercadoria_cabecalho OWNER TO "ADMIN";

--
-- Name: COLUMN separacao_mercadoria_cabecalho.status; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN separacao_mercadoria_cabecalho.status IS 'determinar se o pedido que est sendo com estoquista esta em aberto ou ja foi separado A - ABERTO F - FECHADO';


--
-- Name: separacao_mercadoria_cabecalho_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE separacao_mercadoria_cabecalho_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE separacao_mercadoria_cabecalho_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: separacao_mercadoria_etapas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE separacao_mercadoria_etapas (
    pk_codigo bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    fk_cadetapasseparacaomercadoria bigint NOT NULL,
    fk_estoquista bigint NOT NULL,
    data_inicio timestamp without time zone,
    data_termino timestamp without time zone,
    fk_sepmercadoriacabecalho bigint NOT NULL,
    finalizada character(1) DEFAULT 'A'::bpchar NOT NULL
);


ALTER TABLE separacao_mercadoria_etapas OWNER TO "ADMIN";

--
-- Name: TABLE separacao_mercadoria_etapas; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE separacao_mercadoria_etapas IS 'Responsvel por armazenar cada etapa que passou o pedido na tela de despacho de mercadoria e quanto tempo demorou em cada uma ';


--
-- Name: COLUMN separacao_mercadoria_etapas.finalizada; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN separacao_mercadoria_etapas.finalizada IS 'Informa se a etapa foi finalizada. A = Aberta, F = Finalizada';


--
-- Name: separacao_mercadoria_etapas_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE separacao_mercadoria_etapas_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE separacao_mercadoria_etapas_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: separacao_mercadoria_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE separacao_mercadoria_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE separacao_mercadoria_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: sequencial_geracao_titulos; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE sequencial_geracao_titulos
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sequencial_geracao_titulos OWNER TO "ADMIN";

--
-- Name: setup; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE setup (
    sequencia bigint,
    empresa bigint DEFAULT 0
);


ALTER TABLE setup OWNER TO "ADMIN";

--
-- Name: setup_fechamento_pedido; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE setup_fechamento_pedido (
    numero_acumulativo bigint,
    codigo_cliente bigint,
    numero_pedido bigint,
    sequencia_pedido bigint DEFAULT 0
);


ALTER TABLE setup_fechamento_pedido OWNER TO "ADMIN";

--
-- Name: sysinfo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE sysinfo (
    machine_number bigint NOT NULL,
    sysdate character varying(20),
    mac_address character varying(20),
    syslib character varying(10),
    sysdate2 character varying(20),
    tipo_acesso smallint DEFAULT 1,
    numero_licencas character varying DEFAULT 0,
    numero_acessosexternos character varying DEFAULT 0,
    log_caixa smallint,
    data_ultimo_acesso date
);


ALTER TABLE sysinfo OWNER TO "ADMIN";

--
-- Name: COLUMN sysinfo.tipo_acesso; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN sysinfo.tipo_acesso IS 'Informar o tipo de acesso 1-INTERNO 2-EXTERNO';


--
-- Name: COLUMN sysinfo.data_ultimo_acesso; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN sysinfo.data_ultimo_acesso IS 'campo para guardar a data do ultimo acesso realizado pela mquina que utiliza a licena.';


--
-- Name: tabela_preco_lista_produto_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tabela_preco_lista_produto_pocket (
    codigo character varying(20) NOT NULL,
    tplp_preco_lista_1 numeric DEFAULT 0,
    tplp_preco_lista_2 numeric DEFAULT 0,
    tplp_preco_lista_3 numeric DEFAULT 0,
    tplp_preco_lista_4 numeric DEFAULT 0,
    tplp_preco_lista_5 numeric DEFAULT 0,
    tplp_preco_lista_6 numeric DEFAULT 0,
    tplp_preco_lista_7 numeric DEFAULT 0,
    tplp_preco_lista_8 numeric DEFAULT 0,
    tplp_preco_lista_9 numeric DEFAULT 0,
    tplp_preco_lista_10 numeric DEFAULT 0,
    tplp_data_cadastro date,
    tplp_data_alteracao date
);


ALTER TABLE tabela_preco_lista_produto_pocket OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: tb_acerto_endereco_estoque; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_acerto_endereco_estoque (
    pk_acerto_endereco_estoque bigint NOT NULL,
    data_hora timestamp without time zone NOT NULL,
    quantidade double precision NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_endereco_estoque bigint NOT NULL,
    fk_produto character varying(20) NOT NULL
);


ALTER TABLE tb_acerto_endereco_estoque OWNER TO "ADMIN";

--
-- Name: tb_acerto_endereco_estoque_pk_acerto_endereco_estoque_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_acerto_endereco_estoque_pk_acerto_endereco_estoque_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_acerto_endereco_estoque_pk_acerto_endereco_estoque_seq OWNER TO "ADMIN";

--
-- Name: tb_acerto_endereco_estoque_pk_acerto_endereco_estoque_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_acerto_endereco_estoque_pk_acerto_endereco_estoque_seq OWNED BY tb_acerto_endereco_estoque.pk_acerto_endereco_estoque;


--
-- Name: tb_altura_largura_item; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_altura_largura_item (
    pk_altura_largura_item bigint NOT NULL,
    fk_movimento bigint,
    fk_item bigint,
    tipo_movimento character varying(1),
    quantidade double precision,
    altura double precision,
    largura double precision,
    total double precision
);


ALTER TABLE tb_altura_largura_item OWNER TO "ADMIN";

--
-- Name: tb_altura_largura_item_pk_altura_largura_item_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_altura_largura_item_pk_altura_largura_item_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_altura_largura_item_pk_altura_largura_item_seq OWNER TO "ADMIN";

--
-- Name: tb_altura_largura_item_pk_altura_largura_item_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_altura_largura_item_pk_altura_largura_item_seq OWNED BY tb_altura_largura_item.pk_altura_largura_item;


--
-- Name: tb_apropriacao_bem; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_apropriacao_bem (
    data_inicio timestamp without time zone NOT NULL,
    data_final timestamp without time zone NOT NULL,
    pk_apropriacao bigint NOT NULL,
    saldo_inicial numeric(12,2),
    valor_parcela_passivel_apropriacao numeric(12,2) NOT NULL,
    valor_somatorio_saida_exportacao numeric(12,2) NOT NULL,
    valor_total_saidas numeric(12,2) NOT NULL,
    indice_participacao numeric(12,8) NOT NULL,
    valor_total_icms_apropriacao numeric(12,2) NOT NULL
);


ALTER TABLE tb_apropriacao_bem OWNER TO "ADMIN";

--
-- Name: tb_apropriacao_bem_pk_apropriacao_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_apropriacao_bem_pk_apropriacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_apropriacao_bem_pk_apropriacao_seq OWNER TO "ADMIN";

--
-- Name: tb_apropriacao_bem_pk_apropriacao_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_apropriacao_bem_pk_apropriacao_seq OWNED BY tb_apropriacao_bem.pk_apropriacao;


SET default_with_oids = true;

--
-- Name: tb_assunto_relatorio; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_assunto_relatorio (
    pk_assunto_relatorio bigint NOT NULL,
    nome_assunto character varying(30) NOT NULL,
    descricao_assunto character varying(100),
    fk_assunto_pai bigint
);


ALTER TABLE tb_assunto_relatorio OWNER TO "ADMIN";

--
-- Name: COLUMN tb_assunto_relatorio.pk_assunto_relatorio; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_assunto_relatorio.pk_assunto_relatorio IS 'Chave primria da tabela.';


--
-- Name: COLUMN tb_assunto_relatorio.nome_assunto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_assunto_relatorio.nome_assunto IS 'Nome que ser apresentado na camada de viso onde estar disponibilizado o relatrio.';


--
-- Name: COLUMN tb_assunto_relatorio.descricao_assunto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_assunto_relatorio.descricao_assunto IS 'Texto descritivo do relatrio.';


--
-- Name: tb_assunto_relatorio_pk_assunto_relatorio_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_assunto_relatorio_pk_assunto_relatorio_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_assunto_relatorio_pk_assunto_relatorio_seq OWNER TO "ADMIN";

--
-- Name: tb_assunto_relatorio_pk_assunto_relatorio_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_assunto_relatorio_pk_assunto_relatorio_seq OWNED BY tb_assunto_relatorio.pk_assunto_relatorio;


SET default_with_oids = false;

--
-- Name: tb_auditoria_atualizacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_auditoria_atualizacao (
    data_atualizacao date,
    eh_versao_atual boolean,
    estah_atualizando boolean,
    versao character varying[],
    pk_auditoria_atualizacao bigint NOT NULL,
    fk_usuario bigint NOT NULL,
    atualizacao_concluida boolean,
    atualizacao_bancodedados boolean
);


ALTER TABLE tb_auditoria_atualizacao OWNER TO "ADMIN";

--
-- Name: tb_auditoria_atualizacao_pk_auditoria_atualizacao_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_auditoria_atualizacao_pk_auditoria_atualizacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_auditoria_atualizacao_pk_auditoria_atualizacao_seq OWNER TO "ADMIN";

--
-- Name: tb_auditoria_nfse; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_auditoria_nfse (
    pk_auditoria_nfse bigint NOT NULL,
    fk_nfse bigint,
    numero bigint,
    serie character varying(250),
    chave_acesso character varying(250),
    protocolo bigint,
    even_seq character varying(250),
    even_tipo character varying(250),
    even_id character varying(250),
    dh_aut character varying(250),
    digest_value character varying(250),
    codigo_retorno character varying(250),
    retorno text,
    xml_base64 text,
    pdf_base64 text,
    data timestamp without time zone
);


ALTER TABLE tb_auditoria_nfse OWNER TO "ADMIN";

--
-- Name: tb_auditoria_nfse_pk_auditoria_nfse_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_auditoria_nfse_pk_auditoria_nfse_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_auditoria_nfse_pk_auditoria_nfse_seq OWNER TO "ADMIN";

--
-- Name: tb_auditoria_nfse_pk_auditoria_nfse_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_auditoria_nfse_pk_auditoria_nfse_seq OWNED BY tb_auditoria_nfse.pk_auditoria_nfse;


--
-- Name: tb_autorizacao_lacre; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_autorizacao_lacre (
    pk_autorizacao bigint NOT NULL,
    codigo_autorizacao character varying(50),
    data_cadastro date,
    quantidade numeric(15,4),
    numero_inicial bigint,
    numero_final bigint
);


ALTER TABLE tb_autorizacao_lacre OWNER TO "ADMIN";

--
-- Name: TABLE tb_autorizacao_lacre; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_autorizacao_lacre IS 'Cadastros da autorizao de confeco de lacre';


--
-- Name: COLUMN tb_autorizacao_lacre.pk_autorizacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_autorizacao_lacre.pk_autorizacao IS 'Chave primria da tabela';


--
-- Name: COLUMN tb_autorizacao_lacre.codigo_autorizacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_autorizacao_lacre.codigo_autorizacao IS 'Codigo de autorizao do sefaz';


--
-- Name: COLUMN tb_autorizacao_lacre.data_cadastro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_autorizacao_lacre.data_cadastro IS 'Data de incluso do cadastro';


--
-- Name: COLUMN tb_autorizacao_lacre.quantidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_autorizacao_lacre.quantidade IS 'Quantidade de lacres cadastrados';


--
-- Name: COLUMN tb_autorizacao_lacre.numero_inicial; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_autorizacao_lacre.numero_inicial IS 'Numero do lacre inicial';


--
-- Name: COLUMN tb_autorizacao_lacre.numero_final; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_autorizacao_lacre.numero_final IS 'Numero do lacre final';


--
-- Name: tb_autorizacao_lacre_pk_autorizacao_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_autorizacao_lacre_pk_autorizacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_autorizacao_lacre_pk_autorizacao_seq OWNER TO "ADMIN";

--
-- Name: tb_autorizacao_lacre_pk_autorizacao_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_autorizacao_lacre_pk_autorizacao_seq OWNED BY tb_autorizacao_lacre.pk_autorizacao;


SET default_with_oids = true;

--
-- Name: tb_balanco; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_balanco (
    fk_empresa bigint NOT NULL,
    pk_balanco bigint NOT NULL,
    observacoes text,
    data_inicial date,
    data_final date,
    situacao character varying(1) NOT NULL,
    descricao character varying(50),
    atualiza_estoque boolean DEFAULT false NOT NULL
);


ALTER TABLE tb_balanco OWNER TO "ADMIN";

--
-- Name: TABLE tb_balanco; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_balanco IS 'Armazena os dados iniciais do balanco';


--
-- Name: COLUMN tb_balanco.situacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_balanco.situacao IS 'informao a situaao do balanco 1 - Aberto 2 - Fechado';


--
-- Name: COLUMN tb_balanco.atualiza_estoque; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_balanco.atualiza_estoque IS 'Verdadeiro para informar que atualiza o estoque no fechamento';


--
-- Name: tb_balanco_pk_balanco_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_balanco_pk_balanco_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_balanco_pk_balanco_seq OWNER TO "ADMIN";

--
-- Name: tb_balanco_pk_balanco_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_balanco_pk_balanco_seq OWNED BY tb_balanco.pk_balanco;


SET default_with_oids = false;

--
-- Name: tb_banco; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_banco (
    pk_banco bigint NOT NULL,
    codigo integer NOT NULL,
    nome character varying(255) NOT NULL
);


ALTER TABLE tb_banco OWNER TO "ADMIN";

--
-- Name: tb_banco_pk_banco_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_banco_pk_banco_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_banco_pk_banco_seq OWNER TO "ADMIN";

--
-- Name: tb_banco_pk_banco_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_banco_pk_banco_seq OWNED BY tb_banco.pk_banco;


--
-- Name: tb_bem_imobilizado; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_bem_imobilizado (
    pk_bem_imobilizado bigint NOT NULL,
    tipo_mercadoria smallint NOT NULL,
    fk_produto character varying(20) NOT NULL,
    fk_conta_contabil bigint,
    fk_bem_principal bigint
);


ALTER TABLE tb_bem_imobilizado OWNER TO "ADMIN";

--
-- Name: tb_bem_imobilizado_pk_bem_imobilizado_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_bem_imobilizado_pk_bem_imobilizado_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_bem_imobilizado_pk_bem_imobilizado_seq OWNER TO "ADMIN";

--
-- Name: tb_bem_imobilizado_pk_bem_imobilizado_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_bem_imobilizado_pk_bem_imobilizado_seq OWNED BY tb_bem_imobilizado.pk_bem_imobilizado;


--
-- Name: tb_bem_imobilizado_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_bem_imobilizado_tmp (
    pk_bem_imobilizado_tmp bigint NOT NULL,
    fk_produto character varying(20),
    fk_conta_contabil bigint,
    fk_bem_principal bigint,
    tipo_mercadoria smallint
);


ALTER TABLE tb_bem_imobilizado_tmp OWNER TO "ADMIN";

--
-- Name: tb_bem_imobilizado_tmp_pk_bem_imobilizado_tmp_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_bem_imobilizado_tmp_pk_bem_imobilizado_tmp_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_bem_imobilizado_tmp_pk_bem_imobilizado_tmp_seq OWNER TO "ADMIN";

--
-- Name: tb_bem_imobilizado_tmp_pk_bem_imobilizado_tmp_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_bem_imobilizado_tmp_pk_bem_imobilizado_tmp_seq OWNED BY tb_bem_imobilizado_tmp.pk_bem_imobilizado_tmp;


--
-- Name: tb_beneficiario_boleto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_beneficiario_boleto (
    pk_beneficiario_boleto bigint NOT NULL,
    fk_conta_corrente bigint NOT NULL,
    fk_endereco bigint NOT NULL,
    codigo_beneficiario character varying(50) NOT NULL,
    dv_beneficiario character varying(10) NOT NULL,
    nome character varying(255) NOT NULL,
    cpfcnpj character varying(20) NOT NULL,
    tipo_pessoa integer NOT NULL,
    codigo_transmissao_cnab400 character varying(20),
    codigo_transmissao_cnab240 character varying(15)
);


ALTER TABLE tb_beneficiario_boleto OWNER TO "ADMIN";

--
-- Name: tb_beneficiario_boleto_pk_beneficiario_boleto_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_beneficiario_boleto_pk_beneficiario_boleto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_beneficiario_boleto_pk_beneficiario_boleto_seq OWNER TO "ADMIN";

--
-- Name: tb_beneficiario_boleto_pk_beneficiario_boleto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_beneficiario_boleto_pk_beneficiario_boleto_seq OWNED BY tb_beneficiario_boleto.pk_beneficiario_boleto;


--
-- Name: tb_blocoguias; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_blocoguias (
    pk_blocoguias bigint NOT NULL,
    numero_inicial bigint NOT NULL,
    numero_final bigint NOT NULL,
    data_aquisicao date NOT NULL,
    fk_cliente bigint NOT NULL
);


ALTER TABLE tb_blocoguias OWNER TO "ADMIN";

--
-- Name: TABLE tb_blocoguias; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_blocoguias IS 'responsvel por armazenar cadastro de bloco das guias';


--
-- Name: tb_boleto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_boleto (
    pk_boleto bigint NOT NULL,
    fk_configuracao_boleto bigint NOT NULL,
    fk_cliente bigint NOT NULL,
    fk_titulo bigint NOT NULL,
    codigo_banco integer NOT NULL,
    carteira integer NOT NULL,
    linha_digitavel character varying(100),
    nosso_numero character varying(50) NOT NULL,
    sequencia_nosso_numero bigint NOT NULL,
    numero_documento character varying(255) NOT NULL,
    data_documento date NOT NULL,
    data_vencimento date NOT NULL,
    data_processamento date NOT NULL,
    codigo_beneficiario character varying(50) NOT NULL,
    nome_beneficiario character varying(255) NOT NULL,
    local_pagamento character varying(255) NOT NULL,
    dados_pagador character varying(255) NOT NULL,
    quantidade_dias_protesto integer,
    moeda character varying(50) NOT NULL,
    quantidade_moeda double precision,
    especie character varying(5) NOT NULL,
    aceite character varying(1) NOT NULL,
    valor_documento double precision NOT NULL,
    desconto double precision,
    multa double precision,
    juros double precision,
    outras_deducoes double precision,
    outros_acrescimos double precision,
    valor_cobrado double precision NOT NULL,
    substituido boolean NOT NULL,
    alterado boolean DEFAULT false NOT NULL,
    protestar_dias_uteis boolean DEFAULT true NOT NULL,
    codigo_protesto integer DEFAULT 0
);


ALTER TABLE tb_boleto OWNER TO "ADMIN";

--
-- Name: COLUMN tb_boleto.protestar_dias_uteis; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_boleto.protestar_dias_uteis IS 'Verdadeiro indica dias teis, Falso indica dias corridos.';


--
-- Name: tb_boleto_pk_boleto_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_boleto_pk_boleto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_boleto_pk_boleto_seq OWNER TO "ADMIN";

--
-- Name: tb_boleto_pk_boleto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_boleto_pk_boleto_seq OWNED BY tb_boleto.pk_boleto;


SET default_with_oids = true;

--
-- Name: tb_cad_linha_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cad_linha_produto (
    pk_codigo bigint NOT NULL,
    descricao character varying(60),
    fk_grupo character varying(20),
    inativo smallint DEFAULT 0 NOT NULL
);


ALTER TABLE tb_cad_linha_produto OWNER TO "ADMIN";

--
-- Name: TABLE tb_cad_linha_produto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_cad_linha_produto IS 'Responsvel por armazenar os cadastro de linhas para produtos';


SET default_with_oids = false;

--
-- Name: tb_cadastro_comissao_definicao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cadastro_comissao_definicao (
    pk_definicao bigint NOT NULL,
    fk_grupo_participante bigint NOT NULL,
    fk_participante bigint NOT NULL,
    percentual_participacao double precision NOT NULL,
    fk_comissao_diferenciada bigint
);


ALTER TABLE tb_cadastro_comissao_definicao OWNER TO "ADMIN";

--
-- Name: tb_cadastro_comissao_funcao_participante; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cadastro_comissao_funcao_participante (
    pk_funcao_participante bigint NOT NULL,
    nome_funcao_participante character varying(100) NOT NULL
);


ALTER TABLE tb_cadastro_comissao_funcao_participante OWNER TO "ADMIN";

--
-- Name: tb_cadastro_comissao_grupo_participantes; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cadastro_comissao_grupo_participantes (
    pk_grupo_participante bigint NOT NULL,
    fk_vendedor_principal bigint NOT NULL,
    nome_grupo_participantes character varying(200) NOT NULL
);


ALTER TABLE tb_cadastro_comissao_grupo_participantes OWNER TO "ADMIN";

--
-- Name: tb_cadastro_comissao_participante; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cadastro_comissao_participante (
    pk_participante bigint NOT NULL,
    fk_funcao_participante bigint NOT NULL,
    nome_participante character varying(200) NOT NULL
);


ALTER TABLE tb_cadastro_comissao_participante OWNER TO "ADMIN";

--
-- Name: tb_cadastro_faixa_periodo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cadastro_faixa_periodo (
    pk_cadastro_faixa_periodo bigint NOT NULL,
    descricao_faixa character varying(100) NOT NULL,
    qtde_dias_inicial bigint NOT NULL,
    qtde_faixas bigint NOT NULL,
    qtde_dias_faixa bigint NOT NULL
);


ALTER TABLE tb_cadastro_faixa_periodo OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: tb_cadastro_marckup; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cadastro_marckup (
    empresa bigint NOT NULL,
    pk_codigo bigint NOT NULL,
    lucro_atacado numeric(15,6),
    lucro_varejo numeric(15,6),
    marckup_atacado numeric(15,6),
    marckup_varejo numeric(15,6),
    marckup_minimo smallint,
    despesas_variaveis numeric(15,6)
);


ALTER TABLE tb_cadastro_marckup OWNER TO "ADMIN";

--
-- Name: TABLE tb_cadastro_marckup; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_cadastro_marckup IS 'Cadastro de marckups de produtos';


--
-- Name: tb_cadastro_tributacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cadastro_tributacao (
    pk_codigo integer NOT NULL,
    descricao character varying(100),
    inativo bit(1) DEFAULT B'0'::"bit" NOT NULL
);


ALTER TABLE tb_cadastro_tributacao OWNER TO "ADMIN";

--
-- Name: TABLE tb_cadastro_tributacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_cadastro_tributacao IS 'Responsvel por criar um nome para uma tributao especfica de um grupo de produtos.Ed.: Oleos Lubrificantes - Peas - etc...';


SET default_with_oids = false;

--
-- Name: tb_caixa_dados_fechamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_caixa_dados_fechamento (
    pk_tb_caixa_dados_fechamento bigint NOT NULL,
    fk_caixa bigint NOT NULL,
    fk_portador_destino bigint NOT NULL,
    codigo_especie bigint NOT NULL,
    valor_vendas double precision NOT NULL,
    valor_entradas double precision NOT NULL,
    valor_saidas double precision NOT NULL
);


ALTER TABLE tb_caixa_dados_fechamento OWNER TO "ADMIN";

--
-- Name: tb_caixa_dados_fechamento_pk_tb_caixa_dados_fechamento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_caixa_dados_fechamento_pk_tb_caixa_dados_fechamento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_caixa_dados_fechamento_pk_tb_caixa_dados_fechamento_seq OWNER TO "ADMIN";

--
-- Name: tb_caixa_dados_fechamento_pk_tb_caixa_dados_fechamento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_caixa_dados_fechamento_pk_tb_caixa_dados_fechamento_seq OWNED BY tb_caixa_dados_fechamento.pk_tb_caixa_dados_fechamento;


SET default_with_oids = true;

--
-- Name: tb_cartacorrecao_nfe; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cartacorrecao_nfe (
    fk_empresa bigint NOT NULL,
    fk_id_nfe bigint NOT NULL,
    codigo_correcao bigint NOT NULL,
    registro_correcao character varying,
    dados_correcao text
);


ALTER TABLE tb_cartacorrecao_nfe OWNER TO "ADMIN";

--
-- Name: tb_central_nfse; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_central_nfse (
    pk_central_nfse bigint NOT NULL,
    fk_movimento_cabecalho_nota_fiscal_saida bigint,
    status_envio smallint,
    ultimo_erro character varying(200),
    fk_empresa bigint,
    codigo_verificacao character varying(50)
);


ALTER TABLE tb_central_nfse OWNER TO "ADMIN";

--
-- Name: COLUMN tb_central_nfse.status_envio; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_central_nfse.status_envio IS '0 = Pendente / 1 = Enviado com sucesso';


--
-- Name: tb_central_nfse_pk_central_nfse_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_central_nfse_pk_central_nfse_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_central_nfse_pk_central_nfse_seq OWNER TO "ADMIN";

--
-- Name: tb_central_nfse_pk_central_nfse_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_central_nfse_pk_central_nfse_seq OWNED BY tb_central_nfse.pk_central_nfse;


--
-- Name: tb_cf_impostos_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cf_impostos_tmp (
    pk_codigo bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    percentual_icms_simples numeric(15,4),
    valor_icms_simples numeric(15,4),
    base_calculo_pis numeric(15,4),
    percentual_pis numeric(15,4),
    base_calculo_cofins numeric(15,4),
    percentual_cofins numeric(15,4),
    cst_pis character varying(3),
    cst_cofins character varying(3),
    cst_ipi character varying(3),
    base_calculo_ipi numeric(15,4),
    fk_cupomfiscaltmp bigint,
    valor_aproximado_impostos numeric(15,4) DEFAULT 0,
    percentual_mva_icmsst double precision DEFAULT 0 NOT NULL
);


ALTER TABLE tb_cf_impostos_tmp OWNER TO "ADMIN";

--
-- Name: TABLE tb_cf_impostos_tmp; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_cf_impostos_tmp IS 'Responsvel por armazenar temporariamente as vendas do PDV antes do fechamento final do cupom fiscal para depois envi-la para tabela movimento_impostos';


--
-- Name: tb_cf_impostos_tmp_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_cf_impostos_tmp_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_cf_impostos_tmp_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: tb_cf_impostos_tmp_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_cf_impostos_tmp_pk_codigo_seq OWNED BY tb_cf_impostos_tmp.pk_codigo;


--
-- Name: tb_cheque_moradia; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cheque_moradia (
    pk_cheque_moradia bigint NOT NULL,
    fk_cliente bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_sequencia_venda bigint NOT NULL,
    numero_cheque character varying(100) NOT NULL,
    codigo_beneficiario character varying(100) NOT NULL,
    valor_cheque numeric(15,4) NOT NULL
);


ALTER TABLE tb_cheque_moradia OWNER TO "ADMIN";

--
-- Name: tb_cheque_moradia_pk_cheque_moradia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_cheque_moradia_pk_cheque_moradia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_cheque_moradia_pk_cheque_moradia_seq OWNER TO "ADMIN";

--
-- Name: tb_cheque_moradia_pk_cheque_moradia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_cheque_moradia_pk_cheque_moradia_seq OWNED BY tb_cheque_moradia.pk_cheque_moradia;


SET default_with_oids = false;

--
-- Name: tb_cliente_licenca_pf; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cliente_licenca_pf (
    pk_codigo bigint NOT NULL,
    fk_cliente bigint NOT NULL,
    licenca_pf character varying(30) NOT NULL,
    validade date NOT NULL
);


ALTER TABLE tb_cliente_licenca_pf OWNER TO "ADMIN";

--
-- Name: COLUMN tb_cliente_licenca_pf.fk_cliente; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_licenca_pf.fk_cliente IS 'Ligao da licena com o cliente.';


--
-- Name: COLUMN tb_cliente_licenca_pf.licenca_pf; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_licenca_pf.licenca_pf IS 'Cdigo da licena da Polcia Federal.';


--
-- Name: COLUMN tb_cliente_licenca_pf.validade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_licenca_pf.validade IS 'Data de validade da Licena.';


SET default_with_oids = true;

--
-- Name: tb_cliente_licenca_pf_produtos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cliente_licenca_pf_produtos (
    fk_clientelicencapf bigint NOT NULL,
    fk_tbprodutocontroladopf bigint NOT NULL
);


ALTER TABLE tb_cliente_licenca_pf_produtos OWNER TO "ADMIN";

--
-- Name: COLUMN tb_cliente_licenca_pf_produtos.fk_clientelicencapf; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_licenca_pf_produtos.fk_clientelicencapf IS 'Chave extrangeira da tabela tb_cliente_licenca_pf';


--
-- Name: COLUMN tb_cliente_licenca_pf_produtos.fk_tbprodutocontroladopf; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_licenca_pf_produtos.fk_tbprodutocontroladopf IS 'Chave extrangeira da tabela tb_produto_controlado_pf';


SET default_with_oids = false;

--
-- Name: tb_cliente_mobilidade; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cliente_mobilidade (
    pk_cliente_mobilidade character varying(25) NOT NULL,
    fk_cliente_erp bigint NOT NULL,
    data_processamento date NOT NULL,
    origem_registro character varying(3) NOT NULL,
    fk_cliente_mobilidade character varying(25),
    fk_empresa bigint NOT NULL
);


ALTER TABLE tb_cliente_mobilidade OWNER TO "ADMIN";

--
-- Name: TABLE tb_cliente_mobilidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_cliente_mobilidade IS 'Tabela que contem as informaes relativas s ligaes dos clientes do sistema de mobilidade e o sistema ERP.';


--
-- Name: COLUMN tb_cliente_mobilidade.pk_cliente_mobilidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_mobilidade.pk_cliente_mobilidade IS 'chave primria da tabela, cujo valor, quando no existir valor em fk_cliente_mobilidade, ser a chave de  ligaao com o sistema de mobilidade.';


--
-- Name: COLUMN tb_cliente_mobilidade.data_processamento; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_mobilidade.data_processamento IS 'Data em que fora processada a informao.';


--
-- Name: COLUMN tb_cliente_mobilidade.origem_registro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_mobilidade.origem_registro IS 'indica de onde foi a origem do cadastro. erp: Sistema erp mbl:  sismtema mobilidade ';


--
-- Name: COLUMN tb_cliente_mobilidade.fk_cliente_mobilidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_mobilidade.fk_cliente_mobilidade IS 'Chave que vem do processo de integrao, chave criada para o cliente no sistema de mobilidade.';


--
-- Name: COLUMN tb_cliente_mobilidade.fk_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_mobilidade.fk_empresa IS 'Chave estrangeira que identifica a empresa do registro.';


--
-- Name: tb_cliente_pontolocacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cliente_pontolocacao (
    fk_pontolocacao bigint NOT NULL,
    fk_cliente bigint NOT NULL,
    inativo character varying(1) DEFAULT '0'::character varying NOT NULL,
    data_alteracao date NOT NULL
);


ALTER TABLE tb_cliente_pontolocacao OWNER TO "ADMIN";

--
-- Name: TABLE tb_cliente_pontolocacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_cliente_pontolocacao IS 'Responsvel por armazenar relacionamento entre cliente e ponto de locao. Um ponto de locao s ser passado para outro cliente se o seu relacionamento atual estiver inativo.';


--
-- Name: COLUMN tb_cliente_pontolocacao.inativo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_cliente_pontolocacao.inativo IS 'Informar se o relacionamento entre cliente e ponto de ligao ainda est ativo, pois s poder passar para outro cliente se a ligao ficar inativa. 0 - ativo 1 - inativo';


SET default_with_oids = true;

--
-- Name: tb_cliente_transportadora; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cliente_transportadora (
    fk_cliente bigint,
    fk_transportadora bigint
);


ALTER TABLE tb_cliente_transportadora OWNER TO "ADMIN";

--
-- Name: TABLE tb_cliente_transportadora; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_cliente_transportadora IS 'Armazenar relacionamento entre transportadora preferencial do cliente';


--
-- Name: tb_cnae_servico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cnae_servico (
    pk_cnae_servico bigint NOT NULL,
    codigo_cnae character varying(25),
    descricao_atividade character varying(200)
);


ALTER TABLE tb_cnae_servico OWNER TO "ADMIN";

--
-- Name: tb_cnae_servico_pk_cnae_servico_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_cnae_servico_pk_cnae_servico_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_cnae_servico_pk_cnae_servico_seq OWNER TO "ADMIN";

--
-- Name: tb_cnae_servico_pk_cnae_servico_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_cnae_servico_pk_cnae_servico_seq OWNED BY tb_cnae_servico.pk_cnae_servico;


--
-- Name: tb_cobrancaautomatica; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_cobrancaautomatica (
    fk_empresa bigint,
    fk_financeiro bigint,
    dataenvio date,
    hora character varying(10)
);


ALTER TABLE tb_cobrancaautomatica OWNER TO "ADMIN";

--
-- Name: TABLE tb_cobrancaautomatica; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_cobrancaautomatica IS 'Responsvvel por armazenar os ttulos do financeiro enviados para o cliente por cobrana automtica';


SET default_with_oids = false;

--
-- Name: tb_configuracao_balanca; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_configuracao_balanca (
    pk_configuracao_balanca bigint NOT NULL,
    descricao character varying(250),
    modelo integer,
    porta character varying(100),
    taxabps integer
);


ALTER TABLE tb_configuracao_balanca OWNER TO "ADMIN";

--
-- Name: tb_configuracao_balanca_pk_configuracao_balanca_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_configuracao_balanca_pk_configuracao_balanca_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_configuracao_balanca_pk_configuracao_balanca_seq OWNER TO "ADMIN";

--
-- Name: tb_configuracao_balanca_pk_configuracao_balanca_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_configuracao_balanca_pk_configuracao_balanca_seq OWNED BY tb_configuracao_balanca.pk_configuracao_balanca;


--
-- Name: tb_configuracao_boleto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_configuracao_boleto (
    pk_configuracao_boleto bigint NOT NULL,
    fk_beneficiario_boleto bigint NOT NULL,
    fk_configuracao_smtp bigint,
    descricao character varying(255) NOT NULL,
    proximo_nosso_numero bigint NOT NULL,
    inicio_nosso_numero bigint NOT NULL,
    fim_nosso_numero bigint NOT NULL,
    sequencia_arquivo_remessa bigint NOT NULL,
    carteira integer NOT NULL,
    especie character varying(5) NOT NULL,
    aceite character varying(1) NOT NULL,
    leiaute_remessa character varying(100) NOT NULL,
    leiaute_retorno character varying(100) NOT NULL,
    diretorio_arquivo_remessa character varying(255) NOT NULL,
    diretorio_arquivo_retorno character varying(255) NOT NULL,
    diretorio_arquivo_boleto character varying(255) NOT NULL,
    local_pagamento character varying(255) NOT NULL,
    variacao_carteira character varying(20),
    comprovante_entrega_venda boolean DEFAULT false NOT NULL,
    comprovante_entrega_comum boolean DEFAULT false NOT NULL,
    recibo_pagador_venda boolean DEFAULT false NOT NULL,
    recibo_pagador_comum boolean DEFAULT false NOT NULL,
    formato_carne_venda boolean DEFAULT false NOT NULL,
    formato_carne_comum boolean DEFAULT false NOT NULL,
    protestar_dias_uteis_venda boolean DEFAULT true NOT NULL,
    protestar_dias_uteis_comum boolean DEFAULT true NOT NULL,
    codigo_protesto integer DEFAULT 1 NOT NULL,
    dias_devolucao smallint DEFAULT 0 NOT NULL,
    dias_negativar smallint DEFAULT 0 NOT NULL
);


ALTER TABLE tb_configuracao_boleto OWNER TO "ADMIN";

--
-- Name: COLUMN tb_configuracao_boleto.protestar_dias_uteis_venda; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_boleto.protestar_dias_uteis_venda IS 'Verdadeiro indica dias teis, Falso indica dias corridos.';


--
-- Name: COLUMN tb_configuracao_boleto.protestar_dias_uteis_comum; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_boleto.protestar_dias_uteis_comum IS 'Verdadeiro indica dias teis, Falso indica dias corridos.';


--
-- Name: tb_configuracao_boleto_pk_configuracao_boleto_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_configuracao_boleto_pk_configuracao_boleto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_configuracao_boleto_pk_configuracao_boleto_seq OWNER TO "ADMIN";

--
-- Name: tb_configuracao_boleto_pk_configuracao_boleto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_configuracao_boleto_pk_configuracao_boleto_seq OWNED BY tb_configuracao_boleto.pk_configuracao_boleto;


--
-- Name: tb_configuracao_documento_fiscal_eletronico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_configuracao_documento_fiscal_eletronico (
    pk_codigo bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    codigo_uf smallint NOT NULL,
    chave_parceiro character varying(250),
    chave_comunicacao character varying(250),
    fuso_horario character varying(6),
    imprimir_nome_fantasia_emitente boolean DEFAULT false,
    resp_tecnico_cnpj character varying(14),
    resp_tecnico_contato character varying(60),
    resp_tecnico_email character varying(60),
    resp_tecnico_telefone character varying(14)
);


ALTER TABLE tb_configuracao_documento_fiscal_eletronico OWNER TO "ADMIN";

--
-- Name: COLUMN tb_configuracao_documento_fiscal_eletronico.codigo_uf; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_documento_fiscal_eletronico.codigo_uf IS 'Codigo do estado no IBGE';


--
-- Name: COLUMN tb_configuracao_documento_fiscal_eletronico.chave_parceiro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_documento_fiscal_eletronico.chave_parceiro IS 'Chave do parceiro na plataforma Invoicy';


--
-- Name: COLUMN tb_configuracao_documento_fiscal_eletronico.chave_comunicacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_documento_fiscal_eletronico.chave_comunicacao IS 'Chave de comunicao/cliente cadastrado na plataforma Invoicy';


--
-- Name: tb_configuracao_documento_fiscal_eletronico_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_configuracao_documento_fiscal_eletronico_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_configuracao_documento_fiscal_eletronico_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: tb_configuracao_documento_fiscal_eletronico_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_configuracao_documento_fiscal_eletronico_pk_codigo_seq OWNED BY tb_configuracao_documento_fiscal_eletronico.pk_codigo;


--
-- Name: tb_configuracao_impressao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_configuracao_impressao (
    pk_configuracao_impressao bigint NOT NULL,
    impressora text,
    margem_esquerda double precision,
    margem_direita double precision,
    largura_papel double precision,
    tamanho_fonte_itens double precision,
    formatar_fracionados boolean,
    utilizar_formato_fracionado_padrao boolean
);


ALTER TABLE tb_configuracao_impressao OWNER TO "ADMIN";

--
-- Name: tb_configuracao_impressao_pk_configuracao_impressao_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_configuracao_impressao_pk_configuracao_impressao_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_configuracao_impressao_pk_configuracao_impressao_seq OWNER TO "ADMIN";

--
-- Name: tb_configuracao_impressao_pk_configuracao_impressao_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_configuracao_impressao_pk_configuracao_impressao_seq OWNED BY tb_configuracao_impressao.pk_configuracao_impressao;


SET default_with_oids = true;

--
-- Name: tb_configuracao_mdfe; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_configuracao_mdfe (
    fk_configuracao_documento_fiscal_eletronico bigint NOT NULL,
    numero bigint NOT NULL,
    modelo character varying(2),
    serie smallint NOT NULL,
    ambiente smallint DEFAULT 2 NOT NULL,
    versao character varying(20),
    tipo_emitente smallint DEFAULT 2 NOT NULL,
    tipo_emissao smallint DEFAULT 1 NOT NULL,
    rntrc smallint DEFAULT 0
);


ALTER TABLE tb_configuracao_mdfe OWNER TO "ADMIN";

--
-- Name: COLUMN tb_configuracao_mdfe.ambiente; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_mdfe.ambiente IS '1 - Produo 2 - Homologao';


--
-- Name: COLUMN tb_configuracao_mdfe.tipo_emitente; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_mdfe.tipo_emitente IS '1 Prestador de servio de transporte, 2 - Transportador de Carga Prpria';


--
-- Name: COLUMN tb_configuracao_mdfe.tipo_emissao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_mdfe.tipo_emissao IS '1 - Normal, 2 - Contingncia';


SET default_with_oids = false;

--
-- Name: tb_configuracao_nfce; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_configuracao_nfce (
    fk_configuracao_documento_fiscal_eletronico bigint NOT NULL,
    numero bigint NOT NULL,
    modelo character varying(2),
    serie smallint NOT NULL,
    ambiente smallint DEFAULT 2 NOT NULL,
    versao character varying(20),
    id_token character varying(10),
    csc character varying(255),
    contingencia_offline boolean DEFAULT false,
    data_hora_ativacao_contingencia timestamp without time zone,
    justificativa_contingencia character varying(250),
    impressao_resumida boolean DEFAULT false
);


ALTER TABLE tb_configuracao_nfce OWNER TO "ADMIN";

--
-- Name: COLUMN tb_configuracao_nfce.ambiente; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_nfce.ambiente IS '1 - Produo 2 - Homologao';


--
-- Name: tb_configuracao_nfe; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_configuracao_nfe (
    fk_configuracao_documento_fiscal_eletronico bigint NOT NULL,
    ambiente smallint DEFAULT 2 NOT NULL,
    versao character varying(20),
    plataforma_emissao smallint DEFAULT 0 NOT NULL,
    logo character varying(255),
    numero_serie_certificado character varying(255),
    tipo_certificado character varying(3),
    protocolo_seguranca character varying(3) DEFAULT 'TLS'::character varying,
    timeout bigint DEFAULT 30000,
    imprimir_valor_total_produto_liquido boolean DEFAULT false
);


ALTER TABLE tb_configuracao_nfe OWNER TO "ADMIN";

--
-- Name: COLUMN tb_configuracao_nfe.ambiente; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_nfe.ambiente IS '1 - Produo 2 - Homologao';


--
-- Name: COLUMN tb_configuracao_nfe.plataforma_emissao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_configuracao_nfe.plataforma_emissao IS '0 - Local 1 - Nuvem';


--
-- Name: tb_configuracao_nfse; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_configuracao_nfse (
    fk_configuracao_documento_fiscal_eletronico bigint NOT NULL,
    ambiente smallint DEFAULT 2 NOT NULL,
    versao character varying(20),
    aliquota_pis numeric,
    aliquota_cofins numeric,
    aliquota_inss numeric,
    aliquota_ir numeric,
    aliquota_csll numeric,
    aliquota_iss numeric,
    serie character varying(50),
    url_retorno_municipio text,
    timeout bigint DEFAULT 6000
);


ALTER TABLE tb_configuracao_nfse OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: tb_configuracao_proxy; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_configuracao_proxy (
    fk_configuracao_documento_fiscal_eletronico bigint NOT NULL,
    host character varying(250),
    porta character varying(10),
    usuario character varying(100),
    senha character varying(50)
);


ALTER TABLE tb_configuracao_proxy OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: tb_conta_corrente; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_conta_corrente (
    pk_conta_corrente bigint NOT NULL,
    fk_banco bigint NOT NULL,
    descricao character varying(255) NOT NULL,
    numero_agencia character varying(50) NOT NULL,
    dv_agencia character varying(10) NOT NULL,
    nome_agencia character varying(255) NOT NULL,
    conta_corrente character varying(50) NOT NULL,
    dv_conta_corrente character varying(10) NOT NULL
);


ALTER TABLE tb_conta_corrente OWNER TO "ADMIN";

--
-- Name: tb_conta_corrente_pk_conta_corrente_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_conta_corrente_pk_conta_corrente_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_conta_corrente_pk_conta_corrente_seq OWNER TO "ADMIN";

--
-- Name: tb_conta_corrente_pk_conta_corrente_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_conta_corrente_pk_conta_corrente_seq OWNED BY tb_conta_corrente.pk_conta_corrente;


--
-- Name: tb_contagem_balanco; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_contagem_balanco (
    pk_contagem_balanco integer NOT NULL,
    fk_usuario bigint,
    descricao character varying(50),
    data_contagem date,
    status character(1),
    pk_empresa bigint NOT NULL,
    fk_balanco bigint,
    contagem bigint DEFAULT 0 NOT NULL
);


ALTER TABLE tb_contagem_balanco OWNER TO "ADMIN";

--
-- Name: tb_contagem_balanco_pk_contagem_balanco_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_contagem_balanco_pk_contagem_balanco_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_contagem_balanco_pk_contagem_balanco_seq OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: tb_credenciadora; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_credenciadora (
    pk_codigo bigint NOT NULL,
    razao_social character varying(200),
    cnpj character varying(14),
    fk_empresa bigint
);


ALTER TABLE tb_credenciadora OWNER TO "ADMIN";

--
-- Name: tb_credenciadora_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_credenciadora_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_credenciadora_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: tb_credenciadora_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_credenciadora_pk_codigo_seq OWNED BY tb_credenciadora.pk_codigo;


--
-- Name: tb_csrt_sefaz; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_csrt_sefaz (
    pk_csrt_sefaz bigint NOT NULL,
    codigo_uf smallint NOT NULL,
    id_csrt smallint NOT NULL,
    csrt_sefaz text NOT NULL
);


ALTER TABLE tb_csrt_sefaz OWNER TO "ADMIN";

--
-- Name: tb_csrt_sefaz_pk_csrt_sefaz_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_csrt_sefaz_pk_csrt_sefaz_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_csrt_sefaz_pk_csrt_sefaz_seq OWNER TO "ADMIN";

--
-- Name: tb_csrt_sefaz_pk_csrt_sefaz_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_csrt_sefaz_pk_csrt_sefaz_seq OWNED BY tb_csrt_sefaz.pk_csrt_sefaz;


--
-- Name: tb_dados_importacao_mobilidad_pk_dados_importacao_mobilidad_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_dados_importacao_mobilidad_pk_dados_importacao_mobilidad_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_dados_importacao_mobilidad_pk_dados_importacao_mobilidad_seq OWNER TO "ADMIN";

--
-- Name: tb_dados_importacao_mobilidade; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_dados_importacao_mobilidade (
    pk_dados_importacao_mobilidade bigint DEFAULT nextval('tb_dados_importacao_mobilidad_pk_dados_importacao_mobilidad_seq'::regclass) NOT NULL,
    data_hora_importacao timestamp without time zone,
    fk_usuario bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    ultima_importacao boolean NOT NULL
);


ALTER TABLE tb_dados_importacao_mobilidade OWNER TO "ADMIN";

--
-- Name: COLUMN tb_dados_importacao_mobilidade.pk_dados_importacao_mobilidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_dados_importacao_mobilidade.pk_dados_importacao_mobilidade IS 'Identificador do registro de dados da importao.';


--
-- Name: COLUMN tb_dados_importacao_mobilidade.data_hora_importacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_dados_importacao_mobilidade.data_hora_importacao IS 'Momento em que foi concluda a importao.';


--
-- Name: COLUMN tb_dados_importacao_mobilidade.fk_usuario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_dados_importacao_mobilidade.fk_usuario IS 'usrio que executou o processo de atualizao.';


--
-- Name: COLUMN tb_dados_importacao_mobilidade.fk_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_dados_importacao_mobilidade.fk_empresa IS 'Referencia a emrpesa para qual foi feita a importacao.';


--
-- Name: COLUMN tb_dados_importacao_mobilidade.ultima_importacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_dados_importacao_mobilidade.ultima_importacao IS 'Identifica que  a ltima importao.';


--
-- Name: tb_dados_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_dados_produto (
    fk_empresa bigint NOT NULL,
    fk_produto character varying(20) NOT NULL,
    custo_financeiro numeric(15,6),
    fk_marckup bigint,
    curva_abc character varying(15),
    giro_periodo numeric(15,4),
    ponto_pedido numeric(15,4),
    margem_de_contribuicao numeric(15,4),
    preco_sugerido numeric(15,4),
    qtde_sugestao_compras numeric(15,6),
    cobertura_estoque numeric(15,6),
    venda_periodo numeric(15,4) DEFAULT 0,
    estoque_maximo_sugerido numeric(15,4) DEFAULT 0 NOT NULL,
    estoque_minimo_sugerido numeric(15,4) DEFAULT 0 NOT NULL,
    tempo_reposicao bigint DEFAULT 0 NOT NULL
);


ALTER TABLE tb_dados_produto OWNER TO "ADMIN";

--
-- Name: TABLE tb_dados_produto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_dados_produto IS 'armazena informaes extras do produto';


--
-- Name: tb_data_atualizacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_data_atualizacao (
    tipo_atualizacao bigint,
    data date,
    fk_empresa bigint
);


ALTER TABLE tb_data_atualizacao OWNER TO "ADMIN";

--
-- Name: TABLE tb_data_atualizacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_data_atualizacao IS 'Responsvel por armazenar as datas que j foram executados processamentos no sistema como por ex.: backup,  atualizao da movimentacao total do produtos, envio de boleto automatico dentre outros.os tipos so: 1 - data de verificaao de licena no banco da sabre 2 - data de verificao do reprocessamento estoque transito  3 - data do backup  4 - data da atualizaao da movimentao total  5 - data envio cobrana automatico';


--
-- Name: tb_definicao_movimento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_definicao_movimento (
    pk_definicao_movimento bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_item_entrada bigint,
    fk_item_saida bigint,
    fk_item_devolvida bigint,
    fk_item_cancelada bigint,
    fk_item_orcamento bigint,
    utilizou_desconto_progressivo character varying(1)
);


ALTER TABLE tb_definicao_movimento OWNER TO "ADMIN";

--
-- Name: tb_definicao_movimento_pk_definicao_movimento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_definicao_movimento_pk_definicao_movimento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_definicao_movimento_pk_definicao_movimento_seq OWNER TO "ADMIN";

--
-- Name: tb_definicao_movimento_pk_definicao_movimento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_definicao_movimento_pk_definicao_movimento_seq OWNED BY tb_definicao_movimento.pk_definicao_movimento;


--
-- Name: tb_desconto_progressivo_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_desconto_progressivo_produto (
    pk_desconto_progressivo_produto bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_produto character varying(20) NOT NULL,
    fk_unidade bigint NOT NULL,
    unidade_secundaria boolean,
    fator_conversao numeric(15,6),
    quantidade numeric(18,7) NOT NULL,
    percentual_desconto double precision NOT NULL,
    percentual_apresentacao double precision NOT NULL
);


ALTER TABLE tb_desconto_progressivo_produto OWNER TO "ADMIN";

--
-- Name: tb_desconto_progressivo_produ_pk_desconto_progressivo_produ_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_desconto_progressivo_produ_pk_desconto_progressivo_produ_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_desconto_progressivo_produ_pk_desconto_progressivo_produ_seq OWNER TO "ADMIN";

--
-- Name: tb_desconto_progressivo_produ_pk_desconto_progressivo_produ_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_desconto_progressivo_produ_pk_desconto_progressivo_produ_seq OWNED BY tb_desconto_progressivo_produto.pk_desconto_progressivo_produto;


--
-- Name: tb_desconto_progressivo_valor; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_desconto_progressivo_valor (
    pk_desconto_progressivo_valor bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    valor numeric(15,4) NOT NULL,
    percentual_desconto double precision NOT NULL,
    percentual_apresentacao double precision NOT NULL
);


ALTER TABLE tb_desconto_progressivo_valor OWNER TO "ADMIN";

--
-- Name: tb_desconto_progressivo_valor_pk_desconto_progressivo_valor_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_desconto_progressivo_valor_pk_desconto_progressivo_valor_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_desconto_progressivo_valor_pk_desconto_progressivo_valor_seq OWNER TO "ADMIN";

--
-- Name: tb_desconto_progressivo_valor_pk_desconto_progressivo_valor_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_desconto_progressivo_valor_pk_desconto_progressivo_valor_seq OWNED BY tb_desconto_progressivo_valor.pk_desconto_progressivo_valor;


SET default_with_oids = false;

--
-- Name: tb_documento_fiscal; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_documento_fiscal (
    pk_documentofiscal bigint NOT NULL,
    indicador_documento_fiscal smallint NOT NULL,
    fk_fornecedor bigint NOT NULL,
    modelo_fiscal numeric(15,4) NOT NULL,
    serie character varying(20),
    numero_documento bigint NOT NULL,
    chave_documento_fiscal character varying(120),
    data_emissao timestamp without time zone NOT NULL,
    numero_item bigint
);


ALTER TABLE tb_documento_fiscal OWNER TO "ADMIN";

--
-- Name: tb_documento_fiscal_pk_documentofiscal_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_documento_fiscal_pk_documentofiscal_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_documento_fiscal_pk_documentofiscal_seq OWNER TO "ADMIN";

--
-- Name: tb_documento_fiscal_pk_documentofiscal_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_documento_fiscal_pk_documentofiscal_seq OWNED BY tb_documento_fiscal.pk_documentofiscal;


SET default_with_oids = true;

--
-- Name: tb_documento_fiscal_referenciado; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_documento_fiscal_referenciado (
    pk_documentofiscal_referenciado bigint NOT NULL,
    fk_seqsaida bigint,
    fk_fornecedor bigint NOT NULL,
    numero_documento bigint NOT NULL,
    modelo_documento character varying(3) NOT NULL,
    serie character varying(3) NOT NULL,
    data_emissao date,
    chave_documento_fiscal character varying(50)
);


ALTER TABLE tb_documento_fiscal_referenciado OWNER TO "ADMIN";

--
-- Name: tb_documento_fiscal_referenci_pk_documentofiscal_referencia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_documento_fiscal_referenci_pk_documentofiscal_referencia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_documento_fiscal_referenci_pk_documentofiscal_referencia_seq OWNER TO "ADMIN";

--
-- Name: tb_documento_fiscal_referenci_pk_documentofiscal_referencia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_documento_fiscal_referenci_pk_documentofiscal_referencia_seq OWNED BY tb_documento_fiscal_referenciado.pk_documentofiscal_referenciado;


--
-- Name: tb_email; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_email (
    pk_email bigint NOT NULL,
    email character varying(100),
    descricao text,
    recebe_documentos bit(1),
    tipo_email smallint
);


ALTER TABLE tb_email OWNER TO "ADMIN";

--
-- Name: tb_email_cliente; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_email_cliente (
    fk_cliente bigint NOT NULL,
    fk_email bigint NOT NULL
);


ALTER TABLE tb_email_cliente OWNER TO "ADMIN";

--
-- Name: tb_email_fornecedor; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_email_fornecedor (
    fk_email bigint NOT NULL,
    fk_fornecedor bigint NOT NULL
);


ALTER TABLE tb_email_fornecedor OWNER TO "ADMIN";

--
-- Name: tb_email_pk_email_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_email_pk_email_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_email_pk_email_seq OWNER TO "ADMIN";

--
-- Name: tb_email_pk_email_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_email_pk_email_seq OWNED BY tb_email.pk_email;


SET default_with_oids = false;

--
-- Name: tb_endereco; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_endereco (
    pk_endereco bigint NOT NULL,
    cep character varying(15),
    logradouro character varying(255),
    numero character varying(100),
    bairro character varying(255),
    fk_cidade bigint,
    complemento character varying(255)
);


ALTER TABLE tb_endereco OWNER TO "ADMIN";

--
-- Name: tb_endereco_estoque; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_endereco_estoque (
    pk_endereco_estoque bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    descricao character varying(250) NOT NULL,
    permitir_saida boolean NOT NULL,
    permitir_entrada boolean NOT NULL,
    permitir_outras boolean NOT NULL
);


ALTER TABLE tb_endereco_estoque OWNER TO "ADMIN";

--
-- Name: tb_endereco_estoque_pk_endereco_estoque_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_endereco_estoque_pk_endereco_estoque_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_endereco_estoque_pk_endereco_estoque_seq OWNER TO "ADMIN";

--
-- Name: tb_endereco_estoque_pk_endereco_estoque_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_endereco_estoque_pk_endereco_estoque_seq OWNED BY tb_endereco_estoque.pk_endereco_estoque;


--
-- Name: tb_endereco_estoque_saldo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_endereco_estoque_saldo (
    pk_endereco_estoque_saldo bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_endereco_estoque bigint NOT NULL,
    fk_produto character varying(20) NOT NULL,
    quantidade double precision NOT NULL
);


ALTER TABLE tb_endereco_estoque_saldo OWNER TO "ADMIN";

--
-- Name: tb_endereco_estoque_saldo_pk_endereco_estoque_saldo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_endereco_estoque_saldo_pk_endereco_estoque_saldo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_endereco_estoque_saldo_pk_endereco_estoque_saldo_seq OWNER TO "ADMIN";

--
-- Name: tb_endereco_estoque_saldo_pk_endereco_estoque_saldo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_endereco_estoque_saldo_pk_endereco_estoque_saldo_seq OWNED BY tb_endereco_estoque_saldo.pk_endereco_estoque_saldo;


SET default_with_oids = true;

--
-- Name: tb_endereco_estoque_vendedor_mbl; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_endereco_estoque_vendedor_mbl (
    fk_endereco_estoque bigint NOT NULL,
    fk_vendedor bigint NOT NULL
);


ALTER TABLE tb_endereco_estoque_vendedor_mbl OWNER TO "ADMIN";

--
-- Name: tb_endereco_pk_endereco_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_endereco_pk_endereco_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_endereco_pk_endereco_seq OWNER TO "ADMIN";

--
-- Name: tb_endereco_pk_endereco_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_endereco_pk_endereco_seq OWNED BY tb_endereco.pk_endereco;


SET default_with_oids = false;

--
-- Name: tb_esquema_centro_custo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_esquema_centro_custo (
    pk_esquema_centro_custo bigint NOT NULL,
    fk_conta_contabil character varying(15) NOT NULL,
    fk_centro_custo bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    proporcao double precision NOT NULL
);


ALTER TABLE tb_esquema_centro_custo OWNER TO "ADMIN";

--
-- Name: tb_esquema_centro_custo_pk_esquema_centro_custo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_esquema_centro_custo_pk_esquema_centro_custo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_esquema_centro_custo_pk_esquema_centro_custo_seq OWNER TO "ADMIN";

--
-- Name: tb_esquema_centro_custo_pk_esquema_centro_custo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_esquema_centro_custo_pk_esquema_centro_custo_seq OWNED BY tb_esquema_centro_custo.pk_esquema_centro_custo;


--
-- Name: tb_estrutura_resultados; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_estrutura_resultados (
    pk_estrutura_resultados bigint NOT NULL,
    descricao character varying(255) NOT NULL
);


ALTER TABLE tb_estrutura_resultados OWNER TO "ADMIN";

--
-- Name: tb_estrutura_resultados_pk_estrutura_resultados_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_estrutura_resultados_pk_estrutura_resultados_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_estrutura_resultados_pk_estrutura_resultados_seq OWNER TO "ADMIN";

--
-- Name: tb_estrutura_resultados_pk_estrutura_resultados_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_estrutura_resultados_pk_estrutura_resultados_seq OWNED BY tb_estrutura_resultados.pk_estrutura_resultados;


--
-- Name: tb_fechamento_contabil; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_fechamento_contabil (
    pk_fechamento_contabil bigint NOT NULL,
    empresa bigint NOT NULL,
    data_inicial date NOT NULL,
    data_final date NOT NULL,
    data_fechamento date NOT NULL,
    fechado boolean NOT NULL,
    substituido boolean DEFAULT false NOT NULL,
    fk_usuario bigint NOT NULL,
    observacoes character varying(250)
);


ALTER TABLE tb_fechamento_contabil OWNER TO "ADMIN";

--
-- Name: tb_fechamento_contabil_item; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_fechamento_contabil_item (
    pk_fechamento_contabil_item bigint NOT NULL,
    fk_fechamento_contabil bigint NOT NULL,
    fk_conta_contabil character varying(15),
    credito double precision NOT NULL,
    debito double precision NOT NULL,
    saldo_final double precision NOT NULL
);


ALTER TABLE tb_fechamento_contabil_item OWNER TO "ADMIN";

--
-- Name: tb_fechamento_contabil_item_pk_fechamento_contabil_item_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_fechamento_contabil_item_pk_fechamento_contabil_item_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_fechamento_contabil_item_pk_fechamento_contabil_item_seq OWNER TO "ADMIN";

--
-- Name: tb_fechamento_contabil_item_pk_fechamento_contabil_item_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_fechamento_contabil_item_pk_fechamento_contabil_item_seq OWNED BY tb_fechamento_contabil_item.pk_fechamento_contabil_item;


--
-- Name: tb_fechamento_contabil_pk_fechamento_contabil_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_fechamento_contabil_pk_fechamento_contabil_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_fechamento_contabil_pk_fechamento_contabil_seq OWNER TO "ADMIN";

--
-- Name: tb_fechamento_contabil_pk_fechamento_contabil_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_fechamento_contabil_pk_fechamento_contabil_seq OWNED BY tb_fechamento_contabil.pk_fechamento_contabil;


SET default_with_oids = true;

--
-- Name: tb_financeiro_pontolocacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_financeiro_pontolocacao (
    fk_financeiro bigint NOT NULL,
    fk_pontolocacao bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    tipo_movimento smallint DEFAULT 0,
    codigo_controle character varying(20) DEFAULT '0'::character varying NOT NULL
);


ALTER TABLE tb_financeiro_pontolocacao OWNER TO "ADMIN";

--
-- Name: COLUMN tb_financeiro_pontolocacao.tipo_movimento; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_financeiro_pontolocacao.tipo_movimento IS 'Tipos de movimento: 0 - Normal, 1 - Negociao, 2 - Renegociao, 3 - Baixa com ttulo, 4 - Liquidao';


--
-- Name: tb_financeiro_unificados; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_financeiro_unificados (
    fk_empresa bigint,
    fk_receber_exclusao bigint,
    fk_receber bigint
);


ALTER TABLE tb_financeiro_unificados OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: tb_fiscal_movimento_caixa; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_fiscal_movimento_caixa (
    pk_fiscal_movimento_caixa bigint NOT NULL,
    fk_empresa bigint,
    fk_movimento_caixa bigint,
    fk_venda bigint,
    fk_entrada bigint
);


ALTER TABLE tb_fiscal_movimento_caixa OWNER TO "ADMIN";

--
-- Name: tb_fiscal_movimento_caixa_pk_fiscal_movimento_caixa_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_fiscal_movimento_caixa_pk_fiscal_movimento_caixa_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_fiscal_movimento_caixa_pk_fiscal_movimento_caixa_seq OWNER TO "ADMIN";

--
-- Name: tb_fiscal_movimento_caixa_pk_fiscal_movimento_caixa_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_fiscal_movimento_caixa_pk_fiscal_movimento_caixa_seq OWNED BY tb_fiscal_movimento_caixa.pk_fiscal_movimento_caixa;


--
-- Name: tb_forma_faturamento_conta; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_forma_faturamento_conta (
    pk_forma_faturamento_conta bigint NOT NULL,
    fk_conta character varying(15) NOT NULL,
    fk_forma_faturamento integer NOT NULL,
    empresa bigint NOT NULL,
    tipo_conta character varying(20) NOT NULL
);


ALTER TABLE tb_forma_faturamento_conta OWNER TO "ADMIN";

--
-- Name: tb_forma_faturamento_conta_pk_forma_faturamento_conta_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_forma_faturamento_conta_pk_forma_faturamento_conta_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_forma_faturamento_conta_pk_forma_faturamento_conta_seq OWNER TO "ADMIN";

--
-- Name: tb_forma_faturamento_conta_pk_forma_faturamento_conta_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_forma_faturamento_conta_pk_forma_faturamento_conta_seq OWNED BY tb_forma_faturamento_conta.pk_forma_faturamento_conta;


--
-- Name: tb_funrural_entrada; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_funrural_entrada (
    pk_funrural_entrada bigint NOT NULL,
    fk_entrada bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    aliquota double precision,
    base_calculo double precision,
    valor double precision
);


ALTER TABLE tb_funrural_entrada OWNER TO "ADMIN";

--
-- Name: tb_funrural_entrada_pk_funrural_entrada_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_funrural_entrada_pk_funrural_entrada_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_funrural_entrada_pk_funrural_entrada_seq OWNER TO "ADMIN";

--
-- Name: tb_funrural_entrada_pk_funrural_entrada_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_funrural_entrada_pk_funrural_entrada_seq OWNED BY tb_funrural_entrada.pk_funrural_entrada;


--
-- Name: tb_gerenciador_tef; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_gerenciador_tef (
    pk_gerenciadortef bigint NOT NULL,
    descricao character varying(250) NOT NULL,
    endereco_pasta_principal character varying(500) NOT NULL,
    nome_executavel_gerenciador character varying(500) NOT NULL,
    cnpj character varying(24)
);


ALTER TABLE tb_gerenciador_tef OWNER TO "ADMIN";

--
-- Name: tb_gerenciador_tef_pk_gerenciadortef_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_gerenciador_tef_pk_gerenciadortef_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_gerenciador_tef_pk_gerenciadortef_seq OWNER TO "ADMIN";

--
-- Name: tb_gerenciador_tef_pk_gerenciadortef_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_gerenciador_tef_pk_gerenciadortef_seq OWNED BY tb_gerenciador_tef.pk_gerenciadortef;


--
-- Name: tb_grupo_apresentacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_grupo_apresentacao (
    pk_grupo_apresentacao bigint NOT NULL,
    nome_grupo_apresentacao character varying(100) NOT NULL,
    fk_unidade bigint NOT NULL
);


ALTER TABLE tb_grupo_apresentacao OWNER TO "ADMIN";

--
-- Name: tb_grupo_apresentacao_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_grupo_apresentacao_produto (
    pk_grupo_apresentacao_produto bigint NOT NULL,
    fk_grupo_apresentacao bigint NOT NULL,
    fk_produto character varying(20) NOT NULL
);


ALTER TABLE tb_grupo_apresentacao_produto OWNER TO "ADMIN";

--
-- Name: tb_grupo_apresentacao_unidade; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_grupo_apresentacao_unidade (
    pk_grupo_apresentacao_unidade bigint NOT NULL,
    fk_grupo_apresentacao_produto bigint NOT NULL,
    fk_unidade bigint NOT NULL,
    fator_conversao double precision DEFAULT 1 NOT NULL
);


ALTER TABLE tb_grupo_apresentacao_unidade OWNER TO "ADMIN";

--
-- Name: tb_grupo_apresentacao_unidades_referencia; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_grupo_apresentacao_unidades_referencia (
    pk_grupo_apresentacao_unidade_referencia bigint NOT NULL,
    fk_grupo_apresentacao bigint NOT NULL,
    fk_unidade bigint NOT NULL
);


ALTER TABLE tb_grupo_apresentacao_unidades_referencia OWNER TO "ADMIN";

--
-- Name: tb_grupo_personalizado; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_grupo_personalizado (
    pk_grupo_personalizado bigint NOT NULL,
    fk_grupo_personalizado_tipo bigint NOT NULL,
    nome_grupo_personalizado character varying(200) NOT NULL
);


ALTER TABLE tb_grupo_personalizado OWNER TO "ADMIN";

--
-- Name: tb_grupo_personalizado_cliente; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_grupo_personalizado_cliente (
    pk_grupo_personalizado_cliente bigint NOT NULL,
    fk_grupo_personalizado bigint NOT NULL,
    fk_cliente bigint NOT NULL
);


ALTER TABLE tb_grupo_personalizado_cliente OWNER TO "ADMIN";

--
-- Name: tb_grupo_personalizado_tipo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_grupo_personalizado_tipo (
    pk_grupo_personalizado_tipo bigint NOT NULL,
    nome_tipo_grupo_personalizado character varying(100)
);


ALTER TABLE tb_grupo_personalizado_tipo OWNER TO "ADMIN";

--
-- Name: tb_grupo_resultado_conta_contabil; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_grupo_resultado_conta_contabil (
    pk_grupo_resultados_conta_contabil bigint NOT NULL,
    fk_grupo_resultados bigint NOT NULL,
    conta_contabil character varying(15) NOT NULL,
    digito_conta character varying(1) NOT NULL,
    padrao_grupo boolean NOT NULL
);


ALTER TABLE tb_grupo_resultado_conta_contabil OWNER TO "ADMIN";

--
-- Name: tb_grupo_resultado_conta_cont_pk_grupo_resultados_conta_con_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_grupo_resultado_conta_cont_pk_grupo_resultados_conta_con_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_grupo_resultado_conta_cont_pk_grupo_resultados_conta_con_seq OWNER TO "ADMIN";

--
-- Name: tb_grupo_resultado_conta_cont_pk_grupo_resultados_conta_con_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_grupo_resultado_conta_cont_pk_grupo_resultados_conta_con_seq OWNED BY tb_grupo_resultado_conta_contabil.pk_grupo_resultados_conta_contabil;


--
-- Name: tb_grupo_resultados; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_grupo_resultados (
    pk_grupo_resultados bigint NOT NULL,
    descricao character varying(250) NOT NULL,
    descricao_totalizador character varying(250) NOT NULL,
    nivel bigint NOT NULL,
    analitico boolean NOT NULL,
    fk_grupo_pai bigint,
    fk_estrutura_resultados bigint NOT NULL
);


ALTER TABLE tb_grupo_resultados OWNER TO "ADMIN";

--
-- Name: tb_grupo_resultados_pk_grupo_resultados_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_grupo_resultados_pk_grupo_resultados_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_grupo_resultados_pk_grupo_resultados_seq OWNER TO "ADMIN";

--
-- Name: tb_grupo_resultados_pk_grupo_resultados_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_grupo_resultados_pk_grupo_resultados_seq OWNED BY tb_grupo_resultados.pk_grupo_resultados;


--
-- Name: tb_guia; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_guia (
    pk_guia bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    numero_guia bigint NOT NULL,
    data_emissao date NOT NULL,
    fk_blocoguias bigint NOT NULL,
    fk_pontolocacao bigint NOT NULL,
    valor_comissao numeric(15,4) DEFAULT 0 NOT NULL,
    valor_guia numeric(15,4) DEFAULT 0 NOT NULL,
    fk_movimentacaoguias bigint NOT NULL
);


ALTER TABLE tb_guia OWNER TO "ADMIN";

--
-- Name: TABLE tb_guia; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_guia IS 'Armazena informaes dos lanamentos das guias de seus respectivos acessores, calculando suas comisses para lana-los no financeiro';


--
-- Name: tb_guia_pk_guia_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_guia_pk_guia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_guia_pk_guia_seq OWNER TO "ADMIN";

--
-- Name: tb_guia_pk_guia_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_guia_pk_guia_seq OWNED BY tb_guia.pk_guia;


--
-- Name: tb_guias_financeiro; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_guias_financeiro (
    pk_guias_financeiro bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    fk_contasreceber bigint,
    fk_contasapagar bigint,
    fk_movimentacaoguias bigint NOT NULL
);


ALTER TABLE tb_guias_financeiro OWNER TO "ADMIN";

--
-- Name: tb_guias_financeiro_pk_guias_financeiro_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_guias_financeiro_pk_guias_financeiro_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_guias_financeiro_pk_guias_financeiro_seq OWNER TO "ADMIN";

--
-- Name: tb_guias_financeiro_pk_guias_financeiro_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_guias_financeiro_pk_guias_financeiro_seq OWNED BY tb_guias_financeiro.pk_guias_financeiro;


SET default_with_oids = true;

--
-- Name: tb_importacao_coletor; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_importacao_coletor (
    contagem_total numeric(15,4) DEFAULT 0,
    contagem_totalcx numeric(15,3) DEFAULT 0,
    fk_empresa bigint NOT NULL,
    fk_balanco bigint,
    fk_produto character varying(20)
);


ALTER TABLE tb_importacao_coletor OWNER TO "ADMIN";

--
-- Name: TABLE tb_importacao_coletor; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_importacao_coletor IS 'Armazena os itens lanados manualmente ou pelo coletor de estoque possibilitando sua manuteno antes do fechamento aps o fechamento ser lanado os dados para tb_item_balanco e esvaziando a tabela, para agilizar processamento de empresas com muitos itens. ';


--
-- Name: tb_importacao_coletor_codigo_barras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_importacao_coletor_codigo_barras (
    contagem numeric(15,4) DEFAULT 0,
    contagemcx numeric(15,4) DEFAULT 0,
    codigo_barras character varying(20),
    fk_empresa bigint,
    fk_balanco bigint,
    status character varying(1)
);


ALTER TABLE tb_importacao_coletor_codigo_barras OWNER TO "ADMIN";

--
-- Name: TABLE tb_importacao_coletor_codigo_barras; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_importacao_coletor_codigo_barras IS 'Responsvel por armazenar as informaes do coletor por cdigo de barras enquanto estiver em aberto o objetivo das duas tabelas identicas e no ganho de perfomance Sem relacionamento pois posso ter cdio de barras na importao no cadastrado. O sistema ir ficar por conta de efetuaar a checagem do relacionamento';


--
-- Name: tb_impressorafiscal_venda; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_impressorafiscal_venda (
    fk_impressorafiscal bigint,
    fk_empresa bigint,
    fk_movcabsaida bigint,
    fk_movcabcancelada bigint
);


ALTER TABLE tb_impressorafiscal_venda OWNER TO "ADMIN";

--
-- Name: TABLE tb_impressorafiscal_venda; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_impressorafiscal_venda IS 'Responsvel por fazer relacionamento entre entidade impressora_fiscal e movimento_cabecalho_nota_fiscal_saida';


SET default_with_oids = false;

--
-- Name: tb_informacoes_senha_externa; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_informacoes_senha_externa (
    codigo bigint NOT NULL,
    fk_logsenhatemp bigint,
    tipo integer,
    informacao character varying(500)
);


ALTER TABLE tb_informacoes_senha_externa OWNER TO "ADMIN";

--
-- Name: tb_informacoes_senha_externa_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_informacoes_senha_externa_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_informacoes_senha_externa_codigo_seq OWNER TO "ADMIN";

--
-- Name: tb_informacoes_senha_externa_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_informacoes_senha_externa_codigo_seq OWNED BY tb_informacoes_senha_externa.codigo;


--
-- Name: tb_integracao_dominio; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_integracao_dominio (
    pk_integracao_dominio bigint NOT NULL,
    empresa bigint NOT NULL,
    codigo_dominio bigint NOT NULL,
    codigo_filial_matriz bigint NOT NULL,
    numero_sequencial bigint NOT NULL,
    utlizar_plano_conta_contabilidade boolean NOT NULL,
    diretorio_arquivo character varying(250) NOT NULL,
    usuario_dominio character varying(250)
);


ALTER TABLE tb_integracao_dominio OWNER TO "ADMIN";

--
-- Name: tb_integracao_dominio_pk_integracao_dominio_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_integracao_dominio_pk_integracao_dominio_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_integracao_dominio_pk_integracao_dominio_seq OWNER TO "ADMIN";

--
-- Name: tb_integracao_dominio_pk_integracao_dominio_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_integracao_dominio_pk_integracao_dominio_seq OWNED BY tb_integracao_dominio.pk_integracao_dominio;


SET default_with_oids = true;

--
-- Name: tb_inventario; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_inventario (
    fk_empresa bigint NOT NULL,
    pk_inventario bigint NOT NULL,
    situacao character varying(1) NOT NULL,
    data_inventario date DEFAULT '1900-01-01'::date NOT NULL
);


ALTER TABLE tb_inventario OWNER TO "ADMIN";

--
-- Name: COLUMN tb_inventario.situacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_inventario.situacao IS 'Armazena informao o status do inventrio do respectivo mes/ano 1 - Pendente 2 - Fechado';


--
-- Name: tb_inventario_pk_inventario_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_inventario_pk_inventario_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_inventario_pk_inventario_seq OWNER TO "ADMIN";

--
-- Name: tb_inventario_pk_inventario_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_inventario_pk_inventario_seq OWNED BY tb_inventario.pk_inventario;


--
-- Name: tb_item_alteracao_inventario; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_alteracao_inventario (
    fk_empresa bigint NOT NULL,
    fk_inventario bigint NOT NULL,
    data_alteracao date NOT NULL,
    situacao character varying(1) NOT NULL,
    fk_produto character varying(20),
    pk_itemalteracaoinventario bigint NOT NULL
);


ALTER TABLE tb_item_alteracao_inventario OWNER TO "ADMIN";

--
-- Name: TABLE tb_item_alteracao_inventario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_item_alteracao_inventario IS 'Responsvel por armazenar os itens ue sofrero alterao depois que o inventrio ja foi fechado, para efetuar um novo fechamento apenas dos itens alterados.';


--
-- Name: COLUMN tb_item_alteracao_inventario.situacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_alteracao_inventario.situacao IS 'Armazena informao o status do inventrio do respectivo mes/ano 1 - Pendente 2 - Fechado';


--
-- Name: tb_item_alteracao_inventario_pk_itemalteracaoinventario_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_alteracao_inventario_pk_itemalteracaoinventario_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_alteracao_inventario_pk_itemalteracaoinventario_seq OWNER TO "ADMIN";

--
-- Name: tb_item_alteracao_inventario_pk_itemalteracaoinventario_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_item_alteracao_inventario_pk_itemalteracaoinventario_seq OWNED BY tb_item_alteracao_inventario.pk_itemalteracaoinventario;


--
-- Name: tb_item_balanco; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_balanco (
    contagem_total numeric(15,4) DEFAULT 0,
    pk_itembalanco bigint NOT NULL,
    fk_empresa bigint DEFAULT 1 NOT NULL,
    fk_balanco bigint,
    estoque_do_dia numeric(15,4),
    fk_produto character varying(20),
    diferenca_estoque numeric(15,4) DEFAULT 0 NOT NULL,
    contidonobalanco boolean DEFAULT false NOT NULL
);


ALTER TABLE tb_item_balanco OWNER TO "ADMIN";

--
-- Name: TABLE tb_item_balanco; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_item_balanco IS 'Responsvel por armazenar os itens depois do balano fechado ';


--
-- Name: COLUMN tb_item_balanco.estoque_do_dia; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_balanco.estoque_do_dia IS 'armazena o estoque do dia do fechamento do balanco';


--
-- Name: tb_item_balanco_codigobarras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_balanco_codigobarras (
    contagem numeric(15,4) DEFAULT 0,
    fk_codigobarras character varying(100),
    fk_empresa bigint DEFAULT 1,
    fk_balanco bigint
);


ALTER TABLE tb_item_balanco_codigobarras OWNER TO "ADMIN";

--
-- Name: TABLE tb_item_balanco_codigobarras; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_item_balanco_codigobarras IS 'Aramazena informaes do balanco por cdigo de barras depois de fechado';


--
-- Name: tb_item_balanco_pk_itembalanco_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_balanco_pk_itembalanco_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_balanco_pk_itembalanco_seq OWNER TO "ADMIN";

--
-- Name: tb_item_balanco_pk_itembalanco_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_item_balanco_pk_itembalanco_seq OWNED BY tb_item_balanco.pk_itembalanco;


--
-- Name: tb_item_contagem_balanco; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_contagem_balanco (
    fk_contagembalanco integer,
    fk_itembalanco bigint,
    fk_empresa bigint NOT NULL,
    qtde_contagem_total numeric(15,4),
    selecionado boolean DEFAULT false NOT NULL,
    pk_itemcontagembalanco bigint NOT NULL
);


ALTER TABLE tb_item_contagem_balanco OWNER TO "ADMIN";

--
-- Name: tb_item_contagem_balanco_pk_itemcontagembalanco_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_contagem_balanco_pk_itemcontagembalanco_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_contagem_balanco_pk_itemcontagembalanco_seq OWNER TO "ADMIN";

--
-- Name: tb_item_contagem_balanco_pk_itemcontagembalanco_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_item_contagem_balanco_pk_itemcontagembalanco_seq OWNED BY tb_item_contagem_balanco.pk_itemcontagembalanco;


--
-- Name: tb_item_contagem_codigobarras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_contagem_codigobarras (
    qtde_contagem numeric(15,4) DEFAULT 0,
    fk_codigobarras character varying(100),
    fk_empresa bigint DEFAULT 1,
    fk_contagembalanco bigint,
    pk_itemcontagemcodigobarra bigint DEFAULT 0 NOT NULL,
    fk_itembalanco bigint
);


ALTER TABLE tb_item_contagem_codigobarras OWNER TO "ADMIN";

--
-- Name: TABLE tb_item_contagem_codigobarras; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_item_contagem_codigobarras IS 'Aramazena informaes do balanco por cdigo de barras depois de fechado';


--
-- Name: tb_item_contagem_codigobarras_pk_itemcontagemcodigobarra_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_contagem_codigobarras_pk_itemcontagemcodigobarra_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_contagem_codigobarras_pk_itemcontagemcodigobarra_seq OWNER TO "ADMIN";

--
-- Name: tb_item_inventario; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_inventario (
    fk_empresa bigint,
    fk_produto character varying(20),
    quantidade numeric(15,4),
    preco_de_custo_anterior numeric(15,4),
    preco_custo_medio numeric(15,4),
    preco_de_custo numeric(15,4),
    preco_de_custo_medio_anterior numeric(15,4),
    producao numeric(15,4) DEFAULT 0,
    preco_compra numeric(15,4) DEFAULT 0 NOT NULL,
    fk_inventario bigint DEFAULT 0 NOT NULL,
    alterado numeric(2,0) DEFAULT 0
);


ALTER TABLE tb_item_inventario OWNER TO "ADMIN";

--
-- Name: TABLE tb_item_inventario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_item_inventario IS 'Armazena os produtos do inventrio com suas respectivas quantidades';


--
-- Name: COLUMN tb_item_inventario.preco_compra; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_inventario.preco_compra IS 'Armazenar informaes do ltimo preo de compra no fechamento do inventario ';


--
-- Name: tb_item_movimentacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_movimentacao (
    pk_item_movimentacao bigint NOT NULL,
    quantidade numeric(15,4) NOT NULL,
    ordem smallint NOT NULL,
    valor_bruto numeric(15,7) NOT NULL,
    valor_desconto numeric(15,4) NOT NULL,
    fk_movimentacao bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_produto character varying(20) NOT NULL,
    fk_unidade bigint NOT NULL,
    fk_transporte bigint,
    cfop character varying(4),
    cst character varying(3),
    cst_pis character varying(3),
    cst_cofins character varying(3),
    cst_ipi character varying(3),
    desconto_penota numeric(15,4),
    outras_despesas numeric(15,4),
    despesas_acessorias numeric(15,4),
    valor_bonificacao numeric(15,4)
);


ALTER TABLE tb_item_movimentacao OWNER TO "ADMIN";

--
-- Name: TABLE tb_item_movimentacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_item_movimentacao IS 'Armazena informaes das movimentaes por item (venda,devolucao,entrada,cancelamento,pedido de mercadoria etc..)';


--
-- Name: COLUMN tb_item_movimentacao.pk_item_movimentacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacao.pk_item_movimentacao IS 'Chave primaria da tabela.';


--
-- Name: COLUMN tb_item_movimentacao.quantidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacao.quantidade IS 'Quantidade do produto que o item se refere.';


--
-- Name: COLUMN tb_item_movimentacao.ordem; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacao.ordem IS 'Ordem na qual esse item foi adicionado ao pedido.';


--
-- Name: COLUMN tb_item_movimentacao.valor_bruto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacao.valor_bruto IS 'Valor pelo qual o produto foi negociado para esse pedido, de maneira unitria.';


--
-- Name: COLUMN tb_item_movimentacao.valor_desconto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacao.valor_desconto IS 'Valor do desconto aplicado para o item do pedido.';


--
-- Name: COLUMN tb_item_movimentacao.fk_movimentacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacao.fk_movimentacao IS 'Referencia para o pedido ao qual o item pertence.';


--
-- Name: COLUMN tb_item_movimentacao.fk_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacao.fk_empresa IS 'referencia para  a empresa responsvel pelo pedido.';


--
-- Name: COLUMN tb_item_movimentacao.fk_produto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacao.fk_produto IS 'Referencia para o produto do item.';


--
-- Name: COLUMN tb_item_movimentacao.fk_unidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacao.fk_unidade IS 'Unidade de medida utilizada para o pedido';


SET default_with_oids = false;

--
-- Name: tb_item_movimentacao_lista_precos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_movimentacao_lista_precos (
    pk_item_mov_lista_precos bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_lista_precos bigint NOT NULL,
    fk_item_saida bigint,
    fk_item_devolvida bigint,
    fk_item_cancelada bigint,
    fk_item_orcamento bigint
);


ALTER TABLE tb_item_movimentacao_lista_precos OWNER TO "ADMIN";

--
-- Name: tb_item_movimentacao_lista_precos_pk_item_mov_lista_precos_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_movimentacao_lista_precos_pk_item_mov_lista_precos_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_movimentacao_lista_precos_pk_item_mov_lista_precos_seq OWNER TO "ADMIN";

--
-- Name: tb_item_movimentacao_lista_precos_pk_item_mov_lista_precos_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_item_movimentacao_lista_precos_pk_item_mov_lista_precos_seq OWNED BY tb_item_movimentacao_lista_precos.pk_item_mov_lista_precos;


--
-- Name: tb_item_movimentacao_pk_item_movimentacao_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_movimentacao_pk_item_movimentacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_movimentacao_pk_item_movimentacao_seq OWNER TO "ADMIN";

--
-- Name: tb_item_movimentacao_pk_item_movimentacao_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_item_movimentacao_pk_item_movimentacao_seq OWNED BY tb_item_movimentacao.pk_item_movimentacao;


SET default_with_oids = true;

--
-- Name: tb_item_movimentacaoconsumo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_movimentacaoconsumo (
    pk_item bigint NOT NULL,
    fk_movimentacaoconsumo bigint NOT NULL,
    fk_produto character varying(20) NOT NULL,
    quantidade numeric(15,4) NOT NULL
);


ALTER TABLE tb_item_movimentacaoconsumo OWNER TO "ADMIN";

--
-- Name: TABLE tb_item_movimentacaoconsumo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_item_movimentacaoconsumo IS 'Guarda os registros dos itens de movimentao de Produtos para Consumo Prprio.';


--
-- Name: COLUMN tb_item_movimentacaoconsumo.pk_item; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacaoconsumo.pk_item IS 'Chave primria da tabela';


--
-- Name: COLUMN tb_item_movimentacaoconsumo.fk_movimentacaoconsumo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacaoconsumo.fk_movimentacaoconsumo IS 'Relacionamento com a tabela tb_movimentacao_consumo';


--
-- Name: COLUMN tb_item_movimentacaoconsumo.fk_produto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacaoconsumo.fk_produto IS 'Relacionamento com a tabela produto';


--
-- Name: COLUMN tb_item_movimentacaoconsumo.quantidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_movimentacaoconsumo.quantidade IS 'Quantidade de sada do Produto para Consumo Prprio.';


--
-- Name: tb_item_movimentacaoconsumo_pk_item_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_movimentacaoconsumo_pk_item_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_movimentacaoconsumo_pk_item_seq OWNER TO "ADMIN";

--
-- Name: tb_item_movimentacaoconsumo_pk_item_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_item_movimentacaoconsumo_pk_item_seq OWNED BY tb_item_movimentacaoconsumo.pk_item;


--
-- Name: tb_item_pedidocompra; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_pedidocompra (
    fk_item_movimentacao bigint,
    fk_movimentacao bigint,
    fk_empresa bigint NOT NULL,
    situacao_item smallint DEFAULT 1,
    pk_itempedidocompra bigint NOT NULL,
    preco_compra_anterior numeric(15,6) DEFAULT 0 NOT NULL,
    custo_anterior numeric(15,6) DEFAULT 0 NOT NULL,
    quantidade_recebida numeric(15,4) NOT NULL
);


ALTER TABLE tb_item_pedidocompra OWNER TO "ADMIN";

--
-- Name: TABLE tb_item_pedidocompra; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_item_pedidocompra IS 'Responsvel por armazenar dados especficos do pedido de compra por item';


--
-- Name: COLUMN tb_item_pedidocompra.quantidade_recebida; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_item_pedidocompra.quantidade_recebida IS 'Quantidade que foi recebida de produtos relativo ao item.';


--
-- Name: tb_item_pedidocompra_pk_itempedidocompra_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_pedidocompra_pk_itempedidocompra_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_pedidocompra_pk_itempedidocompra_seq OWNER TO "ADMIN";

--
-- Name: tb_item_pedidocompra_pk_itempedidocompra_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_item_pedidocompra_pk_itempedidocompra_seq OWNED BY tb_item_pedidocompra.pk_itempedidocompra;


--
-- Name: tb_item_reg_painel_controle; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_reg_painel_controle (
    pk_item_reg_painel_controle bigint NOT NULL,
    descricao character varying(80),
    identificador character varying(50),
    valor character varying(50),
    tipo_valor integer,
    fk_reg_painel_controle bigint NOT NULL
);


ALTER TABLE tb_item_reg_painel_controle OWNER TO "ADMIN";

--
-- Name: tb_item_reg_painel_controle_pk_item_reg_painel_controle_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_reg_painel_controle_pk_item_reg_painel_controle_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_reg_painel_controle_pk_item_reg_painel_controle_seq OWNER TO "ADMIN";

--
-- Name: tb_item_reg_painel_controle_pk_item_reg_painel_controle_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_item_reg_painel_controle_pk_item_reg_painel_controle_seq OWNED BY tb_item_reg_painel_controle.pk_item_reg_painel_controle;


--
-- Name: tb_item_retencao_servico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_item_retencao_servico (
    pk_item_retancao_servico bigint NOT NULL,
    tipo_tributo smallint,
    valor_retido numeric(15,4),
    fk_retencao_servico bigint,
    fk_movimento_cabecalho_nota_fiscal_saida bigint,
    valor_pendente_retencao numeric(15,4)
);


ALTER TABLE tb_item_retencao_servico OWNER TO "ADMIN";

--
-- Name: tb_item_retencao_servico_pk_item_retancao_servico_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_item_retencao_servico_pk_item_retancao_servico_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_item_retencao_servico_pk_item_retancao_servico_seq OWNER TO "ADMIN";

--
-- Name: tb_item_retencao_servico_pk_item_retancao_servico_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_item_retencao_servico_pk_item_retancao_servico_seq OWNED BY tb_item_retencao_servico.pk_item_retancao_servico;


SET default_with_oids = false;

--
-- Name: tb_lacre; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_lacre (
    pk_lacre bigint NOT NULL,
    fk_autorizacaolacre bigint NOT NULL,
    numero_lacre bigint NOT NULL
);


ALTER TABLE tb_lacre OWNER TO "ADMIN";

--
-- Name: TABLE tb_lacre; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_lacre IS 'Cadastro de lacres por autorizao';


--
-- Name: COLUMN tb_lacre.pk_lacre; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_lacre.pk_lacre IS 'Chave primria da tabela';


--
-- Name: COLUMN tb_lacre.fk_autorizacaolacre; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_lacre.fk_autorizacaolacre IS 'Chave extrangeira da tabela tb_autorizacao_lacre';


--
-- Name: COLUMN tb_lacre.numero_lacre; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_lacre.numero_lacre IS 'Numero do lacre';


--
-- Name: tb_lacre_funcionario; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_lacre_funcionario (
    fk_lacre bigint NOT NULL,
    fk_funcionario bigint NOT NULL
);


ALTER TABLE tb_lacre_funcionario OWNER TO "ADMIN";

--
-- Name: TABLE tb_lacre_funcionario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_lacre_funcionario IS 'Relacionamento item lacre com funcionario (Tecnico)';


--
-- Name: COLUMN tb_lacre_funcionario.fk_lacre; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_lacre_funcionario.fk_lacre IS 'Chave extrangeira da tabela tb_lacre';


--
-- Name: COLUMN tb_lacre_funcionario.fk_funcionario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_lacre_funcionario.fk_funcionario IS 'Chave extrangeira da tabela funcionario';


--
-- Name: tb_lacre_pk_lacre_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_lacre_pk_lacre_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_lacre_pk_lacre_seq OWNER TO "ADMIN";

--
-- Name: tb_lacre_pk_lacre_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_lacre_pk_lacre_seq OWNED BY tb_lacre.pk_lacre;


--
-- Name: tb_lacre_servico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_lacre_servico (
    fk_lacre bigint NOT NULL,
    fk_servico bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    observacao character varying(50)
);


ALTER TABLE tb_lacre_servico OWNER TO "ADMIN";

--
-- Name: TABLE tb_lacre_servico; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_lacre_servico IS 'Relacionamento tb_lacre com tabela movimento_cabecalho_servicos';


--
-- Name: COLUMN tb_lacre_servico.fk_lacre; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_lacre_servico.fk_lacre IS 'Chave extrangeira da tabela tb_lacre';


--
-- Name: COLUMN tb_lacre_servico.fk_servico; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_lacre_servico.fk_servico IS 'Chave extrangeira da tabela movimento_cabecalho_servicos';


--
-- Name: COLUMN tb_lacre_servico.fk_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_lacre_servico.fk_empresa IS 'Chave extrangeira da tabela movimento_cabecalho_servicos (composta)';


SET default_with_oids = true;

--
-- Name: tb_lancamento_financeiro_misto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_lancamento_financeiro_misto (
    pk_codigo bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    fk_usuario bigint,
    data_geracao date
);


ALTER TABLE tb_lancamento_financeiro_misto OWNER TO "ADMIN";

--
-- Name: TABLE tb_lancamento_financeiro_misto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_lancamento_financeiro_misto IS 'Responsvel por armazenar os dados iniciais do lanamento financeiro misto contas a pagar receber com calculo de juros pela financeira ex.: (pagh light)';


--
-- Name: tb_lancamento_financeiro_misto_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_lancamento_financeiro_misto_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_lancamento_financeiro_misto_codigo_seq OWNER TO "ADMIN";

--
-- Name: tb_lancfinanmisto_contaspagar; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_lancfinanmisto_contaspagar (
    fk_lancfinmisto bigint,
    fk_empresa bigint,
    fk_contasapagar bigint
);


ALTER TABLE tb_lancfinanmisto_contaspagar OWNER TO "ADMIN";

--
-- Name: TABLE tb_lancfinanmisto_contaspagar; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_lancfinanmisto_contaspagar IS 'Entidade responsvel por armazenar o relacionamento do lanamento misto financeiro com a comisso gerada no contas a pagar';


SET default_with_oids = false;

--
-- Name: tb_layout_importacao_rastreabilidade; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_layout_importacao_rastreabilidade (
    pk_layout_rastreabilidade bigint NOT NULL,
    fk_fornecedor bigint NOT NULL,
    tipo_arquivo smallint NOT NULL,
    separador character(1) NOT NULL,
    tamanho_linha_valida smallint NOT NULL
);


ALTER TABLE tb_layout_importacao_rastreabilidade OWNER TO "ADMIN";

--
-- Name: tb_layout_importacao_rastreabilidade_campos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_layout_importacao_rastreabilidade_campos (
    pk_layout_importacao_rastreabilidade_campos bigint NOT NULL,
    fk_layout_importacao_rastreabilidade bigint NOT NULL,
    tipo_campo smallint NOT NULL,
    numero_ordem smallint DEFAULT 0 NOT NULL,
    posicao_inicial smallint DEFAULT 0 NOT NULL,
    posicao_final smallint DEFAULT 0 NOT NULL
);


ALTER TABLE tb_layout_importacao_rastreabilidade_campos OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: tb_ligacao_listaprecos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_ligacao_listaprecos (
    fk_condicaopagamento bigint,
    fk_cadastroregioes bigint,
    fk_listaprecos bigint,
    fk_endereco_estoque bigint
);


ALTER TABLE tb_ligacao_listaprecos OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: tb_lista_preco_cliente; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_lista_preco_cliente (
    pk_lista_preco_cliente integer NOT NULL,
    fk_lista_precos bigint NOT NULL,
    fk_codigo_cliente bigint NOT NULL
);


ALTER TABLE tb_lista_preco_cliente OWNER TO "ADMIN";

--
-- Name: tb_lista_preco_cliente_pk_lista_preco_cliente_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_lista_preco_cliente_pk_lista_preco_cliente_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_lista_preco_cliente_pk_lista_preco_cliente_seq OWNER TO "ADMIN";

--
-- Name: tb_lista_preco_cliente_pk_lista_preco_cliente_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_lista_preco_cliente_pk_lista_preco_cliente_seq OWNED BY tb_lista_preco_cliente.pk_lista_preco_cliente;


SET default_with_oids = true;

--
-- Name: tb_lista_precos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_lista_precos (
    nom_lista_precos character varying(100) NOT NULL,
    des_observacao text,
    pk_lista_precos bigint NOT NULL
);


ALTER TABLE tb_lista_precos OWNER TO "ADMIN";

--
-- Name: tb_lista_precos_pk_lista_precos_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_lista_precos_pk_lista_precos_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_lista_precos_pk_lista_precos_seq OWNER TO "ADMIN";

--
-- Name: tb_lista_precos_pk_lista_precos_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_lista_precos_pk_lista_precos_seq OWNED BY tb_lista_precos.pk_lista_precos;


SET default_with_oids = false;

--
-- Name: tb_marca; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_marca (
    pk_marca bigint NOT NULL,
    descricao character varying(250) NOT NULL,
    inativo smallint DEFAULT 0
);


ALTER TABLE tb_marca OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: tb_mdfe; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mdfe (
    pk_mdfe bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    numero bigint NOT NULL,
    modelo smallint NOT NULL,
    serie smallint NOT NULL,
    codigo_chave bigint NOT NULL,
    data_emissao timestamp without time zone,
    uf_inicial_carregamento character varying(2) NOT NULL,
    uf_final_descarregamento character varying(2) NOT NULL,
    data_inicio_viagem timestamp without time zone,
    valor_total numeric(13,2),
    peso_total numeric(11,4),
    codigo_unidade_medida character varying(3) NOT NULL,
    informacoes_fisco text,
    informacoes_complementares text
);


ALTER TABLE tb_mdfe OWNER TO "ADMIN";

--
-- Name: tb_mdfe_auditoria; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mdfe_auditoria (
    pk_mdfe_auditoria bigint NOT NULL,
    fk_mdfe bigint NOT NULL,
    status smallint,
    chave_acesso character varying,
    numero_recepcao bigint,
    numero_protocolo bigint,
    xml_base64 text
);


ALTER TABLE tb_mdfe_auditoria OWNER TO "ADMIN";

--
-- Name: COLUMN tb_mdfe_auditoria.status; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_mdfe_auditoria.status IS '0 - Pendente; 1 - Autorizado (No encerrado) ; 2 - Autorizado (Encerrado); 3 - Cancelado;';


--
-- Name: tb_mdfe_auditoria_pk_mdfe_auditoria_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mdfe_auditoria_pk_mdfe_auditoria_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mdfe_auditoria_pk_mdfe_auditoria_seq OWNER TO "ADMIN";

--
-- Name: tb_mdfe_auditoria_pk_mdfe_auditoria_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_mdfe_auditoria_pk_mdfe_auditoria_seq OWNED BY tb_mdfe_auditoria.pk_mdfe_auditoria;


--
-- Name: tb_mdfe_condutor; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mdfe_condutor (
    pk_mdfe_condutor bigint NOT NULL,
    fk_mdfe bigint NOT NULL,
    fk_mdfe_veiculo bigint NOT NULL,
    fk_motorista bigint NOT NULL
);


ALTER TABLE tb_mdfe_condutor OWNER TO "ADMIN";

--
-- Name: tb_mdfe_condutor_pk_mdfe_condutor_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mdfe_condutor_pk_mdfe_condutor_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mdfe_condutor_pk_mdfe_condutor_seq OWNER TO "ADMIN";

--
-- Name: tb_mdfe_condutor_pk_mdfe_condutor_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_mdfe_condutor_pk_mdfe_condutor_seq OWNED BY tb_mdfe_condutor.pk_mdfe_condutor;


--
-- Name: tb_mdfe_municipio_carregamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mdfe_municipio_carregamento (
    pk_mdfe_municipio_carregamento bigint NOT NULL,
    fk_mdfe bigint NOT NULL,
    fk_cidade bigint NOT NULL
);


ALTER TABLE tb_mdfe_municipio_carregamento OWNER TO "ADMIN";

--
-- Name: tb_mdfe_municipio_carregament_pk_mdfe_municipio_carregament_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mdfe_municipio_carregament_pk_mdfe_municipio_carregament_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mdfe_municipio_carregament_pk_mdfe_municipio_carregament_seq OWNER TO "ADMIN";

--
-- Name: tb_mdfe_municipio_carregament_pk_mdfe_municipio_carregament_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_mdfe_municipio_carregament_pk_mdfe_municipio_carregament_seq OWNED BY tb_mdfe_municipio_carregamento.pk_mdfe_municipio_carregamento;


--
-- Name: tb_mdfe_municipio_descarga; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mdfe_municipio_descarga (
    pk_mdfe_municipio_descarga bigint NOT NULL,
    fk_mdfe bigint NOT NULL,
    fk_nfe bigint,
    chave_documento_eletronico character varying,
    fk_cidade bigint NOT NULL,
    tipo_movimento smallint
);


ALTER TABLE tb_mdfe_municipio_descarga OWNER TO "ADMIN";

--
-- Name: COLUMN tb_mdfe_municipio_descarga.tipo_movimento; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_mdfe_municipio_descarga.tipo_movimento IS 'Compras = 0,Vendas = 1,DevolucaoVendas = 2,DevolucaoCompras = 3,Canceladas = 4';


--
-- Name: tb_mdfe_municipio_descarga_pk_mdfe_municipio_descarga_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mdfe_municipio_descarga_pk_mdfe_municipio_descarga_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mdfe_municipio_descarga_pk_mdfe_municipio_descarga_seq OWNER TO "ADMIN";

--
-- Name: tb_mdfe_municipio_descarga_pk_mdfe_municipio_descarga_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_mdfe_municipio_descarga_pk_mdfe_municipio_descarga_seq OWNED BY tb_mdfe_municipio_descarga.pk_mdfe_municipio_descarga;


--
-- Name: tb_mdfe_percurso; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mdfe_percurso (
    pk_mdfe_percurso bigint NOT NULL,
    fk_mdfe bigint NOT NULL,
    ordem smallint,
    estado character varying(2)
);


ALTER TABLE tb_mdfe_percurso OWNER TO "ADMIN";

--
-- Name: tb_mdfe_percurso_pk_mdfe_percurso_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mdfe_percurso_pk_mdfe_percurso_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mdfe_percurso_pk_mdfe_percurso_seq OWNER TO "ADMIN";

--
-- Name: tb_mdfe_percurso_pk_mdfe_percurso_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_mdfe_percurso_pk_mdfe_percurso_seq OWNED BY tb_mdfe_percurso.pk_mdfe_percurso;


--
-- Name: tb_mdfe_pk_mdfe_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mdfe_pk_mdfe_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mdfe_pk_mdfe_seq OWNER TO "ADMIN";

--
-- Name: tb_mdfe_seguro; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mdfe_seguro (
    pk_mdfe_seguro bigint NOT NULL,
    fk_mdfe bigint NOT NULL,
    responsavel smallint,
    cnpj_cpf_responsavel character varying(14),
    nome_seguradora character varying(30),
    cnpj_seguradora character varying(14),
    numero_apolice character varying(20),
    numero_averbacao character varying(40)
);


ALTER TABLE tb_mdfe_seguro OWNER TO "ADMIN";

--
-- Name: COLUMN tb_mdfe_seguro.responsavel; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_mdfe_seguro.responsavel IS '1- Emitente do MDF-e, 2 - Responsvel pela contratao do servio de transporte (contratante)';


--
-- Name: tb_mdfe_seguro_pk_mdfe_seguro_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mdfe_seguro_pk_mdfe_seguro_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mdfe_seguro_pk_mdfe_seguro_seq OWNER TO "ADMIN";

--
-- Name: tb_mdfe_seguro_pk_mdfe_seguro_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_mdfe_seguro_pk_mdfe_seguro_seq OWNED BY tb_mdfe_seguro.pk_mdfe_seguro;


--
-- Name: tb_mdfe_veiculo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mdfe_veiculo (
    pk_mdfe_veiculo bigint NOT NULL,
    fk_mdfe bigint NOT NULL,
    fk_veiculo bigint NOT NULL
);


ALTER TABLE tb_mdfe_veiculo OWNER TO "ADMIN";

--
-- Name: tb_mdfe_veiculo_pk_mdfe_veiculo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mdfe_veiculo_pk_mdfe_veiculo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mdfe_veiculo_pk_mdfe_veiculo_seq OWNER TO "ADMIN";

--
-- Name: tb_mdfe_veiculo_pk_mdfe_veiculo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_mdfe_veiculo_pk_mdfe_veiculo_seq OWNED BY tb_mdfe_veiculo.pk_mdfe_veiculo;


SET default_with_oids = false;

--
-- Name: tb_mensagem_boleto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mensagem_boleto (
    pk_mensagem_boleto bigint NOT NULL,
    fk_boleto bigint NOT NULL,
    mensagem character varying(500) NOT NULL,
    referencia character varying(255),
    valor double precision NOT NULL
);


ALTER TABLE tb_mensagem_boleto OWNER TO "ADMIN";

--
-- Name: tb_mensagem_boleto_pk_mensagem_boleto_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mensagem_boleto_pk_mensagem_boleto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mensagem_boleto_pk_mensagem_boleto_seq OWNER TO "ADMIN";

--
-- Name: tb_mensagem_boleto_pk_mensagem_boleto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_mensagem_boleto_pk_mensagem_boleto_seq OWNED BY tb_mensagem_boleto.pk_mensagem_boleto;


--
-- Name: tb_mensagem_configuracao_boleto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_mensagem_configuracao_boleto (
    pk_mensagem_configuracao_boleto bigint NOT NULL,
    fk_configuracao_boleto bigint NOT NULL,
    mensagem character varying(500) NOT NULL
);


ALTER TABLE tb_mensagem_configuracao_boleto OWNER TO "ADMIN";

--
-- Name: tb_mensagem_configuracao_bole_pk_mensagem_configuracao_bole_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_mensagem_configuracao_bole_pk_mensagem_configuracao_bole_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_mensagem_configuracao_bole_pk_mensagem_configuracao_bole_seq OWNER TO "ADMIN";

--
-- Name: tb_mensagem_configuracao_bole_pk_mensagem_configuracao_bole_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_mensagem_configuracao_bole_pk_mensagem_configuracao_bole_seq OWNED BY tb_mensagem_configuracao_boleto.pk_mensagem_configuracao_boleto;


--
-- Name: tb_meta_vendas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_meta_vendas (
    pk_meta_vendas bigint NOT NULL,
    fk_sazonalidade_metas bigint NOT NULL,
    tipo smallint NOT NULL,
    descricao character varying(250) NOT NULL,
    razao smallint NOT NULL
);


ALTER TABLE tb_meta_vendas OWNER TO "ADMIN";

--
-- Name: tb_meta_vendas_fornecedor; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_meta_vendas_fornecedor (
    pk_meta_vendas_fornecedor bigint NOT NULL,
    fk_meta_vendas_item bigint NOT NULL,
    fk_fornecedor bigint NOT NULL,
    valor double precision NOT NULL
);


ALTER TABLE tb_meta_vendas_fornecedor OWNER TO "ADMIN";

--
-- Name: tb_meta_vendas_fornecedor_pk_meta_vendas_fornecedor_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_meta_vendas_fornecedor_pk_meta_vendas_fornecedor_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_meta_vendas_fornecedor_pk_meta_vendas_fornecedor_seq OWNER TO "ADMIN";

--
-- Name: tb_meta_vendas_fornecedor_pk_meta_vendas_fornecedor_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_meta_vendas_fornecedor_pk_meta_vendas_fornecedor_seq OWNED BY tb_meta_vendas_fornecedor.pk_meta_vendas_fornecedor;


--
-- Name: tb_meta_vendas_item; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_meta_vendas_item (
    pk_meta_vendas_item bigint NOT NULL,
    fk_meta_vendas bigint NOT NULL,
    fk_funcionario bigint NOT NULL,
    valor double precision NOT NULL
);


ALTER TABLE tb_meta_vendas_item OWNER TO "ADMIN";

--
-- Name: tb_meta_vendas_item_pk_meta_vendas_item_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_meta_vendas_item_pk_meta_vendas_item_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_meta_vendas_item_pk_meta_vendas_item_seq OWNER TO "ADMIN";

--
-- Name: tb_meta_vendas_item_pk_meta_vendas_item_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_meta_vendas_item_pk_meta_vendas_item_seq OWNED BY tb_meta_vendas_item.pk_meta_vendas_item;


--
-- Name: tb_meta_vendas_pk_meta_vendas_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_meta_vendas_pk_meta_vendas_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_meta_vendas_pk_meta_vendas_seq OWNER TO "ADMIN";

--
-- Name: tb_meta_vendas_pk_meta_vendas_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_meta_vendas_pk_meta_vendas_seq OWNED BY tb_meta_vendas.pk_meta_vendas;


--
-- Name: tb_meta_vendas_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_meta_vendas_produto (
    pk_meta_vendas_produto bigint NOT NULL,
    fk_meta_vendas_item bigint NOT NULL,
    fk_produto character varying(250) NOT NULL,
    valor double precision NOT NULL
);


ALTER TABLE tb_meta_vendas_produto OWNER TO "ADMIN";

--
-- Name: tb_meta_vendas_produto_pk_meta_vendas_produto_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_meta_vendas_produto_pk_meta_vendas_produto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_meta_vendas_produto_pk_meta_vendas_produto_seq OWNER TO "ADMIN";

--
-- Name: tb_meta_vendas_produto_pk_meta_vendas_produto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_meta_vendas_produto_pk_meta_vendas_produto_seq OWNED BY tb_meta_vendas_produto.pk_meta_vendas_produto;


--
-- Name: tb_motivo_cancelamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_motivo_cancelamento (
    pk_motivo_cancelamento integer NOT NULL,
    descricao character varying(255),
    fk_cancelamento bigint,
    empresa bigint NOT NULL
);


ALTER TABLE tb_motivo_cancelamento OWNER TO "ADMIN";

--
-- Name: tb_motivo_cancelamento_pk_motivo_cancelamento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_motivo_cancelamento_pk_motivo_cancelamento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_motivo_cancelamento_pk_motivo_cancelamento_seq OWNER TO "ADMIN";

--
-- Name: tb_motivo_cancelamento_pk_motivo_cancelamento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_motivo_cancelamento_pk_motivo_cancelamento_seq OWNED BY tb_motivo_cancelamento.pk_motivo_cancelamento;


--
-- Name: tb_motivo_nao_venda; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_motivo_nao_venda (
    pk_motivo_nao_venda bigint NOT NULL,
    descricao character varying(40)
);


ALTER TABLE tb_motivo_nao_venda OWNER TO "ADMIN";

--
-- Name: TABLE tb_motivo_nao_venda; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_motivo_nao_venda IS 'Lista de motivos de no venda quando das visitas aos clientes pelos vendedores externos.';


--
-- Name: COLUMN tb_motivo_nao_venda.pk_motivo_nao_venda; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_motivo_nao_venda.pk_motivo_nao_venda IS 'Chave primria da tabela, valor sequencial para identificao dos motivos de no venda.';


--
-- Name: COLUMN tb_motivo_nao_venda.descricao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_motivo_nao_venda.descricao IS 'Texto descritivo do motivo de no venda.';


--
-- Name: tb_motivo_nao_venda_cliente; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_motivo_nao_venda_cliente (
    pk_motivo_nao_venda_cliente bigint NOT NULL,
    fk_funcionario bigint,
    fk_cliente bigint,
    data_ocorrencia timestamp without time zone,
    fk_motivo_nao_venda bigint,
    data_processamento date,
    numero_processamento character varying(25)
);


ALTER TABLE tb_motivo_nao_venda_cliente OWNER TO "ADMIN";

--
-- Name: TABLE tb_motivo_nao_venda_cliente; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_motivo_nao_venda_cliente IS 'Relao dos motivos de no venda aos clientes registrados pelos vendedores.';


--
-- Name: COLUMN tb_motivo_nao_venda_cliente.pk_motivo_nao_venda_cliente; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_motivo_nao_venda_cliente.pk_motivo_nao_venda_cliente IS 'Chave primaria da tabela. Valor sequencia que identifica o registro do relacionamento de motivo de nao venda a um certo cliente.';


--
-- Name: COLUMN tb_motivo_nao_venda_cliente.fk_funcionario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_motivo_nao_venda_cliente.fk_funcionario IS 'Chave estrangeira que identifica o funcionario que registrou o motivo de no venda.';


--
-- Name: COLUMN tb_motivo_nao_venda_cliente.fk_cliente; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_motivo_nao_venda_cliente.fk_cliente IS 'Chave estrangeira que identifica o cliente do motivo de no venda.';


--
-- Name: COLUMN tb_motivo_nao_venda_cliente.data_ocorrencia; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_motivo_nao_venda_cliente.data_ocorrencia IS 'Data em que ocorreu a no venda.';


--
-- Name: COLUMN tb_motivo_nao_venda_cliente.fk_motivo_nao_venda; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_motivo_nao_venda_cliente.fk_motivo_nao_venda IS 'Chave estrangeira que indica o motivo da no venda.';


--
-- Name: COLUMN tb_motivo_nao_venda_cliente.data_processamento; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_motivo_nao_venda_cliente.data_processamento IS 'Data em que foi executado o processamento da ocorrencia.';


--
-- Name: COLUMN tb_motivo_nao_venda_cliente.numero_processamento; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_motivo_nao_venda_cliente.numero_processamento IS 'Nmero nico de processamento para rastreamento de dados.';


--
-- Name: tb_motivo_nao_venda_cliente_pk_motivo_nao_venda_cliente_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_motivo_nao_venda_cliente_pk_motivo_nao_venda_cliente_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_motivo_nao_venda_cliente_pk_motivo_nao_venda_cliente_seq OWNER TO "ADMIN";

--
-- Name: tb_motivo_nao_venda_cliente_pk_motivo_nao_venda_cliente_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_motivo_nao_venda_cliente_pk_motivo_nao_venda_cliente_seq OWNED BY tb_motivo_nao_venda_cliente.pk_motivo_nao_venda_cliente;


--
-- Name: tb_motivo_nao_venda_pk_motivo_nao_venda_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_motivo_nao_venda_pk_motivo_nao_venda_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_motivo_nao_venda_pk_motivo_nao_venda_seq OWNER TO "ADMIN";

--
-- Name: tb_motivo_nao_venda_pk_motivo_nao_venda_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_motivo_nao_venda_pk_motivo_nao_venda_seq OWNED BY tb_motivo_nao_venda.pk_motivo_nao_venda;


SET default_with_oids = true;

--
-- Name: tb_movimentacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimentacao (
    pk_movimentacao bigint NOT NULL,
    data_criacao date NOT NULL,
    data_entrega date,
    fk_empresa bigint NOT NULL,
    observacoes text,
    fk_funcionario bigint NOT NULL,
    data_saida date,
    fk_formafaturamento integer
);


ALTER TABLE tb_movimentacao OWNER TO "ADMIN";

--
-- Name: COLUMN tb_movimentacao.pk_movimentacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao.pk_movimentacao IS 'Chave primria da tabela';


--
-- Name: COLUMN tb_movimentacao.data_criacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao.data_criacao IS 'Data em que foi efetuado o cadastro do registro do pedido.';


--
-- Name: COLUMN tb_movimentacao.data_entrega; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao.data_entrega IS 'Data prevista para a entrega da mercadoria.';


--
-- Name: COLUMN tb_movimentacao.fk_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao.fk_empresa IS 'Especificao de qual empresa  o pedido.';


--
-- Name: COLUMN tb_movimentacao.observacoes; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao.observacoes IS 'Armazena as observaes relativas ao pedido.';


--
-- Name: COLUMN tb_movimentacao.fk_funcionario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao.fk_funcionario IS 'Representa o responsvel pela realizao do pedido.';


--
-- Name: tb_movimentacao_consumo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimentacao_consumo (
    pk_movimentacaoconsumo bigint NOT NULL,
    data_emissao date NOT NULL,
    fk_usuario bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    observacao text
);


ALTER TABLE tb_movimentacao_consumo OWNER TO "ADMIN";

--
-- Name: TABLE tb_movimentacao_consumo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_movimentacao_consumo IS 'Guarda os registros de movimentao de Produtos para Consumo Prprio';


--
-- Name: COLUMN tb_movimentacao_consumo.pk_movimentacaoconsumo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao_consumo.pk_movimentacaoconsumo IS 'Chave primria da tabela';


--
-- Name: COLUMN tb_movimentacao_consumo.data_emissao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao_consumo.data_emissao IS 'Data de emisso de sada do produto';


--
-- Name: COLUMN tb_movimentacao_consumo.fk_usuario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao_consumo.fk_usuario IS 'Cdigo do usurio responsvel pela operao.';


--
-- Name: COLUMN tb_movimentacao_consumo.fk_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao_consumo.fk_empresa IS 'Cdigo da empresa';


--
-- Name: COLUMN tb_movimentacao_consumo.observacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao_consumo.observacao IS 'Observao referente ao movimento em questo.';


--
-- Name: tb_movimentacao_consumo_pk_movimentacaoconsumo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_movimentacao_consumo_pk_movimentacaoconsumo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_movimentacao_consumo_pk_movimentacaoconsumo_seq OWNER TO "ADMIN";

--
-- Name: tb_movimentacao_consumo_pk_movimentacaoconsumo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_movimentacao_consumo_pk_movimentacaoconsumo_seq OWNED BY tb_movimentacao_consumo.pk_movimentacaoconsumo;


SET default_with_oids = false;

--
-- Name: tb_movimentacao_guias; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimentacao_guias (
    pk_movimentacaoguia bigint NOT NULL,
    pk_empresa bigint NOT NULL,
    data_lancamento date NOT NULL,
    fk_funcionario bigint NOT NULL,
    percentual_comissao numeric(15,4) DEFAULT 0 NOT NULL,
    valor_total numeric(15,4) DEFAULT 0 NOT NULL
);


ALTER TABLE tb_movimentacao_guias OWNER TO "ADMIN";

--
-- Name: tb_movimentacao_pk_movimentacao_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_movimentacao_pk_movimentacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_movimentacao_pk_movimentacao_seq OWNER TO "ADMIN";

--
-- Name: tb_movimentacao_pk_movimentacao_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_movimentacao_pk_movimentacao_seq OWNED BY tb_movimentacao.pk_movimentacao;


SET default_with_oids = true;

--
-- Name: tb_movimentacao_replicacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimentacao_replicacao (
    pk_movimentacao_replicacao bigint NOT NULL,
    serializacao_movimento_original text NOT NULL,
    situacao_replicacao smallint NOT NULL,
    sequencia_movimentacao bigint NOT NULL,
    empresa_destino bigint NOT NULL,
    data_movimentacao date NOT NULL
);


ALTER TABLE tb_movimentacao_replicacao OWNER TO "ADMIN";

--
-- Name: COLUMN tb_movimentacao_replicacao.serializacao_movimento_original; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao_replicacao.serializacao_movimento_original IS 'xml da serializao do pedido original.';


--
-- Name: COLUMN tb_movimentacao_replicacao.situacao_replicacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimentacao_replicacao.situacao_replicacao IS '1 - PENDENTE 2 - CANCELADO 3 - CONCLUIDO';


--
-- Name: tb_movimentacao_replicacao_pk_movimentacao_replicacao_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_movimentacao_replicacao_pk_movimentacao_replicacao_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_movimentacao_replicacao_pk_movimentacao_replicacao_seq OWNER TO "ADMIN";

--
-- Name: tb_movimentacao_replicacao_pk_movimentacao_replicacao_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_movimentacao_replicacao_pk_movimentacao_replicacao_seq OWNED BY tb_movimentacao_replicacao.pk_movimentacao_replicacao;


SET default_with_oids = false;

--
-- Name: tb_movimentacoes_fiscais_efetivadas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimentacoes_fiscais_efetivadas (
    pk_movimentacoes_fiscais_efetivadas bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_entrada bigint NOT NULL
);


ALTER TABLE tb_movimentacoes_fiscais_efetivadas OWNER TO "ADMIN";

--
-- Name: tb_movimentacoes_fiscais_efet_pk_movimentacoes_fiscais_efet_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_movimentacoes_fiscais_efet_pk_movimentacoes_fiscais_efet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_movimentacoes_fiscais_efet_pk_movimentacoes_fiscais_efet_seq OWNER TO "ADMIN";

--
-- Name: tb_movimentacoes_fiscais_efet_pk_movimentacoes_fiscais_efet_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_movimentacoes_fiscais_efet_pk_movimentacoes_fiscais_efet_seq OWNED BY tb_movimentacoes_fiscais_efetivadas.pk_movimentacoes_fiscais_efetivadas;


--
-- Name: tb_movimento_centro_custo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_centro_custo (
    pk_movimento_centro_custo bigint NOT NULL,
    fk_movimento_conta_contabil bigint NOT NULL,
    fk_centro_custo bigint NOT NULL,
    valor double precision NOT NULL
);


ALTER TABLE tb_movimento_centro_custo OWNER TO "ADMIN";

--
-- Name: tb_movimento_centro_custo_pk_movimento_centro_custo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_movimento_centro_custo_pk_movimento_centro_custo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_movimento_centro_custo_pk_movimento_centro_custo_seq OWNER TO "ADMIN";

--
-- Name: tb_movimento_centro_custo_pk_movimento_centro_custo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_movimento_centro_custo_pk_movimento_centro_custo_seq OWNED BY tb_movimento_centro_custo.pk_movimento_centro_custo;


--
-- Name: tb_movimento_comissao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_comissao (
    pk_movimento_comissao bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_grupo_participante bigint NOT NULL,
    fk_item_venda bigint NOT NULL,
    percentual_comissao double precision DEFAULT 0 NOT NULL,
    valor_comissao double precision DEFAULT 0 NOT NULL,
    tipo_movimento integer DEFAULT 0 NOT NULL,
    fk_item_dev bigint,
    data_movimento date
);


ALTER TABLE tb_movimento_comissao OWNER TO "ADMIN";

--
-- Name: tb_movimento_comissao_participante; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_comissao_participante (
    pk_movimento_comissao_participante bigint NOT NULL,
    fk_movimento_comissao bigint NOT NULL,
    fk_participante bigint NOT NULL,
    percentual_participacao double precision DEFAULT 0 NOT NULL,
    valor_comissao_participante double precision DEFAULT 0 NOT NULL
);


ALTER TABLE tb_movimento_comissao_participante OWNER TO "ADMIN";

--
-- Name: tb_movimento_conta_contabil; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_conta_contabil (
    pk_movimento_conta_contabil bigint NOT NULL,
    fk_movimento_contabil bigint NOT NULL,
    fk_conta_contabil character varying(15) NOT NULL,
    empresa bigint NOT NULL,
    tipo_movimento character varying(1) NOT NULL,
    valor double precision NOT NULL
);


ALTER TABLE tb_movimento_conta_contabil OWNER TO "ADMIN";

--
-- Name: tb_movimento_conta_contabil_pk_movimento_conta_contabil_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_movimento_conta_contabil_pk_movimento_conta_contabil_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_movimento_conta_contabil_pk_movimento_conta_contabil_seq OWNER TO "ADMIN";

--
-- Name: tb_movimento_conta_contabil_pk_movimento_conta_contabil_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_movimento_conta_contabil_pk_movimento_conta_contabil_seq OWNED BY tb_movimento_conta_contabil.pk_movimento_conta_contabil;


--
-- Name: tb_movimento_contabil; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_contabil (
    pk_movimento_contabil bigint NOT NULL,
    data_movimento date NOT NULL,
    historico character varying(100) NOT NULL
);


ALTER TABLE tb_movimento_contabil OWNER TO "ADMIN";

--
-- Name: tb_movimento_contabil_pk_movimento_contabil_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_movimento_contabil_pk_movimento_contabil_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_movimento_contabil_pk_movimento_contabil_seq OWNER TO "ADMIN";

--
-- Name: tb_movimento_contabil_pk_movimento_contabil_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_movimento_contabil_pk_movimento_contabil_seq OWNED BY tb_movimento_contabil.pk_movimento_contabil;


--
-- Name: tb_movimento_endereco_estoque; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_endereco_estoque (
    pk_movimento_endereco_estoque bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_produto character varying(20) NOT NULL,
    fk_endereco_estoque bigint NOT NULL,
    tipo_movimentacao character varying(2) NOT NULL,
    fk_item_entrada bigint,
    fk_item_saida bigint,
    fk_item_devolvida bigint,
    fk_item_cancelada bigint,
    fk_item_orcamento bigint,
    fk_acerto_endereco_estoque bigint
);


ALTER TABLE tb_movimento_endereco_estoque OWNER TO "ADMIN";

--
-- Name: tb_movimento_endereco_estoque_pk_movimento_endereco_estoque_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_movimento_endereco_estoque_pk_movimento_endereco_estoque_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_movimento_endereco_estoque_pk_movimento_endereco_estoque_seq OWNER TO "ADMIN";

--
-- Name: tb_movimento_endereco_estoque_pk_movimento_endereco_estoque_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_movimento_endereco_estoque_pk_movimento_endereco_estoque_seq OWNED BY tb_movimento_endereco_estoque.pk_movimento_endereco_estoque;


SET default_with_oids = true;

--
-- Name: tb_movimento_financeiro_misto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_financeiro_misto (
    fk_lancfinmisto bigint,
    fk_empresa bigint,
    fk_contasapagar bigint,
    fk_contasareceber bigint,
    fk_pos bigint,
    valorlancamento numeric(15,2) NOT NULL,
    numparcelas bigint NOT NULL,
    fatoroperacao numeric(15,4) NOT NULL,
    taxaparcela numeric(15,2) NOT NULL,
    valorcomissao numeric(15,2) DEFAULT 0
);


ALTER TABLE tb_movimento_financeiro_misto OWNER TO "ADMIN";

--
-- Name: TABLE tb_movimento_financeiro_misto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_movimento_financeiro_misto IS 'Responsvel por armazenar os relacionamentos dos titulos gerados para ambas as carteiras do financeiro oriundo de lanamento manual obs.: (processo pag light)';


--
-- Name: COLUMN tb_movimento_financeiro_misto.fk_pos; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimento_financeiro_misto.fk_pos IS 'Armazena o nmero do POS utilizado ';


--
-- Name: COLUMN tb_movimento_financeiro_misto.valorcomissao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_movimento_financeiro_misto.valorcomissao IS 'Armazena o valor da comisso calclado ';


SET default_with_oids = false;

--
-- Name: tb_movimento_fiscal_movimento_contabil; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_fiscal_movimento_contabil (
    empresa bigint NOT NULL,
    sequencia_saida bigint,
    sequencia_entrada bigint,
    sequencia_cancelamento bigint,
    sequencia_devolucao bigint,
    fk_nfse bigint,
    identificador_caixa_geral bigint,
    identificador_caixa_diario bigint,
    fk_titulo_receber bigint,
    fk_titulo_pagar bigint,
    fk_inventario bigint,
    fk_movimento_contabil bigint NOT NULL,
    tipo_movimento character varying(3) NOT NULL
);


ALTER TABLE tb_movimento_fiscal_movimento_contabil OWNER TO "ADMIN";

--
-- Name: tb_movimento_meta_venda_vendedor_item; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_meta_venda_vendedor_item (
    pk_movimento_meta_venda_vendedor_item bigint NOT NULL,
    fk_movimento_meta_venda_vendedor bigint NOT NULL,
    fk_cadastro character varying(20) NOT NULL,
    fk_unidade bigint NOT NULL,
    fator_conversao double precision DEFAULT 1 NOT NULL,
    quantidade double precision DEFAULT 0 NOT NULL,
    valor_unitario double precision DEFAULT 0 NOT NULL,
    valor_cota double precision DEFAULT 0 NOT NULL
);


ALTER TABLE tb_movimento_meta_venda_vendedor_item OWNER TO "ADMIN";

--
-- Name: tb_movimento_meta_vendas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_meta_vendas (
    pk_movimento_meta_vendas bigint NOT NULL,
    nome_meta character varying(250) NOT NULL,
    data_inicio date,
    data_encerramento date,
    status integer DEFAULT 0 NOT NULL,
    tipo_ciclo integer,
    quantidade_ciclos integer,
    valor_meta double precision DEFAULT 0 NOT NULL,
    valor_apurado double precision DEFAULT 0 NOT NULL,
    tipo_meta integer NOT NULL
);


ALTER TABLE tb_movimento_meta_vendas OWNER TO "ADMIN";

--
-- Name: tb_movimento_meta_vendas_periodo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_meta_vendas_periodo (
    pk_meta_vendas_periodo bigint NOT NULL,
    fk_movimento_meta_vendas bigint NOT NULL,
    nome_periodo character varying(100),
    data_inicio date,
    data_encerramento date,
    percentual_meta double precision DEFAULT 0 NOT NULL,
    status integer DEFAULT 0 NOT NULL,
    valor_cota double precision DEFAULT 0 NOT NULL
);


ALTER TABLE tb_movimento_meta_vendas_periodo OWNER TO "ADMIN";

--
-- Name: tb_movimento_meta_vendas_periodo_item; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_meta_vendas_periodo_item (
    pk_movimento_meta_vendas_periodo_item bigint NOT NULL,
    fk_movimento_meta_vendas_periodo bigint NOT NULL,
    fk_cadastro character varying(20) NOT NULL,
    percentual_periodo double precision DEFAULT 0 NOT NULL
);


ALTER TABLE tb_movimento_meta_vendas_periodo_item OWNER TO "ADMIN";

--
-- Name: tb_movimento_meta_vendas_vendedor; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_meta_vendas_vendedor (
    pk_movimento_meta_venda_vendedor bigint NOT NULL,
    fk_movimento_meta_venda bigint NOT NULL,
    fk_vendedor bigint NOT NULL,
    percentual_meta double precision DEFAULT 0 NOT NULL,
    valor_cota double precision DEFAULT 0 NOT NULL
);


ALTER TABLE tb_movimento_meta_vendas_vendedor OWNER TO "ADMIN";

--
-- Name: tb_movimento_meta_vendas_vendedor_item; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_meta_vendas_vendedor_item (
    pk_movimento_meta_venda_vendedor_item bigint NOT NULL,
    fk_movimento_meta_venda_vendedor bigint NOT NULL,
    fk_cadastro character varying(20) NOT NULL,
    fk_unidade bigint NOT NULL,
    fator_conversao double precision DEFAULT 1 NOT NULL,
    quantidade double precision DEFAULT 0 NOT NULL,
    valor_unitario double precision DEFAULT 0 NOT NULL,
    valor_cota double precision DEFAULT 0 NOT NULL
);


ALTER TABLE tb_movimento_meta_vendas_vendedor_item OWNER TO "ADMIN";

--
-- Name: tb_movimento_meta_vendas_vinculo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_meta_vendas_vinculo (
    pk_meta_vendas_vinculo bigint NOT NULL,
    fk_produto character varying(20) NOT NULL
);


ALTER TABLE tb_movimento_meta_vendas_vinculo OWNER TO "ADMIN";

--
-- Name: tb_movimento_orcamento_pedido_associado; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_movimento_orcamento_pedido_associado (
    pk_pedido_associado bigint NOT NULL,
    sequencia_venda bigint,
    codigo_produto character varying(250),
    pedido_compra character varying(15),
    status_venda character varying(2),
    numero_item bigint
);


ALTER TABLE tb_movimento_orcamento_pedido_associado OWNER TO "ADMIN";

--
-- Name: tb_movimento_orcamento_pedido_associado_pk_pedido_associado_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_movimento_orcamento_pedido_associado_pk_pedido_associado_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_movimento_orcamento_pedido_associado_pk_pedido_associado_seq OWNER TO "ADMIN";

--
-- Name: tb_movimento_orcamento_pedido_associado_pk_pedido_associado_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_movimento_orcamento_pedido_associado_pk_pedido_associado_seq OWNED BY tb_movimento_orcamento_pedido_associado.pk_pedido_associado;


SET default_with_oids = true;

--
-- Name: tb_nfe_cupom_eletronico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfe_cupom_eletronico (
    pk_nfe_cupom_eletronico bigint NOT NULL,
    empresa bigint,
    data_de_emissao timestamp without time zone,
    numero_nf bigint NOT NULL,
    serie_nf character varying(3),
    modelo_nf character varying(2),
    codificacao_fiscal bigint,
    fk_forma_faturamento bigint,
    codigo_do_cliente bigint,
    codigo_situacao_tributaria character varying(3),
    sequencia bigint,
    id_nfe bigint,
    status_nfe character varying(2) DEFAULT 'S'::character varying,
    dados_adicionais text
);


ALTER TABLE tb_nfe_cupom_eletronico OWNER TO "ADMIN";

--
-- Name: tb_nfe_cupom_eletronico_pk_nfe_cupom_eletronico_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfe_cupom_eletronico_pk_nfe_cupom_eletronico_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfe_cupom_eletronico_pk_nfe_cupom_eletronico_seq OWNER TO "ADMIN";

--
-- Name: tb_nfe_cupom_eletronico_pk_nfe_cupom_eletronico_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfe_cupom_eletronico_pk_nfe_cupom_eletronico_seq OWNED BY tb_nfe_cupom_eletronico.pk_nfe_cupom_eletronico;


SET default_with_oids = false;

--
-- Name: tb_nfse; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse (
    pk_nfse bigint NOT NULL,
    rps_numero bigint NOT NULL,
    rps_serie character varying(5) NOT NULL,
    rps_tipo smallint DEFAULT 1 NOT NULL,
    data_emissao date NOT NULL,
    data_competencia date,
    local_prestacao_servico smallint,
    natureza_operacao smallint NOT NULL,
    operacao_tributacao character varying(2) NOT NULL,
    numero_processo character varying(30) NOT NULL,
    status_rps smallint NOT NULL,
    codigo_verificacao_rps character varying(30),
    fk_empresa bigint NOT NULL,
    fk_cliente bigint NOT NULL,
    fk_transportadora bigint NOT NULL,
    placa_veiculo character varying(10),
    tipo_frete smallint
);


ALTER TABLE tb_nfse OWNER TO "ADMIN";

--
-- Name: tb_nfse_construcao_civil; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_construcao_civil (
    pk_nfse_construcao_civil bigint NOT NULL,
    fk_nfse bigint NOT NULL,
    codigo_obra character varying(15),
    codigo_art character varying(15),
    logradouro character varying(100),
    complemento_endereco character varying(100),
    numero_endereco character varying(10),
    bairro_endereco character varying(100),
    cep bigint,
    fk_cidade bigint,
    numero_cei_obra character varying(15),
    matricula_obra character varying(15),
    valor_reducao_base_calculo numeric(16,2),
    tipo_obra smallint
);


ALTER TABLE tb_nfse_construcao_civil OWNER TO "ADMIN";

--
-- Name: tb_nfse_construcao_civil_pk_nfse_construcao_civil_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_construcao_civil_pk_nfse_construcao_civil_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_construcao_civil_pk_nfse_construcao_civil_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_construcao_civil_pk_nfse_construcao_civil_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_construcao_civil_pk_nfse_construcao_civil_seq OWNED BY tb_nfse_construcao_civil.pk_nfse_construcao_civil;


--
-- Name: tb_nfse_deducao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_deducao (
    pk_nfse_deducao bigint NOT NULL,
    fk_nfse bigint NOT NULL,
    sequencia bigint NOT NULL,
    identificacao_valor_percentual character varying(3) NOT NULL,
    tipo_deducao character varying(3) NOT NULL,
    cnpj character varying(14),
    cpf character varying(11),
    numero_nota_fiscal_referencia bigint,
    valor_total_referencia numeric(16,2),
    percentual_deduzir numeric(16,2),
    valor_deducao numeric(16,2) NOT NULL,
    quantidade_itens numeric(16,2),
    valor_unitario numeric(16,2),
    descricao character varying(255)
);


ALTER TABLE tb_nfse_deducao OWNER TO "ADMIN";

--
-- Name: tb_nfse_deducao_pk_nfse_deducao_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_deducao_pk_nfse_deducao_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_deducao_pk_nfse_deducao_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_deducao_pk_nfse_deducao_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_deducao_pk_nfse_deducao_seq OWNED BY tb_nfse_deducao.pk_nfse_deducao;


--
-- Name: tb_nfse_intermediario; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_intermediario (
    pk_nfse_intermediario bigint NOT NULL,
    fk_nfse bigint NOT NULL,
    razao_social character varying(115) NOT NULL,
    cnpj character varying(14) NOT NULL,
    cpf character varying(11) NOT NULL,
    inscricao_municipal character varying(15),
    email character varying(100),
    endereco character varying(125),
    numero character varying(10),
    complemento character varying(60),
    bairro character varying(60),
    cep character varying(10),
    fk_cidade bigint,
    telefone character varying(11),
    inscricao_estadual character varying(40)
);


ALTER TABLE tb_nfse_intermediario OWNER TO "ADMIN";

--
-- Name: tb_nfse_intermediario_pk_nfse_intermediario_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_intermediario_pk_nfse_intermediario_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_intermediario_pk_nfse_intermediario_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_intermediario_pk_nfse_intermediario_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_intermediario_pk_nfse_intermediario_seq OWNED BY tb_nfse_intermediario.pk_nfse_intermediario;


--
-- Name: tb_nfse_item; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_item (
    pk_nfse_item bigint NOT NULL,
    fk_nfse bigint NOT NULL,
    sequencia bigint NOT NULL,
    codigo character varying(255) NOT NULL,
    descricao text NOT NULL,
    codigo_unidade_medida character varying(10),
    item_tribuitavel character varying(2),
    cnae bigint,
    codigo_tributacao_municipio character varying(20),
    numero_alvara character varying(15),
    retencao_iss smallint NOT NULL,
    responsavel_retencao smallint,
    codigo_lista_servico character varying(15) NOT NULL,
    codigo_natureza_operacao smallint NOT NULL,
    municipio_incidencia smallint,
    numero_processo character varying(30),
    tipo_deducao character varying(1),
    cpf_referencia_deducao character varying(11),
    cnpj_referencia_deducao character varying(14),
    numero_referencia_deducao bigint,
    justivificativa_deducao character varying(255),
    pais_imposto_devido character varying(2),
    cst smallint
);


ALTER TABLE tb_nfse_item OWNER TO "ADMIN";

--
-- Name: tb_nfse_item_pk_nfse_item_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_item_pk_nfse_item_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_item_pk_nfse_item_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_item_pk_nfse_item_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_item_pk_nfse_item_seq OWNED BY tb_nfse_item.pk_nfse_item;


--
-- Name: tb_nfse_item_valores; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_item_valores (
    pk_nfse_item_valores bigint NOT NULL,
    fk_nfse_item bigint NOT NULL,
    quantidade numeric(16,2) NOT NULL,
    valor_unitario numeric(16,2) NOT NULL,
    valor_liquido numeric(16,2),
    valor_total numeric(16,4),
    valor_desconto numeric(16,2),
    valor_deducao numeric(16,2),
    valor_iss numeric(16,2) NOT NULL,
    valor_aliquota_iss numeric(6,4) NOT NULL,
    base_de_calculo numeric(16,2) NOT NULL,
    valor_iss_retido numeric(16,2),
    valor_nota_referencia_deducao numeric(16,2),
    percentual_referencia_deducao numeric(16,2),
    valor_referencia_deducao numeric(16,2),
    aliquota_inss numeric(6,4),
    valor_inss numeric(16,2),
    aliquota_ir numeric(6,4),
    valor_ir numeric(16,2),
    aliquota_cofins numeric(6,4),
    valor_cofins numeric(16,2),
    aliquota_csll numeric(6,4),
    valor_csll numeric(16,2),
    aliquota_pis numeric(6,4),
    valor_pis numeric(16,2),
    reducao_base_calculo_retido numeric(16,2),
    base_calculo_retido numeric(16,2),
    aliquota_iss_retido numeric(6,4),
    outras_retencoes numeric(16,2),
    desconto_incondicionado numeric(16,2),
    desconto_condicionado numeric(16,2)
);


ALTER TABLE tb_nfse_item_valores OWNER TO "ADMIN";

--
-- Name: tb_nfse_item_valores_pk_nfse_item_valores_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_item_valores_pk_nfse_item_valores_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_item_valores_pk_nfse_item_valores_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_item_valores_pk_nfse_item_valores_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_item_valores_pk_nfse_item_valores_seq OWNED BY tb_nfse_item_valores.pk_nfse_item_valores;


--
-- Name: tb_nfse_material_construcao_civil; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_material_construcao_civil (
    pk_nfse_material_construcao_civil bigint NOT NULL,
    fk_nfse_construcao_civil bigint NOT NULL,
    codigo_material character varying(20) NOT NULL,
    descricao character varying(120) NOT NULL,
    codigo_unidade_medida character varying(20) NOT NULL,
    sigla_unidade_medida character varying(7) NOT NULL,
    quantidade smallint NOT NULL,
    valor_total numeric(16,2) NOT NULL
);


ALTER TABLE tb_nfse_material_construcao_civil OWNER TO "ADMIN";

--
-- Name: tb_nfse_material_construcao_c_pk_nfse_material_construcao_c_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_material_construcao_c_pk_nfse_material_construcao_c_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_material_construcao_c_pk_nfse_material_construcao_c_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_material_construcao_c_pk_nfse_material_construcao_c_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_material_construcao_c_pk_nfse_material_construcao_c_seq OWNED BY tb_nfse_material_construcao_civil.pk_nfse_material_construcao_civil;


--
-- Name: tb_nfse_parcelas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_parcelas (
    pk_nfse_parcelas integer NOT NULL,
    fk_nfse bigint NOT NULL,
    sequencia bigint,
    valor numeric(16,2),
    data_vencimento date,
    numero_fatura bigint,
    tipo_vencimento smallint,
    descricao_tipo_vencimento character varying(15),
    valor_liquido numeric(16,2),
    valor_desconto numeric(16,2)
);


ALTER TABLE tb_nfse_parcelas OWNER TO "ADMIN";

--
-- Name: tb_nfse_parcelas_pk_nfse_parcelas_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_parcelas_pk_nfse_parcelas_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_parcelas_pk_nfse_parcelas_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_parcelas_pk_nfse_parcelas_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_parcelas_pk_nfse_parcelas_seq OWNED BY tb_nfse_parcelas.pk_nfse_parcelas;


--
-- Name: tb_nfse_pk_nfse_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_pk_nfse_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_pk_nfse_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_pk_nfse_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_pk_nfse_seq OWNED BY tb_nfse.pk_nfse;


--
-- Name: tb_nfse_servico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_servico (
    pk_nfse_servico bigint NOT NULL,
    fk_nfse bigint NOT NULL,
    codigo_lista_servico character varying(15) NOT NULL,
    cnae bigint,
    forma_pagamento character varying(2),
    codigo_tributacao_municipio character varying(20) NOT NULL,
    descriminacao_servico text NOT NULL,
    codigo_municipio_ibge bigint NOT NULL,
    quantidade_servico numeric(16,2),
    unidade_servico character varying(10),
    numero_alvara character varying(15),
    pais_prestacao_servico character varying(2),
    municipio_incidencia bigint,
    recolhimento_imposto_outro_municipio smallint,
    forma_tributacao_iss smallint,
    cnae_municipio character varying(60),
    executado_vias_publicas smallint,
    numero_parcelas smallint,
    numero_orcamento bigint
);


ALTER TABLE tb_nfse_servico OWNER TO "ADMIN";

--
-- Name: tb_nfse_servico_local_prestacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_servico_local_prestacao (
    pk_nfse_servico_local_prestacao bigint NOT NULL,
    fk_nfse_servico bigint NOT NULL,
    tipo_logradouro character varying(40) NOT NULL,
    endereco character varying(255) NOT NULL,
    numero character varying(10) NOT NULL,
    complemento character varying(60) NOT NULL,
    bairro character varying(60) NOT NULL,
    fk_cidade bigint NOT NULL,
    cep bigint NOT NULL,
    sigla_uf character varying(2) NOT NULL
);


ALTER TABLE tb_nfse_servico_local_prestacao OWNER TO "ADMIN";

--
-- Name: tb_nfse_servico_local_prestac_pk_nfse_servico_local_prestac_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_servico_local_prestac_pk_nfse_servico_local_prestac_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_servico_local_prestac_pk_nfse_servico_local_prestac_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_servico_local_prestac_pk_nfse_servico_local_prestac_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_servico_local_prestac_pk_nfse_servico_local_prestac_seq OWNED BY tb_nfse_servico_local_prestacao.pk_nfse_servico_local_prestacao;


--
-- Name: tb_nfse_servico_pk_nfse_servico_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_servico_pk_nfse_servico_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_servico_pk_nfse_servico_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_servico_pk_nfse_servico_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_servico_pk_nfse_servico_seq OWNED BY tb_nfse_servico.pk_nfse_servico;


--
-- Name: tb_nfse_servico_valores; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_nfse_servico_valores (
    pk_nfse_servico_valores bigint NOT NULL,
    fk_nfse_servico bigint NOT NULL,
    valor_servico numeric(16,2) NOT NULL,
    valor_deducoes numeric(16,2),
    valor_pis numeric(16,2),
    valor_cofins numeric(16,2),
    valor_inss numeric(16,2),
    valor_ir numeric(16,2),
    valor_csll numeric(16,2),
    iss_retido smallint NOT NULL,
    responsavel_retencao smallint NOT NULL,
    item_tributavel character varying(1) NOT NULL,
    valor_iss numeric(16,2) NOT NULL,
    valor_iss_retido numeric(16,2),
    valor_outras_retencoes numeric(16,2),
    base_de_calculo numeric(16,2) NOT NULL,
    aliquota_iss numeric(6,4) NOT NULL,
    aliquota_pis numeric(6,4),
    aliquota_cofins numeric(6,4),
    aliquota_ir numeric(6,4),
    aliquota_csll numeric(6,4),
    aliquota_inss numeric(6,4),
    valor_liquido numeric(16,2) NOT NULL,
    valor_desconto_incondicionado numeric(16,2),
    valor_desconto_condicionado numeric(16,2) NOT NULL,
    aliquota_iss_outro_municipio numeric(6,4),
    informacao_valor_pis numeric(16,2),
    informacao_valor_cofins numeric(16,2),
    valor_liquido_total_parcelas numeric(16,2),
    base_calculo_iss_retido numeric(16,2),
    numero_fatura bigint,
    valor_carga_tributaria numeric(16,2),
    percentual_carga_tributaria numeric(9,4),
    fonte_carga_tributaria character varying(10),
    justificativa_deducao character varying(255)
);


ALTER TABLE tb_nfse_servico_valores OWNER TO "ADMIN";

--
-- Name: tb_nfse_servico_valores_pk_nfse_servico_valores_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_nfse_servico_valores_pk_nfse_servico_valores_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_nfse_servico_valores_pk_nfse_servico_valores_seq OWNER TO "ADMIN";

--
-- Name: tb_nfse_servico_valores_pk_nfse_servico_valores_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_nfse_servico_valores_pk_nfse_servico_valores_seq OWNED BY tb_nfse_servico_valores.pk_nfse_servico_valores;


SET default_with_oids = true;

--
-- Name: tb_notas_fiscais; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_notas_fiscais (
    pk_notasfiscais bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    serie character varying(3) NOT NULL,
    modelo character varying(3) NOT NULL,
    data_emissao date NOT NULL,
    total_servico numeric(15,2) NOT NULL,
    total_despesasacessorias numeric(15,2) NOT NULL,
    total_desconto numeric(15,2) NOT NULL,
    total_seguro numeric(15,2) NOT NULL,
    total_fretenota numeric(15,2) NOT NULL,
    total_base_icms numeric(15,2) NOT NULL,
    total_icms numeric(15,2) NOT NULL,
    total_base_substituicao numeric(15,2) NOT NULL,
    total_substituicao numeric(15,2) NOT NULL,
    total_ipi numeric(15,2) NOT NULL,
    total_produtos numeric(15,2) NOT NULL,
    fk_movimentacao bigint,
    total_nota numeric(15,2) DEFAULT 0 NOT NULL
);


ALTER TABLE tb_notas_fiscais OWNER TO "ADMIN";

--
-- Name: TABLE tb_notas_fiscais; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_notas_fiscais IS 'Responsvel por armazenar as informaes especficas da nota';


--
-- Name: tb_notas_fiscais_pk_notasfiscais_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_notas_fiscais_pk_notasfiscais_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_notas_fiscais_pk_notasfiscais_seq OWNER TO "ADMIN";

--
-- Name: tb_notas_fiscais_pk_notasfiscais_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_notas_fiscais_pk_notasfiscais_seq OWNED BY tb_notas_fiscais.pk_notasfiscais;


--
-- Name: tb_notificacao_cobranca; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_notificacao_cobranca (
    pk_notificacao_cobranca bigint NOT NULL,
    descricao character varying(250),
    inativo boolean DEFAULT false,
    fk_empresa bigint NOT NULL,
    fk_tipo_documento bigint NOT NULL,
    fk_configuracao_boleto bigint,
    fk_portador bigint,
    fk_configuracao_smtp bigint NOT NULL
);


ALTER TABLE tb_notificacao_cobranca OWNER TO "ADMIN";

--
-- Name: tb_notificacao_cobranca_item; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_notificacao_cobranca_item (
    pk_notificacao_cobranca_item bigint NOT NULL,
    fk_notificacao_cobranca bigint NOT NULL,
    tipo_notificacao smallint,
    quantidade_dias smallint,
    tipo_condicao smallint,
    tipo_data smallint,
    titulo_email character varying(250),
    corpo_email text
);


ALTER TABLE tb_notificacao_cobranca_item OWNER TO "ADMIN";

--
-- Name: tb_notificacao_cobranca_item_pk_notificacao_cobranca_item_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_notificacao_cobranca_item_pk_notificacao_cobranca_item_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_notificacao_cobranca_item_pk_notificacao_cobranca_item_seq OWNER TO "ADMIN";

--
-- Name: tb_notificacao_cobranca_item_pk_notificacao_cobranca_item_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_notificacao_cobranca_item_pk_notificacao_cobranca_item_seq OWNED BY tb_notificacao_cobranca_item.pk_notificacao_cobranca_item;


--
-- Name: tb_notificacao_cobranca_pk_notificacao_cobranca_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_notificacao_cobranca_pk_notificacao_cobranca_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_notificacao_cobranca_pk_notificacao_cobranca_seq OWNER TO "ADMIN";

--
-- Name: tb_notificacao_cobranca_pk_notificacao_cobranca_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_notificacao_cobranca_pk_notificacao_cobranca_seq OWNED BY tb_notificacao_cobranca.pk_notificacao_cobranca;


--
-- Name: tb_notificacao_cobranca_titulo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_notificacao_cobranca_titulo (
    pk_notificacao_cobranca_titulo bigint NOT NULL,
    fk_notificacao_cobranca_item bigint,
    fk_titulo_receber bigint,
    fk_titulo_pago bigint,
    data_notificacao timestamp without time zone,
    enviada boolean DEFAULT false,
    mensagem text
);


ALTER TABLE tb_notificacao_cobranca_titulo OWNER TO "ADMIN";

--
-- Name: tb_notificacao_cobranca_titul_pk_notificacao_cobranca_titul_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_notificacao_cobranca_titul_pk_notificacao_cobranca_titul_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_notificacao_cobranca_titul_pk_notificacao_cobranca_titul_seq OWNER TO "ADMIN";

--
-- Name: tb_notificacao_cobranca_titul_pk_notificacao_cobranca_titul_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_notificacao_cobranca_titul_pk_notificacao_cobranca_titul_seq OWNED BY tb_notificacao_cobranca_titulo.pk_notificacao_cobranca_titulo;


--
-- Name: tb_pagamento_venda; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_pagamento_venda (
    pk_pagamento bigint NOT NULL,
    fk_empresa bigint,
    sequencia_venda bigint,
    tipo_pagamento smallint,
    valor numeric(15,2)
);


ALTER TABLE tb_pagamento_venda OWNER TO "ADMIN";

--
-- Name: tb_pagamento_venda_cartao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_pagamento_venda_cartao (
    fk_pagamento_venda bigint,
    fk_pos bigint,
    bandeira smallint,
    numero_autorizacao character varying(20),
    tipo_integracao integer DEFAULT 2 NOT NULL
);


ALTER TABLE tb_pagamento_venda_cartao OWNER TO "ADMIN";

--
-- Name: COLUMN tb_pagamento_venda_cartao.tipo_integracao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pagamento_venda_cartao.tipo_integracao IS 'Tipo de integrao do carto: 1 = TEF, 2 = POS.';


--
-- Name: tb_pagamento_venda_pk_pagamento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_pagamento_venda_pk_pagamento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_pagamento_venda_pk_pagamento_seq OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: tb_pais; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_pais (
    pk_pais bigint NOT NULL,
    nome_pais character varying(200),
    codigo_bacen bigint DEFAULT 0 NOT NULL
);


ALTER TABLE tb_pais OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: tb_paramentro; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_paramentro (
    pk_parametro bigint NOT NULL,
    tipo_paramentro smallint NOT NULL,
    nome_parametro character varying(30) NOT NULL,
    rotulo_parametro character varying(30),
    tamanho_preferido smallint,
    obrigatorio boolean DEFAULT false NOT NULL
);


ALTER TABLE tb_paramentro OWNER TO "ADMIN";

--
-- Name: TABLE tb_paramentro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_paramentro IS 'Tabala que contm os parmetros que podem ser associados aos relatrios.';


--
-- Name: COLUMN tb_paramentro.tipo_paramentro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_paramentro.tipo_paramentro IS 'Define qual dos tipos de dados  o parmetro:1 - Texto (string)2 - Caractere (char)3 - Logico (bool)4 - Data (DateTime)5 - Inteiro (int)6 - Ponto Flutuante (float)7 - Ponto Flutuante Duplo (double)obs: o valor sempre ser gravado como uma string e convertido na aplicao.';


--
-- Name: COLUMN tb_paramentro.nome_parametro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_paramentro.nome_parametro IS 'Nome dado ao parmetro, esse deve ser idntico ao colocado no Design do relatrio.';


--
-- Name: tb_paramentro_pk_parametro_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_paramentro_pk_parametro_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_paramentro_pk_parametro_seq OWNER TO "ADMIN";

--
-- Name: tb_paramentro_pk_parametro_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_paramentro_pk_parametro_seq OWNED BY tb_paramentro.pk_parametro;


--
-- Name: tb_parametro_calculo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_parametro_calculo (
    pk_parametro_calculo bigint NOT NULL,
    tipo_parametro smallint NOT NULL,
    fk_tributo bigint NOT NULL,
    valor character varying(1) NOT NULL
);


ALTER TABLE tb_parametro_calculo OWNER TO "ADMIN";

--
-- Name: TABLE tb_parametro_calculo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_parametro_calculo IS 'cadastro de parametros de clculo para movimentacao de entradas O que influencia em cada tributo calculado Ex.: soma valor frete no total da nota';


--
-- Name: COLUMN tb_parametro_calculo.pk_parametro_calculo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametro_calculo.pk_parametro_calculo IS 'Chave primria da tabela.';


--
-- Name: COLUMN tb_parametro_calculo.tipo_parametro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametro_calculo.tipo_parametro IS 'tipo que referencia o valor na nota para incorporar ao calculo, conforme: -TOTAL DA NOTA -DESCONTO --TODO: PREENCHER';


--
-- Name: COLUMN tb_parametro_calculo.fk_tributo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametro_calculo.fk_tributo IS 'Referencia para o tributo a ser calculado, quando foi para um tributo o paramentro.';


--
-- Name: COLUMN tb_parametro_calculo.valor; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametro_calculo.valor IS 'campo que informa o status do parametro 0 - no marcado 1 - marcado';


--
-- Name: tb_parametro_calculo_movimentacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_parametro_calculo_movimentacao (
    fk_movimentacao bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_parametro_calculo bigint NOT NULL,
    valor smallint DEFAULT 0 NOT NULL
);


ALTER TABLE tb_parametro_calculo_movimentacao OWNER TO "ADMIN";

--
-- Name: COLUMN tb_parametro_calculo_movimentacao.fk_movimentacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametro_calculo_movimentacao.fk_movimentacao IS 'Referencia para o pedido, cujo parametro define o calculo.';


--
-- Name: COLUMN tb_parametro_calculo_movimentacao.fk_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametro_calculo_movimentacao.fk_empresa IS 'Empresa de referencia para o pedido.';


--
-- Name: COLUMN tb_parametro_calculo_movimentacao.fk_parametro_calculo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametro_calculo_movimentacao.fk_parametro_calculo IS 'Referencia para o paramentro definido.';


--
-- Name: tb_parametro_calculo_pk_parametro_calculo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_parametro_calculo_pk_parametro_calculo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_parametro_calculo_pk_parametro_calculo_seq OWNER TO "ADMIN";

--
-- Name: tb_parametro_calculo_pk_parametro_calculo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_parametro_calculo_pk_parametro_calculo_seq OWNED BY tb_parametro_calculo.pk_parametro_calculo;


--
-- Name: tb_parametro_relatorio; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_parametro_relatorio (
    fk_relatorio bigint NOT NULL,
    fk_parametro bigint NOT NULL
);


ALTER TABLE tb_parametro_relatorio OWNER TO "ADMIN";

--
-- Name: TABLE tb_parametro_relatorio; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_parametro_relatorio IS 'Ligao entre parametro e o relatorio, para definir quais so os paramentros do relatrio.';


--
-- Name: COLUMN tb_parametro_relatorio.fk_relatorio; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametro_relatorio.fk_relatorio IS 'Chave estrangeira para tb_relatorio';


--
-- Name: COLUMN tb_parametro_relatorio.fk_parametro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametro_relatorio.fk_parametro IS 'Chave estrangeira para tb_parametro.';


--
-- Name: tb_parametros_replicacao_pedido; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_parametros_replicacao_pedido (
    pk_parametros_replicacao_pedido bigint NOT NULL,
    cliente bigint NOT NULL,
    empresa bigint NOT NULL,
    tipo_formacao_preco smallint NOT NULL,
    forma_faturamento_entrada bigint NOT NULL,
    usuario bigint NOT NULL,
    fornecedor bigint NOT NULL,
    condicao_pagamento_saida bigint NOT NULL
);


ALTER TABLE tb_parametros_replicacao_pedido OWNER TO "ADMIN";

--
-- Name: COLUMN tb_parametros_replicacao_pedido.cliente; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametros_replicacao_pedido.cliente IS 'Indica quem  o cliente na base origem que deve ser utilizado para a venda da origem para o destino.';


--
-- Name: COLUMN tb_parametros_replicacao_pedido.empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametros_replicacao_pedido.empresa IS 'Codigo da empresa destino da transferencia.';


--
-- Name: COLUMN tb_parametros_replicacao_pedido.tipo_formacao_preco; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametros_replicacao_pedido.tipo_formacao_preco IS 'Enumerador que indica qual tipo de formao de preo utilizar para a venda para empresa destino. 1 - PRECO VAREJO 2 - PRECO ATACADO 3 - PRECO CUSTO';


--
-- Name: COLUMN tb_parametros_replicacao_pedido.forma_faturamento_entrada; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametros_replicacao_pedido.forma_faturamento_entrada IS 'Indica qual  a forma de faturamento deve ser utilizada para dar entrada na empresa destino.';


--
-- Name: COLUMN tb_parametros_replicacao_pedido.usuario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametros_replicacao_pedido.usuario IS 'Indica para qual usurio do sistema ser atribuida a venda.';


--
-- Name: COLUMN tb_parametros_replicacao_pedido.fornecedor; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametros_replicacao_pedido.fornecedor IS 'Aponta qual dever ser o fornecedor da entrada na empresa destino.';


--
-- Name: COLUMN tb_parametros_replicacao_pedido.condicao_pagamento_saida; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_parametros_replicacao_pedido.condicao_pagamento_saida IS 'Indica qual a condio de pagamento a ser utilizada para a empresa destino.';


--
-- Name: tb_parametros_replicacao_pedi_pk_parametros_replicacao_pedi_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_parametros_replicacao_pedi_pk_parametros_replicacao_pedi_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_parametros_replicacao_pedi_pk_parametros_replicacao_pedi_seq OWNER TO "ADMIN";

--
-- Name: tb_parametros_replicacao_pedi_pk_parametros_replicacao_pedi_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_parametros_replicacao_pedi_pk_parametros_replicacao_pedi_seq OWNED BY tb_parametros_replicacao_pedido.pk_parametros_replicacao_pedido;


SET default_with_oids = false;

--
-- Name: tb_parcela_apropriacao_icms; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_parcela_apropriacao_icms (
    pk_parcela_apropriacao_icms bigint NOT NULL,
    numero_nf bigint NOT NULL,
    data_aquisicao date NOT NULL,
    numero_parcelas integer NOT NULL,
    parcela integer NOT NULL,
    icms_total double precision NOT NULL,
    parcela_icms double precision NOT NULL,
    fk_item_compra bigint NOT NULL,
    fk_utilizacao_bem bigint NOT NULL,
    data_parcela date NOT NULL,
    status character varying(2)
);


ALTER TABLE tb_parcela_apropriacao_icms OWNER TO "ADMIN";

--
-- Name: tb_parcela_apropriacao_icms_pk_parcela_apropriacao_icms_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_parcela_apropriacao_icms_pk_parcela_apropriacao_icms_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_parcela_apropriacao_icms_pk_parcela_apropriacao_icms_seq OWNER TO "ADMIN";

--
-- Name: tb_parcela_apropriacao_icms_pk_parcela_apropriacao_icms_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_parcela_apropriacao_icms_pk_parcela_apropriacao_icms_seq OWNED BY tb_parcela_apropriacao_icms.pk_parcela_apropriacao_icms;


--
-- Name: tb_pedido_compra_numeropedido_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_pedido_compra_numeropedido_seq
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_pedido_compra_numeropedido_seq OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: tb_pedido_compra; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_pedido_compra (
    fk_movimentacao bigint NOT NULL,
    fk_fornecedor bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    situacao smallint NOT NULL,
    numeropedidofornecedor character varying(50),
    nomevendedorfornecedor character varying(100),
    numeropedido bigint DEFAULT nextval('tb_pedido_compra_numeropedido_seq'::regclass) NOT NULL
);


ALTER TABLE tb_pedido_compra OWNER TO "ADMIN";

--
-- Name: COLUMN tb_pedido_compra.situacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pedido_compra.situacao IS 'Sinalizador para a situao do pedido de comrpa, conforme: 1-FECHADO 2-CONFIRMADO 3-AUTORIZADO 4-ABERTO 5-CANCELADO';


--
-- Name: COLUMN tb_pedido_compra.numeropedidofornecedor; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pedido_compra.numeropedidofornecedor IS 'Informa o nmero do pedido do fornecedor ';


--
-- Name: COLUMN tb_pedido_compra.nomevendedorfornecedor; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pedido_compra.nomevendedorfornecedor IS 'Armazena o nome do vendedor  do fornecedor que est atendendo';


--
-- Name: tb_pedido_item_por_empresa; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_pedido_item_por_empresa (
    quantidade bigint,
    fk_empresa_destino bigint,
    fk_empresa bigint,
    fk_itempedidocompra bigint
);


ALTER TABLE tb_pedido_item_por_empresa OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: tb_pedido_mobilidade; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_pedido_mobilidade (
    pk_pedido_mobilidade character varying(25) NOT NULL,
    fk_pedido_erp bigint NOT NULL,
    data_processamento date NOT NULL,
    fk_empresa bigint NOT NULL,
    origem_registro character varying(3) NOT NULL,
    fk_pedido_mbl character varying(25)
);


ALTER TABLE tb_pedido_mobilidade OWNER TO "ADMIN";

--
-- Name: TABLE tb_pedido_mobilidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_pedido_mobilidade IS 'Entidade que mantm as informaes de ligao dos pedidos entre mobilidade e erp.';


--
-- Name: COLUMN tb_pedido_mobilidade.pk_pedido_mobilidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pedido_mobilidade.pk_pedido_mobilidade IS 'Chave primria da tabela e chave de ligao do pedido com a mobilidade quando o pedido no foi originado pela mobilidade.';


--
-- Name: COLUMN tb_pedido_mobilidade.fk_pedido_erp; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pedido_mobilidade.fk_pedido_erp IS 'Chave estrangeira que identifica o pedido no erp.';


--
-- Name: COLUMN tb_pedido_mobilidade.data_processamento; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pedido_mobilidade.data_processamento IS 'Data do processamento da transferencia entre erp e mobilidade.';


--
-- Name: COLUMN tb_pedido_mobilidade.fk_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pedido_mobilidade.fk_empresa IS 'Identificador da empresa responsvel pelo pedido.';


--
-- Name: COLUMN tb_pedido_mobilidade.origem_registro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pedido_mobilidade.origem_registro IS 'Identificador da origem do registro: erp: Sistema erp mbl: Sistema mobilidade ';


--
-- Name: COLUMN tb_pedido_mobilidade.fk_pedido_mbl; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_pedido_mobilidade.fk_pedido_mbl IS 'Chave que identifica um pedido originado na mobilidade.';


SET default_with_oids = true;

--
-- Name: tb_periodo_aviamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_periodo_aviamento (
    pk_periodo_aviamento bigint NOT NULL,
    data_inicio_periodo date,
    data_termino_periodo date,
    descricao text,
    status smallint,
    fk_empresa bigint
);


ALTER TABLE tb_periodo_aviamento OWNER TO "ADMIN";

--
-- Name: tb_periodo_aviamento_pk_periodo_aviamento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_periodo_aviamento_pk_periodo_aviamento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_periodo_aviamento_pk_periodo_aviamento_seq OWNER TO "ADMIN";

--
-- Name: tb_periodo_aviamento_pk_periodo_aviamento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_periodo_aviamento_pk_periodo_aviamento_seq OWNED BY tb_periodo_aviamento.pk_periodo_aviamento;


SET default_with_oids = false;

--
-- Name: tb_ponto_locacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_ponto_locacao (
    pk_pontolocacao bigint NOT NULL,
    descricao character varying(100) NOT NULL,
    tamanho integer,
    localizacao character varying(50),
    inativo character varying(1) DEFAULT '0'::character varying
);


ALTER TABLE tb_ponto_locacao OWNER TO "ADMIN";

--
-- Name: TABLE tb_ponto_locacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_ponto_locacao IS 'Armazena cadastro de ponto de locao dos camelodromos';


--
-- Name: COLUMN tb_ponto_locacao.tamanho; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_ponto_locacao.tamanho IS 'em m2';


--
-- Name: COLUMN tb_ponto_locacao.inativo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_ponto_locacao.inativo IS '0 - ativo 1 - inativo';


SET default_with_oids = true;

--
-- Name: tb_prazo_faturamento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_prazo_faturamento (
    fk_movimentacao bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    quantidade_dias integer NOT NULL
);


ALTER TABLE tb_prazo_faturamento OWNER TO "ADMIN";

--
-- Name: tb_preco_produto_lista; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_preco_produto_lista (
    val_preco_varejo numeric(15,4),
    val_preco_atacado numeric(15,4),
    fk_produto character varying(20) NOT NULL,
    fk_lista_precos bigint NOT NULL,
    val_markup_varejo numeric(15,4),
    val_markup_atacado numeric(15,4),
    desconto_max_varejo numeric(15,4),
    desconto_max_atacado numeric(15,4)
);


ALTER TABLE tb_preco_produto_lista OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: tb_produto_balanca_automatica; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_produto_balanca_automatica (
    fk_produto character varying(20),
    fk_unidade bigint
);


ALTER TABLE tb_produto_balanca_automatica OWNER TO "ADMIN";

SET default_with_oids = true;

--
-- Name: tb_produto_controlado_pf; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_produto_controlado_pf (
    pk_codigo bigint NOT NULL,
    fk_produto character varying(20),
    unidade character varying(2) NOT NULL,
    quantidade numeric(18,7) NOT NULL,
    fk_usuario bigint NOT NULL,
    data_alteracao date NOT NULL
);


ALTER TABLE tb_produto_controlado_pf OWNER TO "ADMIN";

--
-- Name: TABLE tb_produto_controlado_pf; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_produto_controlado_pf IS 'Armazenar os produtos que so controlados pelo orgao federal';


--
-- Name: COLUMN tb_produto_controlado_pf.fk_produto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_produto_controlado_pf.fk_produto IS 'Codigo do produto controlado';


--
-- Name: COLUMN tb_produto_controlado_pf.unidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_produto_controlado_pf.unidade IS 'Unidade';


--
-- Name: COLUMN tb_produto_controlado_pf.quantidade; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_produto_controlado_pf.quantidade IS 'Quantidade limite';


--
-- Name: COLUMN tb_produto_controlado_pf.fk_usuario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_produto_controlado_pf.fk_usuario IS 'Usurio que criou/alterou pela ultima vez';


--
-- Name: COLUMN tb_produto_controlado_pf.data_alteracao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_produto_controlado_pf.data_alteracao IS 'Data da criao/alterao';


--
-- Name: tb_promocao_lista_preco; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_promocao_lista_preco (
    fk_produto character varying(20) NOT NULL,
    fk_lista_precos bigint NOT NULL,
    val_promocao_varejo numeric(15,4),
    val_promocao_atacado numeric(15,4),
    dat_inicio_promocao date,
    dat_termino_promocao date,
    desconto_max_varejo numeric(15,4),
    desconto_max_atacado numeric(15,4)
);


ALTER TABLE tb_promocao_lista_preco OWNER TO "ADMIN";

--
-- Name: tb_propriedades_tributacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_propriedades_tributacao (
    pk_codigo integer NOT NULL,
    pk_empresa integer NOT NULL,
    fk_formafaturamento integer NOT NULL,
    fk_cadastrotributacao integer NOT NULL,
    origem_mercadoria character varying(2) NOT NULL,
    cst character varying(3) NOT NULL,
    aliquota_icms numeric(15,2),
    reducao_baseicms numeric(15,4) NOT NULL,
    iva numeric(15,2) NOT NULL,
    aliquota_icms_subst numeric(15,2),
    reducao_base_icms_subst numeric(15,4) NOT NULL,
    calcula_ipi character varying(1) NOT NULL,
    inclui_ipi_base_icms character varying(1) NOT NULL,
    cst_ipi character varying(3) NOT NULL,
    cst_pis character varying(3) NOT NULL,
    aliquota_pis numeric(15,2) NOT NULL,
    cst_cofins character varying(3) NOT NULL,
    aliquota_cofins numeric(15,2) NOT NULL,
    codigo_cfop integer NOT NULL,
    estado character varying(2) NOT NULL,
    codigo_natureza_receita integer,
    codigo_estado integer NOT NULL,
    fk_aliquotaicms bigint,
    fk_aliquotaicmssubst bigint,
    calcula_dif_aliq_subst character varying(1) DEFAULT 0 NOT NULL,
    fk_aliquotaredcf bigint,
    percentual_diferencial_aliquota numeric(15,2) DEFAULT 0 NOT NULL,
    aliquota_icms_destino numeric(15,4),
    aliquota_fcp numeric(15,4),
    calcular_icms_compartilhado smallint
);


ALTER TABLE tb_propriedades_tributacao OWNER TO "ADMIN";

--
-- Name: TABLE tb_propriedades_tributacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_propriedades_tributacao IS 'Responsel por armazenar as propriedades da tributao por grupo (cadastro tributacao - estado - CFOP  e a forma faturamento)';


--
-- Name: COLUMN tb_propriedades_tributacao.calcula_dif_aliq_subst; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_propriedades_tributacao.calcula_dif_aliq_subst IS 'Responsel por armazenar as propriedades da tributao por grupo (cadastro tributacao - estado - CFOP  e a forma faturamento)';


--
-- Name: COLUMN tb_propriedades_tributacao.fk_aliquotaredcf; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_propriedades_tributacao.fk_aliquotaredcf IS 'Armazenar o ID do cadastro de aliquota relativo ao percentual do icms reduo do cupom fiscal ';


--
-- Name: COLUMN tb_propriedades_tributacao.percentual_diferencial_aliquota; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_propriedades_tributacao.percentual_diferencial_aliquota IS 'Armazena percentual do icms interno para quando houver clculo do diferencial de aliquota';


SET default_with_oids = false;

--
-- Name: tb_rastreabilidade; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_rastreabilidade (
    pk_rastreabilidade bigint NOT NULL,
    identificador character varying(50) NOT NULL,
    fk_produto character varying(20) NOT NULL,
    descricao character varying(50) NOT NULL,
    quantidade_inicial double precision NOT NULL,
    quantidade_atual double precision NOT NULL,
    data_entrada date NOT NULL
);


ALTER TABLE tb_rastreabilidade OWNER TO "ADMIN";

--
-- Name: tb_rastreabilidade_movimento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_rastreabilidade_movimento (
    pk_rastreabilidade_movimento bigint NOT NULL,
    fk_rastreabilidade bigint NOT NULL,
    data_movimento date NOT NULL,
    quantidade double precision NOT NULL
);


ALTER TABLE tb_rastreabilidade_movimento OWNER TO "ADMIN";

--
-- Name: tb_rastreabilidade_movimento_documento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_rastreabilidade_movimento_documento (
    pk_rastreabilidade_mov_documento bigint NOT NULL,
    tipo_movimentacao character varying(2) NOT NULL,
    fk_rastreabilidade_movimento bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_item_saida bigint,
    fk_item_entrada bigint,
    fk_item_devolvida bigint,
    fk_item_cancelada bigint,
    fk_item_orcamento bigint
);


ALTER TABLE tb_rastreabilidade_movimento_documento OWNER TO "ADMIN";

--
-- Name: tb_rastreabilidade_movimento__pk_rastreabilidade_mov_docume_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_rastreabilidade_movimento__pk_rastreabilidade_mov_docume_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_rastreabilidade_movimento__pk_rastreabilidade_mov_docume_seq OWNER TO "ADMIN";

--
-- Name: tb_rastreabilidade_movimento__pk_rastreabilidade_mov_docume_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_rastreabilidade_movimento__pk_rastreabilidade_mov_docume_seq OWNED BY tb_rastreabilidade_movimento_documento.pk_rastreabilidade_mov_documento;


--
-- Name: tb_rastreabilidade_movimento_pk_rastreabilidade_movimento_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_rastreabilidade_movimento_pk_rastreabilidade_movimento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_rastreabilidade_movimento_pk_rastreabilidade_movimento_seq OWNER TO "ADMIN";

--
-- Name: tb_rastreabilidade_movimento_pk_rastreabilidade_movimento_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_rastreabilidade_movimento_pk_rastreabilidade_movimento_seq OWNED BY tb_rastreabilidade_movimento.pk_rastreabilidade_movimento;


--
-- Name: tb_rastreabilidade_pk_rastreabilidade_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_rastreabilidade_pk_rastreabilidade_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_rastreabilidade_pk_rastreabilidade_seq OWNER TO "ADMIN";

--
-- Name: tb_rastreabilidade_pk_rastreabilidade_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_rastreabilidade_pk_rastreabilidade_seq OWNED BY tb_rastreabilidade.pk_rastreabilidade;


SET default_with_oids = true;

--
-- Name: tb_reg_painel_controle; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_reg_painel_controle (
    pk_reg_painel_controle bigint NOT NULL,
    descricao character varying(80),
    tipo_registro integer
);


ALTER TABLE tb_reg_painel_controle OWNER TO "ADMIN";

--
-- Name: tb_reg_painel_controle_pk_reg_painel_controle_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_reg_painel_controle_pk_reg_painel_controle_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_reg_painel_controle_pk_reg_painel_controle_seq OWNER TO "ADMIN";

--
-- Name: tb_reg_painel_controle_pk_reg_painel_controle_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_reg_painel_controle_pk_reg_painel_controle_seq OWNED BY tb_reg_painel_controle.pk_reg_painel_controle;


--
-- Name: tb_rel_cadlinha_produto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_rel_cadlinha_produto (
    fk_produto character varying(20),
    fk_linhaproduto bigint
);


ALTER TABLE tb_rel_cadlinha_produto OWNER TO "ADMIN";

--
-- Name: TABLE tb_rel_cadlinha_produto; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_rel_cadlinha_produto IS 'Responsvel por armazenar o relacionamento entre tb_cad_linhaproduto com cadastro de produtos';


--
-- Name: tb_relacao_pagar_com_receber; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_relacao_pagar_com_receber (
    pk_relacao_pagar_com_receber bigint NOT NULL,
    fk_empresa bigint,
    fk_titulo_recebido bigint,
    fk_titulo_pago bigint
);


ALTER TABLE tb_relacao_pagar_com_receber OWNER TO "ADMIN";

--
-- Name: tb_relacao_pagar_com_receber_pk_relacao_pagar_com_receber_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_relacao_pagar_com_receber_pk_relacao_pagar_com_receber_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_relacao_pagar_com_receber_pk_relacao_pagar_com_receber_seq OWNER TO "ADMIN";

--
-- Name: tb_relacao_pagar_com_receber_pk_relacao_pagar_com_receber_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_relacao_pagar_com_receber_pk_relacao_pagar_com_receber_seq OWNED BY tb_relacao_pagar_com_receber.pk_relacao_pagar_com_receber;


SET default_with_oids = false;

--
-- Name: tb_relatorio; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_relatorio (
    pk_relatorio bigint NOT NULL,
    descricao_relatorio character varying(100),
    nome_apresentacao character varying(30) NOT NULL,
    arquivo_relatorio character varying(100) NOT NULL,
    fk_assunto_relatorio bigint NOT NULL
);


ALTER TABLE tb_relatorio OWNER TO "ADMIN";

--
-- Name: TABLE tb_relatorio; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_relatorio IS 'Repositorio contendo os relatorios do jasper reports.';


--
-- Name: COLUMN tb_relatorio.descricao_relatorio; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_relatorio.descricao_relatorio IS 'Texto contendo a descricao do propsito do relatrio.';


--
-- Name: COLUMN tb_relatorio.nome_apresentacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_relatorio.nome_apresentacao IS 'Nome que ser apresentado na camada de viso para acesso ao relatrio.';


--
-- Name: COLUMN tb_relatorio.arquivo_relatorio; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_relatorio.arquivo_relatorio IS 'referencia do arquivo que contem o layout do relatorio (jasper). ';


--
-- Name: tb_relatorio_pk_relatorio_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_relatorio_pk_relatorio_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_relatorio_pk_relatorio_seq OWNER TO "ADMIN";

--
-- Name: tb_relatorio_pk_relatorio_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_relatorio_pk_relatorio_seq OWNED BY tb_relatorio.pk_relatorio;


--
-- Name: tb_remessa_boleto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_remessa_boleto (
    pk_remessa_boleto bigint NOT NULL,
    data_geracao timestamp without time zone NOT NULL,
    nome_arquivo character varying(255) NOT NULL
);


ALTER TABLE tb_remessa_boleto OWNER TO "ADMIN";

--
-- Name: tb_remessa_boleto_item; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_remessa_boleto_item (
    pk_remessa_boleto_item bigint NOT NULL,
    fk_remessa_boleto bigint NOT NULL,
    fk_boleto bigint NOT NULL
);


ALTER TABLE tb_remessa_boleto_item OWNER TO "ADMIN";

--
-- Name: tb_remessa_boleto_item_pk_remessa_boleto_item_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_remessa_boleto_item_pk_remessa_boleto_item_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_remessa_boleto_item_pk_remessa_boleto_item_seq OWNER TO "ADMIN";

--
-- Name: tb_remessa_boleto_item_pk_remessa_boleto_item_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_remessa_boleto_item_pk_remessa_boleto_item_seq OWNED BY tb_remessa_boleto_item.pk_remessa_boleto_item;


--
-- Name: tb_remessa_boleto_pk_remessa_boleto_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_remessa_boleto_pk_remessa_boleto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_remessa_boleto_pk_remessa_boleto_seq OWNER TO "ADMIN";

--
-- Name: tb_remessa_boleto_pk_remessa_boleto_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_remessa_boleto_pk_remessa_boleto_seq OWNED BY tb_remessa_boleto.pk_remessa_boleto;


SET default_with_oids = true;

--
-- Name: tb_retencao_servico; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_retencao_servico (
    pk_retencao_servico bigint NOT NULL,
    fk_cliente bigint,
    periodo_retencao date,
    valor_acumulado numeric(15,4)
);


ALTER TABLE tb_retencao_servico OWNER TO "ADMIN";

--
-- Name: tb_retencao_servico_pk_retencao_servico_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_retencao_servico_pk_retencao_servico_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_retencao_servico_pk_retencao_servico_seq OWNER TO "ADMIN";

--
-- Name: tb_retencao_servico_pk_retencao_servico_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_retencao_servico_pk_retencao_servico_seq OWNED BY tb_retencao_servico.pk_retencao_servico;


SET default_with_oids = false;

--
-- Name: tb_rps_substituido; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_rps_substituido (
    pk_rps_substituido bigint NOT NULL,
    fk_nfse bigint NOT NULL,
    numero_rps_substituido bigint NOT NULL,
    serie_rps character(5) NOT NULL,
    tipo_rps smallint NOT NULL,
    numero_nfse_subistituida bigint
);


ALTER TABLE tb_rps_substituido OWNER TO "ADMIN";

--
-- Name: tb_rps_substituido_pk_rps_substituido_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_rps_substituido_pk_rps_substituido_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_rps_substituido_pk_rps_substituido_seq OWNER TO "ADMIN";

--
-- Name: tb_rps_substituido_pk_rps_substituido_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_rps_substituido_pk_rps_substituido_seq OWNED BY tb_rps_substituido.pk_rps_substituido;


--
-- Name: tb_sazonalidade_metas; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_sazonalidade_metas (
    pk_sazonalidade_metas bigint NOT NULL,
    tipo smallint NOT NULL,
    descricao character varying(250) NOT NULL
);


ALTER TABLE tb_sazonalidade_metas OWNER TO "ADMIN";

--
-- Name: tb_sazonalidade_metas_pk_sazonalidade_metas_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_sazonalidade_metas_pk_sazonalidade_metas_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_sazonalidade_metas_pk_sazonalidade_metas_seq OWNER TO "ADMIN";

--
-- Name: tb_sazonalidade_metas_pk_sazonalidade_metas_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_sazonalidade_metas_pk_sazonalidade_metas_seq OWNED BY tb_sazonalidade_metas.pk_sazonalidade_metas;


SET default_with_oids = true;

--
-- Name: tb_solicitacao_compras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_solicitacao_compras (
    fk_empresa bigint NOT NULL,
    data_emissao date,
    fk_usuario bigint,
    fk_produto character varying(20),
    fk_cliente bigint,
    validade date,
    quantidade numeric(22,5),
    observacao character varying(200),
    situacao character varying(1),
    pk_pedidocompraautomatico bigint NOT NULL,
    fk_movimentacao bigint
);


ALTER TABLE tb_solicitacao_compras OWNER TO "ADMIN";

--
-- Name: TABLE tb_solicitacao_compras; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_solicitacao_compras IS 'Responsvel por armazenar as solicitaes de compras da empresa que depois iro virar pedidos de compra';


--
-- Name: COLUMN tb_solicitacao_compras.situacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_solicitacao_compras.situacao IS 'Determina a situao que originou o solicitacao de compra  1) Perda de venda 2) Perda Reserva 3) Pelo Estoquista 4) Solicitacao do Cliente';


--
-- Name: tb_solicitacao_compras_pk_pedidocompraautomatico_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_solicitacao_compras_pk_pedidocompraautomatico_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_solicitacao_compras_pk_pedidocompraautomatico_seq OWNER TO "ADMIN";

--
-- Name: tb_solicitacao_compras_pk_pedidocompraautomatico_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_solicitacao_compras_pk_pedidocompraautomatico_seq OWNED BY tb_solicitacao_compras.pk_pedidocompraautomatico;


SET default_with_oids = false;

--
-- Name: tb_template_email_nfse; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_template_email_nfse (
    pk_codigo bigint NOT NULL,
    assunto character varying(255),
    titulo character varying(255),
    mensagem character varying(255),
    endereco_imagem character varying(255)
);


ALTER TABLE tb_template_email_nfse OWNER TO "ADMIN";

--
-- Name: tb_template_email_nfse_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_template_email_nfse_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_template_email_nfse_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: tb_template_email_nfse_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_template_email_nfse_pk_codigo_seq OWNED BY tb_template_email_nfse.pk_codigo;


--
-- Name: tb_template_mensagem_boleto; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_template_mensagem_boleto (
    pk_codigo bigint NOT NULL,
    mensagem text
);


ALTER TABLE tb_template_mensagem_boleto OWNER TO "ADMIN";

--
-- Name: tb_template_mensagem_boleto_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_template_mensagem_boleto_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_template_mensagem_boleto_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: tb_template_mensagem_boleto_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_template_mensagem_boleto_pk_codigo_seq OWNED BY tb_template_mensagem_boleto.pk_codigo;


--
-- Name: tb_template_nfse; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_template_nfse (
    pk_codigo bigint NOT NULL,
    codigo_cliente bigint,
    codigo_servico character varying(250),
    codigo_portador bigint,
    codigo_tipo_documento bigint,
    dia_vencimento bigint,
    valor double precision,
    template_padrao smallint
);


ALTER TABLE tb_template_nfse OWNER TO "ADMIN";

--
-- Name: tb_template_nfse_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_template_nfse_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_template_nfse_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: tb_template_nfse_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_template_nfse_pk_codigo_seq OWNED BY tb_template_nfse.pk_codigo;


--
-- Name: tb_tipo_documento_titulo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_tipo_documento_titulo (
    pk_tipo_documento_titulo bigint NOT NULL,
    fk_empresa bigint,
    fk_tipo_documento_receber bigint,
    fk_tipo_documento_pagar bigint,
    fk_titulo_receber bigint,
    fk_titulo_recebido bigint,
    fk_titulo_pagar bigint,
    fk_titulo_pago bigint
);


ALTER TABLE tb_tipo_documento_titulo OWNER TO "ADMIN";

--
-- Name: tb_tipo_documento_titulo_pk_tipo_documento_titulo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_tipo_documento_titulo_pk_tipo_documento_titulo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_tipo_documento_titulo_pk_tipo_documento_titulo_seq OWNER TO "ADMIN";

--
-- Name: tb_tipo_documento_titulo_pk_tipo_documento_titulo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_tipo_documento_titulo_pk_tipo_documento_titulo_seq OWNED BY tb_tipo_documento_titulo.pk_tipo_documento_titulo;


SET default_with_oids = true;

--
-- Name: tb_titulo_gerado_baixa; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_titulo_gerado_baixa (
    pk_titulo_gerado_baixa bigint NOT NULL,
    fk_empresa bigint,
    fk_titulo_recebido bigint,
    fk_titulo_receber bigint,
    fk_titulo_pago bigint,
    fk_titulo_pagar bigint
);


ALTER TABLE tb_titulo_gerado_baixa OWNER TO "ADMIN";

--
-- Name: tb_titulo_gerado_baixa_pk_titulo_gerado_baixa_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_titulo_gerado_baixa_pk_titulo_gerado_baixa_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_titulo_gerado_baixa_pk_titulo_gerado_baixa_seq OWNER TO "ADMIN";

--
-- Name: tb_titulo_gerado_baixa_pk_titulo_gerado_baixa_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_titulo_gerado_baixa_pk_titulo_gerado_baixa_seq OWNED BY tb_titulo_gerado_baixa.pk_titulo_gerado_baixa;


SET default_with_oids = false;

--
-- Name: tb_transferencia_portadores; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_transferencia_portadores (
    pk_transferencia_portadores bigint NOT NULL,
    fk_movimento_origem bigint NOT NULL,
    fk_movimento_destino bigint NOT NULL,
    data_transferencia date NOT NULL,
    valor_transferencia double precision NOT NULL
);


ALTER TABLE tb_transferencia_portadores OWNER TO "ADMIN";

--
-- Name: tb_transferencia_portadores_pk_transferencia_portadores_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_transferencia_portadores_pk_transferencia_portadores_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_transferencia_portadores_pk_transferencia_portadores_seq OWNER TO "ADMIN";

--
-- Name: tb_transferencia_portadores_pk_transferencia_portadores_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_transferencia_portadores_pk_transferencia_portadores_seq OWNED BY tb_transferencia_portadores.pk_transferencia_portadores;


--
-- Name: tb_transferencia_portadores_titulos; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_transferencia_portadores_titulos (
    pk_tranferencia_portadores_titulos bigint NOT NULL,
    fk_transferencia_portadores bigint NOT NULL,
    fk_titulo bigint NOT NULL,
    valor_titulo double precision NOT NULL
);


ALTER TABLE tb_transferencia_portadores_titulos OWNER TO "ADMIN";

--
-- Name: tb_transferencia_portadores_t_pk_tranferencia_portadores_ti_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_transferencia_portadores_t_pk_tranferencia_portadores_ti_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_transferencia_portadores_t_pk_tranferencia_portadores_ti_seq OWNER TO "ADMIN";

--
-- Name: tb_transferencia_portadores_t_pk_tranferencia_portadores_ti_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_transferencia_portadores_t_pk_tranferencia_portadores_ti_seq OWNED BY tb_transferencia_portadores_titulos.pk_tranferencia_portadores_titulos;


SET default_with_oids = true;

--
-- Name: tb_transporte; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_transporte (
    pk_transporte bigint NOT NULL,
    valor_frete numeric(15,4) NOT NULL,
    valor_seguro numeric(15,4) NOT NULL,
    valor_conhecimento_frete numeric(15,4) NOT NULL,
    valor_icms_conhecimento_frete numeric(15,4) NOT NULL,
    fk_transportadora bigint,
    tipo_frete smallint NOT NULL,
    fk_empresa bigint NOT NULL
);


ALTER TABLE tb_transporte OWNER TO "ADMIN";

--
-- Name: TABLE tb_transporte; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON TABLE tb_transporte IS 'Aramzena valores referentes a transportes originados da movimentao';


--
-- Name: COLUMN tb_transporte.pk_transporte; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_transporte.pk_transporte IS 'Chave primria da tabela.';


--
-- Name: COLUMN tb_transporte.valor_frete; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_transporte.valor_frete IS 'Valor do frete associado ao transporte.';


--
-- Name: COLUMN tb_transporte.valor_seguro; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_transporte.valor_seguro IS 'Valor do seguro contrado para o transporte.';


--
-- Name: COLUMN tb_transporte.valor_conhecimento_frete; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_transporte.valor_conhecimento_frete IS 'Valor do conhecimento de frete.';


--
-- Name: COLUMN tb_transporte.valor_icms_conhecimento_frete; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_transporte.valor_icms_conhecimento_frete IS 'valor do icms agregado ao conhecimento de frete.';


--
-- Name: COLUMN tb_transporte.fk_transportadora; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_transporte.fk_transportadora IS 'Referencia para a tranportadora responsavel pelo transporte.';


--
-- Name: COLUMN tb_transporte.tipo_frete; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_transporte.tipo_frete IS 'Informa o tipo de frete 1 - CIF 2 - FOB ';


--
-- Name: tb_transporte_pk_transporte_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_transporte_pk_transporte_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_transporte_pk_transporte_seq OWNER TO "ADMIN";

--
-- Name: tb_transporte_pk_transporte_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_transporte_pk_transporte_seq OWNED BY tb_transporte.pk_transporte;


--
-- Name: tb_tributo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_tributo (
    pk_tributo bigint NOT NULL,
    tipo_tributo smallint NOT NULL,
    tipo_valor_tributo smallint NOT NULL
);


ALTER TABLE tb_tributo OWNER TO "ADMIN";

--
-- Name: COLUMN tb_tributo.pk_tributo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_tributo.pk_tributo IS 'Chave primria da tabela.';


--
-- Name: COLUMN tb_tributo.tipo_tributo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_tributo.tipo_tributo IS 'Tipo que referencia o tributo para o sistema: 1-ICMS 2-IPI 3-PIS 4-COFINS 5-IVA 6-ICMS SUBSTITUICAO 7-REDUCAO ICMS 8-REDUCAO ICMS SUBSTITUICAO 9-BASE CALCULO SUBSTITUICAO 10-BASE CALCULO ICMS';


--
-- Name: COLUMN tb_tributo.tipo_valor_tributo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_tributo.tipo_valor_tributo IS 'Tipo do valodo do tributo: 1-PERCENTUAL 2-VALOR';


--
-- Name: tb_tributo_itemmovimentacao; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_tributo_itemmovimentacao (
    fk_item_movimentacao bigint NOT NULL,
    fk_movimentacao bigint NOT NULL,
    fk_empresa bigint NOT NULL,
    fk_tributo bigint NOT NULL,
    valor_tributo numeric(15,4) NOT NULL
);


ALTER TABLE tb_tributo_itemmovimentacao OWNER TO "ADMIN";

--
-- Name: COLUMN tb_tributo_itemmovimentacao.fk_item_movimentacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_tributo_itemmovimentacao.fk_item_movimentacao IS 'Identificador do item de pedido cujo tributo est associado.';


--
-- Name: COLUMN tb_tributo_itemmovimentacao.fk_movimentacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_tributo_itemmovimentacao.fk_movimentacao IS 'Pedido referenciado pelo item.';


--
-- Name: COLUMN tb_tributo_itemmovimentacao.fk_empresa; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_tributo_itemmovimentacao.fk_empresa IS 'Empresa referenciada';


--
-- Name: COLUMN tb_tributo_itemmovimentacao.fk_tributo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_tributo_itemmovimentacao.fk_tributo IS 'Tributo referenciado e aplicado ao item.';


--
-- Name: COLUMN tb_tributo_itemmovimentacao.valor_tributo; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_tributo_itemmovimentacao.valor_tributo IS 'Valor real do tributo, podendo ser expresso em percentual ou em especie.';


--
-- Name: tb_tributo_pk_tributo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_tributo_pk_tributo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_tributo_pk_tributo_seq OWNER TO "ADMIN";

--
-- Name: tb_tributo_pk_tributo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_tributo_pk_tributo_seq OWNED BY tb_tributo.pk_tributo;


SET default_with_oids = false;

--
-- Name: tb_unidade_secundaria; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_unidade_secundaria (
    pk_codigo bigint NOT NULL,
    fk_unidade_secundaria bigint NOT NULL,
    fk_unidade bigint NOT NULL,
    fator_conversao numeric(15,6) NOT NULL,
    perc_forma_preco numeric(15,4) DEFAULT 0 NOT NULL,
    unidade_tributavel_exportacao boolean DEFAULT false NOT NULL
);


ALTER TABLE tb_unidade_secundaria OWNER TO "ADMIN";

--
-- Name: COLUMN tb_unidade_secundaria.perc_forma_preco; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_unidade_secundaria.perc_forma_preco IS 'Percentual para formao do preo de venda da unidade secundria.';


--
-- Name: COLUMN tb_unidade_secundaria.unidade_tributavel_exportacao; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_unidade_secundaria.unidade_tributavel_exportacao IS 'Verdadeiro: UnidadeTributvel padro para operao de exportao (uTrib)';


--
-- Name: tb_unidade_secundaria_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_unidade_secundaria_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_unidade_secundaria_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: tb_unidade_secundaria_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_unidade_secundaria_pk_codigo_seq OWNED BY tb_unidade_secundaria.pk_codigo;


SET default_with_oids = true;

--
-- Name: tb_unidadesecundaria_codigobarras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_unidadesecundaria_codigobarras (
    fk_produto character varying(20) NOT NULL,
    fk_unidade_secundaria bigint NOT NULL,
    fk_codigo_barras character varying(100) NOT NULL,
    fk_empresa bigint,
    automatico smallint DEFAULT 0 NOT NULL
);


ALTER TABLE tb_unidadesecundaria_codigobarras OWNER TO "ADMIN";

--
-- Name: COLUMN tb_unidadesecundaria_codigobarras.automatico; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tb_unidadesecundaria_codigobarras.automatico IS 'Define se busca unidade secundria automaticamente pelo cdigo de barras: 0 - No, 1 - Sim';


--
-- Name: tb_usuario_logado; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_usuario_logado (
    fk_licenca bigint NOT NULL,
    fk_usuario bigint NOT NULL,
    numero_ip character varying(100)
);


ALTER TABLE tb_usuario_logado OWNER TO "ADMIN";

SET default_with_oids = false;

--
-- Name: tb_utilizacao_bem; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_utilizacao_bem (
    pk_utilizacao_bem bigint NOT NULL,
    descricao character varying(100) NOT NULL,
    vida_util integer,
    fk_centro_custo bigint NOT NULL
);


ALTER TABLE tb_utilizacao_bem OWNER TO "ADMIN";

--
-- Name: tb_utilizacao_bem_pk_utilizacao_bem_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_utilizacao_bem_pk_utilizacao_bem_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_utilizacao_bem_pk_utilizacao_bem_seq OWNER TO "ADMIN";

--
-- Name: tb_utilizacao_bem_pk_utilizacao_bem_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_utilizacao_bem_pk_utilizacao_bem_seq OWNED BY tb_utilizacao_bem.pk_utilizacao_bem;


--
-- Name: tb_utilizacao_bem_tmp; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tb_utilizacao_bem_tmp (
    pk_utilizacao_bem_tmp bigint NOT NULL,
    descricao character varying(60),
    vida_util integer,
    fk_centro_custo bigint
);


ALTER TABLE tb_utilizacao_bem_tmp OWNER TO "ADMIN";

--
-- Name: tb_utilizacao_bem_tmp_pk_utilizacao_bem_tmp_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tb_utilizacao_bem_tmp_pk_utilizacao_bem_tmp_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tb_utilizacao_bem_tmp_pk_utilizacao_bem_tmp_seq OWNER TO "ADMIN";

--
-- Name: tb_utilizacao_bem_tmp_pk_utilizacao_bem_tmp_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tb_utilizacao_bem_tmp_pk_utilizacao_bem_tmp_seq OWNED BY tb_utilizacao_bem_tmp.pk_utilizacao_bem_tmp;


SET default_with_oids = true;

--
-- Name: tipo_codigo_barras; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tipo_codigo_barras (
    descricao character varying(50),
    numero_digitos integer,
    codigo integer NOT NULL
);


ALTER TABLE tipo_codigo_barras OWNER TO "ADMIN";

--
-- Name: tipo_codigo_barras_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE tipo_codigo_barras_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tipo_codigo_barras_codigo_seq OWNER TO "ADMIN";

--
-- Name: tipo_codigo_barras_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE tipo_codigo_barras_codigo_seq OWNED BY tipo_codigo_barras.codigo;


--
-- Name: tipo_documento; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tipo_documento (
    codigo bigint NOT NULL,
    filial bigint,
    descricao character varying(100),
    conta character varying(10),
    venda_vista bigint DEFAULT 0,
    influencia_comissao smallint DEFAULT 0,
    atualizacarteira smallint DEFAULT 1,
    documento_venda smallint DEFAULT 0,
    empresa bigint,
    tipo bigint DEFAULT 0,
    padrao_cad_cliente smallint DEFAULT 0 NOT NULL,
    ignora_limite_credito smallint,
    lanca_caixa_geral boolean DEFAULT false,
    ignora_debito_aberto smallint DEFAULT 0 NOT NULL,
    mostra_parcelamento_nfe boolean DEFAULT false,
    ignora_restricao_spc smallint DEFAULT 0 NOT NULL,
    padrao_troca boolean DEFAULT false
);


ALTER TABLE tipo_documento OWNER TO "ADMIN";

--
-- Name: COLUMN tipo_documento.ignora_restricao_spc; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN tipo_documento.ignora_restricao_spc IS 'Informa se ignora restrio no spc: 0 - No ignora; 1 - Ignora';


--
-- Name: tipo_documento_pagar; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tipo_documento_pagar (
    codigo bigint NOT NULL,
    filial bigint,
    descricao character varying(100),
    conta character varying(10),
    empresa bigint
);


ALTER TABLE tipo_documento_pagar OWNER TO "ADMIN";

--
-- Name: tipo_sistema; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE tipo_sistema (
    empresa bigint,
    nome character varying(100),
    liberacao bigint
);


ALTER TABLE tipo_sistema OWNER TO "ADMIN";

--
-- Name: transportadora; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE transportadora (
    codigo bigint NOT NULL,
    nome character varying(100),
    fantasia character varying(100),
    endereco character varying(100),
    bairro character varying(100),
    cidade character varying(100),
    uf character varying(2),
    cep character varying(8),
    telefone character varying(13),
    fax character varying(13),
    postal character varying(20),
    e_mail character varying(100),
    cgc character varying(14),
    inscricao_estadual character varying(20),
    ponto_referencia character varying(100),
    conta_contabil bigint,
    cpf character varying(11),
    identidade character varying(14),
    orgao_emissao character varying(10),
    pessoa smallint DEFAULT 2,
    empresa bigint,
    antt character varying DEFAULT ''::character varying,
    codigo_cidade bigint
);


ALTER TABLE transportadora OWNER TO "ADMIN";

--
-- Name: unidade_secundaria; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE unidade_secundaria (
    empresa bigint,
    codigo character varying(20),
    unidade character varying(6),
    fator_operacao numeric(15,4),
    codigo_unidade smallint,
    pk_codigo bigint NOT NULL
);


ALTER TABLE unidade_secundaria OWNER TO "ADMIN";

--
-- Name: unidade_secundaria_pk_codigo_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE unidade_secundaria_pk_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE unidade_secundaria_pk_codigo_seq OWNER TO "ADMIN";

--
-- Name: unidade_secundaria_pk_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE unidade_secundaria_pk_codigo_seq OWNED BY unidade_secundaria.pk_codigo;


--
-- Name: usando_pedido; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE usando_pedido (
    empresa bigint,
    usuario bigint,
    pedido bigint,
    maquina character varying
);


ALTER TABLE usando_pedido OWNER TO "ADMIN";

--
-- Name: usuario; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE usuario (
    codigo bigint NOT NULL,
    nome character varying(100),
    senha character varying(15),
    tipo_de_acesso bigint,
    inativo bigint,
    empresa bigint
);


ALTER TABLE usuario OWNER TO "ADMIN";

--
-- Name: variacao_preco; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE variacao_preco (
    codigo character varying(20),
    subcodigo character varying(20),
    banho character varying(30),
    tipo character varying(10),
    modelo character varying(30),
    codigo_do_grupo character varying(20),
    descricao character varying(100),
    data_alteracao date,
    preco_varejo numeric(15,4),
    preco_atacado numeric(15,4),
    custo numeric(18,7),
    custo_medio numeric(18,7),
    usuario bigint,
    horario time without time zone,
    status character varying(2)
);


ALTER TABLE variacao_preco OWNER TO "ADMIN";

--
-- Name: veiculo; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE veiculo (
    codigo bigint NOT NULL,
    placa character varying(50),
    frota character varying(50),
    chassis character varying(50),
    renavan character varying(50),
    fabricacao character varying(50),
    marca character varying(100),
    cor character varying(100),
    tipo character varying(50),
    licenciamento date,
    ipva date,
    proprietario character varying(100),
    cpf character varying(20),
    cgc character varying(50),
    endereco character varying(100),
    bairro character varying(100),
    municipio character varying(100),
    uf character varying(3),
    motorista character varying(100),
    cpf_motorista character varying(20),
    identidade character varying(30),
    endereco_motorista character varying(100),
    bairro_motorista character varying(100),
    municipio_motorista character varying(100),
    uf_motorista character varying(3),
    data_cadastro timestamp without time zone,
    data_alteracao timestamp without time zone,
    marca_carroceria character varying(100),
    carroceria character varying(50),
    chassis_carroceria character varying(100),
    fabricacao_carroceria character varying(10),
    renavan_carroceria character varying(50),
    cor_carroceria character varying(100),
    tonelagem numeric(15,4),
    placa_carroceria character varying(50),
    licenciamento_carroceria date,
    municipio_carroceria character varying(100),
    uf_carroceria character varying(3),
    nome_carroceria character varying(100),
    cpf_carroceria character varying(20),
    cgc_carroceria character varying(20),
    endereco_carroceria character varying(100),
    bairro_carroceria character varying(100),
    municipio_proprietario_carroceria character varying(100),
    uf_proprietario_carroceria character varying(3),
    observacoes text,
    rastreador character varying(40) DEFAULT ''::character varying,
    tipo_unidade_transporte smallint DEFAULT 1,
    tara smallint,
    capacidade_kg smallint,
    capacidade_m3 smallint,
    tipo_proprietario smallint,
    tipo_rodado smallint,
    tipo_carroceria smallint,
    descricao character varying(250),
    uf_placa character varying(2)
);


ALTER TABLE veiculo OWNER TO "ADMIN";

--
-- Name: COLUMN veiculo.tipo_unidade_transporte; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN veiculo.tipo_unidade_transporte IS '1 - Rodovirio Trao; 2 - Rodovirio Reboque;';


--
-- Name: COLUMN veiculo.tipo_proprietario; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN veiculo.tipo_proprietario IS '0-TAC  Agregado; 1-TAC Independente ou 2  Outros';


--
-- Name: COLUMN veiculo.tipo_rodado; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN veiculo.tipo_rodado IS '1 - Truck; 2 - Toco; 3 - Cavalo Mecnico;4 - VAN; 5 - Utilitrio; 6 - Outros.';


--
-- Name: COLUMN veiculo.tipo_carroceria; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN veiculo.tipo_carroceria IS '0 - no aplicvel; 1 - Aberta; 2 - Fechada/Ba; 3 - Granelera; 4 - Porta Container; 5 - Sider';


--
-- Name: venda_ecommerce; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE venda_ecommerce (
    empresa bigint NOT NULL,
    codigo_cabecalho_orcamento bigint NOT NULL,
    codigo_venda_ecommerce bigint NOT NULL,
    estoque_reservado boolean,
    situacao_faturamento smallint
);


ALTER TABLE venda_ecommerce OWNER TO "ADMIN";

--
-- Name: COLUMN venda_ecommerce.situacao_faturamento; Type: COMMENT; Schema: public; Owner: ADMIN
--

COMMENT ON COLUMN venda_ecommerce.situacao_faturamento IS '1.   PENDENTE        sob anlise 2.  CANCELADO       recusando pela cobrana 3.  AUTORIZADO      liberado para prosseguir 4. FATURADO        processado pela retaguarda 5.   CONSOLIDADO     fechado pelo ecommerce. ';


--
-- Name: visita_sem_venda_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE visita_sem_venda_pocket (
    vsv_id bigint NOT NULL,
    pct_id integer NOT NULL,
    codigo_cliente character varying,
    vsv_codigo_visita bigint,
    vsv_data date,
    vsv_motivo character varying
);


ALTER TABLE visita_sem_venda_pocket OWNER TO "ADMIN";

--
-- Name: visita_sem_venda_pocket_vsv_id_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE visita_sem_venda_pocket_vsv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE visita_sem_venda_pocket_vsv_id_seq OWNER TO "ADMIN";

--
-- Name: visita_sem_venda_pocket_vsv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE visita_sem_venda_pocket_vsv_id_seq OWNED BY visita_sem_venda_pocket.vsv_id;


--
-- Name: vsv_estoque_pocket; Type: TABLE; Schema: public; Owner: ADMIN
--

CREATE TABLE vsv_estoque_pocket (
    vsve_id bigint NOT NULL,
    vsv_id bigint NOT NULL,
    pct_id integer NOT NULL,
    codigo_produto character varying,
    vsve_qtde numeric,
    vsve_valor_venda numeric
);


ALTER TABLE vsv_estoque_pocket OWNER TO "ADMIN";

--
-- Name: vsv_estoque_pocket_vsve_id_seq; Type: SEQUENCE; Schema: public; Owner: ADMIN
--

CREATE SEQUENCE vsv_estoque_pocket_vsve_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE vsv_estoque_pocket_vsve_id_seq OWNER TO "ADMIN";

--
-- Name: vsv_estoque_pocket_vsve_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: ADMIN
--

ALTER SEQUENCE vsv_estoque_pocket_vsve_id_seq OWNED BY vsv_estoque_pocket.vsve_id;


--
-- Name: clip_id; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY cad_cliente_pocket ALTER COLUMN clip_id SET DEFAULT nextval('cad_cliente_pocket_clip_id_seq'::regclass);


--
-- Name: pvp_id; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY cad_pedido_venda_pocket ALTER COLUMN pvp_id SET DEFAULT nextval('cad_pedido_venda_pocket_pvp_id_seq'::regclass);


--
-- Name: ordem; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY cadastro_arquivos_contratos ALTER COLUMN ordem SET DEFAULT nextval('cadastro_arquivos_contratos_ordem_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY cadastro_caracteristica ALTER COLUMN codigo SET DEFAULT nextval('cadastro_caracteristica_codigo_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY cadastro_statuspedidobi ALTER COLUMN pk_codigo SET DEFAULT nextval('cadastro_statuspedidobi_pk_codigo_seq'::regclass);


--
-- Name: id_cadtamanhocaracteristica; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY cadastro_tamanhocaracteristica ALTER COLUMN id_cadtamanhocaracteristica SET DEFAULT nextval('cadastro_tamanhocaracteristica_id_cadtamanhocaracteristica_seq'::regclass);


--
-- Name: pk_cliente_parametros; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY cliente_parametros ALTER COLUMN pk_cliente_parametros SET DEFAULT nextval('cliente_parametros_pk_cliente_parametros_seq'::regclass);


--
-- Name: id_consertaestoque; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY conserta_estoque ALTER COLUMN id_consertaestoque SET DEFAULT nextval('conserta_estoque_id_consertaestoque_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY empresa_adicional ALTER COLUMN codigo SET DEFAULT nextval('empresa_adicional_codigo_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY etiqueta_zebra ALTER COLUMN codigo SET DEFAULT nextval('etiqueta_zebra_codigo_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY etiqueta_zebra_itens ALTER COLUMN codigo SET DEFAULT nextval('etiqueta_zebra_itens_codigo_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY etiqueta_zebra_parametro ALTER COLUMN codigo SET DEFAULT nextval('etiqueta_zebra_parametro_codigo_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY financeira ALTER COLUMN pk_codigo SET DEFAULT nextval('financeira_pk_codigo_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY impressora_fiscal ALTER COLUMN pk_codigo SET DEFAULT nextval('impressora_fiscal_pk_codigo_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY info_fotos_produtos_ecommerce ALTER COLUMN codigo SET DEFAULT nextval('info_fotos_produtos_ecommerce_codigo_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY info_produto_ecommerce ALTER COLUMN codigo SET DEFAULT nextval('info_produto_ecommerce_codigo_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY informacao_codigo_barras ALTER COLUMN codigo SET DEFAULT nextval('informacao_codigo_barras_codigo_seq'::regclass);


--
-- Name: ivp_id; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY lista_item_pedido_pocket ALTER COLUMN ivp_id SET DEFAULT nextval('lista_item_pedido_pocket_ivp_id_seq'::regclass);


--
-- Name: sequencia; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY movimento_cabecalho_conhecimento ALTER COLUMN sequencia SET DEFAULT nextval('movimento_cabecalho_conhecimento_sequencia_seq'::regclass);


--
-- Name: pk_movimento_cabecalho_servicos; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY movimento_cabecalho_servicos ALTER COLUMN pk_movimento_cabecalho_servicos SET DEFAULT nextval('movimento_cabecalho_servicos_pk_movimento_cabecalho_servico_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY movimento_grade ALTER COLUMN codigo SET DEFAULT nextval('movimento_grade_codigo_seq'::regclass);


--
-- Name: sequencia; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY movimento_kit ALTER COLUMN sequencia SET DEFAULT nextval('movimento_kit_sequencia_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY movimento_orcamento ALTER COLUMN pk_codigo SET DEFAULT nextval('movimento_orcamento_pk_codigo_seq'::regclass);


--
-- Name: pk_movimento_ordem_servicos; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY movimento_ordem_servicos ALTER COLUMN pk_movimento_ordem_servicos SET DEFAULT nextval('movimento_ordem_servicos_pk_movimento_ordem_servicos_seq'::regclass);


--
-- Name: serial; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY replicacao ALTER COLUMN serial SET DEFAULT nextval('replicacao_serial_seq'::regclass);


--
-- Name: serial; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY replicacao_cadastros ALTER COLUMN serial SET DEFAULT nextval('replicacao_cadastros_serial_seq'::regclass);


--
-- Name: pk_acerto_endereco_estoque; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_acerto_endereco_estoque ALTER COLUMN pk_acerto_endereco_estoque SET DEFAULT nextval('tb_acerto_endereco_estoque_pk_acerto_endereco_estoque_seq'::regclass);


--
-- Name: pk_altura_largura_item; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_altura_largura_item ALTER COLUMN pk_altura_largura_item SET DEFAULT nextval('tb_altura_largura_item_pk_altura_largura_item_seq'::regclass);


--
-- Name: pk_apropriacao; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_apropriacao_bem ALTER COLUMN pk_apropriacao SET DEFAULT nextval('tb_apropriacao_bem_pk_apropriacao_seq'::regclass);


--
-- Name: pk_assunto_relatorio; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_assunto_relatorio ALTER COLUMN pk_assunto_relatorio SET DEFAULT nextval('tb_assunto_relatorio_pk_assunto_relatorio_seq'::regclass);


--
-- Name: pk_auditoria_nfse; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_auditoria_nfse ALTER COLUMN pk_auditoria_nfse SET DEFAULT nextval('tb_auditoria_nfse_pk_auditoria_nfse_seq'::regclass);


--
-- Name: pk_autorizacao; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_autorizacao_lacre ALTER COLUMN pk_autorizacao SET DEFAULT nextval('tb_autorizacao_lacre_pk_autorizacao_seq'::regclass);


--
-- Name: pk_balanco; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_balanco ALTER COLUMN pk_balanco SET DEFAULT nextval('tb_balanco_pk_balanco_seq'::regclass);


--
-- Name: pk_banco; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_banco ALTER COLUMN pk_banco SET DEFAULT nextval('tb_banco_pk_banco_seq'::regclass);


--
-- Name: pk_bem_imobilizado; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_bem_imobilizado ALTER COLUMN pk_bem_imobilizado SET DEFAULT nextval('tb_bem_imobilizado_pk_bem_imobilizado_seq'::regclass);


--
-- Name: pk_bem_imobilizado_tmp; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_bem_imobilizado_tmp ALTER COLUMN pk_bem_imobilizado_tmp SET DEFAULT nextval('tb_bem_imobilizado_tmp_pk_bem_imobilizado_tmp_seq'::regclass);


--
-- Name: pk_beneficiario_boleto; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_beneficiario_boleto ALTER COLUMN pk_beneficiario_boleto SET DEFAULT nextval('tb_beneficiario_boleto_pk_beneficiario_boleto_seq'::regclass);


--
-- Name: pk_boleto; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_boleto ALTER COLUMN pk_boleto SET DEFAULT nextval('tb_boleto_pk_boleto_seq'::regclass);


--
-- Name: pk_tb_caixa_dados_fechamento; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_caixa_dados_fechamento ALTER COLUMN pk_tb_caixa_dados_fechamento SET DEFAULT nextval('tb_caixa_dados_fechamento_pk_tb_caixa_dados_fechamento_seq'::regclass);


--
-- Name: pk_central_nfse; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_central_nfse ALTER COLUMN pk_central_nfse SET DEFAULT nextval('tb_central_nfse_pk_central_nfse_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_cf_impostos_tmp ALTER COLUMN pk_codigo SET DEFAULT nextval('tb_cf_impostos_tmp_pk_codigo_seq'::regclass);


--
-- Name: pk_cheque_moradia; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_cheque_moradia ALTER COLUMN pk_cheque_moradia SET DEFAULT nextval('tb_cheque_moradia_pk_cheque_moradia_seq'::regclass);


--
-- Name: pk_cnae_servico; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_cnae_servico ALTER COLUMN pk_cnae_servico SET DEFAULT nextval('tb_cnae_servico_pk_cnae_servico_seq'::regclass);


--
-- Name: pk_configuracao_balanca; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_configuracao_balanca ALTER COLUMN pk_configuracao_balanca SET DEFAULT nextval('tb_configuracao_balanca_pk_configuracao_balanca_seq'::regclass);


--
-- Name: pk_configuracao_boleto; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_configuracao_boleto ALTER COLUMN pk_configuracao_boleto SET DEFAULT nextval('tb_configuracao_boleto_pk_configuracao_boleto_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_configuracao_documento_fiscal_eletronico ALTER COLUMN pk_codigo SET DEFAULT nextval('tb_configuracao_documento_fiscal_eletronico_pk_codigo_seq'::regclass);


--
-- Name: pk_configuracao_impressao; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_configuracao_impressao ALTER COLUMN pk_configuracao_impressao SET DEFAULT nextval('tb_configuracao_impressao_pk_configuracao_impressao_seq'::regclass);


--
-- Name: pk_conta_corrente; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_conta_corrente ALTER COLUMN pk_conta_corrente SET DEFAULT nextval('tb_conta_corrente_pk_conta_corrente_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_credenciadora ALTER COLUMN pk_codigo SET DEFAULT nextval('tb_credenciadora_pk_codigo_seq'::regclass);


--
-- Name: pk_csrt_sefaz; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_csrt_sefaz ALTER COLUMN pk_csrt_sefaz SET DEFAULT nextval('tb_csrt_sefaz_pk_csrt_sefaz_seq'::regclass);


--
-- Name: pk_definicao_movimento; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_definicao_movimento ALTER COLUMN pk_definicao_movimento SET DEFAULT nextval('tb_definicao_movimento_pk_definicao_movimento_seq'::regclass);


--
-- Name: pk_desconto_progressivo_produto; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_desconto_progressivo_produto ALTER COLUMN pk_desconto_progressivo_produto SET DEFAULT nextval('tb_desconto_progressivo_produ_pk_desconto_progressivo_produ_seq'::regclass);


--
-- Name: pk_desconto_progressivo_valor; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_desconto_progressivo_valor ALTER COLUMN pk_desconto_progressivo_valor SET DEFAULT nextval('tb_desconto_progressivo_valor_pk_desconto_progressivo_valor_seq'::regclass);


--
-- Name: pk_documentofiscal; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_documento_fiscal ALTER COLUMN pk_documentofiscal SET DEFAULT nextval('tb_documento_fiscal_pk_documentofiscal_seq'::regclass);


--
-- Name: pk_documentofiscal_referenciado; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_documento_fiscal_referenciado ALTER COLUMN pk_documentofiscal_referenciado SET DEFAULT nextval('tb_documento_fiscal_referenci_pk_documentofiscal_referencia_seq'::regclass);


--
-- Name: pk_endereco; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_endereco ALTER COLUMN pk_endereco SET DEFAULT nextval('tb_endereco_pk_endereco_seq'::regclass);


--
-- Name: pk_endereco_estoque; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_endereco_estoque ALTER COLUMN pk_endereco_estoque SET DEFAULT nextval('tb_endereco_estoque_pk_endereco_estoque_seq'::regclass);


--
-- Name: pk_endereco_estoque_saldo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_endereco_estoque_saldo ALTER COLUMN pk_endereco_estoque_saldo SET DEFAULT nextval('tb_endereco_estoque_saldo_pk_endereco_estoque_saldo_seq'::regclass);


--
-- Name: pk_esquema_centro_custo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_esquema_centro_custo ALTER COLUMN pk_esquema_centro_custo SET DEFAULT nextval('tb_esquema_centro_custo_pk_esquema_centro_custo_seq'::regclass);


--
-- Name: pk_estrutura_resultados; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_estrutura_resultados ALTER COLUMN pk_estrutura_resultados SET DEFAULT nextval('tb_estrutura_resultados_pk_estrutura_resultados_seq'::regclass);


--
-- Name: pk_fechamento_contabil; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_fechamento_contabil ALTER COLUMN pk_fechamento_contabil SET DEFAULT nextval('tb_fechamento_contabil_pk_fechamento_contabil_seq'::regclass);


--
-- Name: pk_fechamento_contabil_item; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_fechamento_contabil_item ALTER COLUMN pk_fechamento_contabil_item SET DEFAULT nextval('tb_fechamento_contabil_item_pk_fechamento_contabil_item_seq'::regclass);


--
-- Name: pk_fiscal_movimento_caixa; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_fiscal_movimento_caixa ALTER COLUMN pk_fiscal_movimento_caixa SET DEFAULT nextval('tb_fiscal_movimento_caixa_pk_fiscal_movimento_caixa_seq'::regclass);


--
-- Name: pk_forma_faturamento_conta; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_forma_faturamento_conta ALTER COLUMN pk_forma_faturamento_conta SET DEFAULT nextval('tb_forma_faturamento_conta_pk_forma_faturamento_conta_seq'::regclass);


--
-- Name: pk_funrural_entrada; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_funrural_entrada ALTER COLUMN pk_funrural_entrada SET DEFAULT nextval('tb_funrural_entrada_pk_funrural_entrada_seq'::regclass);


--
-- Name: pk_gerenciadortef; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_gerenciador_tef ALTER COLUMN pk_gerenciadortef SET DEFAULT nextval('tb_gerenciador_tef_pk_gerenciadortef_seq'::regclass);


--
-- Name: pk_grupo_resultados_conta_contabil; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_grupo_resultado_conta_contabil ALTER COLUMN pk_grupo_resultados_conta_contabil SET DEFAULT nextval('tb_grupo_resultado_conta_cont_pk_grupo_resultados_conta_con_seq'::regclass);


--
-- Name: pk_grupo_resultados; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_grupo_resultados ALTER COLUMN pk_grupo_resultados SET DEFAULT nextval('tb_grupo_resultados_pk_grupo_resultados_seq'::regclass);


--
-- Name: pk_guia; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_guia ALTER COLUMN pk_guia SET DEFAULT nextval('tb_guia_pk_guia_seq'::regclass);


--
-- Name: pk_guias_financeiro; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_guias_financeiro ALTER COLUMN pk_guias_financeiro SET DEFAULT nextval('tb_guias_financeiro_pk_guias_financeiro_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_informacoes_senha_externa ALTER COLUMN codigo SET DEFAULT nextval('tb_informacoes_senha_externa_codigo_seq'::regclass);


--
-- Name: pk_integracao_dominio; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_integracao_dominio ALTER COLUMN pk_integracao_dominio SET DEFAULT nextval('tb_integracao_dominio_pk_integracao_dominio_seq'::regclass);


--
-- Name: pk_inventario; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_inventario ALTER COLUMN pk_inventario SET DEFAULT nextval('tb_inventario_pk_inventario_seq'::regclass);


--
-- Name: pk_itemalteracaoinventario; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_item_alteracao_inventario ALTER COLUMN pk_itemalteracaoinventario SET DEFAULT nextval('tb_item_alteracao_inventario_pk_itemalteracaoinventario_seq'::regclass);


--
-- Name: pk_itembalanco; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_item_balanco ALTER COLUMN pk_itembalanco SET DEFAULT nextval('tb_item_balanco_pk_itembalanco_seq'::regclass);


--
-- Name: pk_itemcontagembalanco; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_item_contagem_balanco ALTER COLUMN pk_itemcontagembalanco SET DEFAULT nextval('tb_item_contagem_balanco_pk_itemcontagembalanco_seq'::regclass);


--
-- Name: pk_item_movimentacao; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_item_movimentacao ALTER COLUMN pk_item_movimentacao SET DEFAULT nextval('tb_item_movimentacao_pk_item_movimentacao_seq'::regclass);


--
-- Name: pk_item_mov_lista_precos; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_item_movimentacao_lista_precos ALTER COLUMN pk_item_mov_lista_precos SET DEFAULT nextval('tb_item_movimentacao_lista_precos_pk_item_mov_lista_precos_seq'::regclass);


--
-- Name: pk_item; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_item_movimentacaoconsumo ALTER COLUMN pk_item SET DEFAULT nextval('tb_item_movimentacaoconsumo_pk_item_seq'::regclass);


--
-- Name: pk_itempedidocompra; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_item_pedidocompra ALTER COLUMN pk_itempedidocompra SET DEFAULT nextval('tb_item_pedidocompra_pk_itempedidocompra_seq'::regclass);


--
-- Name: pk_item_reg_painel_controle; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_item_reg_painel_controle ALTER COLUMN pk_item_reg_painel_controle SET DEFAULT nextval('tb_item_reg_painel_controle_pk_item_reg_painel_controle_seq'::regclass);


--
-- Name: pk_item_retancao_servico; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_item_retencao_servico ALTER COLUMN pk_item_retancao_servico SET DEFAULT nextval('tb_item_retencao_servico_pk_item_retancao_servico_seq'::regclass);


--
-- Name: pk_lacre; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_lacre ALTER COLUMN pk_lacre SET DEFAULT nextval('tb_lacre_pk_lacre_seq'::regclass);


--
-- Name: pk_lista_preco_cliente; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_lista_preco_cliente ALTER COLUMN pk_lista_preco_cliente SET DEFAULT nextval('tb_lista_preco_cliente_pk_lista_preco_cliente_seq'::regclass);


--
-- Name: pk_lista_precos; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_lista_precos ALTER COLUMN pk_lista_precos SET DEFAULT nextval('tb_lista_precos_pk_lista_precos_seq'::regclass);


--
-- Name: pk_mdfe_auditoria; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_mdfe_auditoria ALTER COLUMN pk_mdfe_auditoria SET DEFAULT nextval('tb_mdfe_auditoria_pk_mdfe_auditoria_seq'::regclass);


--
-- Name: pk_mdfe_condutor; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_mdfe_condutor ALTER COLUMN pk_mdfe_condutor SET DEFAULT nextval('tb_mdfe_condutor_pk_mdfe_condutor_seq'::regclass);


--
-- Name: pk_mdfe_municipio_carregamento; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_mdfe_municipio_carregamento ALTER COLUMN pk_mdfe_municipio_carregamento SET DEFAULT nextval('tb_mdfe_municipio_carregament_pk_mdfe_municipio_carregament_seq'::regclass);


--
-- Name: pk_mdfe_municipio_descarga; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_mdfe_municipio_descarga ALTER COLUMN pk_mdfe_municipio_descarga SET DEFAULT nextval('tb_mdfe_municipio_descarga_pk_mdfe_municipio_descarga_seq'::regclass);


--
-- Name: pk_mdfe_percurso; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_mdfe_percurso ALTER COLUMN pk_mdfe_percurso SET DEFAULT nextval('tb_mdfe_percurso_pk_mdfe_percurso_seq'::regclass);


--
-- Name: pk_mdfe_seguro; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_mdfe_seguro ALTER COLUMN pk_mdfe_seguro SET DEFAULT nextval('tb_mdfe_seguro_pk_mdfe_seguro_seq'::regclass);


--
-- Name: pk_mdfe_veiculo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_mdfe_veiculo ALTER COLUMN pk_mdfe_veiculo SET DEFAULT nextval('tb_mdfe_veiculo_pk_mdfe_veiculo_seq'::regclass);


--
-- Name: pk_mensagem_boleto; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_mensagem_boleto ALTER COLUMN pk_mensagem_boleto SET DEFAULT nextval('tb_mensagem_boleto_pk_mensagem_boleto_seq'::regclass);


--
-- Name: pk_mensagem_configuracao_boleto; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_mensagem_configuracao_boleto ALTER COLUMN pk_mensagem_configuracao_boleto SET DEFAULT nextval('tb_mensagem_configuracao_bole_pk_mensagem_configuracao_bole_seq'::regclass);


--
-- Name: pk_meta_vendas; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_meta_vendas ALTER COLUMN pk_meta_vendas SET DEFAULT nextval('tb_meta_vendas_pk_meta_vendas_seq'::regclass);


--
-- Name: pk_meta_vendas_fornecedor; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_meta_vendas_fornecedor ALTER COLUMN pk_meta_vendas_fornecedor SET DEFAULT nextval('tb_meta_vendas_fornecedor_pk_meta_vendas_fornecedor_seq'::regclass);


--
-- Name: pk_meta_vendas_item; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_meta_vendas_item ALTER COLUMN pk_meta_vendas_item SET DEFAULT nextval('tb_meta_vendas_item_pk_meta_vendas_item_seq'::regclass);


--
-- Name: pk_meta_vendas_produto; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_meta_vendas_produto ALTER COLUMN pk_meta_vendas_produto SET DEFAULT nextval('tb_meta_vendas_produto_pk_meta_vendas_produto_seq'::regclass);


--
-- Name: pk_motivo_cancelamento; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_motivo_cancelamento ALTER COLUMN pk_motivo_cancelamento SET DEFAULT nextval('tb_motivo_cancelamento_pk_motivo_cancelamento_seq'::regclass);


--
-- Name: pk_motivo_nao_venda; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_motivo_nao_venda ALTER COLUMN pk_motivo_nao_venda SET DEFAULT nextval('tb_motivo_nao_venda_pk_motivo_nao_venda_seq'::regclass);


--
-- Name: pk_movimentacao; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_movimentacao ALTER COLUMN pk_movimentacao SET DEFAULT nextval('tb_movimentacao_pk_movimentacao_seq'::regclass);


--
-- Name: pk_movimentacaoconsumo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_movimentacao_consumo ALTER COLUMN pk_movimentacaoconsumo SET DEFAULT nextval('tb_movimentacao_consumo_pk_movimentacaoconsumo_seq'::regclass);


--
-- Name: pk_movimentacao_replicacao; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_movimentacao_replicacao ALTER COLUMN pk_movimentacao_replicacao SET DEFAULT nextval('tb_movimentacao_replicacao_pk_movimentacao_replicacao_seq'::regclass);


--
-- Name: pk_movimentacoes_fiscais_efetivadas; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_movimentacoes_fiscais_efetivadas ALTER COLUMN pk_movimentacoes_fiscais_efetivadas SET DEFAULT nextval('tb_movimentacoes_fiscais_efet_pk_movimentacoes_fiscais_efet_seq'::regclass);


--
-- Name: pk_movimento_centro_custo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_movimento_centro_custo ALTER COLUMN pk_movimento_centro_custo SET DEFAULT nextval('tb_movimento_centro_custo_pk_movimento_centro_custo_seq'::regclass);


--
-- Name: pk_movimento_conta_contabil; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_movimento_conta_contabil ALTER COLUMN pk_movimento_conta_contabil SET DEFAULT nextval('tb_movimento_conta_contabil_pk_movimento_conta_contabil_seq'::regclass);


--
-- Name: pk_movimento_contabil; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_movimento_contabil ALTER COLUMN pk_movimento_contabil SET DEFAULT nextval('tb_movimento_contabil_pk_movimento_contabil_seq'::regclass);


--
-- Name: pk_movimento_endereco_estoque; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_movimento_endereco_estoque ALTER COLUMN pk_movimento_endereco_estoque SET DEFAULT nextval('tb_movimento_endereco_estoque_pk_movimento_endereco_estoque_seq'::regclass);


--
-- Name: pk_pedido_associado; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_movimento_orcamento_pedido_associado ALTER COLUMN pk_pedido_associado SET DEFAULT nextval('tb_movimento_orcamento_pedido_associado_pk_pedido_associado_seq'::regclass);


--
-- Name: pk_nfe_cupom_eletronico; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfe_cupom_eletronico ALTER COLUMN pk_nfe_cupom_eletronico SET DEFAULT nextval('tb_nfe_cupom_eletronico_pk_nfe_cupom_eletronico_seq'::regclass);


--
-- Name: pk_nfse; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse ALTER COLUMN pk_nfse SET DEFAULT nextval('tb_nfse_pk_nfse_seq'::regclass);


--
-- Name: pk_nfse_construcao_civil; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_construcao_civil ALTER COLUMN pk_nfse_construcao_civil SET DEFAULT nextval('tb_nfse_construcao_civil_pk_nfse_construcao_civil_seq'::regclass);


--
-- Name: pk_nfse_deducao; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_deducao ALTER COLUMN pk_nfse_deducao SET DEFAULT nextval('tb_nfse_deducao_pk_nfse_deducao_seq'::regclass);


--
-- Name: pk_nfse_intermediario; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_intermediario ALTER COLUMN pk_nfse_intermediario SET DEFAULT nextval('tb_nfse_intermediario_pk_nfse_intermediario_seq'::regclass);


--
-- Name: pk_nfse_item; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_item ALTER COLUMN pk_nfse_item SET DEFAULT nextval('tb_nfse_item_pk_nfse_item_seq'::regclass);


--
-- Name: pk_nfse_item_valores; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_item_valores ALTER COLUMN pk_nfse_item_valores SET DEFAULT nextval('tb_nfse_item_valores_pk_nfse_item_valores_seq'::regclass);


--
-- Name: pk_nfse_material_construcao_civil; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_material_construcao_civil ALTER COLUMN pk_nfse_material_construcao_civil SET DEFAULT nextval('tb_nfse_material_construcao_c_pk_nfse_material_construcao_c_seq'::regclass);


--
-- Name: pk_nfse_parcelas; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_parcelas ALTER COLUMN pk_nfse_parcelas SET DEFAULT nextval('tb_nfse_parcelas_pk_nfse_parcelas_seq'::regclass);


--
-- Name: pk_nfse_servico; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_servico ALTER COLUMN pk_nfse_servico SET DEFAULT nextval('tb_nfse_servico_pk_nfse_servico_seq'::regclass);


--
-- Name: pk_nfse_servico_local_prestacao; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_servico_local_prestacao ALTER COLUMN pk_nfse_servico_local_prestacao SET DEFAULT nextval('tb_nfse_servico_local_prestac_pk_nfse_servico_local_prestac_seq'::regclass);


--
-- Name: pk_nfse_servico_valores; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_nfse_servico_valores ALTER COLUMN pk_nfse_servico_valores SET DEFAULT nextval('tb_nfse_servico_valores_pk_nfse_servico_valores_seq'::regclass);


--
-- Name: pk_notasfiscais; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_notas_fiscais ALTER COLUMN pk_notasfiscais SET DEFAULT nextval('tb_notas_fiscais_pk_notasfiscais_seq'::regclass);


--
-- Name: pk_notificacao_cobranca; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_notificacao_cobranca ALTER COLUMN pk_notificacao_cobranca SET DEFAULT nextval('tb_notificacao_cobranca_pk_notificacao_cobranca_seq'::regclass);


--
-- Name: pk_notificacao_cobranca_item; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_notificacao_cobranca_item ALTER COLUMN pk_notificacao_cobranca_item SET DEFAULT nextval('tb_notificacao_cobranca_item_pk_notificacao_cobranca_item_seq'::regclass);


--
-- Name: pk_notificacao_cobranca_titulo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_notificacao_cobranca_titulo ALTER COLUMN pk_notificacao_cobranca_titulo SET DEFAULT nextval('tb_notificacao_cobranca_titul_pk_notificacao_cobranca_titul_seq'::regclass);


--
-- Name: pk_parametro; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_paramentro ALTER COLUMN pk_parametro SET DEFAULT nextval('tb_paramentro_pk_parametro_seq'::regclass);


--
-- Name: pk_parametro_calculo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_parametro_calculo ALTER COLUMN pk_parametro_calculo SET DEFAULT nextval('tb_parametro_calculo_pk_parametro_calculo_seq'::regclass);


--
-- Name: pk_parametros_replicacao_pedido; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_parametros_replicacao_pedido ALTER COLUMN pk_parametros_replicacao_pedido SET DEFAULT nextval('tb_parametros_replicacao_pedi_pk_parametros_replicacao_pedi_seq'::regclass);


--
-- Name: pk_parcela_apropriacao_icms; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_parcela_apropriacao_icms ALTER COLUMN pk_parcela_apropriacao_icms SET DEFAULT nextval('tb_parcela_apropriacao_icms_pk_parcela_apropriacao_icms_seq'::regclass);


--
-- Name: pk_periodo_aviamento; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_periodo_aviamento ALTER COLUMN pk_periodo_aviamento SET DEFAULT nextval('tb_periodo_aviamento_pk_periodo_aviamento_seq'::regclass);


--
-- Name: pk_rastreabilidade; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_rastreabilidade ALTER COLUMN pk_rastreabilidade SET DEFAULT nextval('tb_rastreabilidade_pk_rastreabilidade_seq'::regclass);


--
-- Name: pk_rastreabilidade_movimento; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_rastreabilidade_movimento ALTER COLUMN pk_rastreabilidade_movimento SET DEFAULT nextval('tb_rastreabilidade_movimento_pk_rastreabilidade_movimento_seq'::regclass);


--
-- Name: pk_rastreabilidade_mov_documento; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_rastreabilidade_movimento_documento ALTER COLUMN pk_rastreabilidade_mov_documento SET DEFAULT nextval('tb_rastreabilidade_movimento__pk_rastreabilidade_mov_docume_seq'::regclass);


--
-- Name: pk_reg_painel_controle; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_reg_painel_controle ALTER COLUMN pk_reg_painel_controle SET DEFAULT nextval('tb_reg_painel_controle_pk_reg_painel_controle_seq'::regclass);


--
-- Name: pk_relacao_pagar_com_receber; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_relacao_pagar_com_receber ALTER COLUMN pk_relacao_pagar_com_receber SET DEFAULT nextval('tb_relacao_pagar_com_receber_pk_relacao_pagar_com_receber_seq'::regclass);


--
-- Name: pk_relatorio; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_relatorio ALTER COLUMN pk_relatorio SET DEFAULT nextval('tb_relatorio_pk_relatorio_seq'::regclass);


--
-- Name: pk_remessa_boleto; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_remessa_boleto ALTER COLUMN pk_remessa_boleto SET DEFAULT nextval('tb_remessa_boleto_pk_remessa_boleto_seq'::regclass);


--
-- Name: pk_remessa_boleto_item; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_remessa_boleto_item ALTER COLUMN pk_remessa_boleto_item SET DEFAULT nextval('tb_remessa_boleto_item_pk_remessa_boleto_item_seq'::regclass);


--
-- Name: pk_retencao_servico; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_retencao_servico ALTER COLUMN pk_retencao_servico SET DEFAULT nextval('tb_retencao_servico_pk_retencao_servico_seq'::regclass);


--
-- Name: pk_rps_substituido; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_rps_substituido ALTER COLUMN pk_rps_substituido SET DEFAULT nextval('tb_rps_substituido_pk_rps_substituido_seq'::regclass);


--
-- Name: pk_sazonalidade_metas; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_sazonalidade_metas ALTER COLUMN pk_sazonalidade_metas SET DEFAULT nextval('tb_sazonalidade_metas_pk_sazonalidade_metas_seq'::regclass);


--
-- Name: pk_pedidocompraautomatico; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_solicitacao_compras ALTER COLUMN pk_pedidocompraautomatico SET DEFAULT nextval('tb_solicitacao_compras_pk_pedidocompraautomatico_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_template_email_nfse ALTER COLUMN pk_codigo SET DEFAULT nextval('tb_template_email_nfse_pk_codigo_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_template_mensagem_boleto ALTER COLUMN pk_codigo SET DEFAULT nextval('tb_template_mensagem_boleto_pk_codigo_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_template_nfse ALTER COLUMN pk_codigo SET DEFAULT nextval('tb_template_nfse_pk_codigo_seq'::regclass);


--
-- Name: pk_tipo_documento_titulo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_tipo_documento_titulo ALTER COLUMN pk_tipo_documento_titulo SET DEFAULT nextval('tb_tipo_documento_titulo_pk_tipo_documento_titulo_seq'::regclass);


--
-- Name: pk_titulo_gerado_baixa; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_titulo_gerado_baixa ALTER COLUMN pk_titulo_gerado_baixa SET DEFAULT nextval('tb_titulo_gerado_baixa_pk_titulo_gerado_baixa_seq'::regclass);


--
-- Name: pk_transferencia_portadores; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_transferencia_portadores ALTER COLUMN pk_transferencia_portadores SET DEFAULT nextval('tb_transferencia_portadores_pk_transferencia_portadores_seq'::regclass);


--
-- Name: pk_tranferencia_portadores_titulos; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_transferencia_portadores_titulos ALTER COLUMN pk_tranferencia_portadores_titulos SET DEFAULT nextval('tb_transferencia_portadores_t_pk_tranferencia_portadores_ti_seq'::regclass);


--
-- Name: pk_transporte; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_transporte ALTER COLUMN pk_transporte SET DEFAULT nextval('tb_transporte_pk_transporte_seq'::regclass);


--
-- Name: pk_tributo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_tributo ALTER COLUMN pk_tributo SET DEFAULT nextval('tb_tributo_pk_tributo_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_unidade_secundaria ALTER COLUMN pk_codigo SET DEFAULT nextval('tb_unidade_secundaria_pk_codigo_seq'::regclass);


--
-- Name: pk_utilizacao_bem; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_utilizacao_bem ALTER COLUMN pk_utilizacao_bem SET DEFAULT nextval('tb_utilizacao_bem_pk_utilizacao_bem_seq'::regclass);


--
-- Name: pk_utilizacao_bem_tmp; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tb_utilizacao_bem_tmp ALTER COLUMN pk_utilizacao_bem_tmp SET DEFAULT nextval('tb_utilizacao_bem_tmp_pk_utilizacao_bem_tmp_seq'::regclass);


--
-- Name: codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY tipo_codigo_barras ALTER COLUMN codigo SET DEFAULT nextval('tipo_codigo_barras_codigo_seq'::regclass);


--
-- Name: pk_codigo; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY unidade_secundaria ALTER COLUMN pk_codigo SET DEFAULT nextval('unidade_secundaria_pk_codigo_seq'::regclass);


--
-- Name: vsv_id; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY visita_sem_venda_pocket ALTER COLUMN vsv_id SET DEFAULT nextval('visita_sem_venda_pocket_vsv_id_seq'::regclass);


--
-- Name: vsve_id; Type: DEFAULT; Schema: public; Owner: ADMIN
--

ALTER TABLE ONLY vsv_estoque_pocket ALTER COLUMN vsve_id SET DEFAULT nextval('vsv_estoque_pocket_vsve_id_seq'::regclass);


--
-- Data for Name: abertura_caixa; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY abertura_caixa (caixa, codigo, nome_caixa, data_abertura, hora_abertura, data_fechamento, hora_fechamento, serie_nf, empresa, pk_aberturacaixa, gaveta_inicial, gaveta_final, fechamento_conciliado) FROM stdin;
\.


--
-- Data for Name: acerto_vendedores; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY acerto_vendedores (empresa, numero_do_documento, tipo_de_documento, nome_do_documento, data_de_emissao, data_do_vencimento, numero_da_nf, serie_nf, vendedor, data_liberacao, numero_pedido, saldo, nome_do_cliente, numero_da_duplicata) FROM stdin;
\.


--
-- Data for Name: agenda; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY agenda (empresa, codigo_usuario, nome_usuario, data, item, codigo, nome, data_agendamento, horario_agendamento, descricao, status, descricao1, descricao2, descricao3, descricao4, descricao5) FROM stdin;
\.


--
-- Data for Name: agenda_atendimento_pocket; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY agenda_atendimento_pocket (aga_data, pct_id, aga_status_atualizacao, aga_mensagem_atendimento, aga_grupo, aga_data_atualizacao) FROM stdin;
\.


--
-- Data for Name: aliquota; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY aliquota (codigo, nome, aliquota_do_imposto, empresa) FROM stdin;
1	ISENTO	0.0000	1
2	Substituio Tributria	0.0000	1
3	No Incidncia	0.0000	1
4	ICMS 7%	7.0000	1
5	ICMS 12%	12.0000	1
6	ICMS 17%	17.0000	1
7	ICMS 18%	18.0000	1
8	ICMS 19%	19.0000	1
\.


--
-- Data for Name: aliquota_transportadora; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY aliquota_transportadora (bc_inicial, bc_final, aliquota_inicial, deducao_inicial, bc_acima, aliquota_final, deducao_final, bc_inss, inss_aliquota, desconto_inss, sest_senat) FROM stdin;
\.


--
-- Data for Name: alteracao_cliente; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY alteracao_cliente (codigo_campo, valor_anterior, data_alteracao, codigo_cliente) FROM stdin;
3	AO CONSUMIDOR diego	2013-03-09	0
7		2013-03-09	0
7	ISENTO	2013-03-09	0
\.


--
-- Data for Name: alteracao_produto; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY alteracao_produto (codigo_produto, descricao, data_inicial, data_final) FROM stdin;
\.


--
-- Data for Name: banco; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY banco (codigo, nome, bairro, cidade, endereco, numero, complemento, estado, cep, cgc, telefone, portador_padrao, previsao_inativa, conta_contabil, saldo, saldo_conciliado, saldo_cx, saldo_conciliado_cx, limite_credito, saldo_todos_lancamentos, juros, empresa, codigo_banco, fk_configuracao_boleto, fk_conta_corrente, inativo) FROM stdin;
1	TESOURARIA	.	GOIANIA	.	S	.	GO	74000000	00000000000000		1	0		0.0000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1	\N	\N	\N	f
\.


--
-- Data for Name: boleta_nf; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY boleta_nf (nome_empresa_x, nome_empresa_y, endereco_empresa_x, endereco_empresa_y, cidade_empresa_x, cidade_empresa_y, estado_empresa_x, estado_empresa_y, cgc_empresa_x, cgc_empresa_y, inscricao_empresa_x, inscricao_empresa_y, data_emissao_x, data_emissao_y, vendedor_x, vendedor_y, numero_nf_x, numero_nf_y, valor_nf_x, valor_nf_y, numero_duplicata_x, numero_duplicata_y, valor_duplicata_x, valor_duplicata_y, vencimento_x, vencimento_y, nome_cliente_x, nome_cliente_y, endereco_cliente_x, endereco_cliente_y, telefone_cliente_x, telefone_cliente_y, cidade_cliente_x, cidade_cliente_y, estado_cliente_x, estado_cliente_y, cep_cliente_x, cep_cliente_y, cgc_cliente_x, cgc_cliente_y, inscricao_cliente_x, inscricao_cliente_y, numero_linhas, instrucao_1_x, instrucao_1_y, instrucao_2_x, instrucao_2_y, instrucao_3_x, instrucao_3_y, instrucao_4_x, instrucao_4_y, instrucao_1, instrucao_2, instrucao_3, instrucao_4, data_proc_x, data_proc_y, outros_lanc_x, outros_lanc_y, outros_valores_x, outros_valores_y, salto_paginas, ativar_condensado, ativar_linhas_juntas, banco, nome_banco, juros_c, juros_l, especie_c, "especie_L", aceite_c, "aceite_L", especie, aceite, arquivo_licenca, carteira, compensacao, seq_nome_arquivo, sequencia, layout, proximo_nosso_numero, diretorio_arquivo, tipo_impressao_boleto, codigo_html, margem_superior, qtde_caracteres_sacado, conta_corrente, agencia, codigo_empresa_banco, inicio_nosso_numero, fim_nosso_numero, configuracao1, configuracao2, local_pgto, local_pgto_c, local_pgto_l, linhas_instrucao, fonte, valor_duplicata2_c, valor_duplicata2_l, apresenta_juros_multa, cod_baixa_dev, dias_baixa_dev, servidor_email, logotipocedente, tipo_boleto_email, layoutretorno, dv_agencia) FROM stdin;
\.


--
-- Data for Name: cad_acessor_clientes; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_acessor_clientes (empresa, codigo, nome, telefone, celular) FROM stdin;
1	1	ACESSOR GERAL		
\.


--
-- Data for Name: cad_cliente_pocket; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_cliente_pocket (clip_id, pct_id, clip_codigo_cliente_pocket, clip_razao_social, clip_cnpj_cpf, clip_nome_fantasia, clip_endereco, clip_bairro, clip_cep, clip_telefone, clip_fax, clip_celular, clip_endereco_cobranca, clip_bairro_cobranca, clip_cep_cobranca, clip_fax_cobranca, clip_telefone_cobranca, clip_celular_cobranca, clip_inscricao_estadual, clip_identidade, clip_orgao_emissor, clip_tipo_pessoa, clip_contatos, clip_data_cadastro, clip_data_alteracao, codigo_cidade_cliente, codigo_cidade_cobranca, clip_observacoes, clip_ponto_referencia, codigo_grupo_clientes, clip_status) FROM stdin;
\.


--
-- Name: cad_cliente_pocket_clip_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ADMIN
--

SELECT pg_catalog.setval('cad_cliente_pocket_clip_id_seq', 1, false);


--
-- Data for Name: cad_formula_pontos; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_formula_pontos (empresa, cfp_codigo, cfp_descricao, cfp_validade, cfp_formula, cfp_formula_devolucao, cfp_data_inicio, cfp_habilitado) FROM stdin;
1	1	UM PONTO A CADA R$2,00	12	SELECT (MCNFS.total_da_nota / 2) as pontos FROM movimento_cabecalho_nota_fiscal_saida MCNFS 	SELECT (sum(MNFD.valor_total) / 2) as pontos FROM movimento_nota_fiscal_devolvida MNFD INNER JOIN movimento_controle_pontos MCP ON MCP.empresa = MNFD.empresa and MCP.mcp_sequencia = MNFD.sequencia_devolvida 	\N	0
\.


--
-- Data for Name: cad_grade; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_grade (grade_id, grade_descricao, inativo, categoria) FROM stdin;
\.


--
-- Data for Name: cad_licenca_uso; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_licenca_uso (cli_id, lu_serial_macadress, lu_data_expiracao, lu_status_liberacao, lu_chave_seguranca_pocket, lu_licenca_uso) FROM stdin;
\.


--
-- Data for Name: cad_pedido_venda_pocket; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_pedido_venda_pocket (pvp_id, pct_id, pvp_codigo_cliente, pvp_cod_condicao_pagamento, pvp_cod_pedido_pocket, pvp_sub_total, pvp_desconto, pvp_acrescimo, pvp_valor_liquido, pvp_observacoes, pvp_data_cadastro, pvp_data_alteracao, pvp_status_faturamento, pvp_codigo_pedido, pvp_juros_parcelas_variaveis, tp_id) FROM stdin;
\.


--
-- Name: cad_pedido_venda_pocket_pvp_id_seq; Type: SEQUENCE SET; Schema: public; Owner: ADMIN
--

SELECT pg_catalog.setval('cad_pedido_venda_pocket_pvp_id_seq', 1, false);


--
-- Data for Name: cad_pocket; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_pocket (pct_id, cod_vendedor, pct_versao, pct_query_bd_sqlce, pct_usar_produto_multiplo, pct_numero_serie) FROM stdin;
\.


--
-- Data for Name: cad_resultado_atendimento_pocket; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_resultado_atendimento_pocket (cres_id, cres_resultado, cres_status_atendimento) FROM stdin;
\.


--
-- Data for Name: cad_servidoremail; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_servidoremail (codigo, descricao, servidor, porta, usuario, senha, url_logotipo, titulo_email, mensagem, email_responsavel, msg_cobranca, fk_configuracao_documento_fiscal_eletronico, enviar_copia_oculta, ssl) FROM stdin;
\.


--
-- Data for Name: cad_tabela_preco_pocket; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_tabela_preco_pocket (tp_id, tp_nome, tp_status, tp_id_tabela_pocket, tp_data_cadastro, tp_data_alteracao) FROM stdin;
\.


--
-- Data for Name: cad_tipoimposto_impressorasfiscais; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cad_tipoimposto_impressorasfiscais (pk_codigo, fk_aliquota, fk_impressorasfiscais, fk_empresa, codigo_tributacao) FROM stdin;
\.


--
-- Name: cad_tipoimposto_impressorasfiscais_pk_codigo_seq; Type: SEQUENCE SET; Schema: public; Owner: ADMIN
--

SELECT pg_catalog.setval('cad_tipoimposto_impressorasfiscais_pk_codigo_seq', 8, true);


--
-- Data for Name: cadastro_arquivos_contratos; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_arquivos_contratos (empresa, cod_cliente, ordem, data, nome_arquivo, usuario, cod_modelo) FROM stdin;
\.


--
-- Name: cadastro_arquivos_contratos_ordem_seq; Type: SEQUENCE SET; Schema: public; Owner: ADMIN
--

SELECT pg_catalog.setval('cadastro_arquivos_contratos_ordem_seq', 1, false);


--
-- Data for Name: cadastro_atendimento; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_atendimento (codigo, descricao) FROM stdin;
\.


--
-- Data for Name: cadastro_atividades; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_atividades (codigo, descricao, empresa) FROM stdin;
1	ATIVIDADE GERAL	1
\.


--
-- Data for Name: cadastro_atividades_cliente; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_atividades_cliente (empresa, codigo_cliente, codigo_atividade, codigo_subatividades) FROM stdin;
\.


--
-- Data for Name: cadastro_bens; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_bens (codigo, nome_bens, unidade, nserie_obrigatorio) FROM stdin;
\.


--
-- Data for Name: cadastro_caixas; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_caixas (codigo, descricao, unidades, inativo) FROM stdin;
\.


--
-- Data for Name: cadastro_caixas_venda; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_caixas_venda (caixa, empresa, usa_tef, fk_impressorafiscal, fk_gerenciadortef, fk_configuracaobalanca) FROM stdin;
1	1	0	\N	\N	\N
\.


--
-- Data for Name: cadastro_caracteristica; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_caracteristica (codigo, codigo_caixa, codigo_produto, codigo_fornecedor, codigo_fabricante) FROM stdin;
\.


--
-- Name: cadastro_caracteristica_codigo_seq; Type: SEQUENCE SET; Schema: public; Owner: ADMIN
--

SELECT pg_catalog.setval('cadastro_caracteristica_codigo_seq', 1, false);


--
-- Data for Name: cadastro_centro_custo; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_centro_custo (codigo, descricao, padrao, empresa, data_cadastro, data_alteracao) FROM stdin;
0	CUSTO GERAL	1	1	2012-12-31 00:00:00	2012-12-31 00:00:00
\.


--
-- Data for Name: cadastro_cidades; Type: TABLE DATA; Schema: public; Owner: ADMIN
--

COPY cadastro_cidades (codigo, cidade, estado, descricao_uf, cep, ddd, distancia, empresa, data_cadastro, data_alteracao, codigo_municipio, codigo_pais, inativo, codigo_municipio_setec, fk_pais) FROM stdin;
2	ACRELANDIA	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200013	1058	0	\N	31
1148	BACABAL	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101202	1058	0	\N	31
3106	SANTA FE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123402	1058	0	\N	31
3241	EXU	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605301	1058	0	\N	31
3670	SAPUCAIA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305406	1058	0	\N	31
1	GOIANIA	GO		74000000	062	0.0000	1	2010-03-22 00:00:00	2010-03-22 00:00:00	5208707	1058	0	\N	31
3	ASSIS BRASIL	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200054	1058	0	\N	31
4	BRASILEIA	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200104	1058	0	\N	31
5	BUJARI	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200138	1058	0	\N	31
6	CAPIXABA	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200179	1058	0	\N	31
7	CRUZEIRO DO SUL	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200203	1058	0	\N	31
8	EPITACIOLANDIA	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200252	1058	0	\N	31
9	FEIJO	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200302	1058	0	\N	31
10	JORDAO	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200328	1058	0	\N	31
11	MANCIO LIMA	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200336	1058	0	\N	31
12	MANOEL URBANO	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200344	1058	0	\N	31
13	MARECHAL THAUMATURGO	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200351	1058	0	\N	31
14	PLACIDO DE CASTRO	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200385	1058	0	\N	31
15	PORTO ACRE	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200807	1058	0	\N	31
16	PORTO WALTER	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200393	1058	0	\N	31
17	RIO BRANCO	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200401	1058	0	\N	31
18	RODRIGUES ALVES	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200427	1058	0	\N	31
19	SANTA ROSA DO PURUS	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200435	1058	0	\N	31
20	SENADOR GUIOMARD	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200450	1058	0	\N	31
21	SENA MADUREIRA	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200500	1058	0	\N	31
22	TARAUACA	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200609	1058	0	\N	31
23	XAPURI	AC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1200708	1058	0	\N	31
24	AGUA BRANCA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2700102	1058	0	\N	31
25	ANADIA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2700201	1058	0	\N	31
26	ARAPIRACA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2700300	1058	0	\N	31
27	ATALAIA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2700409	1058	0	\N	31
28	BARRA DE SANTO ANTANIO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2700508	1058	0	\N	31
29	BARRA DE SAO MIGUEL	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2700607	1058	0	\N	31
30	BATALHA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2700706	1058	0	\N	31
31	BELEM	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2700805	1058	0	\N	31
32	BELO MONTE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2700904	1058	0	\N	31
33	BOCA DA MATA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701001	1058	0	\N	31
34	BRANQUINHA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701100	1058	0	\N	31
35	CACIMBINHAS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701209	1058	0	\N	31
36	CAJUEIRO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701308	1058	0	\N	31
37	CAMPESTRE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701357	1058	0	\N	31
38	CAMPO ALEGRE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701407	1058	0	\N	31
39	CAMPO GRANDE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701506	1058	0	\N	31
40	CANAPI	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701605	1058	0	\N	31
41	CAPELA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701704	1058	0	\N	31
42	CARNEIROS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701803	1058	0	\N	31
43	CHA PRETA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2701902	1058	0	\N	31
44	COITE DO NOIA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702009	1058	0	\N	31
45	COLONIA LEOPOLDINA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702108	1058	0	\N	31
46	COQUEIRO SECO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702207	1058	0	\N	31
47	CORURIPE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702306	1058	0	\N	31
48	CRAIBAS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702355	1058	0	\N	31
49	DELMIRO GOUVEIA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702405	1058	0	\N	31
50	DOIS RIACHOS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702504	1058	0	\N	31
51	ESTRELA DE ALAGOAS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702553	1058	0	\N	31
52	FEIRA GRANDE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702603	1058	0	\N	31
53	FELIZ DESERTO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702702	1058	0	\N	31
54	FLEXEIRAS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702801	1058	0	\N	31
55	GIRAU DO PONCIANO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2702900	1058	0	\N	31
56	IBATEGUARA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703007	1058	0	\N	31
57	IGACI	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703106	1058	0	\N	31
58	IGREJA NOVA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703205	1058	0	\N	31
59	INHAPI	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703304	1058	0	\N	31
60	JACARE DOS HOMENS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703403	1058	0	\N	31
61	JACUIPE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703502	1058	0	\N	31
62	JAPARATINGA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703601	1058	0	\N	31
63	JARAMATAIA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703700	1058	0	\N	31
64	JEQUIA DA PRAIA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703759	1058	0	\N	31
65	JOAQUIM GOMES	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703809	1058	0	\N	31
66	JUNDIA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2703908	1058	0	\N	31
67	JUNQUEIRO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704005	1058	0	\N	31
68	LAGOA DA CANOA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704104	1058	0	\N	31
69	LIMOEIRO DE ANADIA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704203	1058	0	\N	31
70	MACEIO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704302	1058	0	\N	31
71	MAJOR ISIDORO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704401	1058	0	\N	31
72	MARAGOGI	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704500	1058	0	\N	31
73	MARAVILHA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704609	1058	0	\N	31
74	MARECHAL DEODORO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704708	1058	0	\N	31
75	MARIBONDO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704807	1058	0	\N	31
76	MAR VERMELHO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2704906	1058	0	\N	31
77	MATA GRANDE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705002	1058	0	\N	31
78	MATRIZ DE CAMARAGIBE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705101	1058	0	\N	31
79	MESSIAS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705200	1058	0	\N	31
80	MINADOR DO NEGRAO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705309	1058	0	\N	31
81	MONTEIROPOLIS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705408	1058	0	\N	31
82	MURICI	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705507	1058	0	\N	31
83	NOVO LINO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705606	1058	0	\N	31
84	OLHO D AGUA DAS FLORES	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705705	1058	0	\N	31
85	OLHO D AGUA DO CASADO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705804	1058	0	\N	31
86	OLHO D AGUA GRANDE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2705903	1058	0	\N	31
87	OLIVENCA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706000	1058	0	\N	31
88	OURO BRANCO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706109	1058	0	\N	31
89	PALESTINA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706208	1058	0	\N	31
90	PALMEIRA DOS INDIOS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706307	1058	0	\N	31
91	PAO DE ACUCAR	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706406	1058	0	\N	31
92	PARICONHA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706422	1058	0	\N	31
93	PARIPUEIRA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706448	1058	0	\N	31
94	PASSO DE CAMARAGIBE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706505	1058	0	\N	31
95	PAULO JACINTO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706604	1058	0	\N	31
96	PENEDO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706703	1058	0	\N	31
97	PIACABUCU	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706802	1058	0	\N	31
98	PILAR	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2706901	1058	0	\N	31
99	PINDOBA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707008	1058	0	\N	31
100	PIRANHAS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707107	1058	0	\N	31
101	POCO DAS TRINCHEIRAS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707206	1058	0	\N	31
102	PORTO CALVO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707305	1058	0	\N	31
103	PORTO DE PEDRAS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707404	1058	0	\N	31
104	PORTO REAL DO COLEGIO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707503	1058	0	\N	31
105	QUEBRANGULO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707602	1058	0	\N	31
106	RIO LARGO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707701	1058	0	\N	31
107	ROTEIRO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707800	1058	0	\N	31
108	SANTA LUZIA DO NORTE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2707909	1058	0	\N	31
109	SANTANA DO IPANEMA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708006	1058	0	\N	31
110	SANTANA DO MUNDAU	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708105	1058	0	\N	31
111	SAO BRAS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708204	1058	0	\N	31
112	SAO JOSE DA LAJE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708303	1058	0	\N	31
113	SAO JOSE DA TAPERA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708402	1058	0	\N	31
114	SAO LUIS DO QUITUNDE	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708501	1058	0	\N	31
115	SAO MIGUEL DOS CAMPOS	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708600	1058	0	\N	31
116	SAO MIGUEL DOS MILAGRES	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708709	1058	0	\N	31
117	SAO SEBASTIAO	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708808	1058	0	\N	31
118	SATUBA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708907	1058	0	\N	31
119	SENADOR RUI PALMEIRA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2708956	1058	0	\N	31
120	TANQUE D ARCA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2709004	1058	0	\N	31
121	TAQUARANA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2709103	1058	0	\N	31
122	TEOTONIO VILELA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2709152	1058	0	\N	31
123	TRAIPU	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2709202	1058	0	\N	31
124	UNIAO DOS PALMARES	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2709301	1058	0	\N	31
125	VICOSA	AL			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2709400	1058	0	\N	31
126	AMAPA	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600105	1058	0	\N	31
127	CALCOENE	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600204	1058	0	\N	31
128	CUTIAS	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600212	1058	0	\N	31
129	FERREIRA GOMES	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600238	1058	0	\N	31
130	ITAUBAL	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600253	1058	0	\N	31
131	LARANJAL DO JARI	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600279	1058	0	\N	31
132	MACAPA	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600303	1058	0	\N	31
133	MAZAGAO	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600402	1058	0	\N	31
134	OIAPOQUE	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600501	1058	0	\N	31
135	PEDRA BRANCA DO AMAPARI	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600154	1058	0	\N	31
136	PORTO GRANDE	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600535	1058	0	\N	31
137	PRACUUBA	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600550	1058	0	\N	31
138	SANTANA	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600600	1058	0	\N	31
139	SERRA DO NAVIO	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600055	1058	0	\N	31
140	TARTARUGALZINHO	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600709	1058	0	\N	31
141	VITORIA DO JARI	AP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1600808	1058	0	\N	31
142	ALVARAES	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300029	1058	0	\N	31
143	AMATURA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300060	1058	0	\N	31
144	ANAMA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300086	1058	0	\N	31
145	ANORI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300102	1058	0	\N	31
146	APUI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300144	1058	0	\N	31
147	ATALAIA DO NORTE	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300201	1058	0	\N	31
148	AUTAZES	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300300	1058	0	\N	31
149	BARCELOS	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300409	1058	0	\N	31
150	BARREIRINHA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300508	1058	0	\N	31
151	BENJAMIN CONSTANT	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300607	1058	0	\N	31
152	BERURI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300631	1058	0	\N	31
153	BOA VISTA DO RAMOS	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300680	1058	0	\N	31
154	BOCA DO ACRE	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300706	1058	0	\N	31
155	BORBA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300805	1058	0	\N	31
156	CAAPIRANGA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300839	1058	0	\N	31
157	CANUTAMA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1300904	1058	0	\N	31
158	CARAUARI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301001	1058	0	\N	31
159	CAREIRO	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301100	1058	0	\N	31
160	CAREIRO DA VARZEA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301159	1058	0	\N	31
161	COARI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301209	1058	0	\N	31
162	CODAJAS	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301308	1058	0	\N	31
163	EIRUNEPE	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301407	1058	0	\N	31
164	ENVIRA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301506	1058	0	\N	31
165	FONTE BOA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301605	1058	0	\N	31
166	GUAJARA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301654	1058	0	\N	31
167	HUMAITA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301704	1058	0	\N	31
168	IPIXUNA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301803	1058	0	\N	31
169	IRANDUBA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301852	1058	0	\N	31
170	ITACOATIARA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301902	1058	0	\N	31
171	ITAMARATI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1301951	1058	0	\N	31
172	ITAPIRANGA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302009	1058	0	\N	31
173	JAPURA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302108	1058	0	\N	31
174	JURUA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302207	1058	0	\N	31
175	JUTAI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302306	1058	0	\N	31
176	LABREA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302405	1058	0	\N	31
177	MANACAPURU	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302504	1058	0	\N	31
178	MANAQUIRI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302553	1058	0	\N	31
179	MANAUS	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302603	1058	0	\N	31
180	MANICORE	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302702	1058	0	\N	31
181	MARAA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302801	1058	0	\N	31
182	MAUES	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1302900	1058	0	\N	31
183	NHAMUNDA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303007	1058	0	\N	31
184	NOVA OLINDA DO NORTE	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303106	1058	0	\N	31
185	NOVO AIRAO	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303205	1058	0	\N	31
186	NOVO ARIPUANA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303304	1058	0	\N	31
187	PARINTINS	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303403	1058	0	\N	31
188	PAUINI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303502	1058	0	\N	31
189	PRESIDENTE FIGUEIREDO	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303536	1058	0	\N	31
190	RIO PRETO DA EVA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303569	1058	0	\N	31
191	SANTA ISABEL DO RIO NEGRO	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303601	1058	0	\N	31
192	SANTO ANTONIO DO ICA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303700	1058	0	\N	31
193	SAO GABRIEL DA CACHOEIRA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303809	1058	0	\N	31
194	SAO PAULO DE OLIVENCA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303908	1058	0	\N	31
195	SAO SEBASTIAO DO UATUMA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1303957	1058	0	\N	31
196	SILVES	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1304005	1058	0	\N	31
197	TABATINGA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1304062	1058	0	\N	31
198	TAPAUA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1304104	1058	0	\N	31
199	TEFE	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1304203	1058	0	\N	31
200	TONANTINS	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1304237	1058	0	\N	31
201	UARINI	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1304260	1058	0	\N	31
202	URUCARA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1304302	1058	0	\N	31
203	URUCURITUBA	AM			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1304401	1058	0	\N	31
204	ABAIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900108	1058	0	\N	31
205	ABARE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900207	1058	0	\N	31
206	ACAJUTIBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900306	1058	0	\N	31
207	ADUSTINA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900355	1058	0	\N	31
208	AGUA FRIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900405	1058	0	\N	31
209	AIQUARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900603	1058	0	\N	31
210	ALAGOINHAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900702	1058	0	\N	31
211	ALCOBACA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900801	1058	0	\N	31
212	ALMADINA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900900	1058	0	\N	31
213	AMARGOSA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901007	1058	0	\N	31
214	AMELIA RODRIGUES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901106	1058	0	\N	31
215	AMERICA DOURADA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901155	1058	0	\N	31
216	ANAGE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901205	1058	0	\N	31
217	ANDARAI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901304	1058	0	\N	31
218	ANDORINHA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901353	1058	0	\N	31
219	ANGICAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901403	1058	0	\N	31
220	ANGUERA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901502	1058	0	\N	31
221	ANTAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901601	1058	0	\N	31
222	ANTONIO CARDOSO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901700	1058	0	\N	31
223	ANTONIO GONCALVES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901809	1058	0	\N	31
224	APORA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901908	1058	0	\N	31
225	APUAREMA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2901957	1058	0	\N	31
226	ARACATU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902005	1058	0	\N	31
227	ARACAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902054	1058	0	\N	31
228	ARACI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902104	1058	0	\N	31
229	ARAMARI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902203	1058	0	\N	31
230	ARATACA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902252	1058	0	\N	31
231	ARATUIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902302	1058	0	\N	31
232	AURELINO LEAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902401	1058	0	\N	31
233	BAIANOPOLIS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902500	1058	0	\N	31
234	BAIXA GRANDE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902609	1058	0	\N	31
235	BANZAE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902658	1058	0	\N	31
236	BARRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902708	1058	0	\N	31
237	BARRA DA ESTIVA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902807	1058	0	\N	31
238	BARRA DO CHOCA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2902906	1058	0	\N	31
239	BARRA DO MENDES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903003	1058	0	\N	31
240	BARRA DO ROCHA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903102	1058	0	\N	31
241	BARREIRAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903201	1058	0	\N	31
242	BARRO ALTO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903235	1058	0	\N	31
243	BARROCAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903276	1058	0	\N	31
244	BARRO PRETO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903300	1058	0	\N	31
245	BELMONTE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903409	1058	0	\N	31
246	BELO CAMPO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903508	1058	0	\N	31
247	BIRITINGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903607	1058	0	\N	31
248	BOA NOVA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903706	1058	0	\N	31
249	BOA VISTA DO TUPIM	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903805	1058	0	\N	31
250	BOM JESUS DA LAPA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903904	1058	0	\N	31
251	BOM JESUS DA SERRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2903953	1058	0	\N	31
252	BONINAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904001	1058	0	\N	31
253	BONITO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904050	1058	0	\N	31
254	BOQUIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904100	1058	0	\N	31
255	BOTUPORA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904209	1058	0	\N	31
256	BREJOES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904308	1058	0	\N	31
257	BREJOLANDIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904407	1058	0	\N	31
258	BROTAS DE MACAUBAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904506	1058	0	\N	31
259	BRUMADO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904605	1058	0	\N	31
260	BUERAREMA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904704	1058	0	\N	31
261	BURITIRAMA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904753	1058	0	\N	31
262	CAATIBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904803	1058	0	\N	31
263	CABACEIRAS DO PARAGUACU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904852	1058	0	\N	31
264	CACHOEIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2904902	1058	0	\N	31
265	CACULE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905008	1058	0	\N	31
266	CAEM	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905107	1058	0	\N	31
267	CAETANOS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905156	1058	0	\N	31
268	CAETITE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905206	1058	0	\N	31
269	CAFARNAUM	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905305	1058	0	\N	31
270	CAIRU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905404	1058	0	\N	31
271	CALDEIRAO GRANDE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905503	1058	0	\N	31
272	CAMACAN	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905602	1058	0	\N	31
273	CAMACARI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905701	1058	0	\N	31
274	CAMAMU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905800	1058	0	\N	31
275	CAMPO ALEGRE DE LOURDES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2905909	1058	0	\N	31
276	CAMPO FORMOSO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906006	1058	0	\N	31
277	CANAPOLIS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906105	1058	0	\N	31
278	CANARANA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906204	1058	0	\N	31
279	CANAVIEIRAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906303	1058	0	\N	31
280	CANDEAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906402	1058	0	\N	31
281	CANDEIAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906501	1058	0	\N	31
282	CANDIBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906600	1058	0	\N	31
283	CANDIDO SALES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906709	1058	0	\N	31
284	CANSANCAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906808	1058	0	\N	31
285	CANUDOS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906824	1058	0	\N	31
286	CAPELA DO ALTO ALEGRE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906857	1058	0	\N	31
287	CAPIM GROSSO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906873	1058	0	\N	31
288	CARAIBAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906899	1058	0	\N	31
289	CARAVELAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2906907	1058	0	\N	31
290	CARDEAL DA SILVA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907004	1058	0	\N	31
291	CARINHANHA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907103	1058	0	\N	31
292	CASA NOVA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907202	1058	0	\N	31
293	CASTRO ALVES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907301	1058	0	\N	31
294	CATOLANDIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907400	1058	0	\N	31
295	CATU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907509	1058	0	\N	31
296	CATURAMA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907558	1058	0	\N	31
297	CENTRAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907608	1058	0	\N	31
298	CHORROCHO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907707	1058	0	\N	31
299	CICERO DANTAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907806	1058	0	\N	31
300	CIPO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2907905	1058	0	\N	31
301	COARACI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908002	1058	0	\N	31
302	COCOS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908101	1058	0	\N	31
303	CONCEICAO DA FEIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908200	1058	0	\N	31
304	CONCEICAO DO ALMEIDA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908309	1058	0	\N	31
305	CONCEICAO DO COITE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908408	1058	0	\N	31
306	CONCEICAO DO JACUIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908507	1058	0	\N	31
307	CONDE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908606	1058	0	\N	31
308	CONDEUBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908705	1058	0	\N	31
309	CONTENDAS DO SINCORA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908804	1058	0	\N	31
310	CORACAO DE MARIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2908903	1058	0	\N	31
311	CORDEIROS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909000	1058	0	\N	31
312	CORIBE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909109	1058	0	\N	31
313	CORONEL JOAO SA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909208	1058	0	\N	31
314	CORRENTINA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909307	1058	0	\N	31
315	COTEGIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909406	1058	0	\N	31
316	CRAVOLANDIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909505	1058	0	\N	31
317	CRISOPOLIS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909604	1058	0	\N	31
318	CRISTOPOLIS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909703	1058	0	\N	31
319	CRUZ DAS ALMAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909802	1058	0	\N	31
320	CURACA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2909901	1058	0	\N	31
321	DARIO MEIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910008	1058	0	\N	31
322	DIAS D AVILA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910057	1058	0	\N	31
323	DOM BASILIO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910107	1058	0	\N	31
324	DOM MACEDO COSTA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910206	1058	0	\N	31
325	ELISIO MEDRADO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910305	1058	0	\N	31
326	ENCRUZILHADA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910404	1058	0	\N	31
327	ENTRE RIOS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910503	1058	0	\N	31
328	ERICO CARDOSO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2900504	1058	0	\N	31
329	ESPLANADA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910602	1058	0	\N	31
330	EUCLIDES DA CUNHA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910701	1058	0	\N	31
331	EUNAPOLIS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910727	1058	0	\N	31
332	FATIMA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910750	1058	0	\N	31
333	FEIRA DA MATA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910776	1058	0	\N	31
334	FEIRA DE SANTANA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910800	1058	0	\N	31
335	FILADELFIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910859	1058	0	\N	31
336	FIRMINO ALVES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2910909	1058	0	\N	31
337	FLORESTA AZUL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911006	1058	0	\N	31
338	FORMOSA DO RIO PRETO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911105	1058	0	\N	31
339	GANDU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911204	1058	0	\N	31
340	GAVIAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911253	1058	0	\N	31
341	GENTIO DO OURO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911303	1058	0	\N	31
342	GLORIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911402	1058	0	\N	31
343	GONGOGI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911501	1058	0	\N	31
344	GOVERNADOR MANGABEIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911600	1058	0	\N	31
345	GUAJERU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911659	1058	0	\N	31
346	GUANAMBI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911709	1058	0	\N	31
347	GUARATINGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911808	1058	0	\N	31
348	HELIOPOLIS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911857	1058	0	\N	31
349	IACU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2911907	1058	0	\N	31
350	IBIASSUCE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912004	1058	0	\N	31
351	IBICARAI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912103	1058	0	\N	31
352	IBICOARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912202	1058	0	\N	31
353	IBICUI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912301	1058	0	\N	31
354	IBIPEBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912400	1058	0	\N	31
355	IBIPITANGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912509	1058	0	\N	31
356	IBIQUERA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912608	1058	0	\N	31
357	IBIRAPITANGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912707	1058	0	\N	31
358	IBIRAPUA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912806	1058	0	\N	31
359	IBIRATAIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2912905	1058	0	\N	31
360	IBITIARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913002	1058	0	\N	31
361	IBITITA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913101	1058	0	\N	31
362	IBOTIRAMA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913200	1058	0	\N	31
363	ICHU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913309	1058	0	\N	31
364	IGAPORA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913408	1058	0	\N	31
365	IGRAPIUNA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913457	1058	0	\N	31
366	IGUAI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913507	1058	0	\N	31
367	ILHEUS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913606	1058	0	\N	31
368	INHAMBUPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913705	1058	0	\N	31
369	IPECAETA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913804	1058	0	\N	31
370	IPIAU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2913903	1058	0	\N	31
371	IPIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914000	1058	0	\N	31
372	IPUPIARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914109	1058	0	\N	31
373	IRAJUBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914208	1058	0	\N	31
374	IRAMAIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914307	1058	0	\N	31
375	IRAQUARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914406	1058	0	\N	31
376	IRARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914505	1058	0	\N	31
377	IRECE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914604	1058	0	\N	31
378	ITABELA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914653	1058	0	\N	31
379	ITABERABA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914703	1058	0	\N	31
380	ITABUNA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914802	1058	0	\N	31
381	ITACARE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2914901	1058	0	\N	31
382	ITAETE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915007	1058	0	\N	31
383	ITAGI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915106	1058	0	\N	31
384	ITAGIBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915205	1058	0	\N	31
385	ITAGIMIRIM	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915304	1058	0	\N	31
386	ITAGUACU DA BAHIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915353	1058	0	\N	31
387	ITAJU DO COLONIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915403	1058	0	\N	31
388	ITAJUIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915502	1058	0	\N	31
389	ITAMARAJU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915601	1058	0	\N	31
390	ITAMARI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915700	1058	0	\N	31
391	ITAMBE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915809	1058	0	\N	31
392	ITANAGRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2915908	1058	0	\N	31
393	ITANHEM	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916005	1058	0	\N	31
394	ITAPARICA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916104	1058	0	\N	31
395	ITAPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916203	1058	0	\N	31
396	ITAPEBI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916302	1058	0	\N	31
397	ITAPETINGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916401	1058	0	\N	31
398	ITAPICURU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916500	1058	0	\N	31
399	ITAPITANGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916609	1058	0	\N	31
400	ITAQUARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916708	1058	0	\N	31
401	ITARANTIM	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916807	1058	0	\N	31
402	ITATIM	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916856	1058	0	\N	31
403	ITIRUCU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2916906	1058	0	\N	31
404	ITIUBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917003	1058	0	\N	31
405	ITORORO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917102	1058	0	\N	31
406	ITUACU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917201	1058	0	\N	31
407	ITUBERA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917300	1058	0	\N	31
408	IUIU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917334	1058	0	\N	31
409	JABORANDI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917359	1058	0	\N	31
410	JACARACI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917409	1058	0	\N	31
411	JACOBINA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917508	1058	0	\N	31
412	JAGUAQUARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917607	1058	0	\N	31
413	JAGUARARI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917706	1058	0	\N	31
414	JAGUARIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917805	1058	0	\N	31
415	JANDAIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2917904	1058	0	\N	31
416	JEQUIE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918001	1058	0	\N	31
417	JEREMOABO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918100	1058	0	\N	31
418	JIQUIRICA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918209	1058	0	\N	31
419	JITAUNA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918308	1058	0	\N	31
420	JOAO DOURADO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918357	1058	0	\N	31
421	JUAZEIRO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918407	1058	0	\N	31
422	JUCURUCU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918456	1058	0	\N	31
423	JUSSARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918506	1058	0	\N	31
424	JUSSARI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918555	1058	0	\N	31
425	JUSSIAPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918605	1058	0	\N	31
426	LAFAIETE COUTINHO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918704	1058	0	\N	31
427	LAGOA REAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918753	1058	0	\N	31
428	LAJE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918803	1058	0	\N	31
429	LAJEDAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2918902	1058	0	\N	31
430	LAJEDINHO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919009	1058	0	\N	31
431	LAJEDO DO TABOCAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919058	1058	0	\N	31
432	LAMARAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919108	1058	0	\N	31
433	LAPAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919157	1058	0	\N	31
434	LAURO DE FREITAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919207	1058	0	\N	31
435	LENCOIS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919306	1058	0	\N	31
436	LICINIO DE ALMEIDA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919405	1058	0	\N	31
437	LIVRAMENTO DE NOSSA SENHORA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919504	1058	0	\N	31
438	LUIS EDUARDO MAGALHAES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919553	1058	0	\N	31
439	MACAJUBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919603	1058	0	\N	31
440	MACARANI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919702	1058	0	\N	31
441	MACAUBAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919801	1058	0	\N	31
442	MACURURE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919900	1058	0	\N	31
443	MADRE DE DEUS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919926	1058	0	\N	31
444	MAETINGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2919959	1058	0	\N	31
445	MAIQUINIQUE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920007	1058	0	\N	31
446	MAIRI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920106	1058	0	\N	31
447	MALHADA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920205	1058	0	\N	31
448	MALHADA DE PEDRAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920304	1058	0	\N	31
449	MANOEL VITORINO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920403	1058	0	\N	31
450	MANSIDAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920452	1058	0	\N	31
451	MARACAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920502	1058	0	\N	31
452	MARAGOGIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920601	1058	0	\N	31
453	MARAU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920700	1058	0	\N	31
454	MARCIONILIO SOUZA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920809	1058	0	\N	31
455	MASCOTE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2920908	1058	0	\N	31
456	MATA DE SAO JOAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921005	1058	0	\N	31
457	MATINA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921054	1058	0	\N	31
458	MEDEIROS NETO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921104	1058	0	\N	31
459	MIGUEL CALMON	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921203	1058	0	\N	31
460	MILAGRES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921302	1058	0	\N	31
461	MIRANGABA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921401	1058	0	\N	31
462	MIRANTE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921450	1058	0	\N	31
463	MONTE SANTO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921500	1058	0	\N	31
464	MORPARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921609	1058	0	\N	31
465	MORRO DO CHAPEU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921708	1058	0	\N	31
466	MORTUGABA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921807	1058	0	\N	31
467	MUCUGE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2921906	1058	0	\N	31
468	MUCURI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922003	1058	0	\N	31
469	MULUNGU DO MORRO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922052	1058	0	\N	31
470	MUNDO NOVO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922102	1058	0	\N	31
471	MUNIZ FERREIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922201	1058	0	\N	31
472	MUQUEM DE SAO FRANCISCO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922250	1058	0	\N	31
473	MURITIBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922300	1058	0	\N	31
474	MUTUIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922409	1058	0	\N	31
475	NAZARE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922508	1058	0	\N	31
476	NILO PECANHA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922607	1058	0	\N	31
477	NORDESTINA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922656	1058	0	\N	31
478	NOVA CANAA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922706	1058	0	\N	31
479	NOVA FATIMA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922730	1058	0	\N	31
480	NOVA IBIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922755	1058	0	\N	31
481	NOVA ITARANA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922805	1058	0	\N	31
482	NOVA REDENCAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922854	1058	0	\N	31
483	NOVA SOURE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2922904	1058	0	\N	31
484	NOVA VICOSA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923001	1058	0	\N	31
485	NOVO HORIZONTE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923035	1058	0	\N	31
486	NOVO TRIUNFO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923050	1058	0	\N	31
487	OLINDINA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923100	1058	0	\N	31
488	OLIVEIRA DOS BREJINHOS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923209	1058	0	\N	31
489	OURICANGAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923308	1058	0	\N	31
490	OUROLANDIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923357	1058	0	\N	31
491	PALMAS DE MONTE ALTO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923407	1058	0	\N	31
492	PALMEIRAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923506	1058	0	\N	31
493	PARAMIRIM	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923605	1058	0	\N	31
494	PARATINGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923704	1058	0	\N	31
495	PARIPIRANGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923803	1058	0	\N	31
496	PAU BRASIL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2923902	1058	0	\N	31
497	PAULO AFONSO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924009	1058	0	\N	31
498	PE DE SERRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924058	1058	0	\N	31
499	PEDRAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924108	1058	0	\N	31
500	PEDRO ALEXANDRE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924207	1058	0	\N	31
501	PIATA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924306	1058	0	\N	31
502	PILAO ARCADO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924405	1058	0	\N	31
503	PINDAI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924504	1058	0	\N	31
504	PINDOBACU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924603	1058	0	\N	31
505	PINTADAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924652	1058	0	\N	31
506	PIRAI DO NORTE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924678	1058	0	\N	31
507	PIRIPA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924702	1058	0	\N	31
508	PIRITIBA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924801	1058	0	\N	31
509	PLANALTINO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2924900	1058	0	\N	31
510	PLANALTO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925006	1058	0	\N	31
511	POCOES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925105	1058	0	\N	31
512	POJUCA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925204	1058	0	\N	31
513	PONTO NOVO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925253	1058	0	\N	31
514	PORTO SEGURO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925303	1058	0	\N	31
515	POTIRAGUA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925402	1058	0	\N	31
516	PRADO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925501	1058	0	\N	31
517	PRESIDENTE DUTRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925600	1058	0	\N	31
518	PRESIDENTE JANIO QUADROS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925709	1058	0	\N	31
519	PRESIDENTE TANCREDO NEVES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925758	1058	0	\N	31
520	QUEIMADAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925808	1058	0	\N	31
521	QUIJINGUE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925907	1058	0	\N	31
522	QUIXABEIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925931	1058	0	\N	31
523	RAFAEL JAMBEIRO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2925956	1058	0	\N	31
524	REMANSO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926004	1058	0	\N	31
525	RETIROLANDIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926103	1058	0	\N	31
526	RIACHAO DAS NEVES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926202	1058	0	\N	31
527	RIACHAO DO JACUIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926301	1058	0	\N	31
528	RIACHO DE SANTANA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926400	1058	0	\N	31
529	RIBEIRA DO AMPARO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926509	1058	0	\N	31
530	RIBEIRA DO POMBAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926608	1058	0	\N	31
531	RIBEIRAO DO LARGO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926657	1058	0	\N	31
532	RIO DE CONTAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926707	1058	0	\N	31
533	RIO DO ANTONIO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926806	1058	0	\N	31
534	RIO DO PIRES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2926905	1058	0	\N	31
535	RIO REAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927002	1058	0	\N	31
536	RODELAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927101	1058	0	\N	31
537	RUY BARBOSA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927200	1058	0	\N	31
538	SALINAS DA MARGARIDA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927309	1058	0	\N	31
539	SALVADOR	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927408	1058	0	\N	31
540	SANTA BARBARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927507	1058	0	\N	31
541	SANTA BRIGIDA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927606	1058	0	\N	31
542	SANTA CRUZ CABRALIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927705	1058	0	\N	31
543	SANTA CRUZ DA VITORIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927804	1058	0	\N	31
544	SANTA INES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2927903	1058	0	\N	31
545	SANTALUZ	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928000	1058	0	\N	31
546	SANTA LUZIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928059	1058	0	\N	31
547	SANTA MARIA DA VITORIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928109	1058	0	\N	31
548	SANTANA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928208	1058	0	\N	31
549	SANTANOPOLIS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928307	1058	0	\N	31
550	SANTA RITA DE CASSIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928406	1058	0	\N	31
551	SANTA TERESINHA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928505	1058	0	\N	31
552	SANTO AMARO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928604	1058	0	\N	31
553	SANTO ANTONIO DE JESUS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928703	1058	0	\N	31
554	SANTO ESTEVAO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928802	1058	0	\N	31
555	SAO DESIDERIO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928901	1058	0	\N	31
556	SAO DOMINGOS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2928950	1058	0	\N	31
557	SAO FELIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929107	1058	0	\N	31
558	SAO FELIX	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929008	1058	0	\N	31
559	SAO FELIX DO CORIBE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929057	1058	0	\N	31
560	SAO FRANCISCO DO CONDE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929206	1058	0	\N	31
561	SAO GABRIEL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929255	1058	0	\N	31
562	SAO GONCALO DOS CAMPOS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929305	1058	0	\N	31
563	SAO JOSE DA VITORIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929354	1058	0	\N	31
564	SAO JOSE DO JACUIPE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929370	1058	0	\N	31
565	SAO MIGUEL DAS MATAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929404	1058	0	\N	31
566	SAO SEBASTIAO DO PASSE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929503	1058	0	\N	31
567	SAPEACU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929602	1058	0	\N	31
568	SATIRO DIAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929701	1058	0	\N	31
569	SAUBARA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929750	1058	0	\N	31
570	SAUDE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929800	1058	0	\N	31
571	SEABRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2929909	1058	0	\N	31
572	SEBASTIAO LARANJEIRAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930006	1058	0	\N	31
573	SENHOR DO BONFIM	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930105	1058	0	\N	31
574	SENTO SE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930204	1058	0	\N	31
575	SERRA DO RAMALHO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930154	1058	0	\N	31
576	SERRA DOURADA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930303	1058	0	\N	31
577	SERRA PRETA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930402	1058	0	\N	31
578	SERRINHA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930501	1058	0	\N	31
579	SERROLANDIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930600	1058	0	\N	31
580	SIMOES FILHO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930709	1058	0	\N	31
581	SITIO DO MATO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930758	1058	0	\N	31
582	SITIO DO QUINTO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930766	1058	0	\N	31
583	SOBRADINHO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930774	1058	0	\N	31
584	SOUTO SOARES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930808	1058	0	\N	31
585	TABOCAS DO BREJO VELHO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2930907	1058	0	\N	31
586	TANHACU	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931004	1058	0	\N	31
587	TANQUE NOVO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931053	1058	0	\N	31
588	TANQUINHO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931103	1058	0	\N	31
589	TAPEROA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931202	1058	0	\N	31
590	TAPIRAMUTA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931301	1058	0	\N	31
591	TEIXEIRA DE FREITAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931350	1058	0	\N	31
592	TEODORO SAMPAIO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931400	1058	0	\N	31
593	TEOFILANDIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931509	1058	0	\N	31
594	TEOLANDIA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931608	1058	0	\N	31
595	TERRA NOVA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931707	1058	0	\N	31
596	TREMEDAL	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931806	1058	0	\N	31
597	TUCANO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2931905	1058	0	\N	31
598	UAUA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932002	1058	0	\N	31
599	UBAIRA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932101	1058	0	\N	31
600	UBAITABA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932200	1058	0	\N	31
601	UBATA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932309	1058	0	\N	31
602	UIBAI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932408	1058	0	\N	31
603	UMBURANAS	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932457	1058	0	\N	31
604	UNA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932507	1058	0	\N	31
605	URANDI	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932606	1058	0	\N	31
606	URUCUCA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932705	1058	0	\N	31
607	UTINGA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932804	1058	0	\N	31
608	VALENCA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2932903	1058	0	\N	31
609	VALENTE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933000	1058	0	\N	31
610	VARZEA DA ROCA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933059	1058	0	\N	31
611	VARZEA DO POCO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933109	1058	0	\N	31
612	VARZEA NOVA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933158	1058	0	\N	31
613	VARZEDO	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933174	1058	0	\N	31
614	VERA CRUZ	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933208	1058	0	\N	31
615	VEREDA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933257	1058	0	\N	31
616	VITORIA DA CONQUISTA	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933307	1058	0	\N	31
617	WAGNER	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933406	1058	0	\N	31
618	WANDERLEY	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933455	1058	0	\N	31
619	WENCESLAU GUIMARAES	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933505	1058	0	\N	31
620	XIQUE XIQUE	BA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2933604	1058	0	\N	31
621	ABAIARA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300101	1058	0	\N	31
622	ACARAPE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300150	1058	0	\N	31
623	ACARAU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300200	1058	0	\N	31
624	ACOPIARA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300309	1058	0	\N	31
625	AIUABA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300408	1058	0	\N	31
626	ALCANTARAS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300507	1058	0	\N	31
627	ALTANEIRA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300606	1058	0	\N	31
628	ALTO SANTO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300705	1058	0	\N	31
629	AMONTADA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300754	1058	0	\N	31
630	ANTONINA DO NORTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300804	1058	0	\N	31
631	APUIARES	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2300903	1058	0	\N	31
632	AQUIRAZ	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301000	1058	0	\N	31
633	ARACATI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301109	1058	0	\N	31
634	ARACOIABA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301208	1058	0	\N	31
635	ARARENDA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301257	1058	0	\N	31
636	ARARIPE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301307	1058	0	\N	31
637	ARATUBA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301406	1058	0	\N	31
638	ARNEIROZ	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301505	1058	0	\N	31
639	ASSARE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301604	1058	0	\N	31
640	AURORA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301703	1058	0	\N	31
641	BAIXIO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301802	1058	0	\N	31
642	BANABUIU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301851	1058	0	\N	31
643	BARBALHA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301901	1058	0	\N	31
644	BARREIRA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2301950	1058	0	\N	31
645	BARRO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302008	1058	0	\N	31
646	BARROQUINHA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302057	1058	0	\N	31
647	BATURITE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302107	1058	0	\N	31
648	BEBERIBE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302206	1058	0	\N	31
649	BELA CRUZ	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302305	1058	0	\N	31
650	BOA VIAGEM	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302404	1058	0	\N	31
651	BREJO SANTO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302503	1058	0	\N	31
652	CAMOCIM	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302602	1058	0	\N	31
653	CAMPOS SALES	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302701	1058	0	\N	31
654	CANINDE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302800	1058	0	\N	31
655	CAPISTRANO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2302909	1058	0	\N	31
656	CARIDADE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303006	1058	0	\N	31
657	CARIRE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303105	1058	0	\N	31
658	CARIRIACU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303204	1058	0	\N	31
659	CARIUS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303303	1058	0	\N	31
660	CARNAUBAL	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303402	1058	0	\N	31
661	CASCAVEL	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303501	1058	0	\N	31
662	CATARINA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303600	1058	0	\N	31
663	CATUNDA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303659	1058	0	\N	31
664	CAUCAIA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303709	1058	0	\N	31
665	CEDRO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303808	1058	0	\N	31
666	CHAVAL	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303907	1058	0	\N	31
667	CHORO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303931	1058	0	\N	31
668	CHOROZINHO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2303956	1058	0	\N	31
669	COREAU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304004	1058	0	\N	31
670	CRATEUS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304103	1058	0	\N	31
671	CRATO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304202	1058	0	\N	31
672	CROATA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304236	1058	0	\N	31
673	CRUZ	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304251	1058	0	\N	31
674	DEPUTADO IRAPUAN RIBEIRO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304269	1058	0	\N	31
675	ERERE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304277	1058	0	\N	31
676	EUSEBIO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304285	1058	0	\N	31
677	FARIAS BRITO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304301	1058	0	\N	31
678	FORQUILHA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304350	1058	0	\N	31
679	FORTALEZA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304400	1058	0	\N	31
680	FORTIM	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304459	1058	0	\N	31
681	FRECHEIRINHA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304509	1058	0	\N	31
682	GENERAL SAMPAIO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304608	1058	0	\N	31
683	GRACA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304657	1058	0	\N	31
684	GRANJA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304707	1058	0	\N	31
685	GRANJEIRO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304806	1058	0	\N	31
686	GROIARAS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304905	1058	0	\N	31
687	GUAIUBA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2304954	1058	0	\N	31
688	GUARACIABA DO NORTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305001	1058	0	\N	31
689	GUARAMIRANGA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305100	1058	0	\N	31
690	HIDROLANDIA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305209	1058	0	\N	31
691	HORIZONTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305233	1058	0	\N	31
692	IBARETAMA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305266	1058	0	\N	31
693	IBIAPINA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305308	1058	0	\N	31
694	IBICUITINGA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305332	1058	0	\N	31
695	ICAPUI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305357	1058	0	\N	31
696	ICO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305407	1058	0	\N	31
697	IGUATU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305506	1058	0	\N	31
698	INDEPENDENCIA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305605	1058	0	\N	31
699	IPAPORANGA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305654	1058	0	\N	31
700	IPAUMIRIM	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305704	1058	0	\N	31
701	IPU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305803	1058	0	\N	31
702	IPUEIRAS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2305902	1058	0	\N	31
703	IRACEMA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306009	1058	0	\N	31
704	IRAUCUBA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306108	1058	0	\N	31
705	ITAICABA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306207	1058	0	\N	31
706	ITAITINGA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306256	1058	0	\N	31
707	ITAPAGE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306306	1058	0	\N	31
708	ITAPIPOCA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306405	1058	0	\N	31
709	ITAPIUNA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306504	1058	0	\N	31
710	ITAREMA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306553	1058	0	\N	31
711	ITATIRA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306603	1058	0	\N	31
712	JAGUARETAMA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306702	1058	0	\N	31
713	JAGUARIBARA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306801	1058	0	\N	31
714	JAGUARIBE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2306900	1058	0	\N	31
715	JAGUARUANA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307007	1058	0	\N	31
716	JARDIM	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307106	1058	0	\N	31
717	JATI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307205	1058	0	\N	31
718	JIJOCA DE JERICOACOARA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307254	1058	0	\N	31
719	JUAZEIRO DO NORTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307304	1058	0	\N	31
720	JUCAS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307403	1058	0	\N	31
721	LAVRAS DA MANGABEIRA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307502	1058	0	\N	31
722	LIMOEIRO DO NORTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307601	1058	0	\N	31
723	MADALENA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307635	1058	0	\N	31
724	MARACANAU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307650	1058	0	\N	31
725	MARANGUAPE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307700	1058	0	\N	31
726	MARCO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307809	1058	0	\N	31
727	MARTINOPOLE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2307908	1058	0	\N	31
728	MASSAPE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308005	1058	0	\N	31
729	MAURITI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308104	1058	0	\N	31
730	MERUOCA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308203	1058	0	\N	31
731	MILAGRES	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308302	1058	0	\N	31
732	MILHA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308351	1058	0	\N	31
733	MIRAIMA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308377	1058	0	\N	31
734	MISSAO VELHA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308401	1058	0	\N	31
735	MOMBACA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308500	1058	0	\N	31
736	MONSENHOR TABOSA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308609	1058	0	\N	31
737	MORADA NOVA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308708	1058	0	\N	31
738	MORAUJO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308807	1058	0	\N	31
739	MORRINHOS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2308906	1058	0	\N	31
740	MUCAMBO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309003	1058	0	\N	31
741	MULUNGU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309102	1058	0	\N	31
742	NOVA OLINDA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309201	1058	0	\N	31
743	NOVA RUSSAS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309300	1058	0	\N	31
744	NOVO ORIENTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309409	1058	0	\N	31
745	OCARA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309458	1058	0	\N	31
746	OROS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309508	1058	0	\N	31
747	PACAJUS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309607	1058	0	\N	31
748	PACATUBA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309706	1058	0	\N	31
749	PACOTI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309805	1058	0	\N	31
750	PACUJA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2309904	1058	0	\N	31
751	PALHANO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310001	1058	0	\N	31
752	PALMACIA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310100	1058	0	\N	31
753	PARACURU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310209	1058	0	\N	31
754	PARAIPABA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310258	1058	0	\N	31
755	PARAMBU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310308	1058	0	\N	31
756	PARAMOTI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310407	1058	0	\N	31
757	PEDRA BRANCA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310506	1058	0	\N	31
758	PENA FORTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310605	1058	0	\N	31
759	PENTECOSTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310704	1058	0	\N	31
760	PEREIRO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310803	1058	0	\N	31
761	PINDORETAMA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310852	1058	0	\N	31
762	PIQUET CARNEIRO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310902	1058	0	\N	31
763	PIRES FERREIRA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2310951	1058	0	\N	31
764	PORANGA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311009	1058	0	\N	31
765	PORTEIRAS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311108	1058	0	\N	31
766	POTENGI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311207	1058	0	\N	31
767	POTIRETAMA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311231	1058	0	\N	31
768	QUITERIANOPOLIS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311264	1058	0	\N	31
769	QUIXADA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311306	1058	0	\N	31
770	QUIXELO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311355	1058	0	\N	31
771	QUIXERAMOBIM	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311405	1058	0	\N	31
772	QUIXERE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311504	1058	0	\N	31
773	REDENCAO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311603	1058	0	\N	31
774	RERIUTABA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311702	1058	0	\N	31
775	RUSSAS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311801	1058	0	\N	31
776	SABOEIRO	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311900	1058	0	\N	31
777	SALITRE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2311959	1058	0	\N	31
778	SANTANA DO ACARAU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312007	1058	0	\N	31
779	SANTANA DO CARIRI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312106	1058	0	\N	31
780	SANTA QUITERIA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312205	1058	0	\N	31
781	SAO BENEDIT	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312304	1058	0	\N	31
782	SAO GONCALO DO AMARANTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312403	1058	0	\N	31
783	SAO JOAO DO JAGUARIBE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312502	1058	0	\N	31
784	SAO LUIZ DO CURU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312601	1058	0	\N	31
785	SENADOR POMPEU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312700	1058	0	\N	31
786	SENADOR SA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312809	1058	0	\N	31
787	SOBRAL	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2312908	1058	0	\N	31
788	SOLONOPOLE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313005	1058	0	\N	31
789	TABULEIRO DO NORTE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313104	1058	0	\N	31
790	TAMBORIL	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313203	1058	0	\N	31
791	TARRAFAS	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313252	1058	0	\N	31
792	TAUA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313302	1058	0	\N	31
793	TEJUCUOCA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313351	1058	0	\N	31
794	TIANGUA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313401	1058	0	\N	31
795	TRAIRI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313500	1058	0	\N	31
796	TURURU	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313559	1058	0	\N	31
797	UBAJARA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313609	1058	0	\N	31
798	UMARI	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313708	1058	0	\N	31
799	UMIRIM	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313757	1058	0	\N	31
800	URUBURETAMA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313807	1058	0	\N	31
801	URUOCA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313906	1058	0	\N	31
802	VARJOTA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2313955	1058	0	\N	31
803	VARZEA ALEGRE	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2314003	1058	0	\N	31
804	VICOSA DO CEARA	CE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2314102	1058	0	\N	31
805	BRASILIA	DF			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5300108	1058	0	\N	31
806	AFONSO CLAUDIO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200102	1058	0	\N	31
807	AGUA DOCE DO NORTE	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200169	1058	0	\N	31
808	AGUIA BRANCA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200136	1058	0	\N	31
809	ALEGRE	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200201	1058	0	\N	31
810	ALFREDO CHAVES	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200300	1058	0	\N	31
811	ALTO RIO NOVO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200359	1058	0	\N	31
812	ANCHIETA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200409	1058	0	\N	31
813	APIACA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200508	1058	0	\N	31
814	ARACRUZ	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200607	1058	0	\N	31
815	ATILIO VIVACQUA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200706	1058	0	\N	31
816	BAIXO GUANDU	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200805	1058	0	\N	31
817	BARRA DE SAO FRANCISCO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3200904	1058	0	\N	31
818	BOA ESPERANCA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201001	1058	0	\N	31
819	BOM JESUS DO NORTE	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201100	1058	0	\N	31
820	BREJETUBA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201159	1058	0	\N	31
821	CACHOEIRO DE ITAPEMIRIM	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201209	1058	0	\N	31
822	CARIACICA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201308	1058	0	\N	31
823	CASTELO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201407	1058	0	\N	31
824	COLATINA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201506	1058	0	\N	31
825	CONCEICAO DA BARRA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201605	1058	0	\N	31
826	CONCEICAO DO CASTELO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201704	1058	0	\N	31
827	DIVINO DE SAO LOURENCO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201803	1058	0	\N	31
828	DOMINGOS MARTINS	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3201902	1058	0	\N	31
829	DORES DO RIO PRETO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202009	1058	0	\N	31
830	ECOPORANGA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202108	1058	0	\N	31
831	FUNDAO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202207	1058	0	\N	31
832	GOVERNADOR LINDENBERG	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202256	1058	0	\N	31
833	GUACUI	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202306	1058	0	\N	31
834	GUARAPARI	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202405	1058	0	\N	31
835	IBATIBA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202454	1058	0	\N	31
836	IBIRACU	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202504	1058	0	\N	31
837	IBITIRAMA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202553	1058	0	\N	31
838	ICONHA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202603	1058	0	\N	31
839	IRUPI	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202652	1058	0	\N	31
840	ITAGUACU	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202702	1058	0	\N	31
841	ITAPEMIRIM	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202801	1058	0	\N	31
842	ITARANA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3202900	1058	0	\N	31
843	IUNA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203007	1058	0	\N	31
844	JAGUARE	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203056	1058	0	\N	31
845	JERONIMO MONTEIRO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203106	1058	0	\N	31
846	JOAO NEIVA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203130	1058	0	\N	31
847	LARANJA DA TERRA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203163	1058	0	\N	31
848	LINHARES	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203205	1058	0	\N	31
849	MANTENOPOLIS	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203304	1058	0	\N	31
850	MARATAIZES	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203320	1058	0	\N	31
851	MARECHAL FLORIANO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203346	1058	0	\N	31
852	MARILANDIA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203353	1058	0	\N	31
853	MIMOSO DO SUL	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203403	1058	0	\N	31
854	MONTANHA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203502	1058	0	\N	31
855	MUCURICI	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203601	1058	0	\N	31
856	MUNIZ FREIRE	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203700	1058	0	\N	31
857	MUQUI	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203809	1058	0	\N	31
858	NOVA VENECIA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3203908	1058	0	\N	31
859	PANCAS	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204005	1058	0	\N	31
860	PEDRO CANARIO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204054	1058	0	\N	31
861	PINHEIROS	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204104	1058	0	\N	31
862	PIUMA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204203	1058	0	\N	31
863	PONTO BELO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204252	1058	0	\N	31
864	PRESIDENTE KENNEDY	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204302	1058	0	\N	31
865	RIO BANANAL	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204351	1058	0	\N	31
866	RIO NOVO DO SUL	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204401	1058	0	\N	31
867	SANTA LEOPOLDINA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204500	1058	0	\N	31
868	SANTA MARIA DE JETIBA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204559	1058	0	\N	31
869	SANTA TERESA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204609	1058	0	\N	31
870	SAO DOMINGOS DO NORTE	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204658	1058	0	\N	31
871	SAO GABRIEL DA PALHA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204708	1058	0	\N	31
872	SAO JOSE DO CALCADO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204807	1058	0	\N	31
873	SAO MATEUS	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204906	1058	0	\N	31
874	SAO ROQUE DO CANAA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3204955	1058	0	\N	31
875	SERRA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3205002	1058	0	\N	31
876	SOORETAMA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3205010	1058	0	\N	31
877	VARGEM ALTA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3205036	1058	0	\N	31
878	VENDA NOVA DO IMIGRANTE	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3205069	1058	0	\N	31
879	VIANA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3205101	1058	0	\N	31
880	VILA PAVAO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3205150	1058	0	\N	31
881	VILA VALERIO	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3205176	1058	0	\N	31
882	VILA VELHA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3205200	1058	0	\N	31
883	VITORIA	ES			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3205309	1058	0	\N	31
884	ABADIA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200050	1058	0	\N	31
885	ABADIANIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200100	1058	0	\N	31
886	ACREUNA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200134	1058	0	\N	31
887	ADELANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200159	1058	0	\N	31
888	AGUA FRIA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200175	1058	0	\N	31
889	AGUA LIMPA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200209	1058	0	\N	31
890	AGUAS LINDAS DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200258	1058	0	\N	31
891	ALEXANIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200308	1058	0	\N	31
892	ALOANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200506	1058	0	\N	31
893	ALTO HORIZONTE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200555	1058	0	\N	31
894	ALTO PARAISO DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200605	1058	0	\N	31
895	ALVORADA DO NORTE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200803	1058	0	\N	31
896	AMARALINA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200829	1058	0	\N	31
897	AMERICANO DO BRASIL	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200852	1058	0	\N	31
898	AMORINOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5200902	1058	0	\N	31
899	ANAPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5201108	1058	0	\N	31
900	ANHANGUERA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5201207	1058	0	\N	31
901	ANICUNS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5201306	1058	0	\N	31
902	APARECIDA DE GOIANIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5201405	1058	0	\N	31
903	APARECIDA DO RIO DOCE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5201454	1058	0	\N	31
904	APORE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5201504	1058	0	\N	31
905	ARACU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5201603	1058	0	\N	31
906	ARAGARCAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5201702	1058	0	\N	31
907	ARAGOIANIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5201801	1058	0	\N	31
908	ARAGUAPAZ	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5202155	1058	0	\N	31
909	ARENOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5202353	1058	0	\N	31
910	ARUANA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5202502	1058	0	\N	31
911	AURILANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5202601	1058	0	\N	31
912	AVELINOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5202809	1058	0	\N	31
913	BALIZA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203104	1058	0	\N	31
914	BARRO ALTO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203203	1058	0	\N	31
915	BELA VISTA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203302	1058	0	\N	31
916	BOM JARDIM DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203401	1058	0	\N	31
917	BOM JESUS DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203500	1058	0	\N	31
918	BONFINOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203559	1058	0	\N	31
919	BONOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203575	1058	0	\N	31
920	BRAZABRANTES	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203609	1058	0	\N	31
921	BRITANIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203807	1058	0	\N	31
922	BURITI ALEGRE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203906	1058	0	\N	31
923	BURITI DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203939	1058	0	\N	31
924	BURITINOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5203962	1058	0	\N	31
925	CABECEIRAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204003	1058	0	\N	31
926	CACHOEIRA ALTA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204102	1058	0	\N	31
927	CACHOEIRA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204201	1058	0	\N	31
928	CACHOEIRA DOURADA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204250	1058	0	\N	31
929	CACU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204300	1058	0	\N	31
930	CAIAPONIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204409	1058	0	\N	31
931	CALDAS NOVAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204508	1058	0	\N	31
932	CALDAZINHA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204557	1058	0	\N	31
933	CAMPESTRE DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204607	1058	0	\N	31
934	CAMPINACU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204656	1058	0	\N	31
935	CAMPINORTE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204706	1058	0	\N	31
936	CAMPO ALEGRE DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204805	1058	0	\N	31
937	CAMPO LIMPO DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204854	1058	0	\N	31
938	CAMPOS BELOS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204904	1058	0	\N	31
939	CAMPOS VERDES	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5204953	1058	0	\N	31
940	CARMO DO RIO VERDE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205000	1058	0	\N	31
941	CASTELANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205059	1058	0	\N	31
942	CATALAO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205109	1058	0	\N	31
943	CATURAI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205208	1058	0	\N	31
944	CAVALCANTE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205307	1058	0	\N	31
945	CERES	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205406	1058	0	\N	31
946	CEZARINA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205455	1058	0	\N	31
947	CHAPADAO DO CEU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205471	1058	0	\N	31
948	CIDADE OCIDENTAL	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205497	1058	0	\N	31
949	COCALZINHO DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205513	1058	0	\N	31
950	COLINAS DO SUL	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205521	1058	0	\N	31
951	CORREGO DO OURO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205703	1058	0	\N	31
952	CORUMBA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205802	1058	0	\N	31
953	CORUMBAIBA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5205901	1058	0	\N	31
954	CRISTALINA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5206206	1058	0	\N	31
955	CRISTIANOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5206305	1058	0	\N	31
956	CRIXAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5206404	1058	0	\N	31
957	CROMINIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5206503	1058	0	\N	31
958	CUMARI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5206602	1058	0	\N	31
959	DAMIANOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5206701	1058	0	\N	31
960	DAMOLANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5206800	1058	0	\N	31
961	DAVINOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5206909	1058	0	\N	31
962	DIORAMA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5207105	1058	0	\N	31
963	DOVERLANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5207253	1058	0	\N	31
964	EDEALINA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5207352	1058	0	\N	31
965	EDEIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5207402	1058	0	\N	31
966	ESTRELA DO NORTE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5207501	1058	0	\N	31
967	FAINA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5207535	1058	0	\N	31
968	FAZENDA NOVA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5207600	1058	0	\N	31
969	FIRMINOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5207808	1058	0	\N	31
970	FLORES DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5207907	1058	0	\N	31
971	FORMOSA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5208004	1058	0	\N	31
972	FORMOSO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5208103	1058	0	\N	31
973	DIVINOPOLIS DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5208301	1058	0	\N	31
974	GAMELEIRA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5208152	1058	0	\N	31
975	GOIANAPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5208400	1058	0	\N	31
976	GOIANDIRA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5208509	1058	0	\N	31
977	GOIANESIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5208608	1058	0	\N	31
978	GOIANIRA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5208806	1058	0	\N	31
979	GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5208905	1058	0	\N	31
980	GOIATUBA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209101	1058	0	\N	31
981	GOUVELANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209150	1058	0	\N	31
982	GUAPO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209200	1058	0	\N	31
983	GUARAITA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209291	1058	0	\N	31
984	GUARANI DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209408	1058	0	\N	31
985	GUARINOS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209457	1058	0	\N	31
986	HEITORAI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209606	1058	0	\N	31
987	HIDROLANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209705	1058	0	\N	31
988	HIDROLINA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209804	1058	0	\N	31
989	IACIARA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209903	1058	0	\N	31
990	INACIOLANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209937	1058	0	\N	31
991	INDIARA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5209952	1058	0	\N	31
992	INHUMAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210000	1058	0	\N	31
993	IPAMERI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210109	1058	0	\N	31
994	IPIRANGA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210158	1058	0	\N	31
995	IPORA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210208	1058	0	\N	31
996	ISRAELANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210307	1058	0	\N	31
997	ITABERAI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210406	1058	0	\N	31
998	ITAGUARI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210562	1058	0	\N	31
999	ITAGUARU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210604	1058	0	\N	31
1000	ITAJA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210802	1058	0	\N	31
1001	ITAPACI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5210901	1058	0	\N	31
1002	ITAPIRAPUA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5211008	1058	0	\N	31
1003	ITAPURANGA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5211206	1058	0	\N	31
1004	ITARUMA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5211305	1058	0	\N	31
1005	ITAUCU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5211404	1058	0	\N	31
1006	ITUMBIARA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5211503	1058	0	\N	31
1007	IVOLANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5211602	1058	0	\N	31
1008	JANDAIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5211701	1058	0	\N	31
1009	JARAGUA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5211800	1058	0	\N	31
1010	JATAI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5211909	1058	0	\N	31
1011	JAUPACI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212006	1058	0	\N	31
1012	JESUPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212055	1058	0	\N	31
1013	JOVIANIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212105	1058	0	\N	31
1014	JUSSARA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212204	1058	0	\N	31
1015	LAGOA SANTA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212253	1058	0	\N	31
1016	LEOPOLDO DE BULHOES	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212303	1058	0	\N	31
1017	LUZIANIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212501	1058	0	\N	31
1018	MAIRIPOTABA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212600	1058	0	\N	31
1019	MAMBAI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212709	1058	0	\N	31
1020	MARA ROSA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212808	1058	0	\N	31
1021	MARZAGAO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212907	1058	0	\N	31
1022	MATRINCHA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5212956	1058	0	\N	31
1023	MAURILANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213004	1058	0	\N	31
1024	MIMOSO DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213053	1058	0	\N	31
1025	MINACU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213087	1058	0	\N	31
1026	MINEIROS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213103	1058	0	\N	31
1027	MOIPORA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213400	1058	0	\N	31
1028	MONTE ALEGRE DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213509	1058	0	\N	31
1029	MONTES CLAROS DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213707	1058	0	\N	31
1030	MONTIVIDIU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213756	1058	0	\N	31
1031	MONTIVIDIU DO NORTE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213772	1058	0	\N	31
1032	MORRINHOS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213806	1058	0	\N	31
1033	MORRO AGUDO DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213855	1058	0	\N	31
1034	MOSSAMEDES	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5213905	1058	0	\N	31
1035	MOZARLANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214002	1058	0	\N	31
1036	MUNDO NOVO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214051	1058	0	\N	31
1037	MUTUNOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214101	1058	0	\N	31
1038	NAZARIO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214408	1058	0	\N	31
1039	NEROPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214507	1058	0	\N	31
1040	NIQUELANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214606	1058	0	\N	31
1041	NOVA AMERICA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214705	1058	0	\N	31
1042	NOVA AURORA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214804	1058	0	\N	31
1043	NOVA CRIXAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214838	1058	0	\N	31
1044	NOVA GLORIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214861	1058	0	\N	31
1045	NOVA IGUACU DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214879	1058	0	\N	31
1046	NOVA ROMA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5214903	1058	0	\N	31
1047	NOVA VENEZA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215009	1058	0	\N	31
1048	NOVO BRASIL	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215207	1058	0	\N	31
1049	NOVO GAMA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215231	1058	0	\N	31
1050	NOVO PLANALTO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215256	1058	0	\N	31
1051	ORIZONA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215306	1058	0	\N	31
1052	OURO VERDE DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215405	1058	0	\N	31
1053	OUVIDOR	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215504	1058	0	\N	31
1054	PADRE BERNARDO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215603	1058	0	\N	31
1055	PALESTINA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215652	1058	0	\N	31
1056	PALMEIRAS DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215702	1058	0	\N	31
1057	PALMELO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215801	1058	0	\N	31
1058	PALMINOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5215900	1058	0	\N	31
1059	PANAMA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5216007	1058	0	\N	31
1060	PARANAIGUARA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5216304	1058	0	\N	31
1061	PARAUNA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5216403	1058	0	\N	31
1062	PEROLANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5216452	1058	0	\N	31
1063	PETROLINA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5216809	1058	0	\N	31
1064	PILAR DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5216908	1058	0	\N	31
1065	PIRACANJUBA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5217104	1058	0	\N	31
1066	PIRANHAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5217203	1058	0	\N	31
1067	PIRENOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5217302	1058	0	\N	31
1068	PIRES DO RIO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5217401	1058	0	\N	31
1069	PLANALTINA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5217609	1058	0	\N	31
1070	PONTALINA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5217708	1058	0	\N	31
1071	PORANGATU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218003	1058	0	\N	31
1072	PORTEIRAO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218052	1058	0	\N	31
1073	PORTELANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218102	1058	0	\N	31
1074	POSSE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218300	1058	0	\N	31
1075	PROFESSOR JAMIL	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218391	1058	0	\N	31
1076	QUIRINOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218508	1058	0	\N	31
1077	RIALMA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218607	1058	0	\N	31
1078	RIANAPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218706	1058	0	\N	31
1079	RIO QUENTE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218789	1058	0	\N	31
1080	RIO VERDE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218805	1058	0	\N	31
1081	RUBIATABA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5218904	1058	0	\N	31
1082	SANCLERLANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219001	1058	0	\N	31
1083	SANTA BARBARA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219100	1058	0	\N	31
1084	SANTA CRUZ DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219209	1058	0	\N	31
1085	SANTA FE DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219258	1058	0	\N	31
1086	SANTA HELENA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219308	1058	0	\N	31
1087	SANTA ISABEL	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219357	1058	0	\N	31
1088	SANTA RITA DO ARAGUAIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219407	1058	0	\N	31
1089	SANTA RITA DO NOVO DESTINO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219456	1058	0	\N	31
1090	SANTA ROSA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219506	1058	0	\N	31
1091	SANTA TEREZA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219605	1058	0	\N	31
1092	SANTA TEREZINHA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219704	1058	0	\N	31
1093	SANTO ANTONIO DA BARRA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219712	1058	0	\N	31
1094	SANTO ANTONIO DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219738	1058	0	\N	31
1095	SANTO ANTONIO DO DESCOBERTO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219753	1058	0	\N	31
1096	SAO DOMINGOS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219803	1058	0	\N	31
1097	SAO FRANCISCO DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5219902	1058	0	\N	31
1098	SAO JOAO D ALIANCA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220009	1058	0	\N	31
1099	SAO JOAO DA PARAUNA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220058	1058	0	\N	31
1100	SAO LUIS DE MONTES BELOS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220108	1058	0	\N	31
1101	SAO LUIZ DO NORTE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220157	1058	0	\N	31
1102	SAO MIGUEL DO ARAGUAIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220207	1058	0	\N	31
1103	SAO MIGUEL DO PASSA QUATRO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220264	1058	0	\N	31
1104	SAO PATRICIO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220280	1058	0	\N	31
1105	SAO SIMAO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220405	1058	0	\N	31
1106	SENADOR CANEDO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220454	1058	0	\N	31
1107	SERRANOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220504	1058	0	\N	31
1108	SILVANIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220603	1058	0	\N	31
1109	SIMOLANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220686	1058	0	\N	31
1110	SITIO D ABADIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5220702	1058	0	\N	31
1111	TAQUARAL DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221007	1058	0	\N	31
1112	TERESINA DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221080	1058	0	\N	31
1113	TEREZOPOLIS DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221197	1058	0	\N	31
1114	TRES RANCHOS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221304	1058	0	\N	31
1115	TRINDADE	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221403	1058	0	\N	31
1116	TROMBAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221452	1058	0	\N	31
1117	TURVANIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221502	1058	0	\N	31
1118	TURVELANDIA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221551	1058	0	\N	31
1119	UIRAPURU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221577	1058	0	\N	31
1120	URUACU	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221601	1058	0	\N	31
1121	URUANA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221700	1058	0	\N	31
1122	URUTAI	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221809	1058	0	\N	31
1123	VALPARAISO DE GOIAS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221858	1058	0	\N	31
1124	VARJAO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5221908	1058	0	\N	31
1125	VIANOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5222005	1058	0	\N	31
1126	VICENTINOPOLIS	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5222054	1058	0	\N	31
1127	VILA BOA	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5222203	1058	0	\N	31
1128	VILA PROPICIO	GO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5222302	1058	0	\N	31
1129	ACAILANDIA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100055	1058	0	\N	31
1130	AFONSO CUNHA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100105	1058	0	\N	31
1131	AGUA DOCE DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100154	1058	0	\N	31
1132	ALCANTARA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100204	1058	0	\N	31
1133	ALDEIAS ALTAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100303	1058	0	\N	31
1134	ALTAMIRA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100402	1058	0	\N	31
1135	ALTO ALEGRE DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100436	1058	0	\N	31
1136	ALTO ALEGRE DO PINDARE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100477	1058	0	\N	31
1137	ALTO PARNAIBA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100501	1058	0	\N	31
1138	AMAPA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100550	1058	0	\N	31
1139	AMARANTE DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100600	1058	0	\N	31
1140	ANAJATUBA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100709	1058	0	\N	31
1141	ANAPURUS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100808	1058	0	\N	31
1142	APICUM ACU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100832	1058	0	\N	31
1143	ARAGUANA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100873	1058	0	\N	31
1144	ARAIOSES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100907	1058	0	\N	31
1145	ARAME	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2100956	1058	0	\N	31
1146	ARARI	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101004	1058	0	\N	31
1147	AXIXA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101103	1058	0	\N	31
1149	BACABEIRA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101251	1058	0	\N	31
1150	BACURI	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101301	1058	0	\N	31
1151	BACURITUBA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101350	1058	0	\N	31
1152	BALSAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101400	1058	0	\N	31
1153	BARAO DE GRAJAU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101509	1058	0	\N	31
1154	BARRA DO CORDA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101608	1058	0	\N	31
1155	BARREIRINHAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101707	1058	0	\N	31
1156	BELAGUA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101731	1058	0	\N	31
1157	BELA VISTA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101772	1058	0	\N	31
1158	BENEDITO LEITE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101806	1058	0	\N	31
1159	BEQUIMAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101905	1058	0	\N	31
1160	BERNARDO DO MEARIM	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101939	1058	0	\N	31
1161	BOA VISTA DO GURUPI	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2101970	1058	0	\N	31
1162	BOM JARDIM	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102002	1058	0	\N	31
1163	BOM JESUS DAS SELVAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102036	1058	0	\N	31
1164	BOM LUGAR	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102077	1058	0	\N	31
1165	BREJO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102101	1058	0	\N	31
1166	BREJO DE AREIA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102150	1058	0	\N	31
1167	BURITI	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102200	1058	0	\N	31
1168	BURITI BRAVO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102309	1058	0	\N	31
1169	BURITICUPU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102325	1058	0	\N	31
1170	BURITIRANA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102358	1058	0	\N	31
1171	CACHOEIRA GRANDE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102374	1058	0	\N	31
1172	CAJAPIO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102408	1058	0	\N	31
1173	CAJARI	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102507	1058	0	\N	31
1174	CAMPESTRE DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102556	1058	0	\N	31
1175	CANDIDO MENDES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102606	1058	0	\N	31
1176	CANTANHEDE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102705	1058	0	\N	31
1177	CAPINZAL DO NORTE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102754	1058	0	\N	31
1178	CAROLINA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102804	1058	0	\N	31
1179	CARUTAPERA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2102903	1058	0	\N	31
1180	CAXIAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103000	1058	0	\N	31
1181	CEDRAL	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103109	1058	0	\N	31
1182	CENTRAL DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103125	1058	0	\N	31
1183	CENTRO DO GUILHERME	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103158	1058	0	\N	31
1184	CENTRO NOVO DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103174	1058	0	\N	31
1185	CHAPADINHA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103208	1058	0	\N	31
1186	CIDELANDIA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103257	1058	0	\N	31
1187	CODO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103307	1058	0	\N	31
1188	COELHO NETO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103406	1058	0	\N	31
1189	COLINAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103505	1058	0	\N	31
1190	CONCEICAO DO LAGO ACU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103554	1058	0	\N	31
1191	COROATA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103604	1058	0	\N	31
1192	CURURUPU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103703	1058	0	\N	31
1193	DAVINOPOLIS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103752	1058	0	\N	31
1194	DOM PEDRO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103802	1058	0	\N	31
1195	DUQUE BACELAR	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2103901	1058	0	\N	31
1196	ESPERANTINOPOLIS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104008	1058	0	\N	31
1197	ESTREITO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104057	1058	0	\N	31
1198	FEIRA NOVA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104073	1058	0	\N	31
1199	FERNANDO FALCAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104081	1058	0	\N	31
1200	FORMOSA DA SERRA NEGRA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104099	1058	0	\N	31
1201	FORTALEZA DOS NOGUEIRAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104107	1058	0	\N	31
1202	FORTUNA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104206	1058	0	\N	31
1203	GODOFREDO VIANA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104305	1058	0	\N	31
1204	GONCALVES DIAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104404	1058	0	\N	31
1205	GOVERNADOR ARCHER	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104503	1058	0	\N	31
1206	GOVERNADOR EDISON LOBAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104552	1058	0	\N	31
1207	GOVERNADOR EUGENIO BARROS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104602	1058	0	\N	31
1208	GOVERNADOR LUIS ROCHA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104628	1058	0	\N	31
1209	GOVERNADOR NEWTON BELLO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104651	1058	0	\N	31
1210	GOVERNADOR NUNES FREIRE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104677	1058	0	\N	31
1211	GRACA ARANHA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104701	1058	0	\N	31
1212	GRAJAU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104800	1058	0	\N	31
1213	GUIMARAES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2104909	1058	0	\N	31
1214	HUMBERTO DE CAMPOS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105005	1058	0	\N	31
1215	ICATU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105104	1058	0	\N	31
1216	IGARAPE DO MEIO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105153	1058	0	\N	31
1217	IGARAPE GRANDE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105203	1058	0	\N	31
1218	IMPERATRIZ	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105302	1058	0	\N	31
1219	ITAIPAVA DO GRAJAU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105351	1058	0	\N	31
1220	ITAPECURU MIRIM	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105401	1058	0	\N	31
1221	ITINGA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105427	1058	0	\N	31
1222	JATOBA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105450	1058	0	\N	31
1223	JENIPAPO DOS VIEIRAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105476	1058	0	\N	31
1224	JOAO LISBOA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105500	1058	0	\N	31
1225	JOSELANDIA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105609	1058	0	\N	31
1226	JUNCO DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105658	1058	0	\N	31
1227	LAGOA DO MATO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105922	1058	0	\N	31
1228	LAGOA GRANDE DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105963	1058	0	\N	31
1229	LAGO DA PEDRA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105708	1058	0	\N	31
1230	LAGO DO JUNCO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105807	1058	0	\N	31
1231	LAGO DOS RODRIGUES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105948	1058	0	\N	31
1232	LAGO VERDE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105906	1058	0	\N	31
1233	LAJEADO NOVO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2105989	1058	0	\N	31
1234	LIMA CAMPOS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106003	1058	0	\N	31
1235	LORETO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106102	1058	0	\N	31
1236	LUIS DOMINGUES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106201	1058	0	\N	31
1237	MAGALHAES DE ALMEIDA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106300	1058	0	\N	31
1238	MARACACUME	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106326	1058	0	\N	31
1239	MARAJA DO SENA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106359	1058	0	\N	31
1240	MARANHAOZINHO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106375	1058	0	\N	31
1241	MATA ROMA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106409	1058	0	\N	31
1242	MATINHA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106508	1058	0	\N	31
1243	MATOES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106607	1058	0	\N	31
1244	MATOES DO NORTE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106631	1058	0	\N	31
1245	MILAGRES DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106672	1058	0	\N	31
1246	MIRADOR	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106706	1058	0	\N	31
1247	MIRANDA DO NORTE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106755	1058	0	\N	31
1248	MIRINZAL	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106805	1058	0	\N	31
1249	MONCAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2106904	1058	0	\N	31
1250	MONTES ALTOS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107001	1058	0	\N	31
1251	MORROS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107100	1058	0	\N	31
1252	NINA RODRIGUES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107209	1058	0	\N	31
1253	NOVA COLINAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107258	1058	0	\N	31
1254	NOVA IORQUE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107308	1058	0	\N	31
1255	NOVA OLINDA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107357	1058	0	\N	31
1256	OLHO D AGUA DAS CUNHAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107407	1058	0	\N	31
1257	OLINDA NOVA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107456	1058	0	\N	31
1258	PACO DO LUMIAR	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107506	1058	0	\N	31
1259	PALMEIRANDIA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107605	1058	0	\N	31
1260	PARAIBANO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107704	1058	0	\N	31
1261	PARNARAMA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107803	1058	0	\N	31
1262	PASSAGEM FRANCA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2107902	1058	0	\N	31
1263	PASTOS BONS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108009	1058	0	\N	31
1264	PAULINO NEVES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108058	1058	0	\N	31
1265	PAULO RAMOS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108108	1058	0	\N	31
1266	PEDREIRAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108207	1058	0	\N	31
1267	PEDRO DO ROSARIO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108256	1058	0	\N	31
1268	PENALVA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108306	1058	0	\N	31
1269	PERI MIRIM	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108405	1058	0	\N	31
1270	PERITORO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108454	1058	0	\N	31
1271	PINDARE-MIRIM	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108504	1058	0	\N	31
1272	PINHEIRO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108603	1058	0	\N	31
1273	PIO XII	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108702	1058	0	\N	31
1274	PIRAPEMAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108801	1058	0	\N	31
1275	POCAO DE PEDRAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2108900	1058	0	\N	31
1276	PORTO FRANCO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109007	1058	0	\N	31
1277	PORTO RICO DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109056	1058	0	\N	31
1278	PRESIDENTE DUTRA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109106	1058	0	\N	31
1279	PRESIDENTE JUSCELINO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109205	1058	0	\N	31
1280	PRESIDENTE MEDICE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109239	1058	0	\N	31
1281	PRESIDENTE SARNEY	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109270	1058	0	\N	31
1282	PRESIDENTE VARGAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109304	1058	0	\N	31
1283	PRIMEIRA CRUZ	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109403	1058	0	\N	31
1284	RAPOSA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109452	1058	0	\N	31
1285	RIACHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109502	1058	0	\N	31
1286	RIBAMAR FIQUENE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109551	1058	0	\N	31
1287	ROSARIO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109601	1058	0	\N	31
1288	SAMBAIBA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109700	1058	0	\N	31
1289	SANTA FILOMENA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109759	1058	0	\N	31
1290	SANTA HELENA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109809	1058	0	\N	31
1291	SANTA INES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2109908	1058	0	\N	31
1292	SANTA LUZIA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110005	1058	0	\N	31
1293	SANTA LUZIA DO PARUA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110039	1058	0	\N	31
1294	SANTANA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110237	1058	0	\N	31
1295	SANTA QUITERIA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110104	1058	0	\N	31
1296	SANTA RITA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110203	1058	0	\N	31
1297	SANTO AMARO DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110278	1058	0	\N	31
1298	SANTO ANTONIO DOS LOPES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110302	1058	0	\N	31
1299	SAO BENEDITO DO RIO PRETO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110401	1058	0	\N	31
1300	SAO BENTO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110500	1058	0	\N	31
1301	SAO BERNARDO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110609	1058	0	\N	31
1302	SAO DOMINGOS DO AZEITAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110658	1058	0	\N	31
1303	SAO DOMINGOS DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110708	1058	0	\N	31
1304	SAO FELIX DE BALSAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110807	1058	0	\N	31
1305	SAO FRANCISCO DO BREJAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110856	1058	0	\N	31
1306	SAO FRANCISCO DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2110906	1058	0	\N	31
1307	SAO JOAO BATISTA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111003	1058	0	\N	31
1308	SAO JOAO DO CARU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111029	1058	0	\N	31
1309	SAO JOAO DO PARAISO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111052	1058	0	\N	31
1310	SAO JOAO DO SOTER	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111078	1058	0	\N	31
1311	SAO JOAO DOS PATOS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111102	1058	0	\N	31
1312	SAO JOSE DE RIBAMAR	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111201	1058	0	\N	31
1313	SAO JOSE DOS BASILIOS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111250	1058	0	\N	31
1314	SAO LUIS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111300	1058	0	\N	31
1315	SAO LUIS GONZAGA DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111409	1058	0	\N	31
1316	SAO MATEUS DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111508	1058	0	\N	31
1317	SAO PEDRO DA AGUA BRANCA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111532	1058	0	\N	31
1318	SAO PEDRO DOS CRENTES	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111573	1058	0	\N	31
1319	SAO RAIMUNDO DAS MANGABEIRAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111607	1058	0	\N	31
1320	SAO RAIMUNDO DO DOCA BEZERRA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111631	1058	0	\N	31
1321	SAO ROBERTO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111672	1058	0	\N	31
1322	SAO VICENTE FERRER	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111706	1058	0	\N	31
1323	SATUBINHA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111722	1058	0	\N	31
1324	SENADOR ALEXANDRE COSTA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111748	1058	0	\N	31
1325	SENADOR LA ROCQUE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111763	1058	0	\N	31
1326	SERRANO DO MARANHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111789	1058	0	\N	31
1327	SITIO NOVO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111805	1058	0	\N	31
1328	SUCUPIRA DO NORTE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111904	1058	0	\N	31
1329	SUCUPIRA DO RIACHAO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2111953	1058	0	\N	31
1330	TASSO FRAGOSO	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112001	1058	0	\N	31
1331	TIMBIRAS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112100	1058	0	\N	31
1332	TIMON	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112209	1058	0	\N	31
1333	TRIZIDELA DO VALE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112233	1058	0	\N	31
1334	TUFILANDIA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112274	1058	0	\N	31
1335	TUNTUM	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112308	1058	0	\N	31
1336	TURIACU	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112407	1058	0	\N	31
1337	TURILANDIA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112456	1058	0	\N	31
1338	TUTOIA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112506	1058	0	\N	31
1339	URBANO SANTOS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112605	1058	0	\N	31
1340	VARGEM GRANDE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112704	1058	0	\N	31
1341	VIANA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112803	1058	0	\N	31
1342	VILA NOVA DOS MARTIRIOS	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112852	1058	0	\N	31
1343	VITORIA DO MEARIM	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2112902	1058	0	\N	31
1344	VITORINO FREIRE	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2113009	1058	0	\N	31
1345	ZE DOCA	MA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2114007	1058	0	\N	31
1346	ACORIZAL	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5100102	1058	0	\N	31
1347	AGUA BOA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5100201	1058	0	\N	31
1348	ALTA FLORESTA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5100250	1058	0	\N	31
1349	ALTO ARAGUAIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5100300	1058	0	\N	31
1350	ALTO BOA VISTA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5100359	1058	0	\N	31
1351	ALTO GARCAS	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5100409	1058	0	\N	31
1352	ALTO PARAGUAI	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5100508	1058	0	\N	31
1353	ALTO TAQUARI	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5100607	1058	0	\N	31
1354	APIACAS	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5100805	1058	0	\N	31
1355	ARAGUAIANA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101001	1058	0	\N	31
1356	ARAGUAINHA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101209	1058	0	\N	31
1357	ARAPUTANGA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101258	1058	0	\N	31
1358	ARENAPOLIS	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101308	1058	0	\N	31
1359	ARIPUANA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101407	1058	0	\N	31
1360	BARAO DE MELGACO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101605	1058	0	\N	31
1361	BARRA DO BUGRES	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101704	1058	0	\N	31
1362	BARRA DO GARCAS	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101803	1058	0	\N	31
1363	BOM JESUS DO ARAGUAIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101852	1058	0	\N	31
1364	BRASNORTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5101902	1058	0	\N	31
1365	CACERES	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5102504	1058	0	\N	31
1366	CAMPINAPOLIS	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5102603	1058	0	\N	31
1367	CAMPO NOVO DO PARECIS	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5102637	1058	0	\N	31
1368	CAMPO VERDE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5102678	1058	0	\N	31
1369	CAMPOS DE JULIO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5102686	1058	0	\N	31
1370	CANABRAVA DO NORTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5102694	1058	0	\N	31
1371	CANARANA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5102702	1058	0	\N	31
1372	CARLINDA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5102793	1058	0	\N	31
1373	CASTANHEIRA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5102850	1058	0	\N	31
1374	CHAPADA DOS GUIMARAES	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103007	1058	0	\N	31
1375	CLAUDIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103056	1058	0	\N	31
1376	COCALINHO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103106	1058	0	\N	31
1377	COLIDER	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103205	1058	0	\N	31
1378	COLNIZA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103254	1058	0	\N	31
1379	COMODORO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103304	1058	0	\N	31
1380	CONFRESA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103353	1058	0	\N	31
1381	CONQUISTA D OESTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103361	1058	0	\N	31
1382	COTRIGUACU	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103379	1058	0	\N	31
1383	CUIABA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103403	1058	0	\N	31
1384	CURVELANDIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103437	1058	0	\N	31
1385	DENISE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103452	1058	0	\N	31
1386	DIAMANTINO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103502	1058	0	\N	31
1387	DOM AQUINO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103601	1058	0	\N	31
1388	FELIZ NATAL	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103700	1058	0	\N	31
1389	FIGUEIROPOLIS D OESTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103809	1058	0	\N	31
1390	GAUCHA DO NORTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103858	1058	0	\N	31
1391	GENERAL CARNEIRO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103908	1058	0	\N	31
1392	GLORIA D OESTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5103957	1058	0	\N	31
1393	GUARANTA DO NORTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5104104	1058	0	\N	31
1394	GUIRATINGA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5104203	1058	0	\N	31
1395	INDIAVAI	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5104500	1058	0	\N	31
1396	IPIRANGA DO NORTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5104526	1058	0	\N	31
1397	ITANHANGA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5104542	1058	0	\N	31
1398	ITAUBA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5104559	1058	0	\N	31
1399	ITIQUIRA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5104609	1058	0	\N	31
1400	JACIARA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5104807	1058	0	\N	31
1401	JANGADA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5104906	1058	0	\N	31
1402	JAURU	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105002	1058	0	\N	31
1403	JUARA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105101	1058	0	\N	31
1404	JUINA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105150	1058	0	\N	31
1405	JURUENA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105176	1058	0	\N	31
1406	JUSCIMEIRA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105200	1058	0	\N	31
1407	LAMBARI D OESTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105234	1058	0	\N	31
1408	LUCAS DO RIO VERDE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105259	1058	0	\N	31
1409	LUCIARA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105309	1058	0	\N	31
1410	VILA BELA DA SANTISSIMA TRINDADE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105507	1058	0	\N	31
1411	MARCELANDIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105580	1058	0	\N	31
1412	MATUPA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105606	1058	0	\N	31
1413	MIRASSOL D OESTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105622	1058	0	\N	31
1414	NOBRES	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5105903	1058	0	\N	31
1415	NORTELANDIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106000	1058	0	\N	31
1416	NOSSA SENHORA DO LIVRAMENTO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106109	1058	0	\N	31
1417	NOVA BANDEIRANTES	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106158	1058	0	\N	31
1418	NOVA BRASILANDIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106208	1058	0	\N	31
1419	NOVA CANAA DO NORTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106216	1058	0	\N	31
1420	NOVA GUARITA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108808	1058	0	\N	31
1421	NOVA LACERDA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106182	1058	0	\N	31
1422	NOVA MARILANDIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108857	1058	0	\N	31
1423	NOVA MARINGA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108907	1058	0	\N	31
1424	NOVA MONTE VERDE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108956	1058	0	\N	31
1425	NOVA MUTUM	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106224	1058	0	\N	31
1426	NOVA NAZARE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106174	1058	0	\N	31
1427	NOVA OLIMPIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106232	1058	0	\N	31
1428	NOVA SANTA HELENA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106190	1058	0	\N	31
1429	NOVA UBIRATA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106240	1058	0	\N	31
1430	NOVA XAVANTINA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106257	1058	0	\N	31
1431	NOVO HORIZONTE DO NORTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106273	1058	0	\N	31
1432	NOVO MUNDO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106265	1058	0	\N	31
1433	NOVO SAO JOAQUIM	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106281	1058	0	\N	31
1434	NOVO SANTO ANTONIO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106315	1058	0	\N	31
1435	PARANAITA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106299	1058	0	\N	31
1436	PARANATINGA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106307	1058	0	\N	31
1437	PEDRA PRETA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106372	1058	0	\N	31
1438	PEIXOTO DE AZEVEDO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106422	1058	0	\N	31
1439	PLANALTO DA SERRA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106455	1058	0	\N	31
1440	POCONE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106505	1058	0	\N	31
1441	PONTAL DO ARAGUAIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106653	1058	0	\N	31
1442	PONTE BRANCA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106703	1058	0	\N	31
1443	PONTES E LACERDA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106752	1058	0	\N	31
1444	PORTO ALEGRE DO NORTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106778	1058	0	\N	31
1445	PORTO DOS GAUCHOS	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106802	1058	0	\N	31
1446	PORTO ESPERIDIAO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106828	1058	0	\N	31
1447	PORTO ESTRELA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5106851	1058	0	\N	31
1448	POXOREO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107008	1058	0	\N	31
1449	PRIMAVERA DO LESTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107040	1058	0	\N	31
1450	QUERENCIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107065	1058	0	\N	31
1451	RESERVA DO CABACAL	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107156	1058	0	\N	31
1452	RIBEIRAO CASCALHEIRA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107180	1058	0	\N	31
1453	RIBEIRAOZINHO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107198	1058	0	\N	31
1454	RIO BRANCO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107206	1058	0	\N	31
1455	RONDOLANDIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107578	1058	0	\N	31
1456	RONDONOPOLIS	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107602	1058	0	\N	31
1457	ROSARIO DO OESTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107701	1058	0	\N	31
1458	SANTA CARMEM	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107248	1058	0	\N	31
1459	SANTA CRUZ DO XINGU	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107743	1058	0	\N	31
1460	SANTA RITA DO TRIVELATO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107768	1058	0	\N	31
1461	SANTA TEREZINHA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107776	1058	0	\N	31
1462	SANTO AFONSO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107263	1058	0	\N	31
1463	SANTO ANTONIO DO LESTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107792	1058	0	\N	31
1464	SAO JOSE DO POVO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107297	1058	0	\N	31
1465	SAO JOSE DO RIO CLARO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107305	1058	0	\N	31
1466	SAO JOSE DOS QUATRO MARCOS	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107107	1058	0	\N	31
1467	SAO JOSE DO XINGU	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107354	1058	0	\N	31
1468	SAO PEDRO DA CIPA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107404	1058	0	\N	31
1469	SALTO DO CEU	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107750	1058	0	\N	31
1470	SANTO ANTONIO DO LEVERGER	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107800	1058	0	\N	31
1471	SAO FELIX DO ARAGUAIA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107859	1058	0	\N	31
1472	SAPEZAL	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107875	1058	0	\N	31
1473	SERRA NOVA DOURADA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107883	1058	0	\N	31
1474	SINOP	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107909	1058	0	\N	31
1475	SORRISO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107925	1058	0	\N	31
1476	TABAPORA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107941	1058	0	\N	31
1477	TANGARA DA SERRA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5107958	1058	0	\N	31
1478	TAPURAH	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108006	1058	0	\N	31
1479	TERRA NOVA DO NORTE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108055	1058	0	\N	31
1480	TESOURO	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108105	1058	0	\N	31
1481	TORIXOREU	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108204	1058	0	\N	31
1482	UNIAO DO SUL	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108303	1058	0	\N	31
1483	VALE DE SAO DOMINGOS 	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108352	1058	0	\N	31
1484	VARZEA GRANDE	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108402	1058	0	\N	31
1485	VERA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108501	1058	0	\N	31
1486	VILA RICA	MT			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5108600	1058	0	\N	31
1487	AGUA CLARA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5000203	1058	0	\N	31
1488	ALCINOPOLIS	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5000252	1058	0	\N	31
1489	AMAMBAI	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5000609	1058	0	\N	31
1490	ANASTACIO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5000708	1058	0	\N	31
1491	ANAURILANDIA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5000807	1058	0	\N	31
1492	ANGELICA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5000856	1058	0	\N	31
1493	ANTONIO JOAO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5000906	1058	0	\N	31
1494	APARECIDA DO TABOADO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5001003	1058	0	\N	31
1495	AQUIDAUANA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5001102	1058	0	\N	31
1496	ARAL MOREIRA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5001243	1058	0	\N	31
1497	BANDEIRANTES	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5001508	1058	0	\N	31
1498	BATAGUASSU	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5001904	1058	0	\N	31
1499	BATAYPORA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002001	1058	0	\N	31
1500	BELA VISTA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002100	1058	0	\N	31
1501	BODOQUENA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002159	1058	0	\N	31
1502	BONITO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002209	1058	0	\N	31
1503	BRASILANDIA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002308	1058	0	\N	31
1504	CAARAPO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002407	1058	0	\N	31
1505	CAMAPUA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002605	1058	0	\N	31
1506	CAMPO GRANDE	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002704	1058	0	\N	31
1507	CARACOL	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002803	1058	0	\N	31
1508	CASSILANDIA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002902	1058	0	\N	31
1509	CHAPADAO DO SUL	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5002951	1058	0	\N	31
1510	CORGUINHO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003108	1058	0	\N	31
1511	CORONEL SAPUCAIA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003157	1058	0	\N	31
1512	CORUMBA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003207	1058	0	\N	31
1513	COSTA RICA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003256	1058	0	\N	31
1514	COXIM	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003306	1058	0	\N	31
1515	DEODAPOLIS	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003454	1058	0	\N	31
1516	DOIS IRMAOS DO BURITI	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003488	1058	0	\N	31
1517	DOURADINA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003504	1058	0	\N	31
1518	DOURADOS	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003702	1058	0	\N	31
1519	ELDORADO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003751	1058	0	\N	31
1520	FATIMA DO SUL	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003801	1058	0	\N	31
1521	FIGUEIRAO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5003900	1058	0	\N	31
1522	GLORIA DE DOURADOS	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5004007	1058	0	\N	31
1523	GUIA LOPES DA LAGUNA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5004106	1058	0	\N	31
1524	IGUATEMI	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5004304	1058	0	\N	31
1525	INOCENCIA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5004403	1058	0	\N	31
1526	ITAPORA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5004502	1058	0	\N	31
1527	ITAQUIRAI	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5004601	1058	0	\N	31
1528	IVINHEMA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5004700	1058	0	\N	31
1529	JAPORA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5004809	1058	0	\N	31
1530	JARAGUARI	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5004908	1058	0	\N	31
1531	JARDIM	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005004	1058	0	\N	31
1532	JATEI	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005103	1058	0	\N	31
1533	JUTI	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005152	1058	0	\N	31
1534	LADARIO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005202	1058	0	\N	31
1535	LAGUNA CARAPA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005251	1058	0	\N	31
1536	MARACAJU	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005400	1058	0	\N	31
1537	MIRANDA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005608	1058	0	\N	31
1538	MUNDO NOVO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005681	1058	0	\N	31
1539	NAVIRAI	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005707	1058	0	\N	31
1540	NIOAQUE	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5005806	1058	0	\N	31
1541	NOVA ALVORADA DO SUL	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5006002	1058	0	\N	31
1542	NOVA ANDRADINA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5006200	1058	0	\N	31
1543	NOVO HORIZONTE DO SUL	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5006259	1058	0	\N	31
1544	PARANAIBA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5006309	1058	0	\N	31
1545	PARANHOS	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5006358	1058	0	\N	31
1546	PEDRO GOMES	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5006408	1058	0	\N	31
1547	PONTA PORA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5006606	1058	0	\N	31
1548	PORTO MURTINHO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5006903	1058	0	\N	31
1549	RIBAS DO RIO PARDO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007109	1058	0	\N	31
1550	RIO BRILHANTE	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007208	1058	0	\N	31
1551	RIO NEGRO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007307	1058	0	\N	31
1552	RIO VERDE DE MATO GROSSO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007406	1058	0	\N	31
1553	ROCHEDO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007505	1058	0	\N	31
1554	SANTA RITA DO PARDO	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007554	1058	0	\N	31
1555	SAO GABRIEL DO OESTE	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007695	1058	0	\N	31
1556	SELVIRIA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007802	1058	0	\N	31
1557	SETE QUEDAS	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007703	1058	0	\N	31
1558	SIDROLANDIA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007901	1058	0	\N	31
1559	SONORA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007935	1058	0	\N	31
1560	TACURU	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007950	1058	0	\N	31
1561	TAQUARUSSU	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5007976	1058	0	\N	31
1562	TERENOS	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5008008	1058	0	\N	31
1563	TRES LAGOAS	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5008305	1058	0	\N	31
1564	VICENTINA	MS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	5008404	1058	0	\N	31
1565	ABADIA DOS DOURADOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3100104	1058	0	\N	31
1566	ABAETE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3100203	1058	0	\N	31
1567	ABRE CAMPO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3100302	1058	0	\N	31
1568	ACAIACA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3100401	1058	0	\N	31
1569	ACUCENA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3100500	1058	0	\N	31
1570	AGUA BOA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3100609	1058	0	\N	31
1571	AGUA COMPRIDA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3100708	1058	0	\N	31
1572	AGUANIL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3100807	1058	0	\N	31
1573	AGUAS FORMOSAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3100906	1058	0	\N	31
1574	AGUAS VERMELHAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101003	1058	0	\N	31
1575	AIMORES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101102	1058	0	\N	31
1576	AIURUOCA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101201	1058	0	\N	31
1577	ALAGOA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101300	1058	0	\N	31
1578	ALBERTINA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101409	1058	0	\N	31
1579	ALEM PARAIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101508	1058	0	\N	31
1580	ALFENAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101607	1058	0	\N	31
1581	ALFREDO VASCONCELOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101631	1058	0	\N	31
1582	ALMENARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101706	1058	0	\N	31
1583	ALPERCATA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101805	1058	0	\N	31
1584	ALPINOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3101904	1058	0	\N	31
1585	ALTEROSA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102001	1058	0	\N	31
1586	ALTO CAPARAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102050	1058	0	\N	31
1587	ALTO JEQUITIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153509	1058	0	\N	31
1588	ALTO RIO DOCE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102100	1058	0	\N	31
1589	ALVARENGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102209	1058	0	\N	31
1590	ALVINOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102308	1058	0	\N	31
1591	ALVORADA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102407	1058	0	\N	31
1592	AMPARO DO SERRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102506	1058	0	\N	31
1593	ANDRADAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102605	1058	0	\N	31
1594	ANDRELANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102803	1058	0	\N	31
1595	ANGELANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102852	1058	0	\N	31
1596	ANTONIO CARLOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102902	1058	0	\N	31
1597	ANTONIO DIAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103009	1058	0	\N	31
1598	ANTONIO PRADO DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103108	1058	0	\N	31
1599	ARACAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103207	1058	0	\N	31
1600	ARACITABA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103306	1058	0	\N	31
1601	ARACUAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103405	1058	0	\N	31
1602	ARAGUARI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103504	1058	0	\N	31
1603	ARANTINA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103603	1058	0	\N	31
1604	ARAPONGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103702	1058	0	\N	31
1605	ARAPORA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103751	1058	0	\N	31
1606	ARAPUA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103801	1058	0	\N	31
1607	ARAUJOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3103900	1058	0	\N	31
1608	ARAXA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104007	1058	0	\N	31
1609	ARCEBURGO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104106	1058	0	\N	31
1610	ARCOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104205	1058	0	\N	31
1611	AREADO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104304	1058	0	\N	31
1612	ARGIRITA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104403	1058	0	\N	31
1613	ARICANDUVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104452	1058	0	\N	31
1614	ARINOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104502	1058	0	\N	31
1615	ASTOLFO DUTRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104601	1058	0	\N	31
1616	ATALEIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104700	1058	0	\N	31
1617	AUGUSTO DE LIMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104809	1058	0	\N	31
1618	BAEPENDI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3104908	1058	0	\N	31
1619	BALDIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3105004	1058	0	\N	31
1620	BAMBUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3105103	1058	0	\N	31
1621	BANDEIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3105202	1058	0	\N	31
1622	BANDEIRA DO SUL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3105301	1058	0	\N	31
1623	BARAO DE COCAIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3105400	1058	0	\N	31
1624	BARAO DE MONTE ALTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3105509	1058	0	\N	31
1625	BARBACENA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3105608	1058	0	\N	31
1626	BARRA LONGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3105707	1058	0	\N	31
1627	BARROSO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3105905	1058	0	\N	31
1628	BELA VISTA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106002	1058	0	\N	31
1629	BELMIRO BRAGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106101	1058	0	\N	31
1630	BELO HORIZONTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106200	1058	0	\N	31
1631	BELO ORIENTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106309	1058	0	\N	31
1632	BELO VALE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106408	1058	0	\N	31
1633	BERILO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106507	1058	0	\N	31
1634	BERIZAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106655	1058	0	\N	31
1635	BETIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106705	1058	0	\N	31
1636	BERTOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106606	1058	0	\N	31
1637	BIAS FORTES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106804	1058	0	\N	31
1638	BICAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3106903	1058	0	\N	31
1639	BIQUINHAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107000	1058	0	\N	31
1640	BOA ESPERANCA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107109	1058	0	\N	31
1641	BOCAINA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107208	1058	0	\N	31
1642	BOCAIUVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107307	1058	0	\N	31
1643	BOM DESPACHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107406	1058	0	\N	31
1644	BOM JARDIM DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107505	1058	0	\N	31
1645	BOM JESUS DA PENHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107604	1058	0	\N	31
1646	BOM JESUS DO AMPARO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107703	1058	0	\N	31
1647	BOM JESUS DO GALHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107802	1058	0	\N	31
1648	BOM REPOUSO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3107901	1058	0	\N	31
1649	BOM SUCESSO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108008	1058	0	\N	31
1650	BONFIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108107	1058	0	\N	31
1651	BONFINOPOLIS DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108206	1058	0	\N	31
1652	BONITO DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108255	1058	0	\N	31
1653	BORDA DA MATA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108305	1058	0	\N	31
1654	BOTELHOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108404	1058	0	\N	31
1655	BOTUMIRIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108503	1058	0	\N	31
1656	BRASILANDIA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108552	1058	0	\N	31
1657	BRASILIA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108602	1058	0	\N	31
1658	BRASOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108909	1058	0	\N	31
1659	BRAS PIRES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108701	1058	0	\N	31
1660	BRAUNAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3108800	1058	0	\N	31
1661	BRUMADINHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109006	1058	0	\N	31
1662	BUENO BRANDAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109105	1058	0	\N	31
1663	BUENOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109204	1058	0	\N	31
1664	BUGRE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109253	1058	0	\N	31
1665	BURITIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109303	1058	0	\N	31
1666	BURITIZEIRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109402	1058	0	\N	31
1667	CABECEIRA GRANDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109451	1058	0	\N	31
1668	CABO VERDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109501	1058	0	\N	31
1669	CACHOEIRA DA PRATA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109600	1058	0	\N	31
1670	CACHOEIRA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109709	1058	0	\N	31
1671	CACHOEIRA DOURADA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109808	1058	0	\N	31
1672	CACHOEIRA DE PAJEU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3102704	1058	0	\N	31
1673	CAETANOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3109907	1058	0	\N	31
1674	CAETE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110004	1058	0	\N	31
1675	CAIANA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110103	1058	0	\N	31
1676	CAJURI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110202	1058	0	\N	31
1677	CALDAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110301	1058	0	\N	31
1678	CAMACHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110400	1058	0	\N	31
1679	CAMANDUCAIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110509	1058	0	\N	31
1680	CAMBUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110608	1058	0	\N	31
1681	CAMBUQUIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110707	1058	0	\N	31
1682	CAMPANARIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110806	1058	0	\N	31
1683	CAMPANHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3110905	1058	0	\N	31
1684	CAMPESTRE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111002	1058	0	\N	31
1685	CAMPINA VERDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111101	1058	0	\N	31
1686	CAMPO AZUL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111150	1058	0	\N	31
1687	CAMPO BELO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111200	1058	0	\N	31
1688	CAMPO DO MEIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111309	1058	0	\N	31
1689	CAMPO FLORIDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111408	1058	0	\N	31
1690	CAMPOS ALTOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111507	1058	0	\N	31
1691	CAMPOS GERAIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111606	1058	0	\N	31
1692	CANAA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111705	1058	0	\N	31
1693	CANAPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111804	1058	0	\N	31
1694	CANA VERDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3111903	1058	0	\N	31
1695	CANDEIAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112000	1058	0	\N	31
1696	CANTAGALO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112059	1058	0	\N	31
1697	CAPARAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112109	1058	0	\N	31
1698	CAPELA NOVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112208	1058	0	\N	31
1699	CAPELINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112307	1058	0	\N	31
1700	CAPETINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112406	1058	0	\N	31
1701	CAPIM BRANCO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112505	1058	0	\N	31
1702	CAPINOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112604	1058	0	\N	31
1703	CAPITAO ANDRADE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112653	1058	0	\N	31
1704	CAPITAO ENEAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112703	1058	0	\N	31
1705	CAPITOLIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112802	1058	0	\N	31
1706	CAPUTIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3112901	1058	0	\N	31
1707	CARAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113008	1058	0	\N	31
1708	CARANAIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113107	1058	0	\N	31
1709	CARANDAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113206	1058	0	\N	31
1710	CARANGOLA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113305	1058	0	\N	31
1711	CARATINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113404	1058	0	\N	31
1712	CARBONITA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113503	1058	0	\N	31
1713	CAREACU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113602	1058	0	\N	31
1714	CARLOS CHAGAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113701	1058	0	\N	31
1715	CARMESIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113800	1058	0	\N	31
1716	CARMO DA CACHOEIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3113909	1058	0	\N	31
1717	CARMO DA MATA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114006	1058	0	\N	31
1718	CARMO DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114105	1058	0	\N	31
1719	CARMO DO CAJURU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114204	1058	0	\N	31
1720	CARMO DO PARANAIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114303	1058	0	\N	31
1721	CARMO DO RIO CLARO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114402	1058	0	\N	31
1722	CARMOPOLIS DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114501	1058	0	\N	31
1723	CARNEIRINHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114550	1058	0	\N	31
1724	CARRANCAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114600	1058	0	\N	31
1725	CARVALHOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114709	1058	0	\N	31
1726	CARVALHOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114808	1058	0	\N	31
1727	CASA GRANDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3114907	1058	0	\N	31
1728	CASCALHO RICO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115003	1058	0	\N	31
1729	CASSIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115102	1058	0	\N	31
1730	CATAGUASES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115300	1058	0	\N	31
1731	CATAS ALTAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115359	1058	0	\N	31
1732	CATAS ALTAS DA NORUEGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115409	1058	0	\N	31
1733	CATUJI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115458	1058	0	\N	31
1734	CATUTI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115474	1058	0	\N	31
1735	CAXAMBU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115508	1058	0	\N	31
1736	CEDRO DO ABAETE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115607	1058	0	\N	31
1737	CENTRAL DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115706	1058	0	\N	31
1738	CENTRALINA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115805	1058	0	\N	31
1739	CHACARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115904	1058	0	\N	31
1740	CHALE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116001	1058	0	\N	31
1741	CHAPADA DO NORTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116100	1058	0	\N	31
1742	CHAPADA GAUCHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116159	1058	0	\N	31
1743	CHIADOR	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116209	1058	0	\N	31
1744	CIPOTANEA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116308	1058	0	\N	31
1745	CLARAVAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116407	1058	0	\N	31
1746	CLARO DOS POCOES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116506	1058	0	\N	31
1747	CLAUDIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116605	1058	0	\N	31
1748	COIMBRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116704	1058	0	\N	31
1749	COLUNA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116803	1058	0	\N	31
1750	COMENDADOR GOMES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3116902	1058	0	\N	31
1751	COMERCINHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117009	1058	0	\N	31
1752	CONCEICAO DA APARECIDA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117108	1058	0	\N	31
1753	CONCEICAO DA BARRA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3115201	1058	0	\N	31
1754	CONCEICAO DAS ALAGOAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117306	1058	0	\N	31
1755	CONCEICAO DAS PEDRAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117207	1058	0	\N	31
1756	CONCEICAO DE IPANEMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117405	1058	0	\N	31
1757	CONCEICAO DO MATO DENTRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117504	1058	0	\N	31
1758	CONCEICAO DO PARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117603	1058	0	\N	31
1759	CONCEICAO DO RIO VERDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117702	1058	0	\N	31
1760	CONCEICAO DOS OUROS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117801	1058	0	\N	31
1761	CONEGO MARINHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117836	1058	0	\N	31
1762	CONFINS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117876	1058	0	\N	31
1763	CONGONHAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3117900	1058	0	\N	31
1764	CONGONHAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118007	1058	0	\N	31
1765	CONGONHAS DO NORTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118106	1058	0	\N	31
1766	CONQUISTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118205	1058	0	\N	31
1767	CONSELHEIRO LAFAIETE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118304	1058	0	\N	31
1768	CONSELHEIRO PENA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118403	1058	0	\N	31
1769	CONSOLACAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118502	1058	0	\N	31
1770	CONTAGEM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118601	1058	0	\N	31
1771	COQUEIRAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118700	1058	0	\N	31
1772	CORACAO DE JESUS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118809	1058	0	\N	31
1773	CORDISBURGO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3118908	1058	0	\N	31
1774	CORDISLANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119005	1058	0	\N	31
1775	CORINTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119104	1058	0	\N	31
1776	COROACI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119203	1058	0	\N	31
1777	COROMANDEL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119302	1058	0	\N	31
1778	CORONEL FABRICIANO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119401	1058	0	\N	31
1779	CORONEL MURTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119500	1058	0	\N	31
1780	CORONEL PACHECO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119609	1058	0	\N	31
1781	CORONEL XAVIER CHAVES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119708	1058	0	\N	31
1782	CORREGO DANTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119807	1058	0	\N	31
1783	CORREGO DO BOM JESUS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119906	1058	0	\N	31
1784	CORREGO FUNDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3119955	1058	0	\N	31
1785	CORREGO NOVO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120003	1058	0	\N	31
1786	COUTO DE MAGALHAES DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120102	1058	0	\N	31
1787	CRISOLITA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120151	1058	0	\N	31
1788	CRISTAIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120201	1058	0	\N	31
1789	CRISTALIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120300	1058	0	\N	31
1790	CRISTIANO OTONI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120409	1058	0	\N	31
1791	CRISTINA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120508	1058	0	\N	31
1792	CRUCILANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120607	1058	0	\N	31
1793	CRUZEIRO DA FORTALEZA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120706	1058	0	\N	31
1794	CRUZILIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120805	1058	0	\N	31
1795	CUPARAQUE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120839	1058	0	\N	31
1796	CURRAL DE DENTRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120870	1058	0	\N	31
1797	CURVELO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3120904	1058	0	\N	31
1798	DATAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121001	1058	0	\N	31
1799	DELFIM MOREIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121100	1058	0	\N	31
1800	DELFINOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121209	1058	0	\N	31
1801	DELTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121258	1058	0	\N	31
1802	DESCOBERTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121308	1058	0	\N	31
1803	DESTERRO DE ENTRE RIOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121407	1058	0	\N	31
1804	DESTERRO DO MELO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121506	1058	0	\N	31
1805	DIAMANTINA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121605	1058	0	\N	31
1806	DIOGO DE VASCONCELOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121704	1058	0	\N	31
1807	DIONISIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121803	1058	0	\N	31
1808	DIVINESIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3121902	1058	0	\N	31
1809	DIVINO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122009	1058	0	\N	31
1810	DIVINO DAS LARANJEIRAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122108	1058	0	\N	31
1811	DIVINOLANDIA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122207	1058	0	\N	31
1812	DIVINOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122306	1058	0	\N	31
1813	DIVISA ALEGRE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122355	1058	0	\N	31
1814	DIVISA NOVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122405	1058	0	\N	31
1815	DIVISOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122454	1058	0	\N	31
1816	DOM BOSCO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122470	1058	0	\N	31
1817	DOM CAVATI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122504	1058	0	\N	31
1818	DOM JOAQUIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122603	1058	0	\N	31
1819	DOM SILVERIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122702	1058	0	\N	31
1820	DOM VICOSO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122801	1058	0	\N	31
1821	DONA EUSEBIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3122900	1058	0	\N	31
1822	DORES DE CAMPOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123007	1058	0	\N	31
1823	DORES DE GUANHAES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123106	1058	0	\N	31
1824	DORES DO INDAIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123205	1058	0	\N	31
1825	DORES DO TURVO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123304	1058	0	\N	31
1826	DORESOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123403	1058	0	\N	31
1827	DOURADOQUARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123502	1058	0	\N	31
1828	DURANDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123528	1058	0	\N	31
1829	ELOI MENDES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123601	1058	0	\N	31
1830	ENGENHEIRO CALDAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123700	1058	0	\N	31
1831	ENGENHEIRO NAVARRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123809	1058	0	\N	31
1832	ENTRE FOLHAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123858	1058	0	\N	31
1833	ENTRE RIOS DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3123908	1058	0	\N	31
1834	ERVALIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124005	1058	0	\N	31
1835	ESMERALDAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124104	1058	0	\N	31
1836	ESPERA FELIZ	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124203	1058	0	\N	31
1837	ESPINOSA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124302	1058	0	\N	31
1838	ESPIRITO SANTO DO DOURADO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124401	1058	0	\N	31
1839	ESTIVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124500	1058	0	\N	31
1840	ESTRELA DALVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124609	1058	0	\N	31
1841	ESTRELA DO INDAIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124708	1058	0	\N	31
1842	ESTRELA DO SUL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124807	1058	0	\N	31
1843	EUGENOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3124906	1058	0	\N	31
1844	EWBANK DA CAMARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125002	1058	0	\N	31
1845	EXTREMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125101	1058	0	\N	31
1846	FAMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125200	1058	0	\N	31
1847	FARIA LEMOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125309	1058	0	\N	31
1848	FELICIO DOS SANTOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125408	1058	0	\N	31
1849	FELISBURGO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125606	1058	0	\N	31
1850	FELIXLANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125705	1058	0	\N	31
1851	FERNANDES TOURINHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125804	1058	0	\N	31
1852	FERROS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125903	1058	0	\N	31
1853	FERVEDOURO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125952	1058	0	\N	31
1854	FLORESTAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126000	1058	0	\N	31
1855	FORMIGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126109	1058	0	\N	31
1856	FORMOSO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126208	1058	0	\N	31
1857	FORTALEZA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126307	1058	0	\N	31
1858	FORTUNA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126406	1058	0	\N	31
1859	FRANCISCO BADARO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126505	1058	0	\N	31
1860	FRANCISCO DUMONT	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126604	1058	0	\N	31
1861	FRANCISCO SA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126703	1058	0	\N	31
1862	FRANCISCOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126752	1058	0	\N	31
1863	FREI GASPAR	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126802	1058	0	\N	31
1864	FREI INOCENCIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126901	1058	0	\N	31
1865	FREI LAGONEGRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3126950	1058	0	\N	31
1866	FRONTEIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127008	1058	0	\N	31
1867	FRONTEIRA DOS VALES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127057	1058	0	\N	31
1868	FRUTA DE LEITE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127073	1058	0	\N	31
1869	FRUTAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127107	1058	0	\N	31
1870	FUNILANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127206	1058	0	\N	31
1871	GALILEIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127305	1058	0	\N	31
1872	GAMELEIRAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127339	1058	0	\N	31
1873	GLAUCILANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127354	1058	0	\N	31
1874	GOIABEIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127370	1058	0	\N	31
1875	GOIANA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127388	1058	0	\N	31
1876	GONCALVES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127404	1058	0	\N	31
1877	GONZAGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127503	1058	0	\N	31
1878	GOUVEA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127602	1058	0	\N	31
1879	GOVERNADOR VALADARES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127701	1058	0	\N	31
1880	GRAO MOGOL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127800	1058	0	\N	31
1881	GRUPIARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3127909	1058	0	\N	31
1882	GUANHAES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128006	1058	0	\N	31
1883	GUAPE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128105	1058	0	\N	31
1884	GUARACIABA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128204	1058	0	\N	31
1885	GUARACIAMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128253	1058	0	\N	31
1886	GUARANESIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128303	1058	0	\N	31
1887	GUARANI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128402	1058	0	\N	31
1888	GUARARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128501	1058	0	\N	31
1889	GUARDA MOR	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128600	1058	0	\N	31
1890	GUAXUPE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128709	1058	0	\N	31
1891	GUIDOVAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128808	1058	0	\N	31
1892	GUIMARANIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3128907	1058	0	\N	31
1893	GUIRICEMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129004	1058	0	\N	31
1894	GURINHATA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129103	1058	0	\N	31
1895	HELIODORA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129202	1058	0	\N	31
1896	IAPU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129301	1058	0	\N	31
1897	IBERTIOGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129400	1058	0	\N	31
1898	IBIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129509	1058	0	\N	31
1899	IBIAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129608	1058	0	\N	31
1900	IBIRACATU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129657	1058	0	\N	31
1901	IBIRACI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129707	1058	0	\N	31
1902	IBIRITE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129806	1058	0	\N	31
1903	IBITIURA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3129905	1058	0	\N	31
1904	IBITURUNA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130002	1058	0	\N	31
1905	ICARAI DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130051	1058	0	\N	31
1906	IGARAPE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130101	1058	0	\N	31
1907	IGARATINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130200	1058	0	\N	31
1908	IGUATAMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130309	1058	0	\N	31
1909	IJACI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130408	1058	0	\N	31
1910	ILICINEA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130507	1058	0	\N	31
1911	IMBE DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130556	1058	0	\N	31
1912	INCONFIDENTES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130606	1058	0	\N	31
1913	INDAIABIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130655	1058	0	\N	31
1914	INDIANOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130705	1058	0	\N	31
1915	INGAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130804	1058	0	\N	31
1916	INHAPIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3130903	1058	0	\N	31
1917	INHAUMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131000	1058	0	\N	31
1918	INIMUTABA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131109	1058	0	\N	31
1919	IPABA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131158	1058	0	\N	31
1920	IPANEMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131208	1058	0	\N	31
1921	IPATINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131307	1058	0	\N	31
1922	IPIACU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131406	1058	0	\N	31
1923	IPUIUNA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131505	1058	0	\N	31
1924	IRAI DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131604	1058	0	\N	31
1925	ITABIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131703	1058	0	\N	31
1926	ITABIRINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131802	1058	0	\N	31
1927	ITABIRITO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3131901	1058	0	\N	31
1928	ITACAMBIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132008	1058	0	\N	31
1929	ITACARAMBI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132107	1058	0	\N	31
1930	ITAGUARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132206	1058	0	\N	31
1931	ITAIPE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132305	1058	0	\N	31
1932	ITAJUBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132404	1058	0	\N	31
1933	ITAMARANDIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132503	1058	0	\N	31
1934	ITAMARATI DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132602	1058	0	\N	31
1935	ITAMBACURI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132701	1058	0	\N	31
1936	ITAMBE DO MATO DENTRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132800	1058	0	\N	31
1937	ITAMOGI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3132909	1058	0	\N	31
1938	ITAMONTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133006	1058	0	\N	31
1939	ITANHANDU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133105	1058	0	\N	31
1940	ITANHOMI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133204	1058	0	\N	31
1941	ITAOBIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133303	1058	0	\N	31
1942	ITAPAGIPE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133402	1058	0	\N	31
1943	ITAPECERICA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133501	1058	0	\N	31
1944	ITAPEVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133600	1058	0	\N	31
1945	ITATIAIUCU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133709	1058	0	\N	31
1946	ITAU DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133758	1058	0	\N	31
1947	ITAUNA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133808	1058	0	\N	31
1948	ITAVERAVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3133907	1058	0	\N	31
1949	ITINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134004	1058	0	\N	31
1950	ITUETA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134103	1058	0	\N	31
1951	ITUIUTABA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134202	1058	0	\N	31
1952	ITUMIRIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134301	1058	0	\N	31
1953	ITURAMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134400	1058	0	\N	31
1954	ITUTINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134509	1058	0	\N	31
1955	JABOTICATUBAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134608	1058	0	\N	31
1956	JACINTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134707	1058	0	\N	31
1957	JACUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134806	1058	0	\N	31
1958	JACUTINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3134905	1058	0	\N	31
1959	JAGUARACU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135001	1058	0	\N	31
1960	JAIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135050	1058	0	\N	31
1961	JAMPRUCA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135076	1058	0	\N	31
1962	JANAUBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135100	1058	0	\N	31
1963	JANUARIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135209	1058	0	\N	31
1964	JAPARAIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135308	1058	0	\N	31
1965	JAPONVAR	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135357	1058	0	\N	31
1966	JECEABA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135407	1058	0	\N	31
1967	JENIPAPO DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135456	1058	0	\N	31
1968	JEQUERI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135506	1058	0	\N	31
1969	JEQUITAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135605	1058	0	\N	31
1970	JEQUITIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135704	1058	0	\N	31
1971	JEQUITINHONHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135803	1058	0	\N	31
1972	JESUANIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3135902	1058	0	\N	31
1973	JOAIMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136009	1058	0	\N	31
1974	JOANESIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136108	1058	0	\N	31
1975	JOAO MONLEVADE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136207	1058	0	\N	31
1976	JOAO PINHEIRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136306	1058	0	\N	31
1977	JOAQUIM FELICIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136405	1058	0	\N	31
1978	JORDANIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136504	1058	0	\N	31
1979	JOSE GONCALVES DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136520	1058	0	\N	31
1980	JOSENOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136579	1058	0	\N	31
1981	JOSE RAYDAN	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136553	1058	0	\N	31
1982	JUATUBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136652	1058	0	\N	31
1983	JUIZ DE FORA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136702	1058	0	\N	31
1984	JURAMENTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136801	1058	0	\N	31
1985	JURUAIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136900	1058	0	\N	31
1986	JUVENILIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136959	1058	0	\N	31
1987	LADAINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137007	1058	0	\N	31
1988	LAGAMAR	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137106	1058	0	\N	31
1989	LAGOA DA PRATA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137205	1058	0	\N	31
1990	LAGOA DOS PATOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137304	1058	0	\N	31
1991	LAGOA DOURADA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137403	1058	0	\N	31
1992	LAGOA FORMOSA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137502	1058	0	\N	31
1993	LAGOA GRANDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137536	1058	0	\N	31
1994	LAGOA SANTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137601	1058	0	\N	31
1995	LAJINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137700	1058	0	\N	31
1996	LAMBARI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137809	1058	0	\N	31
1997	LAMIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3137908	1058	0	\N	31
1998	LARANJAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138005	1058	0	\N	31
1999	LASSANCE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138104	1058	0	\N	31
2000	LAVRAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138203	1058	0	\N	31
2001	LEANDRO FERREIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138302	1058	0	\N	31
2002	LEME DO PRADO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138351	1058	0	\N	31
2003	LEOPOLDINA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138401	1058	0	\N	31
2004	LIBERDADE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138500	1058	0	\N	31
2005	LIMA DUARTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138609	1058	0	\N	31
2006	LIMEIRA DO OESTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138625	1058	0	\N	31
2007	LONTRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138658	1058	0	\N	31
2008	LUISLANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138682	1058	0	\N	31
2009	LUISBURGO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138674	1058	0	\N	31
2010	LUMINARIAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138708	1058	0	\N	31
2011	LUZ	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138807	1058	0	\N	31
2012	MACHACALIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3138906	1058	0	\N	31
2013	MACHADO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139003	1058	0	\N	31
2014	MADRE DE DEUS DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139102	1058	0	\N	31
2015	MALACACHETA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139201	1058	0	\N	31
2016	MAMONAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139250	1058	0	\N	31
2017	MANGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139300	1058	0	\N	31
2018	MANHUACU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139409	1058	0	\N	31
2019	MANHUMIRIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139508	1058	0	\N	31
2020	MANTENA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139607	1058	0	\N	31
2021	MARAVILHAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139706	1058	0	\N	31
2022	MAR DE ESPANHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139805	1058	0	\N	31
2023	MARIA DA FE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3139904	1058	0	\N	31
2024	MARIANA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140001	1058	0	\N	31
2025	MARILAC	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140100	1058	0	\N	31
2026	MARIO CAMPOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140159	1058	0	\N	31
2027	MARIPA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140209	1058	0	\N	31
2028	MARLIERIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140308	1058	0	\N	31
2029	MARMELOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140407	1058	0	\N	31
2030	MARTINHO CAMPOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140506	1058	0	\N	31
2031	MARTINS SOARES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140530	1058	0	\N	31
2032	MATA VERDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140555	1058	0	\N	31
2033	MATERLANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140605	1058	0	\N	31
2034	MATEUS LEME	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140704	1058	0	\N	31
2035	MATIAS BARBOSA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140803	1058	0	\N	31
2036	MATIAS CARDOSO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140852	1058	0	\N	31
2037	MATIPO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3140902	1058	0	\N	31
2038	MATHIAS LOBATO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171501	1058	0	\N	31
2039	MATO VERDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141009	1058	0	\N	31
2040	MATOZINHOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141108	1058	0	\N	31
2041	MATUTINA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141207	1058	0	\N	31
2042	MEDEIROS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141306	1058	0	\N	31
2043	MEDINA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141405	1058	0	\N	31
2044	MENDES PIMENTEL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141504	1058	0	\N	31
2045	MERCES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141603	1058	0	\N	31
2046	MESQUITA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141702	1058	0	\N	31
2047	MINAS NOVAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141801	1058	0	\N	31
2048	MINDURI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3141900	1058	0	\N	31
2049	MIRABELA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142007	1058	0	\N	31
2050	MIRADOURO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142106	1058	0	\N	31
2051	MIRAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142205	1058	0	\N	31
2052	MIRAVANIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142254	1058	0	\N	31
2053	MOEDA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142304	1058	0	\N	31
2054	MOEMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142403	1058	0	\N	31
2055	MONJOLOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142502	1058	0	\N	31
2056	MONSENHOR PAULO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142601	1058	0	\N	31
2057	MONTALVANIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142700	1058	0	\N	31
2058	MONTE ALEGRE DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142809	1058	0	\N	31
2059	MONTE AZUL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3142908	1058	0	\N	31
2060	MONTE BELO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143005	1058	0	\N	31
2061	MONTE CARMELO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143104	1058	0	\N	31
2062	MONTE FORMOSO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143153	1058	0	\N	31
2063	MONTE SANTO DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143203	1058	0	\N	31
2064	MONTES CLAROS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143302	1058	0	\N	31
2065	MONTE SIAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143401	1058	0	\N	31
2066	MONTEZUMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143450	1058	0	\N	31
2067	MORADA NOVA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143500	1058	0	\N	31
2068	MORRO DA GARCA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143609	1058	0	\N	31
2069	MORRO DO PILAR	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143708	1058	0	\N	31
2070	MUNHOZ	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143807	1058	0	\N	31
2071	MURIAE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3143906	1058	0	\N	31
2072	MUTUM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144003	1058	0	\N	31
2073	MUZAMBINHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144102	1058	0	\N	31
2074	NACIP RAYDAN	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144201	1058	0	\N	31
2075	NANUQUE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144300	1058	0	\N	31
2076	NAQUE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144359	1058	0	\N	31
2077	NATALANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144375	1058	0	\N	31
2078	NATERCIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144409	1058	0	\N	31
2079	NAZARENO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144508	1058	0	\N	31
2080	NEPOMUCENO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144607	1058	0	\N	31
2081	NINHEIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144656	1058	0	\N	31
2082	NOVA BELEM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144672	1058	0	\N	31
2083	NOVA ERA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144706	1058	0	\N	31
2084	NOVA LIMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144805	1058	0	\N	31
2085	NOVA MODICA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3144904	1058	0	\N	31
2086	NOVA PONTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145000	1058	0	\N	31
2087	NOVA PORTEIRINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145059	1058	0	\N	31
2088	NOVA RESENDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145109	1058	0	\N	31
2089	NOVA SERRANA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145208	1058	0	\N	31
2090	NOVA UNIAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3136603	1058	0	\N	31
2091	NOVO CRUZEIRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145307	1058	0	\N	31
2092	NOVO ORIENTE DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145356	1058	0	\N	31
2093	NOVORIZONTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145372	1058	0	\N	31
2094	OLARIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145406	1058	0	\N	31
2095	OLHOS D AGUA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145455	1058	0	\N	31
2096	OLIMPIO NORONHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145505	1058	0	\N	31
2097	OLIVEIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145604	1058	0	\N	31
2098	OLIVEIRA FORTES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145703	1058	0	\N	31
2099	ONCA DE PITANGUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145802	1058	0	\N	31
2100	ORATORIOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145851	1058	0	\N	31
2101	ORIZANIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145877	1058	0	\N	31
2102	OURO BRANCO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3145901	1058	0	\N	31
2103	OURO FINO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146008	1058	0	\N	31
2104	OURO PRETO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146107	1058	0	\N	31
2105	OURO VERDE DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146206	1058	0	\N	31
2106	PADRE CARVALHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146255	1058	0	\N	31
2107	PADRE PARAISO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146305	1058	0	\N	31
2108	PAINEIRAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146404	1058	0	\N	31
2109	PAINS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146503	1058	0	\N	31
2110	PAI PEDRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146552	1058	0	\N	31
2111	PAIVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146602	1058	0	\N	31
2112	PALMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146701	1058	0	\N	31
2113	PALMOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146750	1058	0	\N	31
2114	PAPAGAIOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3146909	1058	0	\N	31
2115	PARACATU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147006	1058	0	\N	31
2116	PARA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147105	1058	0	\N	31
2117	PARAGUACU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147204	1058	0	\N	31
2118	PARAISOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147303	1058	0	\N	31
2119	PARAOPEBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147402	1058	0	\N	31
2120	PASSABEM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147501	1058	0	\N	31
2121	PASSA QUATRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147600	1058	0	\N	31
2122	PASSA TEMPO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147709	1058	0	\N	31
2123	PASSA VINTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147808	1058	0	\N	31
2124	PASSOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147907	1058	0	\N	31
2125	PATIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3147956	1058	0	\N	31
2126	PATOS DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148004	1058	0	\N	31
2127	PATROCINIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148103	1058	0	\N	31
2128	PATROCINIO DO MURIAE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148202	1058	0	\N	31
2129	PAULA CANDIDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148301	1058	0	\N	31
2130	PAULISTAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148400	1058	0	\N	31
2131	PAVAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148509	1058	0	\N	31
2132	PECANHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148608	1058	0	\N	31
2133	PEDRA AZUL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148707	1058	0	\N	31
2134	PEDRA BONITA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148756	1058	0	\N	31
2135	PEDRA DO ANTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148806	1058	0	\N	31
2136	PEDRA DO INDAIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3148905	1058	0	\N	31
2137	PEDRA DOURADA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149002	1058	0	\N	31
2138	PEDRALVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149101	1058	0	\N	31
2139	PEDRAS DE MARIA DA CRUZ	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149150	1058	0	\N	31
2140	PEDRINOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149200	1058	0	\N	31
2141	PEDRO LEOPOLDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149309	1058	0	\N	31
2142	PEDRO TEIXEIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149408	1058	0	\N	31
2143	PEQUERI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149507	1058	0	\N	31
2144	PEQUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149606	1058	0	\N	31
2145	PERDIGAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149705	1058	0	\N	31
2146	PERDIZES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149804	1058	0	\N	31
2147	PERDOES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149903	1058	0	\N	31
2148	PERIQUITO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3149952	1058	0	\N	31
2149	PESCADOR	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150000	1058	0	\N	31
2150	PIAU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150109	1058	0	\N	31
2151	PIEDADE DE CARATINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150158	1058	0	\N	31
2152	PIEDADE DE PONTE NOVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150208	1058	0	\N	31
2153	PIEDADE DO RIO GRANDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150307	1058	0	\N	31
2154	PIEDADE DOS GERAIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150406	1058	0	\N	31
2155	PIMENTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150505	1058	0	\N	31
2156	PINGO-D AGUA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150539	1058	0	\N	31
2157	PINTOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150570	1058	0	\N	31
2158	PIRACEMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150604	1058	0	\N	31
2159	PIRAJUBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150703	1058	0	\N	31
2160	PIRANGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150802	1058	0	\N	31
2161	PIRANGUCU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3150901	1058	0	\N	31
2162	PIRANGUINHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151008	1058	0	\N	31
2163	PIRAPETINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151107	1058	0	\N	31
2164	PIRAPORA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151206	1058	0	\N	31
2165	PIRAUBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151305	1058	0	\N	31
2166	PITANGUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151404	1058	0	\N	31
2167	PIUMHI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151503	1058	0	\N	31
2168	PLANURA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151602	1058	0	\N	31
2169	POCO FUNDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151701	1058	0	\N	31
2170	POCOS DE CALDAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151800	1058	0	\N	31
2171	POCRANE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3151909	1058	0	\N	31
2172	POMPEU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152006	1058	0	\N	31
2173	PONTE NOVA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152105	1058	0	\N	31
2174	PONTO CHIQUE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152131	1058	0	\N	31
2175	PONTO DOS VOLANTES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152170	1058	0	\N	31
2176	PORTEIRINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152204	1058	0	\N	31
2177	PORTO FIRME	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152303	1058	0	\N	31
2178	POTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152402	1058	0	\N	31
2179	POUSO ALEGRE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152501	1058	0	\N	31
2180	POUSO ALTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152600	1058	0	\N	31
2181	PRADOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152709	1058	0	\N	31
2182	PRATA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152808	1058	0	\N	31
2183	PRATAPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3152907	1058	0	\N	31
2184	PRATINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153004	1058	0	\N	31
2185	PRESIDENTE BERNARDES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153103	1058	0	\N	31
2186	PRESIDENTE JUSCELINO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153202	1058	0	\N	31
2187	PRESIDENTE KUBITSCHEK	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153301	1058	0	\N	31
2188	PRESIDENTE OLEGARIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153400	1058	0	\N	31
2189	PRUDENTE DE MORAIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153608	1058	0	\N	31
2190	QUARTEL GERAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153707	1058	0	\N	31
2191	QUELUZITO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153806	1058	0	\N	31
2192	RAPOSOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3153905	1058	0	\N	31
2193	RAUL SOARES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154002	1058	0	\N	31
2194	RECREIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154101	1058	0	\N	31
2195	REDUTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154150	1058	0	\N	31
2196	RESENDE COSTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154200	1058	0	\N	31
2197	RESPLENDOR	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154309	1058	0	\N	31
2198	RESSAQUINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154408	1058	0	\N	31
2199	RIACHINHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154457	1058	0	\N	31
2200	RIACHO DOS MACHADOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154507	1058	0	\N	31
2201	RIBEIRAO DAS NEVES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154606	1058	0	\N	31
2202	RIBEIRAO VERMELHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154705	1058	0	\N	31
2203	RIO ACIMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154804	1058	0	\N	31
2204	RIO CASCA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3154903	1058	0	\N	31
2205	RIO DOCE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155009	1058	0	\N	31
2206	RIO DO PRADO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155108	1058	0	\N	31
2207	RIO ESPERA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155207	1058	0	\N	31
2208	RIO MANSO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155306	1058	0	\N	31
2209	RIO NOVO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155405	1058	0	\N	31
2210	RIO PARANAIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155504	1058	0	\N	31
2211	RIO PARDO DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155603	1058	0	\N	31
2212	RIO PIRACICABA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155702	1058	0	\N	31
2213	RIO POMBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155801	1058	0	\N	31
2214	RIO PRETO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3155900	1058	0	\N	31
2215	RIO VERMELHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156007	1058	0	\N	31
2216	RITAPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156106	1058	0	\N	31
2217	ROCHEDO DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156205	1058	0	\N	31
2218	RODEIRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156304	1058	0	\N	31
2219	ROMARIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156403	1058	0	\N	31
2220	ROSARIO DA LIMEIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156452	1058	0	\N	31
2221	RUBELITA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156502	1058	0	\N	31
2222	RUBIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156601	1058	0	\N	31
2223	SABARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156700	1058	0	\N	31
2224	SABINOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156809	1058	0	\N	31
2225	SACRAMENTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3156908	1058	0	\N	31
2226	SALINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157005	1058	0	\N	31
2227	SALTO DA DIVISA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157104	1058	0	\N	31
2228	SANTA BARBARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157203	1058	0	\N	31
2229	SANTA BARBARA DO LESTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157252	1058	0	\N	31
2230	SANTA BARBARA DO MONTE VERDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157278	1058	0	\N	31
2231	SANTA BARBARA DO TUGURIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157302	1058	0	\N	31
2232	SANTA CRUZ DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157336	1058	0	\N	31
2233	SANTA CRUZ DE SALINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157377	1058	0	\N	31
2234	SANTA CRUZ DO ESCALVADO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157401	1058	0	\N	31
2235	SANTA EFIGENIA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157500	1058	0	\N	31
2236	SANTA FE DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157609	1058	0	\N	31
2237	SANTA HELENA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157658	1058	0	\N	31
2238	SANTA JULIANA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157708	1058	0	\N	31
2239	SANTA LUZIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157807	1058	0	\N	31
2240	SANTA MARGARIDA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3157906	1058	0	\N	31
2241	SANTA MARIA DE ITABIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158003	1058	0	\N	31
2242	SANTA MARIA DO SALTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158102	1058	0	\N	31
2243	SANTA MARIA DO SUACUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158201	1058	0	\N	31
2244	SANTANA DA VARGEM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158300	1058	0	\N	31
2245	SANTANA DE CATAGUASES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158409	1058	0	\N	31
2246	SANTANA DE PIRAPAMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158508	1058	0	\N	31
2247	SANTANA DO DESERTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158607	1058	0	\N	31
2248	SANTANA DO GARAMBEU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158706	1058	0	\N	31
2249	SANTANA DO JACARE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158805	1058	0	\N	31
2250	SANTANA DO MANHUACU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158904	1058	0	\N	31
2251	SANTANA DO PARAISO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3158953	1058	0	\N	31
2252	SANTANA DO RIACHO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159001	1058	0	\N	31
2253	SANTANA DOS MONTES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159100	1058	0	\N	31
2254	SANTA RITA DE CALDAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159209	1058	0	\N	31
2255	SANTA RITA DE JACUTINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159308	1058	0	\N	31
2256	SANTA RITA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159357	1058	0	\N	31
2257	SANTA RITA DO IBITIPOCA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159407	1058	0	\N	31
2258	SANTA RITA DO ITUETO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159506	1058	0	\N	31
2259	SANTA RITA DO SAPUCAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159605	1058	0	\N	31
2260	SANTA ROSA DA SERRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159704	1058	0	\N	31
2261	SANTA VITORIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159803	1058	0	\N	31
2262	SANTO ANTONIO DO AMPARO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3159902	1058	0	\N	31
2263	SANTO ANTONIO DO AVENTUREIRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160009	1058	0	\N	31
2264	SANTO ANTONIO DO GRAMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160108	1058	0	\N	31
2265	SANTO ANTONIO DO ITAMBE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160207	1058	0	\N	31
2266	SANTO ANTONIO DO JACINTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160306	1058	0	\N	31
2267	SANTO ANTONIO DO MONTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160405	1058	0	\N	31
2268	SANTO ANTONIO DO RETIRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160454	1058	0	\N	31
2269	SANTO ANTONIO DO RIO ABAIXO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160504	1058	0	\N	31
2270	SANTO HIPOLITO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160603	1058	0	\N	31
2271	SANTOS DUMONT	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160702	1058	0	\N	31
2272	SAO BENTO ABADE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160801	1058	0	\N	31
2273	SAO BRAS DO SUACUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160900	1058	0	\N	31
2274	SAO DOMINGOS DAS DORES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3160959	1058	0	\N	31
2275	SAO DOMINGOS DO PRATA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161007	1058	0	\N	31
2276	SAO FELIX DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161056	1058	0	\N	31
2277	SAO FRANCISCO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161106	1058	0	\N	31
2278	SAO FRANCISCO DE PAULA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161205	1058	0	\N	31
2279	SAO FRANCISCO DE SALES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161304	1058	0	\N	31
2280	SAO FRANCISCO DO GLORIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161403	1058	0	\N	31
2281	SAO GERALDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161502	1058	0	\N	31
2282	SAO GERALDO DA PIEDADE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161601	1058	0	\N	31
2283	SAO GERALDO DO BAIXIO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161650	1058	0	\N	31
2284	SAO GONCALO DO ABAETE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161700	1058	0	\N	31
2285	SAO GONCALO DO PARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161809	1058	0	\N	31
2286	SAO GONCALO DO RIO ABAIXO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3161908	1058	0	\N	31
2287	SAO GONCALO DO SAPUCAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162005	1058	0	\N	31
2288	SAO GONCALO DO RIO PRETO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3125507	1058	0	\N	31
2289	SAO GOTARDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162104	1058	0	\N	31
2290	SAO JOAO BATISTA DO GLORIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162203	1058	0	\N	31
2291	SAO JOAO DA LAGOA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162252	1058	0	\N	31
2292	SAO JOAO DA MATA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162302	1058	0	\N	31
2293	SAO JOAO DA PONTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162401	1058	0	\N	31
2294	SAO JOAO DAS MISSOES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162450	1058	0	\N	31
2295	SAO JOAO DEL REI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162500	1058	0	\N	31
2296	SAO JOAO DO MANHUACU	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162559	1058	0	\N	31
2297	SAO JOAO DO MANTENINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162575	1058	0	\N	31
2298	SAO JOAO DO ORIENTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162609	1058	0	\N	31
2299	SAO JOAO DO PACUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162658	1058	0	\N	31
2300	SAO JOAO DO PARAISO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162708	1058	0	\N	31
2301	SAO JOAO EVANGELISTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162807	1058	0	\N	31
2302	SAO JOAO NEPOMUCENO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162906	1058	0	\N	31
2303	SAO JOAQUIM DE BICAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162922	1058	0	\N	31
2304	SAO JOSE DA BARRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162948	1058	0	\N	31
2305	SAO JOSE DA LAPA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3162955	1058	0	\N	31
2306	SAO JOSE DA SAFIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163003	1058	0	\N	31
2307	SAO JOSE DA VARGINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163102	1058	0	\N	31
2308	SAO JOSE DO ALEGRE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163201	1058	0	\N	31
2309	SAO JOSE DO DIVINO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163300	1058	0	\N	31
2310	SAO JOSE DO GOIABAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163409	1058	0	\N	31
2311	SAO JOSE DO JACURI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163508	1058	0	\N	31
2312	SAO JOSE DO MANTIMENTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163607	1058	0	\N	31
2313	SAO LOURENCO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163706	1058	0	\N	31
2314	SAO MIGUEL DO ANTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163805	1058	0	\N	31
2315	SAO PEDRO DA UNIAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3163904	1058	0	\N	31
2316	SAO PEDRO DOS FERROS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164001	1058	0	\N	31
2317	SAO PEDRO DO SUACUI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164100	1058	0	\N	31
2318	SAO ROMAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164209	1058	0	\N	31
2319	SAO ROQUE DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164308	1058	0	\N	31
2320	SAO SEBASTIAO DA BELA VISTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164407	1058	0	\N	31
2321	SAO SEBASTIAO DA VARGEM ALEGRE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164431	1058	0	\N	31
2322	SAO SEBASTIAO DO ANTA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164472	1058	0	\N	31
2323	SAO SEBASTIAO DO MARANHAO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164506	1058	0	\N	31
2324	SAO SEBASTIAO DO OESTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164605	1058	0	\N	31
2325	SAO SEBASTIAO DO PARAISO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164704	1058	0	\N	31
2326	SAO SEBASTIAO DO RIO PRETO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164803	1058	0	\N	31
2327	SAO SEBASTIAO DO RIO VERDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3164902	1058	0	\N	31
2328	SAO THOME DAS LETRAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165206	1058	0	\N	31
2329	SAO TIAGO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165008	1058	0	\N	31
2330	SAO TOMAS DE AQUINO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165107	1058	0	\N	31
2331	SAO VICENTE DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165305	1058	0	\N	31
2332	SAPUCAI MIRIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165404	1058	0	\N	31
2333	SARDOA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165503	1058	0	\N	31
2334	SARZEDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165537	1058	0	\N	31
2335	SETUBINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165552	1058	0	\N	31
2336	SEM-PEIXE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165560	1058	0	\N	31
2337	SENADOR AMARAL	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165578	1058	0	\N	31
2338	SENADOR CORTES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165602	1058	0	\N	31
2339	SENADOR FIRMINO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165701	1058	0	\N	31
2340	SENADOR JOSE BENTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165800	1058	0	\N	31
2341	SENADOR MODESTINO GONCALVES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3165909	1058	0	\N	31
2342	SENHORA DE OLIVEIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166006	1058	0	\N	31
2343	SENHORA DO PORTO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166105	1058	0	\N	31
2344	SENHORA DOS REMEDIOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166204	1058	0	\N	31
2345	SERICITA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166303	1058	0	\N	31
2346	SERITINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166402	1058	0	\N	31
2347	SERRA AZUL DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166501	1058	0	\N	31
2348	SERRA DA SAUDADE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166600	1058	0	\N	31
2349	SERRA DOS AIMORES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166709	1058	0	\N	31
2350	SERRA DO SALITRE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166808	1058	0	\N	31
2351	SERRANIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166907	1058	0	\N	31
2352	SERRANOPOLIS DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3166956	1058	0	\N	31
2353	SERRANOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167004	1058	0	\N	31
2354	SERRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167103	1058	0	\N	31
2355	SETE LAGOAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167202	1058	0	\N	31
2356	SILVEIRANIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167301	1058	0	\N	31
2357	SILVIANOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167400	1058	0	\N	31
2358	SIMAO PEREIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167509	1058	0	\N	31
2359	SIMONESIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167608	1058	0	\N	31
2360	SOBRALIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167707	1058	0	\N	31
2361	SOLEDADE DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167806	1058	0	\N	31
2362	TABULEIRO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3167905	1058	0	\N	31
2363	TAIOBEIRAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168002	1058	0	\N	31
2364	TAPARUBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168051	1058	0	\N	31
2365	TAPIRA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168101	1058	0	\N	31
2366	TAPIRAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168200	1058	0	\N	31
2367	TAQUARACU DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168309	1058	0	\N	31
2368	TARUMIRIM	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168408	1058	0	\N	31
2369	TEIXEIRAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168507	1058	0	\N	31
2370	TEOFILO OTONI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168606	1058	0	\N	31
2371	TIMOTEO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168705	1058	0	\N	31
2372	TIRADENTES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168804	1058	0	\N	31
2373	TIROS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3168903	1058	0	\N	31
2374	TOCANTINS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169000	1058	0	\N	31
2375	TOCOS DO MOJI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169059	1058	0	\N	31
2376	TOLEDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169109	1058	0	\N	31
2377	TOMBOS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169208	1058	0	\N	31
2378	TRES CORACOES	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169307	1058	0	\N	31
2379	TRES MARIAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169356	1058	0	\N	31
2380	TRES PONTAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169406	1058	0	\N	31
2381	TUMIRITINGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169505	1058	0	\N	31
2382	TUPACIGUARA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169604	1058	0	\N	31
2383	TURMALINA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169703	1058	0	\N	31
2384	TURVOLANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169802	1058	0	\N	31
2385	UBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3169901	1058	0	\N	31
2386	UBAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170008	1058	0	\N	31
2387	UBAPORANGA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170057	1058	0	\N	31
2388	UBERABA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170107	1058	0	\N	31
2389	UBERLANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170206	1058	0	\N	31
2390	UMBURATIBA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170305	1058	0	\N	31
2391	UNAI	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170404	1058	0	\N	31
2392	UNIAO DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170438	1058	0	\N	31
2393	URUANA DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170479	1058	0	\N	31
2394	URUCANIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170503	1058	0	\N	31
2395	URUCUIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170529	1058	0	\N	31
2396	VARGEM ALEGRE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170578	1058	0	\N	31
2397	VARGEM BONITA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170602	1058	0	\N	31
2398	VARGEM GRANDE DO RIO PARDO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170651	1058	0	\N	31
2399	VARGINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170701	1058	0	\N	31
2400	VARJAO DE MINAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170750	1058	0	\N	31
2401	VARZEA DA PALMA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170800	1058	0	\N	31
2402	VARZELANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3170909	1058	0	\N	31
2403	VAZANTE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171006	1058	0	\N	31
2404	VERDELANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171030	1058	0	\N	31
2405	VEREDINHA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171071	1058	0	\N	31
2406	VERISSIMO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171105	1058	0	\N	31
2407	VERMELHO NOVO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171154	1058	0	\N	31
2408	VESPASIANO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171204	1058	0	\N	31
2409	VICOSA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171303	1058	0	\N	31
2410	VIEIRAS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171402	1058	0	\N	31
2411	VIRGEM DA LAPA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171600	1058	0	\N	31
2412	VIRGINIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171709	1058	0	\N	31
2413	VIRGINOPOLIS	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171808	1058	0	\N	31
2414	VIRGOLANDIA	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3171907	1058	0	\N	31
2415	VISCONDE DO RIO BRANCO	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3172004	1058	0	\N	31
2416	VOLTA GRANDE	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3172103	1058	0	\N	31
2417	WENCESLAU BRAZ	MG			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3172202	1058	0	\N	31
2418	ABAETETUBA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500107	1058	0	\N	31
2419	ABEL FIGUEIREDO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500131	1058	0	\N	31
2420	ACARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500206	1058	0	\N	31
2421	AFUA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500305	1058	0	\N	31
2422	AGUA AZUL DO NORTE	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500347	1058	0	\N	31
2423	ALENQUER	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500404	1058	0	\N	31
2424	ALMEIRIM	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500503	1058	0	\N	31
2425	ALTAMIRA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500602	1058	0	\N	31
2426	ANAJAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500701	1058	0	\N	31
2427	ANANINDEUA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500800	1058	0	\N	31
2428	ANAPU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500859	1058	0	\N	31
2429	AUGUSTO CORREA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500909	1058	0	\N	31
2430	AURORA DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1500958	1058	0	\N	31
2431	AVEIRO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501006	1058	0	\N	31
2432	BAGRE	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501105	1058	0	\N	31
2433	BAIAO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501204	1058	0	\N	31
2434	BANNACH	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501253	1058	0	\N	31
2435	BARCARENA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501303	1058	0	\N	31
2436	BELEM	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501402	1058	0	\N	31
2437	BELTERRA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501451	1058	0	\N	31
2438	BENEVIDES	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501501	1058	0	\N	31
2439	BOM JESUS DO TOCANTINS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501576	1058	0	\N	31
2440	BONITO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501600	1058	0	\N	31
2441	BRAGANCA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501709	1058	0	\N	31
2442	BRASIL NOVO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501725	1058	0	\N	31
2443	BREJO GRANDE DO ARAGUAIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501758	1058	0	\N	31
2444	BREU BRANCO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501782	1058	0	\N	31
2445	BREVES	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501808	1058	0	\N	31
2446	BUJARU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501907	1058	0	\N	31
2447	CACHOEIRA DO ARARI	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502004	1058	0	\N	31
2448	CACHOEIRA DO PIRIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1501956	1058	0	\N	31
2449	CAMETA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502103	1058	0	\N	31
2450	CANAA DOS CARAJAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502152	1058	0	\N	31
2451	CAPANEMA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502202	1058	0	\N	31
2452	CAPITAO POCO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502301	1058	0	\N	31
2453	CASTANHAL	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502400	1058	0	\N	31
2454	CHAVES	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502509	1058	0	\N	31
2455	COLARES	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502608	1058	0	\N	31
2456	CONCEICAO DO ARAGUAIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502707	1058	0	\N	31
2457	CONCORDIA DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502756	1058	0	\N	31
2458	CUMARU DO NORTE	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502764	1058	0	\N	31
2459	CURIONOPOLIS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502772	1058	0	\N	31
2460	CURRALINHO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502806	1058	0	\N	31
2461	CURUA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502855	1058	0	\N	31
2462	CURUCA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502905	1058	0	\N	31
2463	DOM ELISEU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502939	1058	0	\N	31
2464	ELDORADO DOS CARAJAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1502954	1058	0	\N	31
2465	FARO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503002	1058	0	\N	31
2466	FLORESTA DO ARAGUAIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503044	1058	0	\N	31
2467	GARRAFAO DO NORTE	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503077	1058	0	\N	31
2468	GOIANESIA DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503093	1058	0	\N	31
2469	GURUPA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503101	1058	0	\N	31
2470	IGARAPE ACU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503200	1058	0	\N	31
2471	IGARAPE MIRI	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503309	1058	0	\N	31
2472	INHANGAPI	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503408	1058	0	\N	31
2473	IPIXUNA DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503457	1058	0	\N	31
2474	IRITUIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503507	1058	0	\N	31
2475	ITAITUBA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503606	1058	0	\N	31
2476	ITUPIRANGA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503705	1058	0	\N	31
2477	JACAREACANGA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503754	1058	0	\N	31
2478	JACUNDA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503804	1058	0	\N	31
2479	JURUTI	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1503903	1058	0	\N	31
2480	LIMOEIRO DO AJURU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504000	1058	0	\N	31
2481	MAE DO RIO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504059	1058	0	\N	31
2482	MAGALHAES BARATA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504109	1058	0	\N	31
2483	MARABA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504208	1058	0	\N	31
2484	MARACANA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504307	1058	0	\N	31
2485	MARAPANIM	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504406	1058	0	\N	31
2486	MARITUBA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504422	1058	0	\N	31
2487	MEDICILANDIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504455	1058	0	\N	31
2488	MELGACO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504505	1058	0	\N	31
2489	MOCAJUBA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504604	1058	0	\N	31
2490	MOJU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504703	1058	0	\N	31
2491	MONTE ALEGRE	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504802	1058	0	\N	31
2492	MUANA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504901	1058	0	\N	31
2493	NOVA ESPERANCA DO PIRIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504950	1058	0	\N	31
2494	NOVA IPIXUNA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1504976	1058	0	\N	31
2495	NOVA TIMBOTEUA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505007	1058	0	\N	31
2496	NOVO PROGRESSO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505031	1058	0	\N	31
2497	NOVO REPARTIMENTO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505064	1058	0	\N	31
2498	OBIDOS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505106	1058	0	\N	31
2499	OEIRAS DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505205	1058	0	\N	31
2500	ORIXIMINA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505304	1058	0	\N	31
2501	OUREM	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505403	1058	0	\N	31
2502	OURILANDIA DO NORTE	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505437	1058	0	\N	31
2503	PACAJA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505486	1058	0	\N	31
2504	PALESTINA DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505494	1058	0	\N	31
2505	PARAGOMINAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505502	1058	0	\N	31
2506	PARAUAPEBAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505536	1058	0	\N	31
2507	PAU D ARCO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505551	1058	0	\N	31
2508	PEIXE BOI	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505601	1058	0	\N	31
2509	PICARRA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505635	1058	0	\N	31
2510	PLACAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505650	1058	0	\N	31
2511	PONTA DE PEDRAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505700	1058	0	\N	31
2512	PORTEL	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505809	1058	0	\N	31
2513	PORTO DE MOZ	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1505908	1058	0	\N	31
2514	PRAINHA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506005	1058	0	\N	31
2515	PRIMAVERA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506104	1058	0	\N	31
2516	QUATIPURU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506112	1058	0	\N	31
2517	REDENCAO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506138	1058	0	\N	31
2518	RIO MARIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506161	1058	0	\N	31
2519	RONDON DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506187	1058	0	\N	31
2520	RUROPOLIS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506195	1058	0	\N	31
2521	SALINOPOLIS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506203	1058	0	\N	31
2522	SALVATERRA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506302	1058	0	\N	31
2523	SANTA BARBARA DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506351	1058	0	\N	31
2524	SANTA CRUZ DO ARARI	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506401	1058	0	\N	31
2525	SANTA ISABEL DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506500	1058	0	\N	31
2526	SANTA LUZIA DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506559	1058	0	\N	31
2527	SANTA MARIA DAS BARREIRAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506583	1058	0	\N	31
2528	SANTA MARIA DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506609	1058	0	\N	31
2529	SANTANA DO ARAGUAIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506708	1058	0	\N	31
2530	SANTAREM	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506807	1058	0	\N	31
2531	SANTAREM NOVO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1506906	1058	0	\N	31
2532	SANTO ANTONIO DO TAUA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507003	1058	0	\N	31
2533	SAO CAETANO DE ODIVELAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507102	1058	0	\N	31
2534	SAO DOMINGOS DO ARAGUAIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507151	1058	0	\N	31
2535	SAO DOMINGOS DO CAPIM	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507201	1058	0	\N	31
2536	SAO FELIX DO XINGU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507300	1058	0	\N	31
2537	SAO FRANCISCO DO PARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507409	1058	0	\N	31
2538	SAO GERALDO DO ARAGUAIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507458	1058	0	\N	31
2539	SAO JOAO DA PONTA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507466	1058	0	\N	31
2540	SAO JOAO DE PIRABAS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507474	1058	0	\N	31
2541	SAO JOAO DO ARAGUAIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507508	1058	0	\N	31
2542	SAO MIGUEL DO GUAMA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507607	1058	0	\N	31
2543	SAO SEBASTIAO DA BOA VISTA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507706	1058	0	\N	31
2544	SAPUCAIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507755	1058	0	\N	31
2545	SENADOR JOSE PORFIRIO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507805	1058	0	\N	31
2546	SOURE	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507904	1058	0	\N	31
2547	TAILANDIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507953	1058	0	\N	31
2548	TERRA ALTA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507961	1058	0	\N	31
2549	TERRA SANTA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1507979	1058	0	\N	31
2550	TOME ACU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508001	1058	0	\N	31
2551	TRACUATEUA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508035	1058	0	\N	31
2552	TRAIRAO	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508050	1058	0	\N	31
2553	TUCUMA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508084	1058	0	\N	31
2554	TUCURUI	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508100	1058	0	\N	31
2555	ULIANOPOLIS	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508126	1058	0	\N	31
2556	URUARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508159	1058	0	\N	31
2557	VIGIA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508209	1058	0	\N	31
2558	VISEU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508308	1058	0	\N	31
2559	VITORIA DO XINGU	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508357	1058	0	\N	31
2560	XINGUARA	PA			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1508407	1058	0	\N	31
2561	AGUA BRANCA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500106	1058	0	\N	31
2562	AGUIAR	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500205	1058	0	\N	31
2563	ALAGOA GRANDE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500304	1058	0	\N	31
2564	ALAGOA NOVA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500403	1058	0	\N	31
2565	ALAGOINHA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500502	1058	0	\N	31
2566	ALCANTIL	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500536	1058	0	\N	31
2567	ALGODAO DE JANDAIRA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500577	1058	0	\N	31
2568	ALHANDRA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500601	1058	0	\N	31
2569	AMPARO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500734	1058	0	\N	31
2570	APARECIDA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500775	1058	0	\N	31
2571	ARACAGI	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500809	1058	0	\N	31
2572	ARARA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500908	1058	0	\N	31
2573	ARARUNA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501005	1058	0	\N	31
2574	AREIA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501104	1058	0	\N	31
2575	AREIA DE BARAUNAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501153	1058	0	\N	31
2576	AREIAL	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501203	1058	0	\N	31
2577	AROEIRAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501302	1058	0	\N	31
2578	ASSUNCAO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501351	1058	0	\N	31
2579	BAIA DA TRAICAO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501401	1058	0	\N	31
2580	BANANEIRAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501500	1058	0	\N	31
2581	BARAUNA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501534	1058	0	\N	31
2582	BARRA DE SANTANA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501575	1058	0	\N	31
2583	BARRA DE SANTA ROSA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501609	1058	0	\N	31
2584	BARRA DE SAO MIGUEL	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501708	1058	0	\N	31
2585	BAYEUX	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501807	1058	0	\N	31
2586	BELEM	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2501906	1058	0	\N	31
2587	BELEM DO BREJO DO CRUZ	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502003	1058	0	\N	31
2588	BERNARDINO BATISTA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502052	1058	0	\N	31
2589	BOA VENTURA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502102	1058	0	\N	31
2590	BOA VISTA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502151	1058	0	\N	31
2591	BOM JESUS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502201	1058	0	\N	31
2592	BOM SUCESSO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502300	1058	0	\N	31
2593	BONITO DE SANTA FE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502409	1058	0	\N	31
2594	BOQUEIRAO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502508	1058	0	\N	31
2595	BORBOREMA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502706	1058	0	\N	31
2596	BREJO DO CRUZ	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502805	1058	0	\N	31
2597	BREJO DOS SANTOS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502904	1058	0	\N	31
2598	CAAPORA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503001	1058	0	\N	31
2599	CABACEIRAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503100	1058	0	\N	31
2600	CABEDELO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503209	1058	0	\N	31
2601	CACHOEIRA DOS INDIOS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503308	1058	0	\N	31
2602	CACIMBA DE AREIA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503407	1058	0	\N	31
2603	CACIMBA DE DENTRO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503506	1058	0	\N	31
2604	CACIMBAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503555	1058	0	\N	31
2605	CAICARA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503605	1058	0	\N	31
2606	CAJAZEIRAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503704	1058	0	\N	31
2607	CAJAZEIRINHAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503753	1058	0	\N	31
2608	CALDAS BRANDAO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503803	1058	0	\N	31
2609	CAMALAU	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2503902	1058	0	\N	31
2610	CAMPINA GRANDE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504009	1058	0	\N	31
2611	CAPIM	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504033	1058	0	\N	31
2612	CARAUBAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504074	1058	0	\N	31
2613	CARRAPATEIRA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504108	1058	0	\N	31
2614	CASSERENGUE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504157	1058	0	\N	31
2615	CATINGUEIRA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504207	1058	0	\N	31
2616	CATOLE DO ROCHA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504306	1058	0	\N	31
2617	CATURITE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504355	1058	0	\N	31
2618	CONCEICAO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504405	1058	0	\N	31
2619	CONDADO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504504	1058	0	\N	31
2620	CONDE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504603	1058	0	\N	31
2621	CONGO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504702	1058	0	\N	31
2622	COREMAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504801	1058	0	\N	31
2623	COXIXOLA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504850	1058	0	\N	31
2624	CRUZ DO ESPIRITO SANTO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2504900	1058	0	\N	31
2625	CUBATI	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505006	1058	0	\N	31
2626	CUITE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505105	1058	0	\N	31
2627	CUITE DE MAMANGUAPE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505238	1058	0	\N	31
2628	CUITEGI	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505204	1058	0	\N	31
2629	CURRAL DE CIMA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505279	1058	0	\N	31
2630	CURRAL VELHO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505303	1058	0	\N	31
2631	DAMIAO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505352	1058	0	\N	31
2632	DESTERRO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505402	1058	0	\N	31
2633	DIAMANTE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505600	1058	0	\N	31
2634	DONA INES	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505709	1058	0	\N	31
2635	DUAS ESTRADAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505808	1058	0	\N	31
2636	EMAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505907	1058	0	\N	31
2637	ESPERANCA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506004	1058	0	\N	31
2638	FAGUNDES	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506103	1058	0	\N	31
2639	FREI MARTINHO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506202	1058	0	\N	31
2640	GADO BRAVO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506251	1058	0	\N	31
2641	GUARABIRA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506301	1058	0	\N	31
2642	GURINHEM	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506400	1058	0	\N	31
2643	GURJAO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506509	1058	0	\N	31
2644	IBIARA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506608	1058	0	\N	31
2645	IGARACY	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2502607	1058	0	\N	31
2646	IMACULADA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506707	1058	0	\N	31
2647	INGA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506806	1058	0	\N	31
2648	ITABAIANA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2506905	1058	0	\N	31
2649	ITAPORANGA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507002	1058	0	\N	31
2650	ITAPOROROCA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507101	1058	0	\N	31
2651	ITATUBA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507200	1058	0	\N	31
2652	JACARAU	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507309	1058	0	\N	31
2653	JERICO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507408	1058	0	\N	31
2654	JOAO PESSOA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507507	1058	0	\N	31
2655	JUAREZ TAVORA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507606	1058	0	\N	31
2656	JUAZEIRINHO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507705	1058	0	\N	31
2657	JUNCO DO SERIDO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507804	1058	0	\N	31
2658	JURIPIRANGA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2507903	1058	0	\N	31
2659	JURU	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508000	1058	0	\N	31
2660	LAGOA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508109	1058	0	\N	31
2661	LAGOA DE DENTRO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508208	1058	0	\N	31
2662	LAGOA SECA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508307	1058	0	\N	31
2663	LASTRO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508406	1058	0	\N	31
2664	LIVRAMENTO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508505	1058	0	\N	31
2665	LOGRADOURO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508554	1058	0	\N	31
2666	LUCENA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508604	1058	0	\N	31
2667	MAE D AGUA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508703	1058	0	\N	31
2668	MALTA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508802	1058	0	\N	31
2669	MAMANGUAPE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2508901	1058	0	\N	31
2670	MANAIRA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509008	1058	0	\N	31
2671	MARCACAO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509057	1058	0	\N	31
2672	MARI	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509107	1058	0	\N	31
2673	MARIZOPOLIS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509156	1058	0	\N	31
2674	MASSARANDUBA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509206	1058	0	\N	31
2675	MATARACA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509305	1058	0	\N	31
2676	MATINHAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509339	1058	0	\N	31
2677	MATO GROSSO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509370	1058	0	\N	31
2678	MATUREIA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509396	1058	0	\N	31
2679	MOGEIRO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509404	1058	0	\N	31
2680	MONTADAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509503	1058	0	\N	31
2681	MONTE HOREBE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509602	1058	0	\N	31
2682	MONTEIRO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509701	1058	0	\N	31
2683	MULUNGU	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509800	1058	0	\N	31
2684	NATUBA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2509909	1058	0	\N	31
2685	NAZAREZINHO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510006	1058	0	\N	31
2686	NOVA FLORESTA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510105	1058	0	\N	31
2687	NOVA OLINDA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510204	1058	0	\N	31
2688	NOVA PALMEIRA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510303	1058	0	\N	31
2689	OLHO D AGUA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510402	1058	0	\N	31
2690	OLIVEDOS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510501	1058	0	\N	31
2691	OURO VELHO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510600	1058	0	\N	31
2692	PARARI	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510659	1058	0	\N	31
2693	PASSAGEM	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510709	1058	0	\N	31
2694	PATOS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510808	1058	0	\N	31
2695	PAULISTA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2510907	1058	0	\N	31
2696	PEDRA BRANCA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511004	1058	0	\N	31
2697	PEDRA LAVRADA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511103	1058	0	\N	31
2698	PEDRAS DE FOGO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511202	1058	0	\N	31
2699	PEDRO REGIS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512721	1058	0	\N	31
2700	PIANCO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511301	1058	0	\N	31
2701	PICUI	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511400	1058	0	\N	31
2702	PILAR	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511509	1058	0	\N	31
2703	PILOES	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511608	1058	0	\N	31
2704	PILOEZINHOS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511707	1058	0	\N	31
2705	PIRPIRITUBA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511806	1058	0	\N	31
2706	PITIMBU	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2511905	1058	0	\N	31
2707	POCINHOS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512002	1058	0	\N	31
2708	POCO DANTAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512036	1058	0	\N	31
2709	POCO DE JOSE DE MOURA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512077	1058	0	\N	31
2710	POMBAL	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512101	1058	0	\N	31
2711	PRATA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512200	1058	0	\N	31
2712	PRINCESA ISABEL	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512309	1058	0	\N	31
2713	PUXINANA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512408	1058	0	\N	31
2714	QUEIMADAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512507	1058	0	\N	31
2715	QUIXABA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512606	1058	0	\N	31
2716	REMIGIO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512705	1058	0	\N	31
2717	RIACHAO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512747	1058	0	\N	31
2718	RIACHAO DO BACAMARTE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512754	1058	0	\N	31
2719	RIACHAO DO POCO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512762	1058	0	\N	31
2720	RIACHO DE SANTO ANTONIO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512788	1058	0	\N	31
2721	RIACHO DOS CAVALOS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512804	1058	0	\N	31
2722	RIO TINTO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2512903	1058	0	\N	31
2723	SALGADINHO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513000	1058	0	\N	31
2724	SALGADO DE SAO FELIX	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513109	1058	0	\N	31
2725	SANTA CECILIA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513158	1058	0	\N	31
2726	SANTA CRUZ	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513208	1058	0	\N	31
2727	SANTA HELENA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513307	1058	0	\N	31
2728	SANTA INES	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513356	1058	0	\N	31
2729	SANTA LUZIA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513406	1058	0	\N	31
2730	SANTANA DE MANGUEIRA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513505	1058	0	\N	31
2731	SANTANA DOS GARROTES	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513604	1058	0	\N	31
2732	SANTAREM	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513653	1058	0	\N	31
2733	SANTA RITA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513703	1058	0	\N	31
2734	SANTA TERESINHA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513802	1058	0	\N	31
2735	SANTO ANDRE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513851	1058	0	\N	31
2736	SAO BENTINHO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513927	1058	0	\N	31
2737	SAO BENTO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513901	1058	0	\N	31
2738	SAO DOMINGOS DE POMBAL	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513968	1058	0	\N	31
2739	SAO DOMINGOS DO CARIRI	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513943	1058	0	\N	31
2740	SAO FRANCISCO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2513984	1058	0	\N	31
2741	SAO JOAO DO CARIRI	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514008	1058	0	\N	31
2742	SAO JOAO DO RIO DO PEIXE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2500700	1058	0	\N	31
2743	SAO JOAO DO TIGRE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514107	1058	0	\N	31
2744	SAO JOSE DA LAGOA TAPADA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514206	1058	0	\N	31
2745	SAO JOSE DE CAIANA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514305	1058	0	\N	31
2746	SAO JOSE DE ESPINHARAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514404	1058	0	\N	31
2747	SAO JOSE DE PIRANHAS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514503	1058	0	\N	31
2748	SAO JOSE DE PRINCESA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514552	1058	0	\N	31
2749	SAO JOSE DO BONFIM	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514602	1058	0	\N	31
2750	SAO JOSE DO BREJO DO CRUZ	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514651	1058	0	\N	31
2751	SAO JOSE DO SABUGI	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514701	1058	0	\N	31
2752	SAO JOSE DOS CORDEIROS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514800	1058	0	\N	31
2753	SAO JOSE DOS RAMOS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514453	1058	0	\N	31
2754	SAO MAMEDE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2514909	1058	0	\N	31
2755	SAO MIGUEL DE TAIPU	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515005	1058	0	\N	31
2756	SAO SEBASTIAO DE LAGOA DE ROCA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515104	1058	0	\N	31
2757	SAO SEBASTIAO DO UMBUZEIRO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515203	1058	0	\N	31
2758	SAPE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515302	1058	0	\N	31
2759	SERIDO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515401	1058	0	\N	31
2760	SERRA BRANCA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515500	1058	0	\N	31
2761	SERRA DA RAIZ	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515609	1058	0	\N	31
2762	SERRA GRANDE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515708	1058	0	\N	31
2763	SERRA REDONDA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515807	1058	0	\N	31
2764	SERRARIA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515906	1058	0	\N	31
2765	SERTAOZINHO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515930	1058	0	\N	31
2766	SOBRADO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2515971	1058	0	\N	31
2767	SOLANEA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516003	1058	0	\N	31
2768	SOLEDADE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516102	1058	0	\N	31
2769	SOSSEGO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516151	1058	0	\N	31
2770	SOUSA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516201	1058	0	\N	31
2771	SUME	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516300	1058	0	\N	31
2772	TACIMA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516409	1058	0	\N	31
2773	TAPEROA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516508	1058	0	\N	31
2774	TAVARES	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516607	1058	0	\N	31
2775	TEIXEIRA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516706	1058	0	\N	31
2776	TENORIO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516755	1058	0	\N	31
2777	TRIUNFO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516805	1058	0	\N	31
2778	UIRAUNA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2516904	1058	0	\N	31
2779	UMBUZEIRO	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2517001	1058	0	\N	31
2780	VARZEA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2517100	1058	0	\N	31
2781	VIEROPOLIS	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2517209	1058	0	\N	31
2782	VISTA SERRANA	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2505501	1058	0	\N	31
2783	ZABELE	PB			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2517407	1058	0	\N	31
2784	ABATIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100103	1058	0	\N	31
2785	ADRIANOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100202	1058	0	\N	31
2786	AGUDOS DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100301	1058	0	\N	31
2787	ALMIRANTE TAMANDARE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100400	1058	0	\N	31
2788	ALTAMIRA DO PARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100459	1058	0	\N	31
2789	ALTONIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100509	1058	0	\N	31
2790	ALTO PARAISO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128625	1058	0	\N	31
2791	ALTO PARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100608	1058	0	\N	31
2792	ALTO PIQUIRI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100707	1058	0	\N	31
2793	ALVORADA DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100806	1058	0	\N	31
2794	AMAPORA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4100905	1058	0	\N	31
2795	AMPERE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101002	1058	0	\N	31
2796	ANAHY	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101051	1058	0	\N	31
2797	ANDIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101101	1058	0	\N	31
2798	ANGULO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101150	1058	0	\N	31
2799	ANTONINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101200	1058	0	\N	31
2800	ANTONIO OLINTO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101309	1058	0	\N	31
2801	APUCARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101408	1058	0	\N	31
2802	ARAPONGAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101507	1058	0	\N	31
2803	ARAPOTI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101606	1058	0	\N	31
2804	ARAPUA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101655	1058	0	\N	31
2805	ARARUNA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101705	1058	0	\N	31
2806	ARAUCARIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101804	1058	0	\N	31
2807	ARIRANHA DO IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101853	1058	0	\N	31
2808	ASSAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4101903	1058	0	\N	31
2809	ASSIS CHATEAUBRIAND	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102000	1058	0	\N	31
2810	ASTORGA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102109	1058	0	\N	31
2811	ATALAIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102208	1058	0	\N	31
2812	BALSA NOVA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102307	1058	0	\N	31
2813	BANDEIRANTES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102406	1058	0	\N	31
2814	BARBOSA FERRAZ	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102505	1058	0	\N	31
2815	BARRACAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102604	1058	0	\N	31
2816	BARRA DO JACARE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102703	1058	0	\N	31
2817	BELA VISTA DA CAROBA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102752	1058	0	\N	31
2818	BELA VISTA DO PARAISO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102802	1058	0	\N	31
2819	BITURUNA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4102901	1058	0	\N	31
2820	BOA ESPERANCA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103008	1058	0	\N	31
2821	BOA ESPERANCA DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103024	1058	0	\N	31
2822	BOA VENTURA DE SAO ROQUE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103040	1058	0	\N	31
2823	BOA VISTA DA APARECIDA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103057	1058	0	\N	31
2824	BOCAIUVA DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103107	1058	0	\N	31
2825	BOM JESUS DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103156	1058	0	\N	31
2826	BOM SUCESSO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103206	1058	0	\N	31
2827	BOM SUCESSO DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103222	1058	0	\N	31
2828	BORRAZOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103305	1058	0	\N	31
2829	BRAGANEY	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103354	1058	0	\N	31
2830	BRASILANDIA DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103370	1058	0	\N	31
2831	CAFEARA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103404	1058	0	\N	31
2832	CAFELANDIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103453	1058	0	\N	31
2833	CAFEZAL DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103479	1058	0	\N	31
2834	CALIFORNIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103503	1058	0	\N	31
2835	CAMBARA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103602	1058	0	\N	31
2836	CAMBE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103701	1058	0	\N	31
2837	CAMBIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103800	1058	0	\N	31
2838	CAMPINA DA LAGOA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103909	1058	0	\N	31
2839	CAMPINA DO SIMAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4103958	1058	0	\N	31
2840	CAMPINA GRANDE DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104006	1058	0	\N	31
2841	CAMPO BONITO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104055	1058	0	\N	31
2842	CAMPO DO TENENTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104105	1058	0	\N	31
2843	CAMPO LARGO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104204	1058	0	\N	31
2844	CAMPO MAGRO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104253	1058	0	\N	31
2845	CAMPO MOURAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104303	1058	0	\N	31
2846	CANDIDO DE ABREU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104402	1058	0	\N	31
2847	CANDOI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104428	1058	0	\N	31
2848	CANTAGALO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104451	1058	0	\N	31
2849	CAPANEMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104501	1058	0	\N	31
2850	CAPITAO LEONIDAS MARQUES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104600	1058	0	\N	31
2851	CARAMBEI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104659	1058	0	\N	31
2852	CARLOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104709	1058	0	\N	31
2853	CASCAVEL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104808	1058	0	\N	31
2854	CASTRO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4104907	1058	0	\N	31
2855	CATANDUVAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105003	1058	0	\N	31
2856	CENTENARIO DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105102	1058	0	\N	31
2857	CERRO AZUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105201	1058	0	\N	31
2858	CEU AZUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105300	1058	0	\N	31
2859	CHOPINZINHO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105409	1058	0	\N	31
2860	CIANORTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105508	1058	0	\N	31
2861	CIDADE GAUCHA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105607	1058	0	\N	31
2862	CLEVELANDIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105706	1058	0	\N	31
2863	COLOMBO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105805	1058	0	\N	31
2864	COLORADO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4105904	1058	0	\N	31
2865	CONGONHINHAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106001	1058	0	\N	31
2866	CONSELHEIRO MAIRINCK	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106100	1058	0	\N	31
2867	CONTENDA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106209	1058	0	\N	31
2868	CORBELIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106308	1058	0	\N	31
2869	CORNELIO PROCOPIO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106407	1058	0	\N	31
2870	CORONEL DOMINGOS SOARES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106456	1058	0	\N	31
2871	CORONEL VIVIDA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106506	1058	0	\N	31
2872	CORUMBATAI DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106555	1058	0	\N	31
2873	CRUZEIRO DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106571	1058	0	\N	31
2874	CRUZEIRO DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106605	1058	0	\N	31
2875	CRUZEIRO DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106704	1058	0	\N	31
2876	CRUZ MACHADO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106803	1058	0	\N	31
2877	CRUZMALTINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106852	1058	0	\N	31
2878	CURITIBA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4106902	1058	0	\N	31
2879	CURIUVA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107009	1058	0	\N	31
2880	DIAMANTE DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107124	1058	0	\N	31
2881	DIAMANTE DO NORTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107108	1058	0	\N	31
2882	DIAMANTE D OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107157	1058	0	\N	31
2883	DOIS VIZINHOS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107207	1058	0	\N	31
2884	DOURADINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107256	1058	0	\N	31
2885	DOUTOR CAMARGO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107306	1058	0	\N	31
2886	ENEAS MARQUES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107405	1058	0	\N	31
2887	ENGENHEIRO BELTRAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107504	1058	0	\N	31
2888	ENTRE RIOS DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107538	1058	0	\N	31
2889	ESPERANCA NOVA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107520	1058	0	\N	31
2890	ESPIGAO ALTO DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107546	1058	0	\N	31
2891	FAROL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107553	1058	0	\N	31
2892	FAXINAL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107603	1058	0	\N	31
2893	FAZENDA RIO GRANDE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107652	1058	0	\N	31
2894	FENIX	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107702	1058	0	\N	31
2895	FERNANDES PINHEIRO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107736	1058	0	\N	31
2896	FIGUEIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107751	1058	0	\N	31
2897	FLORAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107801	1058	0	\N	31
2898	FLOR DA SERRA DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107850	1058	0	\N	31
2899	FLORESTA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4107900	1058	0	\N	31
2900	FLORESTOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108007	1058	0	\N	31
2901	FLORIDA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108106	1058	0	\N	31
2902	FORMOSA DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108205	1058	0	\N	31
2903	FOZ DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108304	1058	0	\N	31
2904	FRANCISCO ALVES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108320	1058	0	\N	31
2905	FRANCISCO BELTRAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108403	1058	0	\N	31
2906	FOZ DO JORDAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108452	1058	0	\N	31
2907	GENERAL CARNEIRO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108502	1058	0	\N	31
2908	GODOY MOREIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108551	1058	0	\N	31
2909	GOIOERE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108601	1058	0	\N	31
2910	GOIOXIM	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108650	1058	0	\N	31
2911	GRANDES RIOS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108700	1058	0	\N	31
2912	GUAIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108809	1058	0	\N	31
2913	GUAIRACA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108908	1058	0	\N	31
2914	GUAMIRANGA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4108957	1058	0	\N	31
2915	GUAPIRAMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109005	1058	0	\N	31
2916	GUAPOREMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109104	1058	0	\N	31
2917	GUARACI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109203	1058	0	\N	31
2918	GUARANIACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109302	1058	0	\N	31
2919	GUARAPUAVA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109401	1058	0	\N	31
2920	GUARAQUECABA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109500	1058	0	\N	31
2921	GUARATUBA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109609	1058	0	\N	31
2922	HONORIO SERPA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109658	1058	0	\N	31
2923	IBAITI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109708	1058	0	\N	31
2924	IBEMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109757	1058	0	\N	31
2925	IBIPORA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109807	1058	0	\N	31
2926	ICARAIMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4109906	1058	0	\N	31
2927	IGUARACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110003	1058	0	\N	31
2928	IGUATU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110052	1058	0	\N	31
2929	IMBAU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110078	1058	0	\N	31
2930	IMBITUVA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110102	1058	0	\N	31
2931	INACIO MARTINS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110201	1058	0	\N	31
2932	INAJA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110300	1058	0	\N	31
2933	INDIANOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110409	1058	0	\N	31
2934	IPIRANGA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110508	1058	0	\N	31
2935	IPORA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110607	1058	0	\N	31
2936	IRACEMA DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110656	1058	0	\N	31
2937	IRATI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110706	1058	0	\N	31
2938	IRETAMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110805	1058	0	\N	31
2939	ITAGUAJE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110904	1058	0	\N	31
2940	ITAIPULANDIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4110953	1058	0	\N	31
2941	ITAMBARACA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111001	1058	0	\N	31
2942	ITAMBE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111100	1058	0	\N	31
2943	ITAPEJARA D OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111209	1058	0	\N	31
2944	ITAPERUCU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111258	1058	0	\N	31
2945	ITAUNA DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111308	1058	0	\N	31
2946	IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111407	1058	0	\N	31
2947	IVAIPORA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111506	1058	0	\N	31
2948	IVATE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111555	1058	0	\N	31
2949	IVATUBA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111605	1058	0	\N	31
2950	JABOTI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111704	1058	0	\N	31
2951	JACAREZINHO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111803	1058	0	\N	31
2952	JAGUAPITA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4111902	1058	0	\N	31
2953	JAGUARIAIVA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112009	1058	0	\N	31
2954	JANDAIA DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112108	1058	0	\N	31
2955	JANIOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112207	1058	0	\N	31
2956	JAPIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112306	1058	0	\N	31
2957	JAPURA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112405	1058	0	\N	31
2958	JARDIM ALEGRE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112504	1058	0	\N	31
2959	JARDIM OLINDA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112603	1058	0	\N	31
2960	JATAIZINHO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112702	1058	0	\N	31
2961	JESUITAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112751	1058	0	\N	31
2962	JOAQUIM TAVORA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112801	1058	0	\N	31
2963	JUNDIAI DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112900	1058	0	\N	31
2964	JURANDA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4112959	1058	0	\N	31
2965	JUSSARA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113007	1058	0	\N	31
2966	KALORE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113106	1058	0	\N	31
2967	LAPA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113205	1058	0	\N	31
2968	LARANJAL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113254	1058	0	\N	31
2969	LARANJEIRAS DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113304	1058	0	\N	31
2970	LEOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113403	1058	0	\N	31
2971	LIDIANOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113429	1058	0	\N	31
2972	LINDOESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113452	1058	0	\N	31
2973	LOANDA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113502	1058	0	\N	31
2974	LOBATO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113601	1058	0	\N	31
2975	LONDRINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113700	1058	0	\N	31
2976	LUIZIANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113734	1058	0	\N	31
2977	LUNARDELLI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113759	1058	0	\N	31
2978	LUPIONOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113809	1058	0	\N	31
2979	MALLET	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4113908	1058	0	\N	31
2980	MAMBORE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114005	1058	0	\N	31
2981	MANDAGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114104	1058	0	\N	31
2982	MANDAGUARI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114203	1058	0	\N	31
2983	MANDIRITUBA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114302	1058	0	\N	31
2984	MANFRINOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114351	1058	0	\N	31
2985	MANGUEIRINHA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114401	1058	0	\N	31
2986	MANOEL RIBAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114500	1058	0	\N	31
2987	MARECHAL CANDIDO RONDON	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114609	1058	0	\N	31
2988	MARIA HELENA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114708	1058	0	\N	31
2989	MARIALVA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114807	1058	0	\N	31
2990	MARILANDIA DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4114906	1058	0	\N	31
2991	MARILENA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115002	1058	0	\N	31
2992	MARILUZ	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115101	1058	0	\N	31
2993	MARINGA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115200	1058	0	\N	31
2994	MARIOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115309	1058	0	\N	31
2995	MARIPA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115358	1058	0	\N	31
2996	MARMELEIRO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115408	1058	0	\N	31
2997	MARQUINHO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115457	1058	0	\N	31
2998	MARUMBI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115507	1058	0	\N	31
2999	MATELANDIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115606	1058	0	\N	31
3000	MATINHOS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115705	1058	0	\N	31
3001	MATO RICO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115739	1058	0	\N	31
3002	MAUA DA SERRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115754	1058	0	\N	31
3003	MEDIANEIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115804	1058	0	\N	31
3004	MERCEDES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115853	1058	0	\N	31
3005	MIRADOR	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4115903	1058	0	\N	31
3006	MIRASELVA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116000	1058	0	\N	31
3007	MISSAL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116059	1058	0	\N	31
3008	MOREIRA SALES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116109	1058	0	\N	31
3009	MORRETES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116208	1058	0	\N	31
3010	MUNHOZ DE MELO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116307	1058	0	\N	31
3011	NOSSA SENHORA DAS GRACAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116406	1058	0	\N	31
3012	NOVA ALIANCA DO IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116505	1058	0	\N	31
3013	NOVA AMERICA DA COLINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116604	1058	0	\N	31
3014	NOVA AURORA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116703	1058	0	\N	31
3015	NOVA CANTU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116802	1058	0	\N	31
3016	NOVA ESPERANCA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116901	1058	0	\N	31
3017	NOVA ESPERANCA DO SUDOESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4116950	1058	0	\N	31
3018	NOVA FATIMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117008	1058	0	\N	31
3019	NOVA LARANJEIRAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117057	1058	0	\N	31
3020	NOVA LONDRINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117107	1058	0	\N	31
3021	NOVA OLIMPIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117206	1058	0	\N	31
3022	NOVA SANTA BARBARA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117214	1058	0	\N	31
3023	NOVA SANTA ROSA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117222	1058	0	\N	31
3024	NOVA PRATA DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117255	1058	0	\N	31
3025	NOVA TEBAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117271	1058	0	\N	31
3026	NOVO ITACOLOMI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117297	1058	0	\N	31
3027	ORTIGUEIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117305	1058	0	\N	31
3028	OURIZONA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117404	1058	0	\N	31
3029	OURO VERDE DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117453	1058	0	\N	31
3030	PAICANDU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117503	1058	0	\N	31
3031	PALMAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117602	1058	0	\N	31
3032	PALMEIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117701	1058	0	\N	31
3033	PALMITAL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117800	1058	0	\N	31
3034	PALOTINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4117909	1058	0	\N	31
3035	PARAISO DO NORTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118006	1058	0	\N	31
3036	PARANACITY	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118105	1058	0	\N	31
3037	PARANAGUA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118204	1058	0	\N	31
3038	PARANAPOEMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118303	1058	0	\N	31
3039	PARANAVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118402	1058	0	\N	31
3040	PATO BRAGADO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118451	1058	0	\N	31
3041	PATO BRANCO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118501	1058	0	\N	31
3042	PAULA FREITAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118600	1058	0	\N	31
3043	PAULO FRONTIN	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118709	1058	0	\N	31
3044	PEABIRU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118808	1058	0	\N	31
3045	PEROBAL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118857	1058	0	\N	31
3046	PEROLA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4118907	1058	0	\N	31
3047	PEROLA D OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119004	1058	0	\N	31
3048	PIEN	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119103	1058	0	\N	31
3049	PINHAIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119152	1058	0	\N	31
3050	PINHALAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119202	1058	0	\N	31
3051	PINHAL DE SAO BENTO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119251	1058	0	\N	31
3052	PINHAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119301	1058	0	\N	31
3053	PIRAI DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119400	1058	0	\N	31
3054	PIRAQUARA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119509	1058	0	\N	31
3055	PITANGA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119608	1058	0	\N	31
3056	PITANGUEIRAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119657	1058	0	\N	31
3057	PLANALTINA DO PARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119707	1058	0	\N	31
3058	PLANALTO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119806	1058	0	\N	31
3059	PONTA GROSSA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119905	1058	0	\N	31
3060	PONTAL DO PARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4119954	1058	0	\N	31
3061	PORECATU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120002	1058	0	\N	31
3062	PORTO AMAZONAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120101	1058	0	\N	31
3063	PORTO BARREIRO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120150	1058	0	\N	31
3064	PORTO RICO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120200	1058	0	\N	31
3065	PORTO VITORIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120309	1058	0	\N	31
3066	PRADO FERREIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120333	1058	0	\N	31
3067	PRANCHITA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120358	1058	0	\N	31
3068	PRESIDENTE CASTELO BRANCO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120408	1058	0	\N	31
3069	PRIMEIRO DE MAIO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120507	1058	0	\N	31
3070	PRUDENTOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120606	1058	0	\N	31
3071	QUARTO CENTENARIO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120655	1058	0	\N	31
3072	QUATIGUA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120705	1058	0	\N	31
3073	QUATRO BARRAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120804	1058	0	\N	31
3074	QUATRO PONTES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120853	1058	0	\N	31
3075	QUEDAS DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4120903	1058	0	\N	31
3076	QUERENCIA DO NORTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121000	1058	0	\N	31
3077	QUINTA DO SOL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121109	1058	0	\N	31
3078	QUITANDINHA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121208	1058	0	\N	31
3079	RAMILANDIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121257	1058	0	\N	31
3080	RANCHO ALEGRE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121307	1058	0	\N	31
3081	RANCHO ALEGRE D OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121356	1058	0	\N	31
3082	REALEZA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121406	1058	0	\N	31
3083	REBOUCAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121505	1058	0	\N	31
3084	RENASCENCA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121604	1058	0	\N	31
3085	RESERVA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121703	1058	0	\N	31
3086	RESERVA DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121752	1058	0	\N	31
3087	RIBEIRAO CLARO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121802	1058	0	\N	31
3088	RIBEIRAO DO PINHAL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4121901	1058	0	\N	31
3089	RIO AZUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122008	1058	0	\N	31
3090	RIO BOM	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122107	1058	0	\N	31
3091	RIO BONITO DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122156	1058	0	\N	31
3092	RIO BRANCO DO IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122172	1058	0	\N	31
3093	RIO BRANCO DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122206	1058	0	\N	31
3094	RIO NEGRO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122305	1058	0	\N	31
3095	ROLANDIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122404	1058	0	\N	31
3096	RONCADOR	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122503	1058	0	\N	31
3097	RONDON	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122602	1058	0	\N	31
3098	ROSARIO DO IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122651	1058	0	\N	31
3099	SABAUDIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122701	1058	0	\N	31
3100	SALGADO FILHO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122800	1058	0	\N	31
3101	SALTO DO ITARARE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4122909	1058	0	\N	31
3102	SALTO DO LONTRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123006	1058	0	\N	31
3103	SANTA AMELIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123105	1058	0	\N	31
3104	SANTA CECILIA DO PAVAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123204	1058	0	\N	31
3105	SANTA CRUZ DE MONTE CASTELO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123303	1058	0	\N	31
3107	SANTA HELENA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123501	1058	0	\N	31
3108	SANTA INES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123600	1058	0	\N	31
3109	SANTA ISABEL DO IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123709	1058	0	\N	31
3110	SANTA IZABEL DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123808	1058	0	\N	31
3111	SANTA LUCIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123824	1058	0	\N	31
3112	SANTA MARIA DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123857	1058	0	\N	31
3113	SANTA MARIANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123907	1058	0	\N	31
3114	SANTA MONICA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4123956	1058	0	\N	31
3115	SANTANA DO ITARARE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124004	1058	0	\N	31
3116	SANTA TEREZA DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124020	1058	0	\N	31
3117	SANTA TEREZINHA DE ITAIPU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124053	1058	0	\N	31
3118	SANTO ANTONIO DA PLATINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124103	1058	0	\N	31
3119	SANTO ANTONIO DO CAIUA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124202	1058	0	\N	31
3120	SANTO ANTONIO DO PARAISO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124301	1058	0	\N	31
3121	SANTO ANTONIO DO SUDOESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124400	1058	0	\N	31
3122	SANTO INACIO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124509	1058	0	\N	31
3123	SAO CARLOS DO IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124608	1058	0	\N	31
3124	SAO JERONIMO DA SERRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124707	1058	0	\N	31
3125	SAO JOAO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124806	1058	0	\N	31
3126	SAO JOAO DO CAIUA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4124905	1058	0	\N	31
3127	SAO JOAO DO IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125001	1058	0	\N	31
3128	SAO JOAO DO TRIUNFO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125100	1058	0	\N	31
3129	SAO JORGE D OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125209	1058	0	\N	31
3130	SAO JORGE DO IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125308	1058	0	\N	31
3131	SAO JORGE DO PATROCINIO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125357	1058	0	\N	31
3132	SAO JOSE DA BOA VISTA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125407	1058	0	\N	31
3133	SAO JOSE DAS PALMEIRAS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125456	1058	0	\N	31
3134	SAO JOSE DOS PINHAIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125506	1058	0	\N	31
3135	SAO MANOEL DO PARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125555	1058	0	\N	31
3136	SAO MATEUS DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125605	1058	0	\N	31
3137	SAO MIGUEL DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125704	1058	0	\N	31
3138	SAO PEDRO DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125753	1058	0	\N	31
3139	SAO PEDRO DO IVAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125803	1058	0	\N	31
3140	SAO PEDRO DO PARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4125902	1058	0	\N	31
3141	SAO SEBASTIAO DA AMOREIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126009	1058	0	\N	31
3142	SAO TOME	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126108	1058	0	\N	31
3143	SAPOPEMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126207	1058	0	\N	31
3144	SARANDI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126256	1058	0	\N	31
3145	SAUDADE DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126272	1058	0	\N	31
3146	SENGES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126306	1058	0	\N	31
3147	SERRANOPOLIS DO IGUACU	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126355	1058	0	\N	31
3148	SERTANEJA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126405	1058	0	\N	31
3149	SERTANOPOLIS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126504	1058	0	\N	31
3150	SIQUEIRA CAMPOS	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126603	1058	0	\N	31
3151	SULINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126652	1058	0	\N	31
3152	TAMARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126678	1058	0	\N	31
3153	TAMBOARA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126702	1058	0	\N	31
3154	TAPEJARA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126801	1058	0	\N	31
3155	TAPIRA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4126900	1058	0	\N	31
3156	TEIXEIRA SOARES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127007	1058	0	\N	31
3157	TELEMACO BORBA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127106	1058	0	\N	31
3158	TERRA BOA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127205	1058	0	\N	31
3159	TERRA RICA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127304	1058	0	\N	31
3160	TERRA ROXA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127403	1058	0	\N	31
3161	TIBAGI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127502	1058	0	\N	31
3162	TIJUCAS DO SUL	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127601	1058	0	\N	31
3163	TOLEDO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127700	1058	0	\N	31
3164	TOMAZINA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127809	1058	0	\N	31
3165	TRES BARRAS DO PARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127858	1058	0	\N	31
3166	TUNAS DO PARANA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127882	1058	0	\N	31
3167	TUNEIRAS DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127908	1058	0	\N	31
3168	TUPASSI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127957	1058	0	\N	31
3169	TURVO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4127965	1058	0	\N	31
3170	UBIRATA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128005	1058	0	\N	31
3171	UMUARAMA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128104	1058	0	\N	31
3172	UNIAO DA VITORIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128203	1058	0	\N	31
3173	UNIFLOR	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128302	1058	0	\N	31
3174	URAI	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128401	1058	0	\N	31
3175	WENCESLAU BRAZ	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128500	1058	0	\N	31
3176	VENTANIA	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128534	1058	0	\N	31
3177	VERA CRUZ DO OESTE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128559	1058	0	\N	31
3178	VERE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128609	1058	0	\N	31
3179	DOUTOR ULYSSES	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128633	1058	0	\N	31
3180	VIRMOND	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128658	1058	0	\N	31
3181	VITORINO	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128708	1058	0	\N	31
3182	XAMBRE	PR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4128807	1058	0	\N	31
3183	ABREU E LIMA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600054	1058	0	\N	31
3184	AFOGADOS DA INGAZEIRA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600104	1058	0	\N	31
3185	AFRANIO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600203	1058	0	\N	31
3186	AGRESTINA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600302	1058	0	\N	31
3187	AGUA PRETA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600401	1058	0	\N	31
3188	AGUAS BELAS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600500	1058	0	\N	31
3189	ALAGOINHA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600609	1058	0	\N	31
3190	ALIANCA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600708	1058	0	\N	31
3191	ALTINHO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600807	1058	0	\N	31
3192	AMARAJI	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2600906	1058	0	\N	31
3193	ANGELIM	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601003	1058	0	\N	31
3194	ARACOIABA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601052	1058	0	\N	31
3195	ARARIPINA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601102	1058	0	\N	31
3196	ARCOVERDE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601201	1058	0	\N	31
3197	BARRA DE GUABIRABA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601300	1058	0	\N	31
3198	BARREIROS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601409	1058	0	\N	31
3199	BELEM DE MARIA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601508	1058	0	\N	31
3200	BELEM DO SAO FRANCISCO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601607	1058	0	\N	31
3201	BELO JARDIM	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601706	1058	0	\N	31
3202	BETANIA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601805	1058	0	\N	31
3203	BEZERROS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2601904	1058	0	\N	31
3204	BODOCO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602001	1058	0	\N	31
3205	BOM CONSELHO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602100	1058	0	\N	31
3206	BOM JARDIM	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602209	1058	0	\N	31
3207	BONITO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602308	1058	0	\N	31
3208	BREJAO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602407	1058	0	\N	31
3209	BREJINHO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602506	1058	0	\N	31
3210	BREJO DA MADRE DE DEUS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602605	1058	0	\N	31
3211	BUENOS AIRES	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602704	1058	0	\N	31
3212	BUIQUE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602803	1058	0	\N	31
3213	CABO DE SANTO AGOSTINHO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2602902	1058	0	\N	31
3214	CABROBO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603009	1058	0	\N	31
3215	CACHOEIRINHA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603108	1058	0	\N	31
3216	CAETES	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603207	1058	0	\N	31
3217	CALCADO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603306	1058	0	\N	31
3218	CALUMBI	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603405	1058	0	\N	31
3219	CAMARAGIBE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603454	1058	0	\N	31
3220	CAMOCIM DE SAO FELIX	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603504	1058	0	\N	31
3221	CAMUTANGA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603603	1058	0	\N	31
3222	CANHOTINHO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603702	1058	0	\N	31
3223	CAPOEIRAS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603801	1058	0	\N	31
3224	CARNAIBA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603900	1058	0	\N	31
3225	CARNAUBEIRAS DA PENHA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2603926	1058	0	\N	31
3226	CARPINA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604007	1058	0	\N	31
3227	CARUARU	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604106	1058	0	\N	31
3228	CASINHAS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604155	1058	0	\N	31
3229	CATENDE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604205	1058	0	\N	31
3230	CEDRO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604304	1058	0	\N	31
3231	CHA DE ALEGRIA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604403	1058	0	\N	31
3232	CHA GRANDE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604502	1058	0	\N	31
3233	CONDADO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604601	1058	0	\N	31
3234	CORRENTES	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604700	1058	0	\N	31
3235	CORTES	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604809	1058	0	\N	31
3236	CUMARU	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2604908	1058	0	\N	31
3237	CUPIRA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605004	1058	0	\N	31
3238	CUSTODIA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605103	1058	0	\N	31
3239	DORMENTES	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605152	1058	0	\N	31
3240	ESCADA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605202	1058	0	\N	31
3242	FEIRA NOVA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605400	1058	0	\N	31
3243	FERNANDO DE NORONHA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605459	1058	0	\N	31
3244	FERREIROS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605509	1058	0	\N	31
3245	FLORES	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605608	1058	0	\N	31
3246	FLORESTA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605707	1058	0	\N	31
3247	FREI MIGUELINHO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605806	1058	0	\N	31
3248	GAMELEIRA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2605905	1058	0	\N	31
3249	GARANHUNS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606002	1058	0	\N	31
3250	GLORIA DO GOITA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606101	1058	0	\N	31
3251	GOIANA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606200	1058	0	\N	31
3252	GRANITO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606309	1058	0	\N	31
3253	GRAVATA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606408	1058	0	\N	31
3254	IATI	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606507	1058	0	\N	31
3255	IBIMIRIM	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606606	1058	0	\N	31
3256	IBIRAJUBA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606705	1058	0	\N	31
3257	IGARASSU	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606804	1058	0	\N	31
3258	IGUARACI	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2606903	1058	0	\N	31
3259	ILHA DE ITAMARACA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607604	1058	0	\N	31
3260	INAJA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607000	1058	0	\N	31
3261	INGAZEIRA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607109	1058	0	\N	31
3262	IPOJUCA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607208	1058	0	\N	31
3263	IPUBI	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607307	1058	0	\N	31
3264	ITACURUBA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607406	1058	0	\N	31
3265	ITAIBA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607505	1058	0	\N	31
3266	ITAMBE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607653	1058	0	\N	31
3267	ITAPETIM	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607703	1058	0	\N	31
3268	ITAPISSUMA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607752	1058	0	\N	31
3269	ITAQUITINGA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607802	1058	0	\N	31
3270	JABOATAO DOS GUARARAPES	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607901	1058	0	\N	31
3271	JAQUEIRA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2607950	1058	0	\N	31
3272	JATAUBA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608008	1058	0	\N	31
3273	JATOBA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608057	1058	0	\N	31
3274	JOAO ALFREDO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608107	1058	0	\N	31
3275	JOAQUIM NABUCO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608206	1058	0	\N	31
3276	JUCATI	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608255	1058	0	\N	31
3277	JUPI	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608305	1058	0	\N	31
3278	JUREMA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608404	1058	0	\N	31
3279	LAGOA DO CARRO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608453	1058	0	\N	31
3280	LAGOA DO ITAENGA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608503	1058	0	\N	31
3281	LAGOA DO OURO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608602	1058	0	\N	31
3282	LAGOA DOS GATOS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608701	1058	0	\N	31
3283	LAGOA GRANDE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608750	1058	0	\N	31
3284	LAJEDO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608800	1058	0	\N	31
3285	LIMOEIRO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2608909	1058	0	\N	31
3286	MACAPARANA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609006	1058	0	\N	31
3287	MACHADOS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609105	1058	0	\N	31
3288	MANARI	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609154	1058	0	\N	31
3289	MARAIAL	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609204	1058	0	\N	31
3290	MIRANDIBA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609303	1058	0	\N	31
3291	MOREILANDIA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614303	1058	0	\N	31
3292	MORENO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609402	1058	0	\N	31
3293	NAZARE DA MATA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609501	1058	0	\N	31
3294	OLINDA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609600	1058	0	\N	31
3295	OROBO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609709	1058	0	\N	31
3296	OROCO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609808	1058	0	\N	31
3297	OURICURI	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2609907	1058	0	\N	31
3298	PALMARES	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610004	1058	0	\N	31
3299	PALMEIRINA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610103	1058	0	\N	31
3300	PANELAS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610202	1058	0	\N	31
3301	PARANATAMA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610301	1058	0	\N	31
3302	PARNAMIRIM	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610400	1058	0	\N	31
3303	PASSIRA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610509	1058	0	\N	31
3304	PAUDALHO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610608	1058	0	\N	31
3305	PAULISTA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610707	1058	0	\N	31
3306	PEDRA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610806	1058	0	\N	31
3307	PESQUEIRA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2610905	1058	0	\N	31
3308	PETROLANDIA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611002	1058	0	\N	31
3309	PETROLINA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611101	1058	0	\N	31
3310	POCAO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611200	1058	0	\N	31
3311	POMBOS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611309	1058	0	\N	31
3312	PRIMAVERA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611408	1058	0	\N	31
3313	QUIPAPA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611507	1058	0	\N	31
3314	QUIXABA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611533	1058	0	\N	31
3315	RECIFE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611606	1058	0	\N	31
3316	RIACHO DAS ALMAS	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611705	1058	0	\N	31
3317	RIBEIRAO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611804	1058	0	\N	31
3318	RIO FORMOSO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2611903	1058	0	\N	31
3319	SAIRE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612000	1058	0	\N	31
3320	SALGADINHO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612109	1058	0	\N	31
3321	SALGUEIRO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612208	1058	0	\N	31
3322	SALOA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612307	1058	0	\N	31
3323	SANHARO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612406	1058	0	\N	31
3324	SANTA CRUZ	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612455	1058	0	\N	31
3325	SANTA CRUZ DA BAIXA VERDE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612471	1058	0	\N	31
3326	SANTA CRUZ DO CAPIBARIBE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612505	1058	0	\N	31
3327	SANTA FILOMENA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612554	1058	0	\N	31
3328	SANTA MARIA DA BOA VISTA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612604	1058	0	\N	31
3329	SANTA MARIA DO CAMBUCA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612703	1058	0	\N	31
3330	SANTA TEREZINHA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612802	1058	0	\N	31
3331	SAO BENEDITO DO SUL	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2612901	1058	0	\N	31
3332	SAO BENTO DO UNA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613008	1058	0	\N	31
3333	SAO CAITANO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613107	1058	0	\N	31
3334	SAO JOAO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613206	1058	0	\N	31
3335	SAO JOAQUIM DO MONTE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613305	1058	0	\N	31
3336	SAO JOSE DA COROA GRANDE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613404	1058	0	\N	31
3337	SAO JOSE DO BELMONTE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613503	1058	0	\N	31
3338	SAO JOSE DO EGITO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613602	1058	0	\N	31
3339	SAO LOURENCO DA MATA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613701	1058	0	\N	31
3340	SAO VICENTE FERRER	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613800	1058	0	\N	31
3341	SERRA TALHADA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2613909	1058	0	\N	31
3342	SERRITA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614006	1058	0	\N	31
3343	SERTANIA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614105	1058	0	\N	31
3344	SIRINHAEM	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614204	1058	0	\N	31
3345	SOLIDAO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614402	1058	0	\N	31
3346	SURUBIM	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614501	1058	0	\N	31
3347	TABIRA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614600	1058	0	\N	31
3348	TACAIMBO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614709	1058	0	\N	31
3349	TACARATU	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614808	1058	0	\N	31
3350	TAMANDARE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2614857	1058	0	\N	31
3351	TAQUARITINGA DO NORTE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615003	1058	0	\N	31
3352	TEREZINHA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615102	1058	0	\N	31
3353	TERRA NOVA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615201	1058	0	\N	31
3354	TIMBAUBA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615300	1058	0	\N	31
3355	TORITAMA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615409	1058	0	\N	31
3356	TRACUNHAEM	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615508	1058	0	\N	31
3357	TRINDADE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615607	1058	0	\N	31
3358	TRIUNFO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615706	1058	0	\N	31
3359	TUPANATINGA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615805	1058	0	\N	31
3360	TUPARETAMA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2615904	1058	0	\N	31
3361	VENTUROSA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2616001	1058	0	\N	31
3362	VERDEJANTE	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2616100	1058	0	\N	31
3363	VERTENTE DO LERIO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2616183	1058	0	\N	31
3364	VERTENTES	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2616209	1058	0	\N	31
3365	VICENCIA	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2616308	1058	0	\N	31
3366	VITORIA DE SANTO ANTAO	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2616407	1058	0	\N	31
3367	XEXEU	PE			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2616506	1058	0	\N	31
3368	ACAUA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200053	1058	0	\N	31
3369	AGRICOLANDIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200103	1058	0	\N	31
3370	AGUA BRANCA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200202	1058	0	\N	31
3371	ALAGOINHA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200251	1058	0	\N	31
3372	ALEGRETE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200277	1058	0	\N	31
3373	ALTO LONGA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200301	1058	0	\N	31
3374	ALTOS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200400	1058	0	\N	31
3375	ALVORADA DO GURGUEIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200459	1058	0	\N	31
3376	AMARANTE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200509	1058	0	\N	31
3377	ANGICAL DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200608	1058	0	\N	31
3378	ANISIO DE ABREU	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200707	1058	0	\N	31
3379	ANTONIO ALMEIDA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200806	1058	0	\N	31
3380	AROAZES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200905	1058	0	\N	31
3381	AROEIRAS DO ITAIM	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2200954	1058	0	\N	31
3382	ARRAIAL	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201002	1058	0	\N	31
3383	ASSUNCAO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201051	1058	0	\N	31
3384	AVELINO LOPES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201101	1058	0	\N	31
3385	BAIXA GRANDE DO RIBEIRO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201150	1058	0	\N	31
3386	BARRA D ALCANTARA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201176	1058	0	\N	31
3387	BARRAS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201200	1058	0	\N	31
3388	BARREIRAS DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201309	1058	0	\N	31
3389	BARRO DURO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201408	1058	0	\N	31
3390	BATALHA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201507	1058	0	\N	31
3391	BELA VISTA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201556	1058	0	\N	31
3392	BELEM DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201572	1058	0	\N	31
3393	BENEDITINOS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201606	1058	0	\N	31
3394	BERTOLINIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201705	1058	0	\N	31
3395	BETANIA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201739	1058	0	\N	31
3396	BOA HORA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201770	1058	0	\N	31
3397	BOCAINA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201804	1058	0	\N	31
3398	BOM JESUS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201903	1058	0	\N	31
3399	BOM PRINCIPIO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201919	1058	0	\N	31
3400	BONFIM DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201929	1058	0	\N	31
3401	BOQUEIRAO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201945	1058	0	\N	31
3402	BRASILEIRA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201960	1058	0	\N	31
3403	BREJO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2201988	1058	0	\N	31
3404	BURITI DOS LOPES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202000	1058	0	\N	31
3405	BURITI DOS MONTES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202026	1058	0	\N	31
3406	CABECEIRAS DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202059	1058	0	\N	31
3407	CAJAZEIRAS DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202075	1058	0	\N	31
3408	CAJUEIRO DA PRAIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202083	1058	0	\N	31
3409	CALDEIRAO GRANDE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202091	1058	0	\N	31
3410	CAMPINAS DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202109	1058	0	\N	31
3411	CAMPO ALEGRE DO FIDALGO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202117	1058	0	\N	31
3412	CAMPO GRANDE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202133	1058	0	\N	31
3413	CAMPO LARGO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202174	1058	0	\N	31
3414	CAMPO MAIOR	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202208	1058	0	\N	31
3415	CANAVIEIRA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202251	1058	0	\N	31
3416	CANTO DO BURITI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202307	1058	0	\N	31
3417	CAPITAO DE CAMPOS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202406	1058	0	\N	31
3418	CAPITAO GERVASIO OLIVEIRA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202455	1058	0	\N	31
3419	CARACOL	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202505	1058	0	\N	31
3420	CARAUBAS DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202539	1058	0	\N	31
3421	CARIDADE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202554	1058	0	\N	31
3422	CASTELO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202604	1058	0	\N	31
3423	CAXINGO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202653	1058	0	\N	31
3424	COCAL	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202703	1058	0	\N	31
3425	COCAL DE TELHA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202711	1058	0	\N	31
3426	COCAL DO ALVES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202729	1058	0	\N	31
3427	COIVARAS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202737	1058	0	\N	31
3428	COLONIA DO GURGUEIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202752	1058	0	\N	31
3429	COLONIA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202778	1058	0	\N	31
3430	CONCEICAO DO CANINDE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202802	1058	0	\N	31
3431	CORONEL JOSE DIAS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202851	1058	0	\N	31
3432	CORRENTE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2202901	1058	0	\N	31
3433	CRISTALANDIA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203008	1058	0	\N	31
3434	CRISTINO CASTRO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203107	1058	0	\N	31
3435	CURIMATA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203206	1058	0	\N	31
3436	CURRAIS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203230	1058	0	\N	31
3437	CURRALINHOS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203255	1058	0	\N	31
3438	CURRAL NOVO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203271	1058	0	\N	31
3439	DEMERVAL LOBAO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203305	1058	0	\N	31
3440	DIRCEU ARCOVERDE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203354	1058	0	\N	31
3441	DOM EXPEDITO LOPES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203404	1058	0	\N	31
3442	DOMINGOS MOURAO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203420	1058	0	\N	31
3443	DOM INOCENCIO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203453	1058	0	\N	31
3444	ELESBAO VELOSO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203503	1058	0	\N	31
3445	ELISEU MARTINS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203602	1058	0	\N	31
3446	ESPERANTINA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203701	1058	0	\N	31
3447	FARTURA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203750	1058	0	\N	31
3448	FLORES DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203800	1058	0	\N	31
3449	FLORESTA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203859	1058	0	\N	31
3450	FLORIANO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2203909	1058	0	\N	31
3451	FRANCINOPOLIS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204006	1058	0	\N	31
3452	FRANCISCO AYRES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204105	1058	0	\N	31
3453	FRANCISCO MACEDO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204154	1058	0	\N	31
3454	FRANCISCO SANTOS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204204	1058	0	\N	31
3455	FRONTEIRAS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204303	1058	0	\N	31
3456	GEMINIANO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204352	1058	0	\N	31
3457	GILBUES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204402	1058	0	\N	31
3458	GUADALUPE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204501	1058	0	\N	31
3459	GUARIBAS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204550	1058	0	\N	31
3460	HUGO NAPOLEAO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204600	1058	0	\N	31
3461	ILHA GRANDE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204659	1058	0	\N	31
3462	INHUMA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204709	1058	0	\N	31
3463	IPIRANGA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204808	1058	0	\N	31
3464	ISAIAS COELHO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2204907	1058	0	\N	31
3465	ITAINOPOLIS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205003	1058	0	\N	31
3466	ITAUEIRA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205102	1058	0	\N	31
3467	JACOBINA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205151	1058	0	\N	31
3468	JAICOS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205201	1058	0	\N	31
3469	JARDIM DO MULATO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205250	1058	0	\N	31
3470	JATOBA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205276	1058	0	\N	31
3471	JERUMENHA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205300	1058	0	\N	31
3472	JOAO COSTA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205359	1058	0	\N	31
3473	JOAQUIM PIRES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205409	1058	0	\N	31
3474	JOCA MARQUES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205458	1058	0	\N	31
3475	JOSE DE FREITAS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205508	1058	0	\N	31
3476	JUAZEIRO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205516	1058	0	\N	31
3477	JULIO BORGES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205524	1058	0	\N	31
3478	JUREMA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205532	1058	0	\N	31
3479	LAGOA ALEGRE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205557	1058	0	\N	31
3480	LAGOA DE SAO FRANCISCO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205573	1058	0	\N	31
3481	LAGOA DO BARRO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205565	1058	0	\N	31
3482	LAGOA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205581	1058	0	\N	31
3483	LAGOA DO SITIO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205599	1058	0	\N	31
3484	LAGOINHA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205540	1058	0	\N	31
3485	LANDRI SALES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205607	1058	0	\N	31
3486	LUIS CORREIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205706	1058	0	\N	31
3487	LUZILANDIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205805	1058	0	\N	31
3488	MADEIRO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205854	1058	0	\N	31
3489	MANOEL EMIDIO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205904	1058	0	\N	31
3490	MARCOLANDIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2205953	1058	0	\N	31
3491	MARCOS PARENTE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206001	1058	0	\N	31
3492	MASSAPE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206050	1058	0	\N	31
3493	MATIAS OLIMPIO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206100	1058	0	\N	31
3494	MIGUEL ALVES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206209	1058	0	\N	31
3495	MIGUEL LEAO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206308	1058	0	\N	31
3496	MILTON BRANDAO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206357	1058	0	\N	31
3497	MONSENHOR GIL	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206407	1058	0	\N	31
3498	MONSENHOR HIPOLITO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206506	1058	0	\N	31
3499	MONTE ALEGRE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206605	1058	0	\N	31
3500	MORRO CABECA NO TEMPO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206654	1058	0	\N	31
3501	MORRO DO CHAPEU DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206670	1058	0	\N	31
3502	MURICI DOS PORTELAS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206696	1058	0	\N	31
3503	NAZARE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206704	1058	0	\N	31
3504	NOSSA SENHORA DE NAZARE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206753	1058	0	\N	31
3505	NOSSA SENHORA DOS REMEDIOS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206803	1058	0	\N	31
3506	NOVA SANTA RITA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207959	1058	0	\N	31
3507	NOVO ORIENTE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206902	1058	0	\N	31
3508	NOVO SANTO ANTONIO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2206951	1058	0	\N	31
3509	OEIRAS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207009	1058	0	\N	31
3510	OLHO D AGUA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207108	1058	0	\N	31
3511	PADRE MARCOS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207207	1058	0	\N	31
3512	PAES LANDIM	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207306	1058	0	\N	31
3513	PAJEU DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207355	1058	0	\N	31
3514	PALMEIRA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207405	1058	0	\N	31
3515	PALMEIRAIS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207504	1058	0	\N	31
3516	PAQUETA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207553	1058	0	\N	31
3517	PARNAGUA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207603	1058	0	\N	31
3518	PARNAIBA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207702	1058	0	\N	31
3519	PASSAGEM FRANCA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207751	1058	0	\N	31
3520	PATOS DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207777	1058	0	\N	31
3521	PAU  D ARCO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207793	1058	0	\N	31
3522	PAULISTANA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207801	1058	0	\N	31
3523	PAVUSSU	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207850	1058	0	\N	31
3524	PEDRO II	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207900	1058	0	\N	31
3525	PEDRO LAURENTINO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2207934	1058	0	\N	31
3526	PICOS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208007	1058	0	\N	31
3527	PIMENTEIRAS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208106	1058	0	\N	31
3528	PIO IX	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208205	1058	0	\N	31
3529	PIRACURUCA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208304	1058	0	\N	31
3530	PIRIPIRI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208403	1058	0	\N	31
3531	PORTO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208502	1058	0	\N	31
3532	PORTO ALEGRE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208551	1058	0	\N	31
3533	PRATA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208601	1058	0	\N	31
3534	QUEIMADA NOVA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208650	1058	0	\N	31
3535	REDENCAO DO GURGUEIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208700	1058	0	\N	31
3536	REGENERACAO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208809	1058	0	\N	31
3537	RIACHO FRIO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208858	1058	0	\N	31
3538	RIBEIRA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208874	1058	0	\N	31
3539	RIBEIRO GONCALVES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2208908	1058	0	\N	31
3540	RIO GRANDE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209005	1058	0	\N	31
3541	SANTA CRUZ DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209104	1058	0	\N	31
3542	SANTA CRUZ DOS MILAGRES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209153	1058	0	\N	31
3543	SANTA FILOMENA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209203	1058	0	\N	31
3544	SANTA LUZ	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209302	1058	0	\N	31
3545	SANTANA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209351	1058	0	\N	31
3546	SANTA ROSA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209377	1058	0	\N	31
3547	SANTO ANTONIO DE LISBOA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209401	1058	0	\N	31
3548	SANTO ANTONIO DOS MILAGRES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209450	1058	0	\N	31
3549	SANTO INACIO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209500	1058	0	\N	31
3550	SAO BRAZ DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209559	1058	0	\N	31
3551	SAO FELIX DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209609	1058	0	\N	31
3552	SAO FRANCISCO DE ASSIS DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209658	1058	0	\N	31
3553	SAO FRANCISCO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209708	1058	0	\N	31
3554	SAO GONCALO DO GURGUEIA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209757	1058	0	\N	31
3555	SAO GONCALO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209807	1058	0	\N	31
3556	SAO JOAO DA CANABRAVA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209856	1058	0	\N	31
3557	SAO JOAO DA FRONTEIRA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209872	1058	0	\N	31
3558	SAO JOAO DA SERRA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209906	1058	0	\N	31
3559	SAO JOAO DA VARJOTA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209955	1058	0	\N	31
3560	SAO JOAO DO ARRAIAL	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2209971	1058	0	\N	31
3561	SAO JOAO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210003	1058	0	\N	31
3562	SAO JOSE DO DIVINO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210052	1058	0	\N	31
3563	SAO JOSE DO PEIXE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210102	1058	0	\N	31
3564	SAO JOSE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210201	1058	0	\N	31
3565	SAO JULIAO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210300	1058	0	\N	31
3566	SAO LOURENCO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210359	1058	0	\N	31
3567	SAO LUIS DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210375	1058	0	\N	31
3568	SAO MIGUEL DA BAIXA GRANDE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210383	1058	0	\N	31
3569	SAO MIGUEL DO FIDALGO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210391	1058	0	\N	31
3570	SAO MIGUEL DO TAPUIO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210409	1058	0	\N	31
3571	SAO PEDRO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210508	1058	0	\N	31
3572	SAO RAIMUNDO NONATO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210607	1058	0	\N	31
3573	SEBASTIAO BARROS	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210623	1058	0	\N	31
3574	SEBASTIAO LEAL	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210631	1058	0	\N	31
3575	SIGEFREDO PACHECO	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210656	1058	0	\N	31
3576	SIMOES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210706	1058	0	\N	31
3577	SIMPLICIO MENDES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210805	1058	0	\N	31
3578	SOCORRO DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210904	1058	0	\N	31
3579	SUSSUAPARA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210938	1058	0	\N	31
3580	TAMBORIL DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210953	1058	0	\N	31
3581	TANQUE DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2210979	1058	0	\N	31
3582	TERESINA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2211001	1058	0	\N	31
3583	UNIAA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2211100	1058	0	\N	31
3584	URUCUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2211209	1058	0	\N	31
3585	VALENCA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2211308	1058	0	\N	31
3586	VARZEA BRANCA	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2211357	1058	0	\N	31
3587	VARZEA GRANDE	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2211407	1058	0	\N	31
3588	VERA MENDES	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2211506	1058	0	\N	31
3589	VILA NOVA DO PIAUI	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2211605	1058	0	\N	31
3590	WALL FERRAZ	PI			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2211704	1058	0	\N	31
3591	ANGRA DOS REIS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300100	1058	0	\N	31
3592	APERIBE	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300159	1058	0	\N	31
3593	ARARUAMA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300209	1058	0	\N	31
3594	AREAL	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300225	1058	0	\N	31
3595	ARMACAO DOS BUZIOS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300233	1058	0	\N	31
3596	ARRAIAL DO CABO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300258	1058	0	\N	31
3597	BARRA DO PIRAI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300308	1058	0	\N	31
3598	BARRA MANSA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300407	1058	0	\N	31
3599	BELFORD ROXO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300456	1058	0	\N	31
3600	BOM JARDIM	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300506	1058	0	\N	31
3601	BOM JESUS DO ITABAPOANA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300605	1058	0	\N	31
3602	CABO FRIO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300704	1058	0	\N	31
3603	CACHOEIRAS DE MACACU	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300803	1058	0	\N	31
3604	CAMBUCI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300902	1058	0	\N	31
3605	CARAPEBUS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300936	1058	0	\N	31
3606	CAMPOS DOS GOYTACAZES	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301009	1058	0	\N	31
3607	COMENDADOR LEVY GASPARIAN	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3300951	1058	0	\N	31
3608	CANTAGALO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301108	1058	0	\N	31
3609	CARDOSO MOREIRA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301157	1058	0	\N	31
3610	CARMO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301207	1058	0	\N	31
3611	CASIMIRO DE ABREU	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301306	1058	0	\N	31
3612	CONCEICAO DE MACABU	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301405	1058	0	\N	31
3613	CORDEIRO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301504	1058	0	\N	31
3614	DUAS BARRAS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301603	1058	0	\N	31
3615	DUQUE DE CAXIAS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301702	1058	0	\N	31
3616	ENGENHEIRO PAULO DE FRONTIN	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301801	1058	0	\N	31
3617	GUAPIMIRIM	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301850	1058	0	\N	31
3618	IGUABA GRANDE	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301876	1058	0	\N	31
3619	ITABORAI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3301900	1058	0	\N	31
3620	ITAGUAI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302007	1058	0	\N	31
3621	ITALVA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302056	1058	0	\N	31
3622	ITAOCARA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302106	1058	0	\N	31
3623	ITAPERUNA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302205	1058	0	\N	31
3624	ITATIAIA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302254	1058	0	\N	31
3625	JAPERI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302270	1058	0	\N	31
3626	LAJE DO MURIAE	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302304	1058	0	\N	31
3627	MACAE	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302403	1058	0	\N	31
3628	MACUCO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302452	1058	0	\N	31
3629	MAGE	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302502	1058	0	\N	31
3630	MANGARATIBA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302601	1058	0	\N	31
3631	MARICA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302700	1058	0	\N	31
3632	MENDES	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302809	1058	0	\N	31
3633	MESQUITA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302858	1058	0	\N	31
3634	MIGUEL PEREIRA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3302908	1058	0	\N	31
3635	MIRACEMA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303005	1058	0	\N	31
3636	NATIVIDADE	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303104	1058	0	\N	31
3637	NILOPOLIS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303203	1058	0	\N	31
3638	NITEROI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303302	1058	0	\N	31
3639	NOVA FRIBURGO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303401	1058	0	\N	31
3640	NOVA IGUACU	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303500	1058	0	\N	31
3641	PARACAMBI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303609	1058	0	\N	31
3642	PARAIBA DO SUL	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303708	1058	0	\N	31
3643	PARATI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303807	1058	0	\N	31
3644	PATY DO ALFERES	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303856	1058	0	\N	31
3645	PETROPOLIS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303906	1058	0	\N	31
3646	PINHEIRAL	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3303955	1058	0	\N	31
3647	PIRAI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304003	1058	0	\N	31
3648	PORCIUNCULA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304102	1058	0	\N	31
3649	PORTO REAL	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304110	1058	0	\N	31
3650	QUATIS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304128	1058	0	\N	31
3651	QUEIMADOS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304144	1058	0	\N	31
3652	QUISSAMA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304151	1058	0	\N	31
3653	RESENDE	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304201	1058	0	\N	31
3654	RIO BONITO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304300	1058	0	\N	31
3655	RIO CLARO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304409	1058	0	\N	31
3656	RIO DAS FLORES	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304508	1058	0	\N	31
3657	RIO DAS OSTRAS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304524	1058	0	\N	31
3658	RIO DE JANEIRO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304557	1058	0	\N	31
3659	SANTA MARIA MADALENA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304607	1058	0	\N	31
3660	SANTO ANTONIO DE PADUA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304706	1058	0	\N	31
3661	SAO FRANCISCO DE ITABAPOANA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304755	1058	0	\N	31
3662	SAO FIDELIS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304805	1058	0	\N	31
3663	SAO GONCALO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3304904	1058	0	\N	31
3664	SAO JOAO DA BARRA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305000	1058	0	\N	31
3665	SAO JOAO DE MERITI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305109	1058	0	\N	31
3666	SAO JOSE DE UBA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305133	1058	0	\N	31
3667	SAO JOSE DO VALE DO RIO PRETO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305158	1058	0	\N	31
3668	SAO PEDRO DA ALDEIA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305208	1058	0	\N	31
3669	SAO SEBASTIAO DO ALTO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305307	1058	0	\N	31
3671	SAQUAREMA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305505	1058	0	\N	31
3672	SEROPEDICA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305554	1058	0	\N	31
3673	SILVA JARDIM	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305604	1058	0	\N	31
3674	SUMIDOURO	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305703	1058	0	\N	31
3675	TANGUA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305752	1058	0	\N	31
3676	TERESOPOLIS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305802	1058	0	\N	31
3677	TRAJANO DE MORAIS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3305901	1058	0	\N	31
3678	TRES RIOS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3306008	1058	0	\N	31
3679	VALENCA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3306107	1058	0	\N	31
3680	VARRESAI	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3306156	1058	0	\N	31
3681	VASSOURAS	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3306206	1058	0	\N	31
3682	VOLTA REDONDA	RJ			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3306305	1058	0	\N	31
3683	ACARI	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2400109	1058	0	\N	31
3684	ACU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2400208	1058	0	\N	31
3685	AFONSO BEZERRA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2400307	1058	0	\N	31
3686	AGUA NOVA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2400406	1058	0	\N	31
3687	ALEXANDRIA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2400505	1058	0	\N	31
3688	ALMINO AFONSO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2400604	1058	0	\N	31
3689	ALTO DO RODRIGUES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2400703	1058	0	\N	31
3690	ANGICOS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2400802	1058	0	\N	31
3691	ANTONIO MARTINS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2400901	1058	0	\N	31
3692	APODI	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401008	1058	0	\N	31
3693	AREIA BRANCA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401107	1058	0	\N	31
3694	ARES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401206	1058	0	\N	31
3695	AUGUSTO SEVERO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401305	1058	0	\N	31
3696	BAIA FORMOSA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401404	1058	0	\N	31
3697	BARAUNA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401453	1058	0	\N	31
3698	BARCELONA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401503	1058	0	\N	31
3699	BENTO FERNANDES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401602	1058	0	\N	31
3700	BODO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401651	1058	0	\N	31
3701	BOM JESUS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401701	1058	0	\N	31
3702	BREJINHO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401800	1058	0	\N	31
3703	CAICARA DO NORTE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401859	1058	0	\N	31
3704	CAICARA DO RIO DO VENTO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2401909	1058	0	\N	31
3705	CAICO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402006	1058	0	\N	31
3706	CAMPO REDONDO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402105	1058	0	\N	31
3707	CANGUARETAMA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402204	1058	0	\N	31
3708	CARAUBAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402303	1058	0	\N	31
3709	CARNAUBA DOS DANTAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402402	1058	0	\N	31
3710	CARNAUBAIS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402501	1058	0	\N	31
3711	CEARA MIRIM	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402600	1058	0	\N	31
3712	CERRO CORA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402709	1058	0	\N	31
3713	CORONEL EZEQUIEL	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402808	1058	0	\N	31
3714	CORONEL JOAO PESSOA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2402907	1058	0	\N	31
3715	CRUZETA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403004	1058	0	\N	31
3716	CURRAIS NOVOS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403103	1058	0	\N	31
3717	DOUTOR SEVERIANO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403202	1058	0	\N	31
3718	ENCANTO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403301	1058	0	\N	31
3719	EQUADOR	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403400	1058	0	\N	31
3720	ESPIRITO SANTO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403509	1058	0	\N	31
3721	EXTREMOZ	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403608	1058	0	\N	31
3722	FELIPE GUERRA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403707	1058	0	\N	31
3723	FERNANDO PEDROZA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403756	1058	0	\N	31
3724	FLORANIA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403806	1058	0	\N	31
3725	FRANCISCO DANTAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403905	1058	0	\N	31
3726	FRUTUOSO GOMES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404002	1058	0	\N	31
3727	GALINHOS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404101	1058	0	\N	31
3728	GOIANINHA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404200	1058	0	\N	31
3729	GOVERNADOR DIX SEPT ROSADO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404309	1058	0	\N	31
3730	GROSSOS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404408	1058	0	\N	31
3731	GUAMARE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404507	1058	0	\N	31
3732	IELMO MARINHO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404606	1058	0	\N	31
3733	IPANGUACU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404705	1058	0	\N	31
3734	IPUEIRA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404804	1058	0	\N	31
3735	ITAJA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404853	1058	0	\N	31
3736	ITAU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2404903	1058	0	\N	31
3737	JACANA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405009	1058	0	\N	31
3738	JANDAIRA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405108	1058	0	\N	31
3739	JANDUIS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405207	1058	0	\N	31
3740	JANUARIO CICCO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405306	1058	0	\N	31
3741	JAPI	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405405	1058	0	\N	31
3742	JARDIM DE ANGICOS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405504	1058	0	\N	31
3743	JARDIM DE PIRANHAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405603	1058	0	\N	31
3744	JARDIM DO SERIDO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405702	1058	0	\N	31
3745	JOAO CAMARA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405801	1058	0	\N	31
3746	JOAO DIAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2405900	1058	0	\N	31
3747	JOSE DA PENHA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406007	1058	0	\N	31
3748	JUCURUTU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406106	1058	0	\N	31
3749	JUNDIA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406155	1058	0	\N	31
3750	LAGOA D ANTA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406205	1058	0	\N	31
3751	LAGOA DE PEDRAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406304	1058	0	\N	31
3752	LAGOA DE VELHOS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406403	1058	0	\N	31
3753	LAGOA NOVA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406502	1058	0	\N	31
3754	LAGOA SALGADA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406601	1058	0	\N	31
3755	LAJES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406700	1058	0	\N	31
3756	LAJES PINTADAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406809	1058	0	\N	31
3757	LUCRECIA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2406908	1058	0	\N	31
3758	LUIS GOMES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407005	1058	0	\N	31
3759	MACAIBA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407104	1058	0	\N	31
3760	MACAU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407203	1058	0	\N	31
3761	MAJOR SALES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407252	1058	0	\N	31
3762	MARCELINO VIEIRA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407302	1058	0	\N	31
3763	MARTINS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407401	1058	0	\N	31
3764	MAXARANGUAPE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407500	1058	0	\N	31
3765	MESSIAS TARGINO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407609	1058	0	\N	31
3766	MONTANHAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407708	1058	0	\N	31
3767	MONTE ALEGRE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407807	1058	0	\N	31
3768	MONTE DAS GAMELEIRAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2407906	1058	0	\N	31
3769	MOSSORO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408003	1058	0	\N	31
3770	NATAL	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408102	1058	0	\N	31
3771	NISIA FLORESTA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408201	1058	0	\N	31
3772	NOVA CRUZ	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408300	1058	0	\N	31
3773	OLHO D AGUA DO BORGES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408409	1058	0	\N	31
3774	OURO BRANCO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408508	1058	0	\N	31
3775	PARANA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408607	1058	0	\N	31
3776	PARAU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408706	1058	0	\N	31
3777	PARAZINHO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408805	1058	0	\N	31
3778	PARELHAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408904	1058	0	\N	31
3779	RIO DO FOGO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2408953	1058	0	\N	31
3780	PASSA E FICA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409100	1058	0	\N	31
3781	PASSAGEM	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409209	1058	0	\N	31
3782	PATU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409308	1058	0	\N	31
3783	SANTA MARIA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409332	1058	0	\N	31
3784	PAU DOS FERROS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409407	1058	0	\N	31
3785	PARNAMIRIM	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2403251	1058	0	\N	31
3786	PEDRA GRANDE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409506	1058	0	\N	31
3787	PEDRA PRETA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409605	1058	0	\N	31
3788	PEDRO AVELINO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409704	1058	0	\N	31
3789	PEDRO VELHO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409803	1058	0	\N	31
3790	PENDENCIAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2409902	1058	0	\N	31
3791	PILOES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410009	1058	0	\N	31
3792	POCO BRANCO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410108	1058	0	\N	31
3793	PORTALEGRE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410207	1058	0	\N	31
3794	PORTO DO MANGUE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410256	1058	0	\N	31
3795	PRESIDENTE JUSCELINO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410306	1058	0	\N	31
3796	PUREZA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410405	1058	0	\N	31
3797	RAFAEL FERNANDES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410504	1058	0	\N	31
3798	RAFAEL GODEIRO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410603	1058	0	\N	31
3799	RIACHO DA CRUZ	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410702	1058	0	\N	31
3800	RIACHO DE SANTANA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410801	1058	0	\N	31
3801	RIACHUELO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2410900	1058	0	\N	31
3802	RODOLFO FERNANDES	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411007	1058	0	\N	31
3803	TIBAU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411056	1058	0	\N	31
3804	RUY BARBOSA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411106	1058	0	\N	31
3805	SANTA CRUZ	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411205	1058	0	\N	31
3806	SANTANA DO MATOS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411403	1058	0	\N	31
3807	SANTANA DO SERIDO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411429	1058	0	\N	31
3808	SANTO ANTONIO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411502	1058	0	\N	31
3809	SAO BENTO DO NORTE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411601	1058	0	\N	31
3810	SAO BENTO DO TRAIRI	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411700	1058	0	\N	31
3811	SAO FERNANDO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411809	1058	0	\N	31
3812	SAO FRANCISCO DO OESTE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2411908	1058	0	\N	31
3813	SAO GONCALO DO AMARANTE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412005	1058	0	\N	31
3814	SAO JOAO DO SABUGI	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412104	1058	0	\N	31
3815	SAO JOSE DE MIPIBU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412203	1058	0	\N	31
3816	SAO JOSE DO CAMPESTRE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412302	1058	0	\N	31
3817	SAO JOSE DO SERIDO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412401	1058	0	\N	31
3818	SAO MIGUEL	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412500	1058	0	\N	31
3819	SAO MIGUEL DO GOSTOSO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412559	1058	0	\N	31
3820	SAO PAULO DO POTENGI	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412609	1058	0	\N	31
3821	SAO PEDRO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412708	1058	0	\N	31
3822	SAO RAFAEL	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412807	1058	0	\N	31
3823	SAO TOME	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2412906	1058	0	\N	31
3824	SAO VICENTE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413003	1058	0	\N	31
3825	SENADOR ELOI DE SOUZA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413102	1058	0	\N	31
3826	SENADOR GEORGINO AVELINO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413201	1058	0	\N	31
3827	SERRA DE SAO BENTO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413300	1058	0	\N	31
3828	SERRA DO MEL	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413359	1058	0	\N	31
3829	SERRA NEGRA DO NORTE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413409	1058	0	\N	31
3830	SERRINHA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413508	1058	0	\N	31
3831	SERRINHA DOS PINTOS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413557	1058	0	\N	31
3832	SEVERIANO MELO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413607	1058	0	\N	31
3833	SITIO NOVO	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413706	1058	0	\N	31
3834	TABOLEIRO GRANDE	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413805	1058	0	\N	31
3835	TAIPU	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2413904	1058	0	\N	31
3836	TANGARA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414001	1058	0	\N	31
3837	TENENTE ANANIAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414100	1058	0	\N	31
3838	TENENTE LAURENTINO CRUZ	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414159	1058	0	\N	31
3839	TIBAU DO SUL	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414209	1058	0	\N	31
3840	TIMBAUBA DOS BATISTAS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414308	1058	0	\N	31
3841	TOUROS	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414407	1058	0	\N	31
3842	TRIUNFO POTIGUAR	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414456	1058	0	\N	31
3843	UMARIZAL	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414506	1058	0	\N	31
3844	UPANEMA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414605	1058	0	\N	31
3845	VARZEA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414704	1058	0	\N	31
3846	VENHA VER	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414753	1058	0	\N	31
3847	VERA CRUZ	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414803	1058	0	\N	31
3848	VICOSA	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2414902	1058	0	\N	31
3849	VILA FLOR	RN			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	2415008	1058	0	\N	31
3850	ACEGUA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300034	1058	0	\N	31
3851	AGUA SANTA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300059	1058	0	\N	31
3852	AGUDO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300109	1058	0	\N	31
3853	AJURICABA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300208	1058	0	\N	31
3854	ALECRIM	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300307	1058	0	\N	31
3855	ALEGRETE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300406	1058	0	\N	31
3856	ALEGRIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300455	1058	0	\N	31
3857	ALMIRANTE TAMANDARE DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300471	1058	0	\N	31
3858	ALPESTRE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300505	1058	0	\N	31
3859	ALTO ALEGRE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300554	1058	0	\N	31
3860	ALTO FELIZ	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300570	1058	0	\N	31
3861	ALVORADA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300604	1058	0	\N	31
3862	AMARAL FERRADOR	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300638	1058	0	\N	31
3863	AMETISTA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300646	1058	0	\N	31
3864	ANDRE DA ROCHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300661	1058	0	\N	31
3865	ANTA GORDA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300703	1058	0	\N	31
3866	ANTONIO PRADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300802	1058	0	\N	31
3867	ARAMBARE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300851	1058	0	\N	31
3868	ARARICA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300877	1058	0	\N	31
3869	ARATIBA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4300901	1058	0	\N	31
3870	ARROIO DO MEIO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301008	1058	0	\N	31
3871	ARROIO DO PADRE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301073	1058	0	\N	31
3872	ARROIO DO SAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301057	1058	0	\N	31
3873	ARROIO DOS RATOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301107	1058	0	\N	31
3874	ARROIO DO TIGRE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301206	1058	0	\N	31
3875	ARROIO GRANDE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301305	1058	0	\N	31
3876	ARVOREZINHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301404	1058	0	\N	31
3877	AUGUSTO PESTANA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301503	1058	0	\N	31
3878	AUREA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301552	1058	0	\N	31
3879	BAGE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301602	1058	0	\N	31
3880	BALNEARIO PINHAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301636	1058	0	\N	31
3881	BARAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301651	1058	0	\N	31
3882	BARAO DE COTEGIPE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301701	1058	0	\N	31
3883	BARAO DO TRIUNFO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301750	1058	0	\N	31
3884	BARRACAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301800	1058	0	\N	31
3885	BARRA DO GUARITA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301859	1058	0	\N	31
3886	BARRA DO QUARAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301875	1058	0	\N	31
3887	BARRA DO RIBEIRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301909	1058	0	\N	31
3888	BARRA DO RIO AZUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301925	1058	0	\N	31
3889	BARRA FUNDA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4301958	1058	0	\N	31
3890	BARROS CASSAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302006	1058	0	\N	31
3891	BENJAMIN CONSTANT DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302055	1058	0	\N	31
3892	BENTO GONCALVES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302105	1058	0	\N	31
3893	BOA VISTA DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302154	1058	0	\N	31
3894	BOA VISTA DO BURICA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302204	1058	0	\N	31
3895	BOA VISTA DO CADEADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302220	1058	0	\N	31
3896	BOA VISTA DO INCRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302238	1058	0	\N	31
3897	BOA VISTA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302253	1058	0	\N	31
3898	BOM JESUS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302303	1058	0	\N	31
3899	BOM PRINCIPIO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302352	1058	0	\N	31
3900	BOM PROGRESSO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302378	1058	0	\N	31
3901	BOM RETIRO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302402	1058	0	\N	31
3902	BOQUEIRAO DO LEAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302451	1058	0	\N	31
3903	BOSSOROCA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302501	1058	0	\N	31
3904	BOZANO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302584	1058	0	\N	31
3905	BRAGA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302600	1058	0	\N	31
3906	BROCHIER	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302659	1058	0	\N	31
3907	BUTIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302709	1058	0	\N	31
3908	CACAPAVA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302808	1058	0	\N	31
3909	CACEQUI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4302907	1058	0	\N	31
3910	CACHOEIRA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303004	1058	0	\N	31
3911	CACHOEIRINHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303103	1058	0	\N	31
3912	CACIQUE DOBLE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303202	1058	0	\N	31
3913	CAIBATE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303301	1058	0	\N	31
3914	CAICARA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303400	1058	0	\N	31
3915	CAMAQUA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303509	1058	0	\N	31
3916	CAMARGO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303558	1058	0	\N	31
3917	CAMBARA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303608	1058	0	\N	31
3918	CAMPESTRE DA SERRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303673	1058	0	\N	31
3919	CAMPINA DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303707	1058	0	\N	31
3920	CAMPINAS DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303806	1058	0	\N	31
3921	CAMPO BOM	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4303905	1058	0	\N	31
3922	CAMPO NOVO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304002	1058	0	\N	31
3923	CAMPOS BORGES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304101	1058	0	\N	31
3924	CANDELARIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304200	1058	0	\N	31
3925	CANDIDO GODOI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304309	1058	0	\N	31
3926	CANDIOTA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304358	1058	0	\N	31
3927	CANELA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304408	1058	0	\N	31
3928	CANGUCU	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304507	1058	0	\N	31
3929	CANOAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304606	1058	0	\N	31
3930	CANUDOS DO VALE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304614	1058	0	\N	31
3931	CAPAO BONITO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304622	1058	0	\N	31
3932	CAPAO DA CANOA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304630	1058	0	\N	31
3933	CAPAO DO CIPO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304655	1058	0	\N	31
3934	CAPAO DO LEAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304663	1058	0	\N	31
3935	CAPELA DE SANTANA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304689	1058	0	\N	31
3936	CAPITAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304697	1058	0	\N	31
3937	CAPIVARI DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304671	1058	0	\N	31
3938	CARAA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304713	1058	0	\N	31
3939	CARAZINHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304705	1058	0	\N	31
3940	CARLOS BARBOSA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304804	1058	0	\N	31
3941	CARLOS GOMES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304853	1058	0	\N	31
3942	CASCA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304903	1058	0	\N	31
3943	CASEIROS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4304952	1058	0	\N	31
3944	CATUIPE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305009	1058	0	\N	31
3945	CAXIAS DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305108	1058	0	\N	31
3946	CENTENARIO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305116	1058	0	\N	31
3947	CERRITO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305124	1058	0	\N	31
3948	CERRO BRANCO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305132	1058	0	\N	31
3949	CERRO GRANDE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305157	1058	0	\N	31
3950	CERRO GRANDE DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305173	1058	0	\N	31
3951	CERRO LARGO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305207	1058	0	\N	31
3952	CHAPADA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305306	1058	0	\N	31
3953	CHARQUEADAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305355	1058	0	\N	31
3954	CHARRUA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305371	1058	0	\N	31
3955	CHIAPETTA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305405	1058	0	\N	31
3956	CHUI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305439	1058	0	\N	31
3957	CHUVISCA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305447	1058	0	\N	31
3958	CIDREIRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305454	1058	0	\N	31
3959	CIRIACO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305504	1058	0	\N	31
3960	COLINAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305587	1058	0	\N	31
3961	COLORADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305603	1058	0	\N	31
3962	CONDOR	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305702	1058	0	\N	31
3963	CONSTANTINA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305801	1058	0	\N	31
3964	COQUEIRO BAIXO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305835	1058	0	\N	31
3965	COQUEIROS DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305850	1058	0	\N	31
3966	CORONEL BARROS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305871	1058	0	\N	31
3967	CORONEL BICACO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305900	1058	0	\N	31
3968	CORONEL PILAR	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305934	1058	0	\N	31
3969	COTIPORA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305959	1058	0	\N	31
3970	COXILHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4305975	1058	0	\N	31
3971	CRISSIUMAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306007	1058	0	\N	31
3972	CRISTAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306056	1058	0	\N	31
3973	CRISTAL DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306072	1058	0	\N	31
3974	CRUZALTENSE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306130	1058	0	\N	31
3975	CRUZ ALTA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306106	1058	0	\N	31
3976	CRUZEIRO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306205	1058	0	\N	31
3977	DAVID CANABARRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306304	1058	0	\N	31
3978	DERRUBADAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306320	1058	0	\N	31
3979	DEZESSEIS DE NOVEMBRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306353	1058	0	\N	31
3980	DILERMANDO DE AGUIAR	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306379	1058	0	\N	31
3981	DOIS IRMAOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306403	1058	0	\N	31
3982	DOIS IRMAOS DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306429	1058	0	\N	31
3983	DOIS LAJEADOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306452	1058	0	\N	31
3984	DOM FELICIANO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306502	1058	0	\N	31
3985	DOM PEDRO DE ALCANTARA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306551	1058	0	\N	31
3986	DOM PEDRITO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306601	1058	0	\N	31
3987	DONA FRANCISCA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306700	1058	0	\N	31
3988	DOUTOR MAURICIO CARDOSO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306734	1058	0	\N	31
3989	DOUTOR RICARDO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306759	1058	0	\N	31
3990	ELDORADO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306767	1058	0	\N	31
3991	ENCANTADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306809	1058	0	\N	31
3992	ENCRUZILHADA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306908	1058	0	\N	31
3993	ENGENHO VELHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306924	1058	0	\N	31
3994	ENTRE IJUIS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306932	1058	0	\N	31
3995	ENTRE RIOS DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306957	1058	0	\N	31
3996	EREBANGO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4306973	1058	0	\N	31
3997	ERECHIM	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307005	1058	0	\N	31
3998	ERNESTINA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307054	1058	0	\N	31
3999	ERVAL GRANDE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307203	1058	0	\N	31
4000	ERVAL SECO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307302	1058	0	\N	31
4001	ESMERALDA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307401	1058	0	\N	31
4002	ESPERANCA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307450	1058	0	\N	31
4003	ESPUMOSO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307500	1058	0	\N	31
4004	ESTACAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307559	1058	0	\N	31
4005	ESTANCIA VELHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307609	1058	0	\N	31
4006	ESTEIO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307708	1058	0	\N	31
4007	ESTRELA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307807	1058	0	\N	31
4008	ESTRELA VELHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307815	1058	0	\N	31
4009	EUGENIO DE CASTRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307831	1058	0	\N	31
4010	FAGUNDES VARELA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307864	1058	0	\N	31
4011	FARROUPILHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307906	1058	0	\N	31
4012	FAXINAL DO SOTURNO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308003	1058	0	\N	31
4013	FAXINALZINHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308052	1058	0	\N	31
4014	FAZENDA VILANOVA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308078	1058	0	\N	31
4015	FELIZ	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308102	1058	0	\N	31
4016	FLORES DA CUNHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308201	1058	0	\N	31
4017	FLORIANO PEIXOTO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308250	1058	0	\N	31
4018	FONTOURA XAVIER	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308300	1058	0	\N	31
4019	FORMIGUEIRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308409	1058	0	\N	31
4020	FORQUETINHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308433	1058	0	\N	31
4021	FORTALEZA DOS VALOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308458	1058	0	\N	31
4022	FREDERICO WESTPHALEN	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308508	1058	0	\N	31
4023	GARIBALDI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308607	1058	0	\N	31
4024	GARRUCHOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308656	1058	0	\N	31
4025	GAURAMA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308706	1058	0	\N	31
4026	GENERAL CAMARA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308805	1058	0	\N	31
4027	GENTIL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308854	1058	0	\N	31
4028	GETULIO VARGAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4308904	1058	0	\N	31
4029	GIRUA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309001	1058	0	\N	31
4030	GLORINHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309050	1058	0	\N	31
4031	GRAMADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309100	1058	0	\N	31
4032	GRAMADO DOS LOUREIROS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309126	1058	0	\N	31
4033	GRAMADO XAVIER	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309159	1058	0	\N	31
4034	GRAVATAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309209	1058	0	\N	31
4035	GUABIJU	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309258	1058	0	\N	31
4036	GUAIBA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309308	1058	0	\N	31
4037	GUAPORE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309407	1058	0	\N	31
4038	GUARANI DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309506	1058	0	\N	31
4039	HARMONIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309555	1058	0	\N	31
4040	HERVAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4307104	1058	0	\N	31
4041	HERVEIRAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309571	1058	0	\N	31
4042	HORIZONTINA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309605	1058	0	\N	31
4043	HULHA NEGRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309654	1058	0	\N	31
4044	HUMAITA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309704	1058	0	\N	31
4045	IBARAMA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309753	1058	0	\N	31
4046	IBIACA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309803	1058	0	\N	31
4047	IBIRAIARAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309902	1058	0	\N	31
4048	IBIRAPUITA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4309951	1058	0	\N	31
4049	IBIRUBA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310009	1058	0	\N	31
4050	IGREJINHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310108	1058	0	\N	31
4051	IJUI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310207	1058	0	\N	31
4052	ILOPOLIS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310306	1058	0	\N	31
4053	IMBE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310330	1058	0	\N	31
4054	IMIGRANTE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310363	1058	0	\N	31
4055	INDEPENDENCIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310405	1058	0	\N	31
4056	INHACORA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310413	1058	0	\N	31
4057	IPE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310439	1058	0	\N	31
4058	IPIRANGA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310462	1058	0	\N	31
4059	IRAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310504	1058	0	\N	31
4060	ITAARA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310538	1058	0	\N	31
4061	ITACURUBI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310553	1058	0	\N	31
4062	ITAPUCA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310579	1058	0	\N	31
4063	ITAQUI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310603	1058	0	\N	31
4064	ITATI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310652	1058	0	\N	31
4065	ITATIBA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310702	1058	0	\N	31
4066	IVORA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310751	1058	0	\N	31
4067	IVOTI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310801	1058	0	\N	31
4068	JABOTICABA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310850	1058	0	\N	31
4069	JACUIZINHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310876	1058	0	\N	31
4070	JACUTINGA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4310900	1058	0	\N	31
4071	JAGUARAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311007	1058	0	\N	31
4072	JAGUARI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311106	1058	0	\N	31
4073	JAQUIRANA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311122	1058	0	\N	31
4074	JARI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311130	1058	0	\N	31
4075	JOIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311155	1058	0	\N	31
4076	JULIO DE CASTILHOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311205	1058	0	\N	31
4077	LAGOA BONITA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311239	1058	0	\N	31
4078	LAGOA DOS TRES CANTOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311270	1058	0	\N	31
4079	LAGOAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311254	1058	0	\N	31
4080	LAGOA VERMELHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311304	1058	0	\N	31
4081	LAJEADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311403	1058	0	\N	31
4082	LAJEADO DO BUGRE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311429	1058	0	\N	31
4083	LAVRAS DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311502	1058	0	\N	31
4084	LIBERATO SALZANO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311601	1058	0	\N	31
4085	LINDOLFO COLLOR	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311627	1058	0	\N	31
4086	LINHA NOVA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311643	1058	0	\N	31
4087	MACAMBARA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311718	1058	0	\N	31
4088	MACHADINHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311700	1058	0	\N	31
4089	MAMPITUBA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311734	1058	0	\N	31
4090	MANOEL VIANA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311759	1058	0	\N	31
4091	MAQUINE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311775	1058	0	\N	31
4092	MARATA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311791	1058	0	\N	31
4093	MARAU	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311809	1058	0	\N	31
4094	MARCELINO RAMOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311908	1058	0	\N	31
4095	MARIANA PIMENTEL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4311981	1058	0	\N	31
4096	MARIANO MORO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312005	1058	0	\N	31
4097	MARQUES DE SOUZA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312054	1058	0	\N	31
4098	MATA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312104	1058	0	\N	31
4099	MATO CASTELHANO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312138	1058	0	\N	31
4100	MATO LEITAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312153	1058	0	\N	31
4101	MATO QUEIMADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312179	1058	0	\N	31
4102	MAXIMILIANO DE ALMEIDA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312203	1058	0	\N	31
4103	MINAS DO LEAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312252	1058	0	\N	31
4104	MIRAGUAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312302	1058	0	\N	31
4105	MONTAURI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312351	1058	0	\N	31
4106	MONTE ALEGRE DOS CAMPOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312377	1058	0	\N	31
4107	MONTE BELO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312385	1058	0	\N	31
4108	MONTENEGRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312401	1058	0	\N	31
4109	MORMACO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312427	1058	0	\N	31
4110	MORRINHOS DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312443	1058	0	\N	31
4111	MORRO REDONDO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312450	1058	0	\N	31
4112	MORRO REUTER	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312476	1058	0	\N	31
4113	MOSTARDAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312500	1058	0	\N	31
4114	MUCUM	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312609	1058	0	\N	31
4115	MUITOS CAPOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312617	1058	0	\N	31
4116	MULITERNO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312625	1058	0	\N	31
4117	NAO ME TOQUE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312658	1058	0	\N	31
4118	NICOLAU VERGUEIRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312674	1058	0	\N	31
4119	NONOAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312708	1058	0	\N	31
4120	NOVA ALVORADA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312757	1058	0	\N	31
4121	NOVA ARACA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312807	1058	0	\N	31
4122	NOVA BASSANO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312906	1058	0	\N	31
4123	NOVA BOA VISTA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4312955	1058	0	\N	31
4124	NOVA BRESCIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313003	1058	0	\N	31
4125	NOVA CANDELARIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313011	1058	0	\N	31
4126	NOVA ESPERANCA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313037	1058	0	\N	31
4127	NOVA HARTZ	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313060	1058	0	\N	31
4128	NOVA PADUA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313086	1058	0	\N	31
4129	NOVA PALMA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313102	1058	0	\N	31
4130	NOVA PETROPOLIS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313201	1058	0	\N	31
4131	NOVA PRATA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313300	1058	0	\N	31
4132	NOVA RAMADA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313334	1058	0	\N	31
4133	NOVA ROMA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313359	1058	0	\N	31
4134	NOVA SANTA RITA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313375	1058	0	\N	31
4135	NOVO BARREIRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313490	1058	0	\N	31
4136	NOVO CABRAIS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313391	1058	0	\N	31
4137	NOVO HAMBURGO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313409	1058	0	\N	31
4138	NOVO MACHADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313425	1058	0	\N	31
4139	NOVO TIRADENTES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313441	1058	0	\N	31
4140	NOVO XINGU	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313466	1058	0	\N	31
4141	OSORIO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313508	1058	0	\N	31
4142	PAIM FILHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313607	1058	0	\N	31
4143	PALMARES DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313656	1058	0	\N	31
4144	PALMEIRA DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313706	1058	0	\N	31
4145	PALMITINHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313805	1058	0	\N	31
4146	PANAMBI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313904	1058	0	\N	31
4147	PANTANO GRANDE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4313953	1058	0	\N	31
4148	PARAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314001	1058	0	\N	31
4149	PARAISO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314027	1058	0	\N	31
4150	PARECI NOVO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314035	1058	0	\N	31
4151	PAROBE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314050	1058	0	\N	31
4152	PASSA SETE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314068	1058	0	\N	31
4153	PASSO DO SOBRADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314076	1058	0	\N	31
4154	PASSO FUNDO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314100	1058	0	\N	31
4155	PAULO BENTO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314134	1058	0	\N	31
4156	PAVERAMA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314159	1058	0	\N	31
4157	PEDRAS ALTAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314175	1058	0	\N	31
4158	PEDRO OSORIO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314209	1058	0	\N	31
4159	PEJUCARA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314308	1058	0	\N	31
4160	PELOTAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314407	1058	0	\N	31
4161	PICADA CAFE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314423	1058	0	\N	31
4162	PINHAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314456	1058	0	\N	31
4163	PINHAL DA SERRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314464	1058	0	\N	31
4164	PINHAL GRANDE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314472	1058	0	\N	31
4165	PINHEIRINHO DO VALE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314498	1058	0	\N	31
4166	PINHEIRO MACHADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314506	1058	0	\N	31
4167	PINTO BANDEIRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314530	1058	0	\N	31
4168	PIRAPO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314555	1058	0	\N	31
4169	PIRATINI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314605	1058	0	\N	31
4170	PLANALTO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314704	1058	0	\N	31
4171	POCO DAS ANTAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314753	1058	0	\N	31
4172	PONTAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314779	1058	0	\N	31
4173	PONTE PRETA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314787	1058	0	\N	31
4174	PORTAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314803	1058	0	\N	31
4175	PORTO ALEGRE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4314902	1058	0	\N	31
4176	PORTO LUCENA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315008	1058	0	\N	31
4177	PORTO MAUA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315057	1058	0	\N	31
4178	PORTO VERA CRUZ	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315073	1058	0	\N	31
4179	PORTO XAVIER	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315107	1058	0	\N	31
4180	POUSO NOVO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315131	1058	0	\N	31
4181	PRESIDENTE LUCENA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315149	1058	0	\N	31
4182	PROGRESSO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315156	1058	0	\N	31
4183	PROTASIO ALVES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315172	1058	0	\N	31
4184	PUTINGA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315206	1058	0	\N	31
4185	QUATRO IRMAOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315313	1058	0	\N	31
4186	QUARAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315305	1058	0	\N	31
4187	QUEVEDOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315321	1058	0	\N	31
4188	QUINZE DE NOVEMBRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315354	1058	0	\N	31
4189	REDENTORA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315404	1058	0	\N	31
4190	RELVADO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315453	1058	0	\N	31
4191	RESTINGA SECA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315503	1058	0	\N	31
4192	RIO DOS INDIOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315552	1058	0	\N	31
4193	RIO GRANDE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315602	1058	0	\N	31
4194	RIO PARDO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315701	1058	0	\N	31
4195	RIOZINHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315750	1058	0	\N	31
4196	ROCA SALES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315800	1058	0	\N	31
4197	RODEIO BONITO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315909	1058	0	\N	31
4198	ROLADOR	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4315958	1058	0	\N	31
4199	ROLANTE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316006	1058	0	\N	31
4200	RONDA ALTA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316105	1058	0	\N	31
4201	RONDINHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316204	1058	0	\N	31
4202	ROQUE GONZALES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316303	1058	0	\N	31
4203	ROSARIO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316402	1058	0	\N	31
4204	SAGRADA FAMILIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316428	1058	0	\N	31
4205	SALDANHA MARINHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316436	1058	0	\N	31
4206	SALTO DO JACUI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316451	1058	0	\N	31
4207	SALVADOR DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316477	1058	0	\N	31
4208	SALVADOR DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316501	1058	0	\N	31
4209	SANANDUVA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316600	1058	0	\N	31
4210	SANTA BARBARA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316709	1058	0	\N	31
4211	SANTA CECILIA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316733	1058	0	\N	31
4212	SANTA CLARA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316758	1058	0	\N	31
4213	SANTA CRUZ DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316808	1058	0	\N	31
4214	SANTA MARIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316907	1058	0	\N	31
4215	SANTA MARIA DO HERVAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316956	1058	0	\N	31
4216	SANTA ROSA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317202	1058	0	\N	31
4217	SANTA TEREZA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317251	1058	0	\N	31
4218	SANTA VITORIA DO PALMAR	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317301	1058	0	\N	31
4219	SANTANA DA BOA VISTA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317004	1058	0	\N	31
4220	SANTANA DO LIVRAMENTO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317103	1058	0	\N	31
4221	SANTA MARGARIDA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4316972	1058	0	\N	31
4222	SANTIAGO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317400	1058	0	\N	31
4223	SANTO ANGELO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317509	1058	0	\N	31
4224	SANTO ANTONIO DO PALMA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317558	1058	0	\N	31
4225	SANTO ANTONIO DA PATRULHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317608	1058	0	\N	31
4226	SANTO ANTONIO DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317707	1058	0	\N	31
4227	SANTO ANTONIO DO PLANALTO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317756	1058	0	\N	31
4228	SANTO AUGUSTO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317806	1058	0	\N	31
4229	SANTO CRISTO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317905	1058	0	\N	31
4230	SANTO EXPEDITO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4317954	1058	0	\N	31
4231	SAO BORJA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318002	1058	0	\N	31
4232	SAO DOMINGOS DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318051	1058	0	\N	31
4233	SAO FRANCISCO DE ASSIS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318101	1058	0	\N	31
4234	SAO FRANCISCO DE PAULA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318200	1058	0	\N	31
4235	SAO GABRIEL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318309	1058	0	\N	31
4236	SAO JERONIMO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318408	1058	0	\N	31
4237	SAO JOAO DA URTIGA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318424	1058	0	\N	31
4238	SAO JOAO DO POLESINE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318432	1058	0	\N	31
4239	SAO JORGE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318440	1058	0	\N	31
4240	SAO JOSE DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318457	1058	0	\N	31
4241	SAO JOSE DO HERVAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318465	1058	0	\N	31
4242	SAO JOSE DO HORTENCIO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318481	1058	0	\N	31
4243	SAO JOSE DO INHACORA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318499	1058	0	\N	31
4244	SAO JOSE DO NORTE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318507	1058	0	\N	31
4245	SAO JOSE DO OURO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318606	1058	0	\N	31
4246	SAO JOSE DOS AUSENTES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318622	1058	0	\N	31
4247	SAO JOSE DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318614	1058	0	\N	31
4248	SAO LEOPOLDO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318705	1058	0	\N	31
4249	SAO LOURENCO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318804	1058	0	\N	31
4250	SAO LUIZ GONZAGA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4318903	1058	0	\N	31
4251	SAO MARCOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319000	1058	0	\N	31
4252	SAO MARTINHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319109	1058	0	\N	31
4253	SAO MARTINHO DA SERRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319125	1058	0	\N	31
4254	SAO MIGUEL DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319158	1058	0	\N	31
4255	SAO NICOLAU	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319208	1058	0	\N	31
4256	SAO PAULO DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319307	1058	0	\N	31
4257	SAO PEDRO DA SERRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319356	1058	0	\N	31
4258	SAO PEDRO DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319364	1058	0	\N	31
4259	SAO PEDRO DO BUTIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319372	1058	0	\N	31
4260	SAO PEDRO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319406	1058	0	\N	31
4261	SAO SEBASTIAO DO CAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319505	1058	0	\N	31
4262	SAO SEPE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319604	1058	0	\N	31
4263	SAO VALENTIM	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319703	1058	0	\N	31
4264	SAO VALENTIM DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319711	1058	0	\N	31
4265	SAO VALERIO DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319737	1058	0	\N	31
4266	SAO VENDELINO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319752	1058	0	\N	31
4267	SAO VICENTE DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319802	1058	0	\N	31
4268	SAPIRANGA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4319901	1058	0	\N	31
4269	SAPUCAIA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320008	1058	0	\N	31
4270	SARANDI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320107	1058	0	\N	31
4271	SEBERI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320206	1058	0	\N	31
4272	SEDE NOVA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320230	1058	0	\N	31
4273	SEGREDO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320263	1058	0	\N	31
4274	SELBACH	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320305	1058	0	\N	31
4275	SENADOR SALGADO FILHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320321	1058	0	\N	31
4276	SENTINELA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320354	1058	0	\N	31
4277	SERAFINA CORREA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320404	1058	0	\N	31
4278	SERIO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320453	1058	0	\N	31
4279	SERTAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320503	1058	0	\N	31
4280	SERTAO SANTANA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320552	1058	0	\N	31
4281	SETE DE SETEMBRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320578	1058	0	\N	31
4282	SEVERIANO DE ALMEIDA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320602	1058	0	\N	31
4283	SILVEIRA MARTINS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320651	1058	0	\N	31
4284	SINIMBU	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320677	1058	0	\N	31
4285	SOBRADINHO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320701	1058	0	\N	31
4286	SOLEDADE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320800	1058	0	\N	31
4287	TABAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320859	1058	0	\N	31
4288	TAPEJARA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4320909	1058	0	\N	31
4289	TAPERA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321006	1058	0	\N	31
4290	TAPES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321105	1058	0	\N	31
4291	TAQUARA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321204	1058	0	\N	31
4292	TAQUARI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321303	1058	0	\N	31
4293	TAQUARUCU DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321329	1058	0	\N	31
4294	TAVARES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321352	1058	0	\N	31
4295	TENENTE PORTELA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321402	1058	0	\N	31
4296	TERRA DE AREIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321436	1058	0	\N	31
4297	TEUTONIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321451	1058	0	\N	31
4298	TIO HUGO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321469	1058	0	\N	31
4299	TIRADENTES DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321477	1058	0	\N	31
4300	TOROPI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321493	1058	0	\N	31
4301	TORRES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321501	1058	0	\N	31
4302	TRAMANDAI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321600	1058	0	\N	31
4303	TRAVESSEIRO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321626	1058	0	\N	31
4304	TRES ARROIOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321634	1058	0	\N	31
4305	TRES CACHOEIRAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321667	1058	0	\N	31
4306	TRES COROAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321709	1058	0	\N	31
4307	TRES DE MAIO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321808	1058	0	\N	31
4308	TRES FORQUILHAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321832	1058	0	\N	31
4309	TRES PALMEIRAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321857	1058	0	\N	31
4310	TRES PASSOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321907	1058	0	\N	31
4311	TRINDADE DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4321956	1058	0	\N	31
4312	TRIUNFO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322004	1058	0	\N	31
4313	TUCUNDUVA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322103	1058	0	\N	31
4314	TUNAS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322152	1058	0	\N	31
4315	TUPANCI DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322186	1058	0	\N	31
4316	TUPANCIRETA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322202	1058	0	\N	31
4317	TUPANDI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322251	1058	0	\N	31
4318	TUPARENDI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322301	1058	0	\N	31
4319	TURUCU	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322327	1058	0	\N	31
4320	UBIRETAMA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322343	1058	0	\N	31
4321	UNIAO DA SERRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322350	1058	0	\N	31
4322	UNISTALDA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322376	1058	0	\N	31
4323	URUGUAIANA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322400	1058	0	\N	31
4324	VACARIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322509	1058	0	\N	31
4325	VALE DO SOL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322533	1058	0	\N	31
4326	VALE REAL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322541	1058	0	\N	31
4327	VALE VERDE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322525	1058	0	\N	31
4328	VANINI	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322558	1058	0	\N	31
4329	VENANCIO AIRES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322608	1058	0	\N	31
4330	VERA CRUZ	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322707	1058	0	\N	31
4331	VERANOPOLIS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322806	1058	0	\N	31
4332	VESPASIANO CORREA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322855	1058	0	\N	31
4333	VIADUTOS	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4322905	1058	0	\N	31
4334	VIAMAO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323002	1058	0	\N	31
4335	VICENTE DUTRA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323101	1058	0	\N	31
4336	VICTOR GRAEFF	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323200	1058	0	\N	31
4337	VILA FLORES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323309	1058	0	\N	31
4338	VILA LANGARO	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323358	1058	0	\N	31
4339	VILA MARIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323408	1058	0	\N	31
4340	VILA NOVA DO SUL	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323457	1058	0	\N	31
4341	VISTA ALEGRE	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323507	1058	0	\N	31
4342	VISTA ALEGRE DO PRATA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323606	1058	0	\N	31
4343	VISTA GAUCHA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323705	1058	0	\N	31
4344	VITORIA DAS MISSOES	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323754	1058	0	\N	31
4345	WESTFALIA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323770	1058	0	\N	31
4346	XANGRI LA	RS			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4323804	1058	0	\N	31
4347	ALTA FLORESTA D OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100015	1058	0	\N	31
4348	ALTO ALEGRE DOS PARECIS	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100379	1058	0	\N	31
4349	ALTO PARAISO	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100403	1058	0	\N	31
4350	ALVORADA D OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100346	1058	0	\N	31
4351	ARIQUEMES	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100023	1058	0	\N	31
4352	BURITIS	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100452	1058	0	\N	31
4353	CABIXI	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100031	1058	0	\N	31
4354	CACAULANDIA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100601	1058	0	\N	31
4355	CACOAL	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100049	1058	0	\N	31
4356	CAMPO NOVO DE RONDONIA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100700	1058	0	\N	31
4357	CANDEIAS DO JAMARI	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100809	1058	0	\N	31
4358	CASTANHEIRAS	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100908	1058	0	\N	31
4359	CEREJEIRAS	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100056	1058	0	\N	31
4360	CHUPINGUAIA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100924	1058	0	\N	31
4361	COLORADO DO OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100064	1058	0	\N	31
4362	CORUMBIARA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100072	1058	0	\N	31
4363	COSTA MARQUES	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100080	1058	0	\N	31
4364	CUJUBIM	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100940	1058	0	\N	31
4365	ESPIGAO D OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100098	1058	0	\N	31
4366	GOVERNADOR JORGE TEIXEIRA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101005	1058	0	\N	31
4367	GUAJARA MIRIM	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100106	1058	0	\N	31
4368	ITAPUA DO OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101104	1058	0	\N	31
4369	JARU	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100114	1058	0	\N	31
4370	JI PARANA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100122	1058	0	\N	31
4371	MACHADINHO D OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100130	1058	0	\N	31
4372	MINISTRO ANDREAZZA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101203	1058	0	\N	31
4373	MIRANTE DA SERRA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101302	1058	0	\N	31
4374	MONTE NEGRO	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101401	1058	0	\N	31
4375	NOVA BRASILANDIA D OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100148	1058	0	\N	31
4376	NOVA MAMORE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100338	1058	0	\N	31
4377	NOVA UNIAO	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101435	1058	0	\N	31
4378	NOVO HORIZONTE D OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100502	1058	0	\N	31
4379	OURO PRETO DO OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100155	1058	0	\N	31
4380	PARECIS	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101450	1058	0	\N	31
4381	PIMENTA BUENO	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100189	1058	0	\N	31
4382	PIMENTEIRAS DO OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101468	1058	0	\N	31
4383	PORTO VELHO	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100205	1058	0	\N	31
4384	PRESIDENTE MEDICI	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100254	1058	0	\N	31
4385	PRIMAVERA DE RONDONIA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101476	1058	0	\N	31
4386	RIO CRESPO	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100262	1058	0	\N	31
4387	ROLIM DE MOURA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100288	1058	0	\N	31
4388	SANTA LUZIA D OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100296	1058	0	\N	31
4389	SAO FELIPE D OESTE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101484	1058	0	\N	31
4390	SAO FRANCISCO DO GUAPORE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101492	1058	0	\N	31
4391	SAO MIGUEL DO GUAPORE	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100320	1058	0	\N	31
4392	SERINGUEIRAS	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101500	1058	0	\N	31
4393	TEIXEIROPOLIS	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101559	1058	0	\N	31
4394	THEOBROMA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101609	1058	0	\N	31
4395	URUPA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101708	1058	0	\N	31
4396	VALE DO ANARI	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101757	1058	0	\N	31
4397	VALE DO PARAISO	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1101807	1058	0	\N	31
4398	VILHENA	RO			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1100304	1058	0	\N	31
4399	ALTO ALEGRE	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400050	1058	0	\N	31
4400	AMAJARI	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400027	1058	0	\N	31
4401	BOA VISTA	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400100	1058	0	\N	31
4402	BONFIM	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400159	1058	0	\N	31
4403	CANTA	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400175	1058	0	\N	31
4404	CARACARAI	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400209	1058	0	\N	31
4405	CAROEBE	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400233	1058	0	\N	31
4406	IRACEMA	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400282	1058	0	\N	31
4407	MUCAJAI	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400308	1058	0	\N	31
4408	NORMANDIA	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400407	1058	0	\N	31
4409	PACARAIMA	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400456	1058	0	\N	31
4410	RORAINOPOLIS	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400472	1058	0	\N	31
4411	SAO JOAO DA BALIZA	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400506	1058	0	\N	31
4412	SAO LUIZ	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400605	1058	0	\N	31
4413	UIRAMUTA	RR			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	1400704	1058	0	\N	31
4414	ABDON BATISTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200051	1058	0	\N	31
4415	ABELARDO LUZ	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200101	1058	0	\N	31
4416	AGROLANDIA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200200	1058	0	\N	31
4417	AGRONOMICA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200309	1058	0	\N	31
4418	AGUA DOCE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200408	1058	0	\N	31
4419	AGUAS DE CHAPECO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200507	1058	0	\N	31
4420	AGUAS FRIAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200556	1058	0	\N	31
4421	AGUAS MORNAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200606	1058	0	\N	31
4422	ALFREDO WAGNER	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200705	1058	0	\N	31
4423	ALTO BELA VISTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200754	1058	0	\N	31
4424	ANCHIETA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200804	1058	0	\N	31
4425	ANGELINA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4200903	1058	0	\N	31
4426	ANITA GARIBALDI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201000	1058	0	\N	31
4427	ANITAPOLIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201109	1058	0	\N	31
4428	ANTONIO CARLOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201208	1058	0	\N	31
4429	APIUNA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201257	1058	0	\N	31
4430	ARABUTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201273	1058	0	\N	31
4431	ARAQUARI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201307	1058	0	\N	31
4432	ARARANGUA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201406	1058	0	\N	31
4433	ARMAZEM	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201505	1058	0	\N	31
4434	ARROIO TRINTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201604	1058	0	\N	31
4435	ARVOREDO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201653	1058	0	\N	31
4436	ASCURRA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201703	1058	0	\N	31
4437	ATALANTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201802	1058	0	\N	31
4438	AURORA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201901	1058	0	\N	31
4439	BALNEARIO ARROIO DO SILVA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4201950	1058	0	\N	31
4440	BALNEARIO BARRA DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202057	1058	0	\N	31
4441	BALNEARIO CAMBORIU	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202008	1058	0	\N	31
4442	BALNEARIO GAIVOTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202073	1058	0	\N	31
4443	BALNEARIO PICARRAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212809	1058	0	\N	31
4444	BANDEIRANTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202081	1058	0	\N	31
4445	BARRA BONITA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202099	1058	0	\N	31
4446	BARRA VELHA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202107	1058	0	\N	31
4447	BELA VISTA DO TOLDO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202131	1058	0	\N	31
4448	BELMONTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202156	1058	0	\N	31
4449	BENEDITO NOVO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202206	1058	0	\N	31
4450	BIGUACU	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202305	1058	0	\N	31
4451	BLUMENAU	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202404	1058	0	\N	31
4452	BOCAINA DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202438	1058	0	\N	31
4453	BOMBINHAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202453	1058	0	\N	31
4454	BOM JARDIM DA SERRA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202503	1058	0	\N	31
4455	BOM JESUS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202537	1058	0	\N	31
4456	BOM JESUS DO OESTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202578	1058	0	\N	31
4457	BOM RETIRO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202602	1058	0	\N	31
4458	BOTUVERA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202701	1058	0	\N	31
4459	BRACO DO NORTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202800	1058	0	\N	31
4460	BRACO DO TROMBUDO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202859	1058	0	\N	31
4461	BRUNOPOLIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202875	1058	0	\N	31
4462	BRUSQUE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4202909	1058	0	\N	31
4463	CACADOR	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203006	1058	0	\N	31
4464	CAIBI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203105	1058	0	\N	31
4465	CALMON	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203154	1058	0	\N	31
4466	CAMBORIU	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203204	1058	0	\N	31
4467	CAMPO ALEGRE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203303	1058	0	\N	31
4468	CAPAO ALTO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203253	1058	0	\N	31
4469	CAMPO BELO DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203402	1058	0	\N	31
4470	CAMPO ERE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203501	1058	0	\N	31
4471	CAMPOS NOVOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203600	1058	0	\N	31
4472	CANELINHA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203709	1058	0	\N	31
4473	CANOINHAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203808	1058	0	\N	31
4474	CAPINZAL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203907	1058	0	\N	31
4475	CAPIVARI DE BAIXO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4203956	1058	0	\N	31
4476	CATANDUVAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204004	1058	0	\N	31
4477	CAXAMBU DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204103	1058	0	\N	31
4478	CELSO RAMOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204152	1058	0	\N	31
4479	CERRO NEGRO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204178	1058	0	\N	31
4480	CHAPADAO DO LAGEADO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204194	1058	0	\N	31
4481	CHAPECO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204202	1058	0	\N	31
4482	COCAL DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204251	1058	0	\N	31
4483	CONCORDIA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204301	1058	0	\N	31
4484	CORDILHEIRA ALTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204350	1058	0	\N	31
4485	CORONEL FREITAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204400	1058	0	\N	31
4486	CORONEL MARTINS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204459	1058	0	\N	31
4487	CORREIA PINTO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204558	1058	0	\N	31
4488	CORUPA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204509	1058	0	\N	31
4489	CRICIUMA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204608	1058	0	\N	31
4490	CUNHA PORA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204707	1058	0	\N	31
4491	CUNHATAI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204756	1058	0	\N	31
4492	CURITIBANOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204806	1058	0	\N	31
4493	DESCANSO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4204905	1058	0	\N	31
4494	DIONISIO CERQUEIRA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205001	1058	0	\N	31
4495	DONA EMMA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205100	1058	0	\N	31
4496	DOUTOR PEDRINHO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205159	1058	0	\N	31
4497	ENTRE RIOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205175	1058	0	\N	31
4498	ERMO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205191	1058	0	\N	31
4499	ERVAL VELHO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205209	1058	0	\N	31
4500	FAXINAL DOS GUEDES	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205308	1058	0	\N	31
4501	FLOR DO SERTAO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205357	1058	0	\N	31
4502	FLORIANOPOLIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205407	1058	0	\N	31
4503	FORMOSA DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205431	1058	0	\N	31
4504	FORQUILHINHA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205456	1058	0	\N	31
4505	FRAIBURGO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205506	1058	0	\N	31
4506	FREI ROGERIO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205555	1058	0	\N	31
4507	GALVAO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205605	1058	0	\N	31
4508	GAROPABA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205704	1058	0	\N	31
4509	GARUVA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205803	1058	0	\N	31
4510	GASPAR	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4205902	1058	0	\N	31
4511	GOVERNADOR CELSO RAMOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206009	1058	0	\N	31
4512	GRAO PARA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206108	1058	0	\N	31
4513	GRAVATAL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206207	1058	0	\N	31
4514	GUABIRUBA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206306	1058	0	\N	31
4515	GUARACIABA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206405	1058	0	\N	31
4516	GUARAMIRIM	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206504	1058	0	\N	31
4517	GUARUJA DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206603	1058	0	\N	31
4518	GUATAMBU	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206652	1058	0	\N	31
4519	HERVAL D OESTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206702	1058	0	\N	31
4520	IBIAM	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206751	1058	0	\N	31
4521	IBICARE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206801	1058	0	\N	31
4522	IBIRAMA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4206900	1058	0	\N	31
4523	ICARA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207007	1058	0	\N	31
4524	ILHOTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207106	1058	0	\N	31
4525	IMARUI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207205	1058	0	\N	31
4526	IMBITUBA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207304	1058	0	\N	31
4527	IMBUIA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207403	1058	0	\N	31
4528	INDAIAL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207502	1058	0	\N	31
4529	IOMERE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207577	1058	0	\N	31
4530	IPIRA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207601	1058	0	\N	31
4531	IPORA DO OESTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207650	1058	0	\N	31
4532	IPUACU	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207684	1058	0	\N	31
4533	IPUMIRIM	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207700	1058	0	\N	31
4534	IRACEMINHA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207759	1058	0	\N	31
4535	IRANI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207809	1058	0	\N	31
4536	IRATI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207858	1058	0	\N	31
4537	IRINEOPOLIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4207908	1058	0	\N	31
4538	ITA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208005	1058	0	\N	31
4539	ITAIOPOLIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208104	1058	0	\N	31
4540	ITAJAI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208203	1058	0	\N	31
4541	ITAPEMA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208302	1058	0	\N	31
4542	ITAPIRANGA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208401	1058	0	\N	31
4543	ITAPOA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208450	1058	0	\N	31
4544	ITUPORANGA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208500	1058	0	\N	31
4545	JABORA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208609	1058	0	\N	31
4546	JACINTO MACHADO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208708	1058	0	\N	31
4547	JAGUARUNA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208807	1058	0	\N	31
4548	JARAGUA DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208906	1058	0	\N	31
4549	JARDINOPOLIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4208955	1058	0	\N	31
4550	JOACABA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209003	1058	0	\N	31
4551	JOINVILLE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209102	1058	0	\N	31
4552	JOSE BOITEUX	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209151	1058	0	\N	31
4553	JUPIA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209177	1058	0	\N	31
4554	LACERDOPOLIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209201	1058	0	\N	31
4555	LAGES	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209300	1058	0	\N	31
4556	LAGUNA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209409	1058	0	\N	31
4557	LAJEADO GRANDE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209458	1058	0	\N	31
4558	LAURENTINO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209508	1058	0	\N	31
4559	LAURO MULLER	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209607	1058	0	\N	31
4560	LEBON REGIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209706	1058	0	\N	31
4561	LEOBERTO LEAL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209805	1058	0	\N	31
4562	LINDOIA DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209854	1058	0	\N	31
4563	LONTRAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4209904	1058	0	\N	31
4564	LUIZ ALVES	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210001	1058	0	\N	31
4565	LUZERNA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210035	1058	0	\N	31
4566	MACIEIRA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210050	1058	0	\N	31
4567	MAFRA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210100	1058	0	\N	31
4568	MAJOR GERCINO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210209	1058	0	\N	31
4569	MAJOR VIEIRA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210308	1058	0	\N	31
4570	MARACAJA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210407	1058	0	\N	31
4571	MARAVILHA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210506	1058	0	\N	31
4572	MAREMA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210555	1058	0	\N	31
4573	MASSARANDUBA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210605	1058	0	\N	31
4574	MATOS COSTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210704	1058	0	\N	31
4575	MELEIRO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210803	1058	0	\N	31
4576	MIRIM DOCE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210852	1058	0	\N	31
4577	MODELO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4210902	1058	0	\N	31
4578	MONDAI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211009	1058	0	\N	31
4579	MONTE CARLO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211058	1058	0	\N	31
4580	MONTE CASTELO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211108	1058	0	\N	31
4581	MORRO DA FUMACA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211207	1058	0	\N	31
4582	MORRO GRANDE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211256	1058	0	\N	31
4583	NAVEGANTES	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211306	1058	0	\N	31
4584	NOVA ERECHIM	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211405	1058	0	\N	31
4585	NOVA ITABERABA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211454	1058	0	\N	31
4586	NOVA TRENTO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211504	1058	0	\N	31
4587	NOVA VENEZA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211603	1058	0	\N	31
4588	NOVO HORIZONTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211652	1058	0	\N	31
4589	ORLEANS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211702	1058	0	\N	31
4590	OTACILIO COSTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211751	1058	0	\N	31
4591	OURO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211801	1058	0	\N	31
4592	OURO VERDE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211850	1058	0	\N	31
4593	PAIAL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211876	1058	0	\N	31
4594	PAINEL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211892	1058	0	\N	31
4595	PALHOCA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4211900	1058	0	\N	31
4596	PALMA SOLA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212007	1058	0	\N	31
4597	PALMEIRA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212056	1058	0	\N	31
4598	PALMITOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212106	1058	0	\N	31
4599	PAPANDUVA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212205	1058	0	\N	31
4600	PARAISO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212239	1058	0	\N	31
4601	PASSO DE TORRES	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212254	1058	0	\N	31
4602	PASSOS MAIA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212270	1058	0	\N	31
4603	PAULO LOPES	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212304	1058	0	\N	31
4604	PEDRAS GRANDES	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212403	1058	0	\N	31
4605	PENHA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212502	1058	0	\N	31
4606	PERITIBA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212601	1058	0	\N	31
4607	PETROLANDIA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212700	1058	0	\N	31
4608	PINHALZINHO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4212908	1058	0	\N	31
4609	PINHEIRO PRETO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213005	1058	0	\N	31
4610	PIRATUBA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213104	1058	0	\N	31
4611	PLANALTO ALEGRE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213153	1058	0	\N	31
4612	POMERODE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213203	1058	0	\N	31
4613	PONTE ALTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213302	1058	0	\N	31
4614	PONTE ALTA DO NORTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213351	1058	0	\N	31
4615	PONTE SERRADA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213401	1058	0	\N	31
4616	PORTO BELO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213500	1058	0	\N	31
4617	PORTO UNIAO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213609	1058	0	\N	31
4618	POUSO REDONDO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213708	1058	0	\N	31
4619	PRAIA GRANDE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213807	1058	0	\N	31
4620	PRESIDENTE CASTELLO BRANCO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4213906	1058	0	\N	31
4621	PRESIDENTE GETULIO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214003	1058	0	\N	31
4622	PRESIDENTE NEREU	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214102	1058	0	\N	31
4623	PRINCESA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214151	1058	0	\N	31
4624	QUILOMBO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214201	1058	0	\N	31
4625	RANCHO QUEIMADO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214300	1058	0	\N	31
4626	RIO DAS ANTAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214409	1058	0	\N	31
4627	RIO DO CAMPO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214508	1058	0	\N	31
4628	RIO DO OESTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214607	1058	0	\N	31
4629	RIO DOS CEDROS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214706	1058	0	\N	31
4630	RIO DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214805	1058	0	\N	31
4631	RIO FORTUNA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4214904	1058	0	\N	31
4632	RIO NEGRINHO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215000	1058	0	\N	31
4633	RIO RUFINO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215059	1058	0	\N	31
4634	RIQUEZA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215075	1058	0	\N	31
4635	RODEIO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215109	1058	0	\N	31
4636	ROMELANDIA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215208	1058	0	\N	31
4637	SALETE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215307	1058	0	\N	31
4638	SALTINHO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215356	1058	0	\N	31
4639	SALTO VELOSO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215406	1058	0	\N	31
4640	SANGAO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215455	1058	0	\N	31
4641	SANTA CECILIA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215505	1058	0	\N	31
4642	SANTA HELENA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215554	1058	0	\N	31
4643	SANTA ROSA DE LIMA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215604	1058	0	\N	31
4644	SANTA ROSA DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215653	1058	0	\N	31
4645	SANTA TEREZINHA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215679	1058	0	\N	31
4646	SANTA TEREZINHA DO PROGRESSO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215687	1058	0	\N	31
4647	SANTIAGO DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215695	1058	0	\N	31
4648	SANTO AMARO DA IMPERATRIZ	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215703	1058	0	\N	31
4649	SAO BENTO DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215802	1058	0	\N	31
4650	SAO BERNARDINO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215752	1058	0	\N	31
4651	SAO BONIFACIO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4215901	1058	0	\N	31
4652	SAO CARLOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216008	1058	0	\N	31
4653	SAO CRISTOVAO DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216057	1058	0	\N	31
4654	SAO DOMINGOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216107	1058	0	\N	31
4655	SAO FRANCISCO DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216206	1058	0	\N	31
4656	SAO JOAO BATISTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216305	1058	0	\N	31
4657	SAO JOAO DO OESTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216255	1058	0	\N	31
4658	SAO JOAO DO ITAPERIU	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216354	1058	0	\N	31
4659	SAO JOAO DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216404	1058	0	\N	31
4660	SAO JOAQUIM	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216503	1058	0	\N	31
4661	SAO JOSE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216602	1058	0	\N	31
4662	SAO JOSE DO CEDRO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216701	1058	0	\N	31
4663	SAO JOSE DO CERRITO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216800	1058	0	\N	31
4664	SAO LOURENCO DO OESTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4216909	1058	0	\N	31
4665	SAO LUDGERO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217006	1058	0	\N	31
4666	SAO MARTINHO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217105	1058	0	\N	31
4667	SAO MIGUEL DA BOA VISTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217154	1058	0	\N	31
4668	SAO PEDRO DE ALCANTARA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217253	1058	0	\N	31
4669	SAO MIGUEL DO OESTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217204	1058	0	\N	31
4670	SAUDADES	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217303	1058	0	\N	31
4671	SCHROEDER	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217402	1058	0	\N	31
4672	SEARA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217501	1058	0	\N	31
4673	SERRA ALTA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217550	1058	0	\N	31
4674	SIDEROPOLIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217600	1058	0	\N	31
4675	SOMBRIO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217709	1058	0	\N	31
4676	SUL BRASIL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217758	1058	0	\N	31
4677	TAIO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217808	1058	0	\N	31
4678	TANGARA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217907	1058	0	\N	31
4679	TIGRINHOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4217956	1058	0	\N	31
4680	TIJUCAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218004	1058	0	\N	31
4681	TIMBE DO SUL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218103	1058	0	\N	31
4682	TIMBO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218202	1058	0	\N	31
4683	TIMBO GRANDE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218251	1058	0	\N	31
4684	TRES BARRAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218301	1058	0	\N	31
4685	TREVISO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218350	1058	0	\N	31
4686	TREZE DE MAIO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218400	1058	0	\N	31
4687	TREZE TILIAS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218509	1058	0	\N	31
4688	TROMBUDO CENTRAL	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218608	1058	0	\N	31
4689	TUBARAO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218707	1058	0	\N	31
4690	TUNAPOLIS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218756	1058	0	\N	31
4691	TURVO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218806	1058	0	\N	31
4692	UNIAO DO OESTE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218855	1058	0	\N	31
4693	URUBICI	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218905	1058	0	\N	31
4694	URUPEMA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4218954	1058	0	\N	31
4695	URUSSANGA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219002	1058	0	\N	31
4696	VARGEAO	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219101	1058	0	\N	31
4697	VARGEM	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219150	1058	0	\N	31
4698	VARGEM BONITA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219176	1058	0	\N	31
4699	VIDAL RAMOS	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219200	1058	0	\N	31
4700	VIDEIRA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219309	1058	0	\N	31
4701	VITOR MEIRELES	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219358	1058	0	\N	31
4702	WITMARSUM	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219408	1058	0	\N	31
4703	XANXERE	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219507	1058	0	\N	31
4704	XAVANTINA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219606	1058	0	\N	31
4705	XAXIM	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219705	1058	0	\N	31
4706	ZORTEA	SC			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	4219853	1058	0	\N	31
4707	ADAMANTINA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500105	1058	0	\N	31
4708	ADOLFO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500204	1058	0	\N	31
4709	AGUAI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500303	1058	0	\N	31
4710	AGUAS DA PRATA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500402	1058	0	\N	31
4711	AGUAS DE LINDOIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500501	1058	0	\N	31
4712	AGUAS DE SANTA BARBARA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500550	1058	0	\N	31
4713	AGUAS DE SAO PEDRO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500600	1058	0	\N	31
4714	AGUDOS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500709	1058	0	\N	31
4715	ALAMBARI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500758	1058	0	\N	31
4716	ALFREDO MARCONDES	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500808	1058	0	\N	31
4717	ALTAIR	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3500907	1058	0	\N	31
4718	ALTINOPOLIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501004	1058	0	\N	31
4719	ALTO ALEGRE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501103	1058	0	\N	31
4720	ALUMINIO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501152	1058	0	\N	31
4721	ALVARES FLORENCE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501202	1058	0	\N	31
4722	ALVARES MACHADO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501301	1058	0	\N	31
4723	ALVARO DE CARVALHO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501400	1058	0	\N	31
4724	ALVINLANDIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501509	1058	0	\N	31
4725	AMERICANA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501608	1058	0	\N	31
4726	AMERICO BRASILIENSE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501707	1058	0	\N	31
4727	AMERICO DE CAMPOS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501806	1058	0	\N	31
4728	AMPARO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3501905	1058	0	\N	31
4729	ANALANDIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502002	1058	0	\N	31
4730	ANDRADINA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502101	1058	0	\N	31
4731	ANGATUBA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502200	1058	0	\N	31
4732	ANHEMBI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502309	1058	0	\N	31
4733	ANHUMAS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502408	1058	0	\N	31
4734	APARECIDA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502507	1058	0	\N	31
4735	APARECIDA D OESTE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502606	1058	0	\N	31
4736	APIAI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502705	1058	0	\N	31
4737	ARACARIGUAMA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502754	1058	0	\N	31
4738	ARACATUBA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502804	1058	0	\N	31
4739	ARACOIABA DA SERRA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3502903	1058	0	\N	31
4740	ARAMINA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503000	1058	0	\N	31
4741	ARANDU	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503109	1058	0	\N	31
4742	ARAPEI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503158	1058	0	\N	31
4743	ARARAQUARA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503208	1058	0	\N	31
4744	ARARAS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503307	1058	0	\N	31
4745	ARCO IRIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503356	1058	0	\N	31
4746	AREALVA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503406	1058	0	\N	31
4747	AREIAS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503505	1058	0	\N	31
4748	AREIOPOLIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503604	1058	0	\N	31
4749	ARIRANHA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503703	1058	0	\N	31
4750	ARTUR NOGUEIRA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503802	1058	0	\N	31
4751	ARUJA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503901	1058	0	\N	31
4752	ASPASIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3503950	1058	0	\N	31
4753	ASSIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504008	1058	0	\N	31
4754	ATIBAIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504107	1058	0	\N	31
4755	AURIFLAMA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504206	1058	0	\N	31
4756	AVAI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504305	1058	0	\N	31
4757	AVANHANDAVA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504404	1058	0	\N	31
4758	AVARE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504503	1058	0	\N	31
4759	BADY BASSITT	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504602	1058	0	\N	31
4760	BALBINOS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504701	1058	0	\N	31
4761	BALSAMO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504800	1058	0	\N	31
4762	BANANAL	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3504909	1058	0	\N	31
4763	BARAO DE ANTONINA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505005	1058	0	\N	31
4764	BARBOSA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505104	1058	0	\N	31
4765	BARIRI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505203	1058	0	\N	31
4766	BARRA BONITA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505302	1058	0	\N	31
4767	BARRA DO CHAPEU	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505351	1058	0	\N	31
4768	BARRA DO TURVO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505401	1058	0	\N	31
4769	BARRETOS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505500	1058	0	\N	31
4770	BARRINHA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505609	1058	0	\N	31
4771	BARUERI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505708	1058	0	\N	31
4772	BASTOS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505807	1058	0	\N	31
4773	BATATAIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3505906	1058	0	\N	31
4774	BAURU	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506003	1058	0	\N	31
4775	BEBEDOURO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506102	1058	0	\N	31
4776	BENTO DE ABREU	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506201	1058	0	\N	31
4777	BERNARDINO DE CAMPOS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506300	1058	0	\N	31
4778	BERTIOGA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506359	1058	0	\N	31
4779	BILAC	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506409	1058	0	\N	31
4780	BIRIGUI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506508	1058	0	\N	31
4781	BIRITIBA MIRIM	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506607	1058	0	\N	31
4782	BOA ESPERANCA DO SUL	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506706	1058	0	\N	31
4783	BOCAINA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506805	1058	0	\N	31
4784	BOFETE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3506904	1058	0	\N	31
4785	BOITUVA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507001	1058	0	\N	31
4786	BOM JESUS DOS PERDOES	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507100	1058	0	\N	31
4787	BOM SUCESSO DE ITARARE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507159	1058	0	\N	31
4788	BORA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507209	1058	0	\N	31
4789	BORACEIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507308	1058	0	\N	31
4790	BORBOREMA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507407	1058	0	\N	31
4791	BOREBI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507456	1058	0	\N	31
4792	BOTUCATU	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507506	1058	0	\N	31
4793	BRAGANCA PAULISTA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507605	1058	0	\N	31
4794	BRAUNA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507704	1058	0	\N	31
4795	BREJO ALEGRE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507753	1058	0	\N	31
4796	BRODOWSKI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507803	1058	0	\N	31
4797	BROTAS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3507902	1058	0	\N	31
4798	BURI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508009	1058	0	\N	31
4799	BURITAMA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508108	1058	0	\N	31
4800	BURITIZAL	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508207	1058	0	\N	31
4801	CABRALIA PAULISTA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508306	1058	0	\N	31
4802	CABREUVA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508405	1058	0	\N	31
4803	CACAPAVA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508504	1058	0	\N	31
4804	CACHOEIRA PAULISTA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508603	1058	0	\N	31
4805	CACONDE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508702	1058	0	\N	31
4806	CAFELANDIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508801	1058	0	\N	31
4807	CAIABU	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3508900	1058	0	\N	31
4808	CAIEIRAS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509007	1058	0	\N	31
4809	CAIUA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509106	1058	0	\N	31
4810	CAJAMAR	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509205	1058	0	\N	31
4811	CAJATI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509254	1058	0	\N	31
4812	CAJOBI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509304	1058	0	\N	31
4813	CAJURU	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509403	1058	0	\N	31
4814	CAMPINA DO MONTE ALEGRE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509452	1058	0	\N	31
4815	CAMPINAS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509502	1058	0	\N	31
4816	CAMPO LIMPO PAULISTA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509601	1058	0	\N	31
4817	CAMPOS DO JORDAO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509700	1058	0	\N	31
4818	CAMPOS NOVOS PAULISTA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509809	1058	0	\N	31
4819	CANANEIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509908	1058	0	\N	31
4820	CANAS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3509957	1058	0	\N	31
4821	CANDIDO MOTA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510005	1058	0	\N	31
4822	CANDIDO RODRIGUES	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510104	1058	0	\N	31
4823	CANITAR	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510153	1058	0	\N	31
4824	CAPAO BONITO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510203	1058	0	\N	31
4825	CAPELA DO ALTO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510302	1058	0	\N	31
4826	CAPIVARI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510401	1058	0	\N	31
4827	CARAGUATATUBA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510500	1058	0	\N	31
4828	CARAPICUIBA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510609	1058	0	\N	31
4829	CARDOSO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510708	1058	0	\N	31
4830	CASA BRANCA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510807	1058	0	\N	31
4831	CASSIA DOS COQUEIROS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3510906	1058	0	\N	31
4832	CASTILHO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3511003	1058	0	\N	31
4833	CATANDUVA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3511102	1058	0	\N	31
4834	CATIGUA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3511201	1058	0	\N	31
4835	CEDRAL	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3511300	1058	0	\N	31
4836	CERQUEIRA CESAR	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3511409	1058	0	\N	31
4837	CERQUILHO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3511508	1058	0	\N	31
4838	CESARIO LANGE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3511607	1058	0	\N	31
4839	CHARQUEADA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3511706	1058	0	\N	31
4840	CHAVANTES	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3557204	1058	0	\N	31
4841	CLEMENTINA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3511904	1058	0	\N	31
4842	COLINA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512001	1058	0	\N	31
4843	COLOMBIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512100	1058	0	\N	31
4844	CONCHAL	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512209	1058	0	\N	31
4845	CONCHAS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512308	1058	0	\N	31
4846	CORDEIROPOLIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512407	1058	0	\N	31
4847	COROADOS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512506	1058	0	\N	31
4848	CORONEL MACEDO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512605	1058	0	\N	31
4849	CORUMBATAI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512704	1058	0	\N	31
4850	COSMOPOLIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512803	1058	0	\N	31
4851	COSMORAMA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3512902	1058	0	\N	31
4852	COTIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513009	1058	0	\N	31
4853	CRAVINHOS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513108	1058	0	\N	31
4854	CRISTAIS PAULISTA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513207	1058	0	\N	31
4855	CRUZALIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513306	1058	0	\N	31
4856	CRUZEIRO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513405	1058	0	\N	31
4857	CUBATAO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513504	1058	0	\N	31
4858	CUNHA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513603	1058	0	\N	31
4859	DESCALVADO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513702	1058	0	\N	31
4860	DIADEMA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513801	1058	0	\N	31
4861	DIRCE REIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513850	1058	0	\N	31
4862	DIVINOLANDIA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3513900	1058	0	\N	31
4863	DOBRADA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514007	1058	0	\N	31
4864	DOIS CORREGOS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514106	1058	0	\N	31
4865	DOLCINOPOLIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514205	1058	0	\N	31
4866	DOURADO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514304	1058	0	\N	31
4867	DRACENA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514403	1058	0	\N	31
4868	DUARTINA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514502	1058	0	\N	31
4869	DUMONT	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514601	1058	0	\N	31
4870	ECHAPORA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514700	1058	0	\N	31
4871	ELDORADO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514809	1058	0	\N	31
4872	ELIAS FAUSTO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514908	1058	0	\N	31
4873	ELISIARIO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514924	1058	0	\N	31
4874	EMBAUBA	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3514957	1058	0	\N	31
4875	EMBU	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3515004	1058	0	\N	31
4876	EMBU GUACU	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3515103	1058	0	\N	31
4877	EMILIANOPOLIS	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3515129	1058	0	\N	31
4878	ENGENHEIRO COELHO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3515152	1058	0	\N	31
4879	ESPIRITO SANTO DO PINHAL	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3515186	1058	0	\N	31
4880	ESPIRITO SANTO DO TURVO	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3515194	1058	0	\N	31
4881	ESTIVA GERBI	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3557303	1058	0	\N	31
4882	ESTRELA D OESTE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3515202	1058	0	\N	31
4883	ESTRELA DO NORTE	SP			000	0.0000	1	2012-01-24 00:00:00	2012-01-24 00:00:00	3515301	1058	0	\N	31
4884	EUCLIDES DA CUNHA PAU